/* 
 * File:   CMUI_Notify.h
 * Author: piotr
 *
 * Created on 11 listopada 2015, 21:12
 */

#ifndef CMUI_NOTIFY_H
#define	CMUI_NOTIFY_H

#include <libraries/muiplus/CMUI_Object.h>
#include <proto/wb.h>

/***************************************************************************
 **                       CMUI_Notify class definition                       
 ***************************************************************************/

class CMUI_Notify : public CMUI_Object {
public:
    Object *MApplicationObject(void) const;
    struct AppMessage * AppMessage(void) const;
    LONG HelpLine(void) const;
    void SetHelpLine(LONG value);
    STRPTR HelpNode(void) const;
    void SetHelpNode(STRPTR value);
    void SetNoNotify(BOOL value);
    IPTR ObjectID(void) const;
    void SetObjectID(IPTR value);
    Object * Parent(void) const;
    LONG Revision(void) const;
    IPTR UserData(void) const;
    void SetUserData(IPTR value);
    LONG Version(void) const;
    IPTR MCallHook(StartVarArgs sva, struct Hook * Hook, IPTR param1, ...);
    IPTR Export(Object * dataspace);
    IPTR FindUData(IPTR udata);
    IPTR GetConfigItem(IPTR id, IPTR * storage);
    IPTR GetUData(IPTR udata, IPTR attr, IPTR * storage);
    IPTR Import(Object * dataspace);
    IPTR KillNotify(IPTR TrigAttr);
    IPTR KillNotifyObj(IPTR TrigAttr, Object * dest);
    IPTR MultiSet(StartVarArgs sva, IPTR attr, IPTR val, APTR obj, ...);
    IPTR NoNotifySet(StartVarArgs sva, IPTR attr, char * format, IPTR val, ...);
    IPTR Notify(StartVarArgs sva, IPTR TrigAttr, IPTR TrigVal, APTR DestObj, IPTR FollowParams, ...);
    IPTR Set(IPTR attr, IPTR val);
    IPTR SetAsString(StartVarArgs sva, IPTR attr, char * format, IPTR val, ...);
    IPTR SetUData(IPTR udata, IPTR attr, IPTR val);
    IPTR SetUDataOnce(IPTR udata, IPTR attr, IPTR val);
    IPTR WriteLong(IPTR val, IPTR * memory);
    IPTR WriteString(char * str, char * memory);
protected:
    CMUI_Notify(void);
};

#endif	/* CMUI_NOTIFY_H */

