/* 
 * File:   CMUI_List.h
 * Author: Piotr Hoppe
 *
 * Created on 30 listopada 2015, 21:15
 */

#ifndef CMUI_LIST_H
#define CMUI_LIST_H

#include "CMUI_Area.h"

/***************************************************************************
 **                        CMUI_List class definition                        
 ***************************************************************************/

class CMUI_List : public CMUI_Area {
public:
    CMUI_List(void);
    CMUI_List(struct TagItem *tags);
    CMUI_List(Tag tag1, ...);
    CMUI_List(Object * obj);
    CMUI_List & operator=(Object * obj);
    APTR operator[](LONG pos);
    LONG Length(void) const;
    IPTR NumSelected(void);
    void MAddHead(APTR entry);
    void MAddTail(APTR entry);
    void InsertTop(APTR entry);
    void InsertBottom(APTR entry);
    void InsertSorted(APTR entry);
    void InsertActive(APTR entry);

    LONG Active(void) const;
    void SetActive(LONG value);
    BOOL AutoVisible(void) const;
    void SetAutoVisible(BOOL value);
    void SetCompareHook(struct Hook * value);
    void SetConstructHook(struct Hook * value);
    void SetDestructHook(struct Hook * value);
    void SetDisplayHook(struct Hook * value);
    BOOL DragSortable(void) const;
    void SetDragSortable(BOOL value);
    LONG DropMark(void) const;
    LONG Entries(void) const;
    LONG First(void) const;
    STRPTR Format(void) const;
    void SetFormat(STRPTR value);
    LONG InsertPosition(void) const;
    void SetMultiTestHook(struct Hook * value);
    void SetQuiet(BOOL value);
    BOOL ShowDropMarks(void) const;
    void SetShowDropMarks(BOOL value);
    char * Title(void) const;
    void SetTitle(char * value);
    LONG Visible(void) const;
    IPTR Clear(void);
    IPTR CreateImage(Object * obj, IPTR flags);
    IPTR DeleteImage(APTR listimg);
    IPTR Exchange(LONG pos1, LONG pos2);
    IPTR GetEntry(LONG pos, APTR * entry);
    IPTR MInsert(APTR * entries, LONG count, LONG pos);
    IPTR InsertSingle(APTR entry, LONG pos);
    IPTR InsertArray(char** entries);
    IPTR Jump(LONG pos);
    IPTR Move(LONG from, LONG to);
    IPTR NextSelected(LONG * pos);
    IPTR Redraw(LONG pos);
    IPTR MRemove(LONG pos);
    IPTR Select(LONG pos, LONG seltype, LONG * state);
    IPTR Sort(void);
    IPTR TestPos(LONG x, LONG y, struct MUI_List_TestPos_Result * res);
};

#endif /* CMUI_LIST_H */

