/* 
 * File:   CMUI_List.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 21:15
 */

#include "CMUI_List.h"

CMUI_List::CMUI_List()
: CMUI_Area() {
}

CMUI_List::CMUI_List(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_List, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_List object\n");
#endif
}

CMUI_List::CMUI_List(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_List, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_List object\n");
#endif
}

CMUI_List::CMUI_List(Object* obj)
: CMUI_Area() {
    object = obj;
}

void CMUI_List::InsertActive(APTR entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Active);
}

void CMUI_List::InsertBottom(APTR entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Bottom);
}

void CMUI_List::InsertSorted(APTR entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Sorted);
}

void CMUI_List::InsertTop(APTR entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Top);
}

// This method is a convienient alternative to the Entries attribute

LONG CMUI_List::Length() const {
    return (LONG) MGetAttr(MUIA_List_Entries);
}

// These methods can be used as shortcuts for inserting objects into lists

void CMUI_List::MAddHead(APTR entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Top);
}

void CMUI_List::MAddTail(APTR entry) {
    MDoMethod(MUIM_List_InsertSingle, entry, MUIV_List_Insert_Bottom);
}

// This method can be used to retrieve the number of selected entries
// in a list

IPTR CMUI_List::NumSelected() {
    IPTR numSelected;
    MDoMethod(MUIM_List_Select, MUIV_List_Select_All, MUIV_List_Select_Ask, &numSelected);
    return numSelected;
}

CMUI_List& CMUI_List::operator=(Object* obj) {
    object = obj;
    return *this;
}

// By overloading the [] operator you can treat lists like arrays

APTR CMUI_List::operator[](LONG pos) {
    APTR entry;
    MDoMethod(MUIM_List_GetEntry, pos, &entry);
    return entry;
}

LONG CMUI_List::Active(void) const {
    return (LONG) MGetAttr(MUIA_List_Active);
}

void CMUI_List::SetActive(LONG value) {
    SetAttr(MUIA_List_Active, (IPTR) value);
}

BOOL CMUI_List::AutoVisible(void) const {
    return (BOOL) MGetAttr(MUIA_List_AutoVisible);
}

void CMUI_List::SetAutoVisible(BOOL value) {
    SetAttr(MUIA_List_AutoVisible, (IPTR) value);
}

void CMUI_List::SetCompareHook(struct Hook * value) {
    SetAttr(MUIA_List_CompareHook, (IPTR) value);
}

void CMUI_List::SetConstructHook(struct Hook * value) {
    SetAttr(MUIA_List_ConstructHook, (IPTR) value);
}

void CMUI_List::SetDestructHook(struct Hook * value) {
    SetAttr(MUIA_List_DestructHook, (IPTR) value);
}

void CMUI_List::SetDisplayHook(struct Hook * value) {
    SetAttr(MUIA_List_DisplayHook, (IPTR) value);
}

BOOL CMUI_List::DragSortable(void) const {
    return (BOOL) MGetAttr(MUIA_List_DragSortable);
}

void CMUI_List::SetDragSortable(BOOL value) {
    SetAttr(MUIA_List_DragSortable, (IPTR) value);
}

LONG CMUI_List::DropMark(void) const {
    return (LONG) MGetAttr(MUIA_List_DropMark);
}

LONG CMUI_List::Entries(void) const {
    return (LONG) MGetAttr(MUIA_List_Entries);
}

LONG CMUI_List::First(void) const {
    return (LONG) MGetAttr(MUIA_List_First);
}

STRPTR CMUI_List::Format(void) const {
    return (STRPTR) MGetAttr(MUIA_List_Format);
}

void CMUI_List::SetFormat(STRPTR value) {
    SetAttr(MUIA_List_Format, (IPTR) value);
}

LONG CMUI_List::InsertPosition(void) const {
    return (LONG) MGetAttr(MUIA_List_InsertPosition);
}

void CMUI_List::SetMultiTestHook(struct Hook * value) {
    SetAttr(MUIA_List_MultiTestHook, (IPTR) value);
}

void CMUI_List::SetQuiet(BOOL value) {
    SetAttr(MUIA_List_Quiet, (IPTR) value);
}

BOOL CMUI_List::ShowDropMarks(void) const {
    return (BOOL) MGetAttr(MUIA_List_ShowDropMarks);
}

void CMUI_List::SetShowDropMarks(BOOL value) {
    SetAttr(MUIA_List_ShowDropMarks, (IPTR) value);
}

char * CMUI_List::Title(void) const {
    return (char *) MGetAttr(MUIA_List_Title);
}

void CMUI_List::SetTitle(char * value) {
    SetAttr(MUIA_List_Title, (IPTR) value);
}

LONG CMUI_List::Visible(void) const {
    return (LONG) MGetAttr(MUIA_List_Visible);
}

IPTR CMUI_List::Clear(void) {
    return MDoMethod(MUIM_List_Clear);
}

IPTR CMUI_List::CreateImage(Object * obj, IPTR flags) {
    return MDoMethod(MUIM_List_CreateImage, obj, flags);
}

IPTR CMUI_List::DeleteImage(APTR listimg) {
    return MDoMethod(MUIM_List_DeleteImage, listimg);
}

IPTR CMUI_List::Exchange(LONG pos1, LONG pos2) {
    return MDoMethod(MUIM_List_Exchange, pos1, pos2);
}

IPTR CMUI_List::GetEntry(LONG pos, APTR * entry) {
    return MDoMethod(MUIM_List_GetEntry, pos, entry);
}

IPTR CMUI_List::MInsert(APTR * entries, LONG count, LONG pos) {
    return MDoMethod(MUIM_List_Insert, entries, count, pos);
}

IPTR CMUI_List::InsertSingle(APTR entry, LONG pos) {
    return MDoMethod(MUIM_List_InsertSingle, entry, pos);
}

IPTR CMUI_List::InsertArray(char** entries) {
    for (int index = 0; entries[index]; index++) {
        InsertSingle(entries[index], MUIV_List_Insert_Bottom);
    }
}

IPTR CMUI_List::Jump(LONG pos) {
    return MDoMethod(MUIM_List_Jump, pos);
}

IPTR CMUI_List::Move(LONG from, LONG to) {
    return MDoMethod(MUIM_List_Move, from, to);
}

IPTR CMUI_List::NextSelected(LONG * pos) {
    return MDoMethod(MUIM_List_NextSelected, pos);
}

IPTR CMUI_List::Redraw(LONG pos) {
    return MDoMethod(MUIM_List_Redraw, pos);
}

IPTR CMUI_List::MRemove(LONG pos) {
    return MDoMethod(MUIM_List_Remove, pos);
}

IPTR CMUI_List::Select(LONG pos, LONG seltype, LONG * state) {
    return MDoMethod(MUIM_List_Select, pos, seltype, state);
}

IPTR CMUI_List::Sort(void) {
    return MDoMethod(MUIM_List_Sort);
}

IPTR CMUI_List::TestPos(LONG x, LONG y, struct MUI_List_TestPos_Result * res) {
    return MDoMethod(MUIM_List_TestPos, x, y, res);
}
