/* 
 * File:   CMUI_Levelmeter.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 2 grudnia 2015, 21:16
 */

#include "CMUI_Levelmeter.h"

CMUI_Levelmeter::CMUI_Levelmeter()
: CMUI_Numeric() {
}

CMUI_Levelmeter::CMUI_Levelmeter(TagItem* tags)
: CMUI_Numeric() {
    object = MUI_NewObjectA(MUIC_Levelmeter, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Levelmeter object\n");
#endif
}

CMUI_Levelmeter::CMUI_Levelmeter(Tag tag1, ...)
: CMUI_Numeric() {
    object = MUI_NewObjectA(MUIC_Levelmeter, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Levelmeter object\n");
#endif
}

CMUI_Levelmeter::CMUI_Levelmeter(Object* obj)
: CMUI_Numeric() {
    object = obj;
}

CMUI_Levelmeter& CMUI_Levelmeter::operator=(Object* obj) {
    object = obj;
    return *this;
}

STRPTR CMUI_Levelmeter::MLabel(void) const {
    return (STRPTR) MGetAttr(MUIA_Levelmeter_Label);
}

void CMUI_Levelmeter::SetLabel(STRPTR value) {
    SetAttr(MUIA_Levelmeter_Label, (IPTR) value);
}
