/* 
 * File:   CMUI_Knob.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 2 grudnia 2015, 21:11
 */

#include "CMUI_Knob.h"

CMUI_Knob::CMUI_Knob()
: CMUI_Numeric() {
}

CMUI_Knob::CMUI_Knob(TagItem* tags)
: CMUI_Numeric() {
    object = MUI_NewObjectA(MUIC_Knob, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Knob object\n");
#endif
}

CMUI_Knob::CMUI_Knob(Tag tag1, ...)
: CMUI_Numeric() {
    object = MUI_NewObjectA(MUIC_Knob, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Knob object\n");
#endif
}

CMUI_Knob::CMUI_Knob(Object * obj)
: CMUI_Numeric() {
    object = obj;
}

CMUI_Knob & CMUI_Knob::operator=(Object * obj) {
    object = obj;
    return *this;
}
