/* 
 * File:   CMUI_Image.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 17:52
 */

#include "CMUI_Image.h"

CMUI_Image::CMUI_Image()
: CMUI_Area() {
}

CMUI_Image::CMUI_Image(TagItem* tags)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Image, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Image object\n");
#endif
}

CMUI_Image::CMUI_Image(Tag tag1, ...)
: CMUI_Area() {
    object = MUI_NewObjectA(MUIC_Image, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Image object\n");
#endif
}

CMUI_Image::CMUI_Image(Object* obj)
: CMUI_Area() {
    object = obj;
}

CMUI_Image& CMUI_Image::operator=(Object* obj) {
    object = obj;
    return *this;
}

void CMUI_Image::SetState(LONG value) {
    SetAttr(MUIA_Image_State, (IPTR) value);
}
