/* 
 * File:   CMUI_Group.h
 * Author: Piotr Hoppe
 *
 * Created on 2 grudnia 2015, 22:10
 */

#ifndef CMUI_GROUP_H
#define	CMUI_GROUP_H

#include "CMUI_Area.h"

/***************************************************************************
 **                       CMUI_Group class definition                        
 ***************************************************************************/

class CMUI_Group : public CMUI_Area {
public:
    CMUI_Group(void);
    CMUI_Group(struct TagItem *tags);
    CMUI_Group(Tag tag1, ...);
    CMUI_Group(Object * obj);
    CMUI_Group & operator=(Object * obj);
    void AddObject(Object *obj);
    void RemObject(Object *obj);

    LONG ActivePage(void) const;
    void SetActivePage(LONG value);
    struct List * ChildList(void) const;
    void SetColumns(LONG value);
    LONG HorizSpacing(void) const;
    void SetHorizSpacing(LONG value);
    void SetRows(LONG value);
    void SetSpacing(LONG value);
    LONG VertSpacing(void) const;
    void SetVertSpacing(LONG value);
    IPTR ExitChange(void);
    IPTR InitChange(void);
    IPTR Sort(StartVarArgs sva, Object * obj, ...);
};


#endif	/* CMUI_GROUP_H */

