/* 
 * File:   CMUI_Floattext.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 30 listopada 2015, 21:19
 */

#include "CMUI_Floattext.h"

CMUI_Floattext::CMUI_Floattext()
: CMUI_List() {
}

CMUI_Floattext::CMUI_Floattext(TagItem* tags)
: CMUI_List() {
    object = MUI_NewObjectA(MUIC_Floattext, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Floattext object\n");
#endif
}

CMUI_Floattext::CMUI_Floattext(Tag tag1, ...)
: CMUI_List() {
    object = MUI_NewObjectA(MUIC_Floattext, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Floattext object\n");
#endif
}

CMUI_Floattext::CMUI_Floattext(Object* obj)
: CMUI_List() {
    object = obj;
}

CMUI_Floattext& CMUI_Floattext::operator=(Object* obj) {
    object = obj;
    return *this;
}

 BOOL CMUI_Floattext::Justify (void) const
{
	 return (BOOL)MGetAttr (MUIA_Floattext_Justify);
}

 void CMUI_Floattext::SetJustify (BOOL value)
{
	 SetAttr (MUIA_Floattext_Justify, (IPTR)value);
}

 void CMUI_Floattext::SetSkipChars (STRPTR value)
{
	 SetAttr (MUIA_Floattext_SkipChars, (IPTR)value);
}

 void CMUI_Floattext::SetTabSize (LONG value)
{
	 SetAttr (MUIA_Floattext_TabSize, (IPTR)value);
}

 STRPTR CMUI_Floattext::Text (void) const
{
	 return (STRPTR)MGetAttr (MUIA_Floattext_Text);
}

 void CMUI_Floattext::SetText (STRPTR value)
{
	 SetAttr (MUIA_Floattext_Text, (IPTR)value);
}
