/* 
 * File:   CMUI_Family.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 29 listopada 2015, 17:35
 */

#include "CMUI_Family.h"

struct MinList * CMUI_Family::List(void) const {
    return (struct MinList *) MGetAttr(MUIA_Family_List);
}

IPTR CMUI_Family::AddHead(Object * obj) {
    return MDoMethod(MUIM_Family_AddHead, obj);
}

IPTR CMUI_Family::AddTail(Object * obj) {
    return MDoMethod(MUIM_Family_AddTail, obj);
}

IPTR CMUI_Family::Insert(Object * obj, Object * pred) {
    return MDoMethod(MUIM_Family_Insert, obj, pred);
}

IPTR CMUI_Family::Remove(Object * obj) {
    return MDoMethod(MUIM_Family_Remove, obj);
}

IPTR CMUI_Family::Sort(StartVarArgs sva, Object * obj, ...) {
    sva.methodID = MUIM_Family_Sort;
    return MDoMethodA((Msg) & sva);
}

IPTR CMUI_Family::Transfer(Object * family) {
    return MDoMethod(MUIM_Family_Transfer, family);
}

CMUI_Family::CMUI_Family()
: CMUI_Notify() {
}
