/* 
 * File:   CMUI_Dataspace.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 3 grudnia 2015, 22:50
 */

#include "CMUI_Dataspace.h"

CMUI_Dataspace::CMUI_Dataspace()
: CMUI_Semaphore() {
}

CMUI_Dataspace::CMUI_Dataspace(TagItem* tags)
: CMUI_Semaphore() {
    object = MUI_NewObjectA(MUIC_Dataspace, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Dataspace object\n");
#endif
}

CMUI_Dataspace::CMUI_Dataspace(Tag tag1, ...)
: CMUI_Semaphore() {
    object = MUI_NewObjectA(MUIC_Dataspace, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Dataspace object\n");
#endif
}

CMUI_Dataspace::CMUI_Dataspace(Object* obj)
: CMUI_Semaphore() {
    object = obj;
}

CMUI_Dataspace& CMUI_Dataspace::operator=(Object* obj) {
    object = obj;
    return *this;
}

IPTR CMUI_Dataspace::Add(APTR data, LONG len, IPTR id) {
    return MDoMethod(MUIM_Dataspace_Add, data, len, id);
}

IPTR CMUI_Dataspace::Clear(void) {
    return MDoMethod(MUIM_Dataspace_Clear);
}

IPTR CMUI_Dataspace::Find(IPTR id) {
    return MDoMethod(MUIM_Dataspace_Find, id);
}

IPTR CMUI_Dataspace::Merge(Object * dataspace) {
    return MDoMethod(MUIM_Dataspace_Merge, dataspace);
}

IPTR CMUI_Dataspace::ReadIFF(struct IFFHandle * handle) {
    return MDoMethod(MUIM_Dataspace_ReadIFF, handle);
}

IPTR CMUI_Dataspace::Remove(IPTR id) {
    return MDoMethod(MUIM_Dataspace_Remove, id);
}

IPTR CMUI_Dataspace::WriteIFF(struct IFFHandle * handle, IPTR type, IPTR id) {
    return MDoMethod(MUIM_Dataspace_WriteIFF, handle, type, id);
}
