/* 
 * File:   CMUI_Area.h
 * Author: Piotr Hoppe
 *
 * Created on 28 listopada 2015, 23:43
 */

#ifndef CMUI_AREA_H
#define	CMUI_AREA_H

#include <libraries/muiplus/CMUI_Notify.h>

/***************************************************************************
 **                        CMUI_Area class definition                        
 ***************************************************************************/

class CMUI_Area : public CMUI_Notify {
public:
    void SetBackground(LONG value);
    LONG BottomEdge(void) const;
    Object * ContextMenu(void) const;
    void SetContextMenu(Object * value);
    Object * ContextMenuTrigger(void) const;
    char ControlChar(void) const;
    void SetControlChar(char value);
    LONG CycleChain(void) const;
    void SetCycleChain(LONG value);
    BOOL Disabled(void) const;
    void SetDisabled(BOOL value);
    BOOL Draggable(void) const;
    void SetDraggable(BOOL value);
    BOOL Dropable(void) const;
    void SetDropable(BOOL value);
    void SetFillArea(BOOL value);
    struct TextFont * Font(void) const;
    LONG Height(void) const;
    LONG HorizDisappear(void) const;
    void SetHorizDisappear(LONG value);
    WORD HorizWeight(void) const;
    void SetHorizWeight(WORD value);
    LONG InnerBottom(void) const;
    LONG InnerLeft(void) const;
    LONG InnerRight(void) const;
    LONG InnerTop(void) const;
    LONG LeftEdge(void) const;
    BOOL Pressed(void) const;
    LONG RightEdge(void) const;
    BOOL Selected(void) const;
    void SetSelected(BOOL value);
    STRPTR ShortHelp(void) const;
    void SetShortHelp(STRPTR value);
    BOOL ShowMe(void) const;
    void SetShowMe(BOOL value);
    LONG Timer(void) const;
    LONG TopEdge(void) const;
    LONG VertDisappear(void) const;
    void SetVertDisappear(LONG value);
    WORD VertWeight(void) const;
    void SetVertWeight(WORD value);
    LONG Width(void) const;
    struct Window * Window(void) const;
    Object * MWindowObject(void) const;
    IPTR AskMinMax(struct MUI_MinMax * MinMaxInfo);
    IPTR Cleanup(void);
    IPTR ContextMenuBuild(LONG mx, LONG my);
    IPTR ContextMenuChoice(Object * item);
    IPTR CreateBubble(LONG x, LONG y, char * txt, IPTR flags);
    IPTR CreateShortHelp(LONG mx, LONG my);
    IPTR DeleteBubble(APTR bubble);
    IPTR DeleteShortHelp(STRPTR help);
    IPTR DragBegin(Object * obj);
    IPTR DragDrop(Object * obj, LONG x, LONG y);
    IPTR DragFinish(Object * obj);
    IPTR DragQuery(Object * obj);
    IPTR DragReport(Object * obj, LONG x, LONG y, LONG update);
    IPTR Draw(IPTR flags);
    IPTR DrawBackground(LONG left, LONG top, LONG width, LONG height, LONG xoffset, LONG yoffset, LONG flags);
    IPTR HandleEvent(struct IntuiMessage * imsg, LONG muikey);
    IPTR HandleInput(struct IntuiMessage * imsg, LONG muikey);
    IPTR Hide(void);
    IPTR Setup(struct MUI_RenderInfo * RenderInfo);
    IPTR Show(void);
#ifdef MUI_OBSOLETE
    IPTR ExportID(void) const;
    void SetExportID(IPTR value);

#endif /* MUI_OBSOLETE */
protected:
    CMUI_Area(void);
};


#endif	/* CMUI_AREA_H */

