/* 
 * File:   CMUI_Application.cpp
 * Author: Piotr Hoppe
 * 
 * Created on 25 listopada 2015, 20:11
 */

#include "CMUI_Application.h"

CMUI_Application::CMUI_Application()
: CMUI_Notify() {
}

CMUI_Application::CMUI_Application(TagItem* tags)
: CMUI_Notify() {
#ifdef MUIPP_DEBUG
    _CheckTagsSpecified("CMUI_Application", tags, MUIA_Application_Author, "MUIA_Application_Author", MUIA_Application_Base, "MUIA_Application_Base", MUIA_Application_Copyright, "MUIA_Application_Copyright", MUIA_Application_Description, "MUIA_Application_Description", MUIA_Application_Title, "MUIA_Application_Title", MUIA_Application_Version, "MUIA_Application_Version", TAG_DONE);
#endif
    object = MUI_NewObjectA(MUIC_Application, tags);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Application object\n");
#endif
}

CMUI_Application::CMUI_Application(Tag tag1, ...)
: CMUI_Notify() {
#ifdef MUIPP_DEBUG
    _CheckTagsSpecified("CMUI_Application", (struct TagItem *) &tag1, MUIA_Application_Author, "MUIA_Application_Author", MUIA_Application_Base, "MUIA_Application_Base", MUIA_Application_Copyright, "MUIA_Application_Copyright", MUIA_Application_Description, "MUIA_Application_Description", MUIA_Application_Title, "MUIA_Application_Title", MUIA_Application_Version, "MUIA_Application_Version", TAG_DONE);
#endif
    object = MUI_NewObjectA(MUIC_Application, (struct TagItem *) &tag1);
#ifdef MUIPP_DEBUG
    if (object == NULL)
        _MUIPPWarning("Could not create a CMUI_Application object\n");
#endif
}

CMUI_Application::CMUI_Application(Object* obj)
: CMUI_Notify() {
    object = obj;
}

CMUI_Application & CMUI_Application::operator=(Object * obj) {
    object = obj;
    return *this;
}

/* Adds a new window object to application */

void CMUI_Application::AddWindow(Object *window) {
    MDoMethod(OM_ADDMEMBER, window);
}

/* Removes a window object from the application */

void CMUI_Application::RemoveWindow(Object *window) {
    MDoMethod(OM_REMMEMBER, window);
}

BOOL CMUI_Application::Active(void) const {
    return (BOOL) MGetAttr(MUIA_Application_Active);
}

void CMUI_Application::SetActive(BOOL value) {
    SetAttr(MUIA_Application_Active, (IPTR) value);
}

STRPTR CMUI_Application::Author(void) const {
    return (STRPTR) MGetAttr(MUIA_Application_Author);
}

STRPTR CMUI_Application::Base(void) const {
    return (STRPTR) MGetAttr(MUIA_Application_Base);
}

CxObj * CMUI_Application::Broker(void) const {
    return (CxObj *) MGetAttr(MUIA_Application_Broker);
}

struct Hook * CMUI_Application::BrokerHook(void) const {
    return (struct Hook *) MGetAttr(MUIA_Application_BrokerHook);
}

void CMUI_Application::SetBrokerHook(struct Hook * value) {
    SetAttr(MUIA_Application_BrokerHook, (IPTR) value);
}

struct MsgPort * CMUI_Application::BrokerPort(void) const {
    return (struct MsgPort *) MGetAttr(MUIA_Application_BrokerPort);
}

LONG CMUI_Application::BrokerPri(void) const {
    return (LONG) MGetAttr(MUIA_Application_BrokerPri);
}

struct MUI_Command * CMUI_Application::Commands(void) const {
    return (struct MUI_Command *) MGetAttr(MUIA_Application_Commands);
}

void CMUI_Application::SetCommands(struct MUI_Command * value) {
    SetAttr(MUIA_Application_Commands, (IPTR) value);
}

STRPTR CMUI_Application::Copyright(void) const {
    return (STRPTR) MGetAttr(MUIA_Application_Copyright);
}

STRPTR CMUI_Application::Description(void) const {
    return (STRPTR) MGetAttr(MUIA_Application_Description);
}

struct DiskObject * CMUI_Application::DiskObject(void) const {
    return (struct DiskObject *) MGetAttr(MUIA_Application_DiskObject);
}

void CMUI_Application::SetDiskObject(struct DiskObject * value) {
    SetAttr(MUIA_Application_DiskObject, (IPTR) value);
}

BOOL CMUI_Application::DoubleStart(void) const {
    return (BOOL) MGetAttr(MUIA_Application_DoubleStart);
}

void CMUI_Application::SetDropObject(Object * value) {
    SetAttr(MUIA_Application_DropObject, (IPTR) value);
}

BOOL CMUI_Application::ForceQuit(void) const {
    return (BOOL) MGetAttr(MUIA_Application_ForceQuit);
}

STRPTR CMUI_Application::HelpFile(void) const {
    return (STRPTR) MGetAttr(MUIA_Application_HelpFile);
}

void CMUI_Application::SetHelpFile(STRPTR value) {
    SetAttr(MUIA_Application_HelpFile, (IPTR) value);
}

BOOL CMUI_Application::Iconified(void) const {
    return (BOOL) MGetAttr(MUIA_Application_Iconified);
}

void CMUI_Application::SetIconified(BOOL value) {
    SetAttr(MUIA_Application_Iconified, (IPTR) value);
}

IPTR CMUI_Application::MenuAction(void) const {
    return MGetAttr(MUIA_Application_MenuAction);
}

IPTR CMUI_Application::MenuHelp(void) const {
    return MGetAttr(MUIA_Application_MenuHelp);
}

struct Hook * CMUI_Application::RexxHook(void) const {
    return (struct Hook *) MGetAttr(MUIA_Application_RexxHook);
}

void CMUI_Application::SetRexxHook(struct Hook * value) {
    SetAttr(MUIA_Application_RexxHook, (IPTR) value);
}

struct RxMsg * CMUI_Application::RexxMsg(void) const {
    return (struct RxMsg *) MGetAttr(MUIA_Application_RexxMsg);
}

void CMUI_Application::SetRexxString(STRPTR value) {
    SetAttr(MUIA_Application_RexxString, (IPTR) value);
}

void CMUI_Application::SetSleep(BOOL value) {
    SetAttr(MUIA_Application_Sleep, (IPTR) value);
}

STRPTR CMUI_Application::Title(void) const {
    return (STRPTR) MGetAttr(MUIA_Application_Title);
}

STRPTR CMUI_Application::Version(void) const {
    return (STRPTR) MGetAttr(MUIA_Application_Version);
}

struct List * CMUI_Application::WindowList(void) const {
    return (struct List *) MGetAttr(MUIA_Application_WindowList);
}

IPTR CMUI_Application::AboutMUI(Object * refwindow) {
    return MDoMethod(MUIM_Application_AboutMUI, refwindow);
}

IPTR CMUI_Application::AddInputHandler(struct MUI_InputHandlerNode * ihnode) {
    return MDoMethod(MUIM_Application_AddInputHandler, ihnode);
}

IPTR CMUI_Application::CheckRefresh(void) {
    return MDoMethod(MUIM_Application_CheckRefresh);
}

IPTR CMUI_Application::InputBuffered(void) {
    return MDoMethod(MUIM_Application_InputBuffered);
}

IPTR CMUI_Application::Load(STRPTR name) {
    return MDoMethod(MUIM_Application_Load, name);
}

IPTR CMUI_Application::NewInput(LONGBITS * signal) {
    return MDoMethod(MUIM_Application_NewInput, signal);
}

IPTR CMUI_Application::OpenConfigWindow(IPTR flags) {
    return MDoMethod(MUIM_Application_OpenConfigWindow, flags);
}

IPTR CMUI_Application::PushMethod(StartVarArgs sva, Object * dest, LONG count, ...) {
    sva.methodID = MUIM_Application_PushMethod;
    return MDoMethodA((Msg) & sva);
}

IPTR CMUI_Application::RemInputHandler(struct MUI_InputHandlerNode * ihnode) {
    return MDoMethod(MUIM_Application_RemInputHandler, ihnode);
}

IPTR CMUI_Application::ReturnID(IPTR retid) {
    return MDoMethod(MUIM_Application_ReturnID, retid);
}

IPTR CMUI_Application::Save(STRPTR name) {
    return MDoMethod(MUIM_Application_Save, name);
}

IPTR CMUI_Application::SetConfigItem(IPTR item, APTR data) {
    return MDoMethod(MUIM_Application_SetConfigItem, item, data);
}

IPTR CMUI_Application::ShowHelp(Object * window, char * name, char * node, LONG line) {
    return MDoMethod(MUIM_Application_ShowHelp, window, name, node, line);
}
