/*
 * ====================================================================
 * Copyright (c) 2000-2004 CollabNet.  All rights reserved.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at http://subversion.tigris.org/license-1.html.
 * If newer versions of this license are posted there, you may use a
 * newer version instead, at your option.
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://subversion.tigris.org/.
 * ====================================================================
 */

#ifndef WINSVN_COMCP_H_
#define WINSVN_COMCP_H_
#pragma once

#include "MarshalArray.h"

template <class T>
class CProxy_ISVNEvents : public IConnectionPointImpl<T, &DIID__ISVNEvents, CComDynamicMarshalledUnkArray<&DIID__ISVNEvents> >
{
        //Warning this class may be recreated by the wizard.
public:
        HRESULT Fire_RefreshFiles(BSTR bstrDir)
        {
                CComVariant varResult;
                T* pT = static_cast<T*>(this);
                int nConnectionIndex;
                CComVariant* pvars = new CComVariant[1];
                int nConnections = m_vec.GetSize();

                for (nConnectionIndex = 0; nConnectionIndex < nConnections; nConnectionIndex++)
                {
                        pT->Lock();
                        CComPtr<IUnknown> sp = m_vec.GetAt(nConnectionIndex);
                        pT->Unlock();
                        IDispatch* pDispatch = reinterpret_cast<IDispatch*>(sp.p);
                        if (pDispatch != NULL)
                        {
                                VariantClear(&varResult);
                                pvars[0] = bstrDir;
                                DISPPARAMS disp = { pvars, NULL, 1, 0 };
                                pDispatch->Invoke(0x1, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &disp, &varResult, NULL, NULL);
                        }
                }
                delete[] pvars;
                return varResult.scode;

        }
};
#endif
