/*
 *  Source machine generated by GadToolsBox V2.0b
 *  which is (c) Copyright 1991-1993 Jaba Development
 *
 *  GUI Designed by : devitt
 */

#include <exec/types.h>
#include <intuition/intuition.h>
#include <intuition/classes.h>
#include <intuition/classusr.h>
#include <intuition/imageclass.h>
#include <intuition/gadgetclass.h>
#include <libraries/gadtools.h>
#include <graphics/displayinfo.h>
#include <graphics/gfxbase.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/gadtools.h>
#include <proto/graphics.h>
#include <proto/utility.h>
#include <string.h>

#include "memory.h"

struct Screen         *Scr = NULL;
UBYTE                 *PubScreenName = NULL;
APTR                   VisualInfo = NULL;
struct Window         *MemoryWnd = NULL;
struct Gadget         *MemoryGList = NULL;
struct IntuiMessage    MemoryMsg;
struct Gadget         *MemoryGadgets[5];
UWORD                  MemoryLeft = 109;
UWORD                  MemoryTop = 56;
UWORD                  MemoryWidth = 305;
UWORD                  MemoryHeight = 101;
UBYTE                 *MemoryWdt = (UBYTE *)"MemLeak";

struct TextAttr topaz8 = {
	( STRPTR )"topaz.font", 8, 0x00, 0x01 };

struct IntuiText MemoryIText[] = {
	3, 0, JAM1,55, 87, &topaz8, (UBYTE *)"MemLeak 1994 by Devitt", NULL };

UWORD MemoryGTypes[] = {
	BUTTON_KIND,
	BUTTON_KIND,
	TEXT_KIND,
	TEXT_KIND,
	TEXT_KIND
};

struct NewGadget MemoryNGad[] = {
	27, 7, 104, 17, (UBYTE *)"Before", NULL, GD_BeforeGad, PLACETEXT_IN, NULL, (APTR)BeforeGadClicked,
	27, 35, 104, 17, (UBYTE *)"After", NULL, GD_AfterGad, PLACETEXT_IN, NULL, (APTR)AfterGadClicked,
	161, 6, 104, 17, NULL, NULL, GD_BeforeText, 0, NULL, NULL,
	161, 35, 104, 17, NULL, NULL, GD_AfterText, 0, NULL, NULL,
	138, 63, 104, 17, (UBYTE *)"Difference", NULL, GD_DiffText, PLACETEXT_LEFT, NULL, NULL
};

ULONG MemoryGTags[] = {
	(TAG_DONE),
	(TAG_DONE),
	(GTTX_Border), TRUE, (TAG_DONE),
	(GTTX_Border), TRUE, (TAG_DONE),
	(GTTX_Border), TRUE, (TAG_DONE)
};

int SetupScreen( void )
{
	if ( ! ( Scr = LockPubScreen( PubScreenName )))
		return( 1L );

	if ( ! ( VisualInfo = GetVisualInfo( Scr, TAG_DONE )))
		return( 2L );

	return( 0L );
}

void CloseDownScreen( void )
{
	if ( VisualInfo ) {
		FreeVisualInfo( VisualInfo );
		VisualInfo = NULL;
	}

	if ( Scr        ) {
		UnlockPubScreen( NULL, Scr );
		Scr = NULL;
	}
}

void MemoryRender( void )
{
	UWORD		offx, offy;

	offx = MemoryWnd->BorderLeft;
	offy = MemoryWnd->BorderTop;

	PrintIText( MemoryWnd->RPort, MemoryIText, offx, offy );
}

int HandleMemoryIDCMP( void )
{
	struct IntuiMessage	*m;
	int			(*func)();
	BOOL			running = TRUE;

	while( m = GT_GetIMsg( MemoryWnd->UserPort )) {

		CopyMem(( char * )m, ( char * )&MemoryMsg, (long)sizeof( struct IntuiMessage ));

		GT_ReplyIMsg( m );

		switch ( MemoryMsg.Class ) {

			case	IDCMP_REFRESHWINDOW:
				GT_BeginRefresh( MemoryWnd );
				MemoryRender();
				GT_EndRefresh( MemoryWnd, TRUE );
				break;

			case	IDCMP_CLOSEWINDOW:
				running = MemoryCloseWindow();
				break;

			case	IDCMP_GADGETUP:
				func = ( void * )(( struct Gadget * )MemoryMsg.IAddress )->UserData;
				running = func();
				break;
		}
	}
	return( running );
}

int OpenMemoryWindow( void )
{
	struct NewGadget	ng;
	struct Gadget	*g;
	UWORD		lc, tc;
	UWORD		offx = Scr->WBorLeft, offy = Scr->WBorTop + Scr->RastPort.TxHeight + 1;

	if ( ! ( g = CreateContext( &MemoryGList )))
		return( 1L );

	for( lc = 0, tc = 0; lc < Memory_CNT; lc++ ) {

		CopyMem((char * )&MemoryNGad[ lc ], (char * )&ng, (long)sizeof( struct NewGadget ));

		ng.ng_VisualInfo = VisualInfo;
		ng.ng_TextAttr   = &topaz8;
		ng.ng_LeftEdge  += offx;
		ng.ng_TopEdge   += offy;

		MemoryGadgets[ lc ] = g = CreateGadgetA((ULONG)MemoryGTypes[ lc ], g, &ng, ( struct TagItem * )&MemoryGTags[ tc ] );

		while( MemoryGTags[ tc ] ) tc += 2;
		tc++;

		if ( NOT g )
			return( 2L );
	}

	if ( ! ( MemoryWnd = OpenWindowTags( NULL,
				WA_Left,	MemoryLeft,
				WA_Top,		MemoryTop,
				WA_Width,	MemoryWidth,
				WA_Height,	MemoryHeight + offy,
				WA_IDCMP,	BUTTONIDCMP|TEXTIDCMP|IDCMP_CLOSEWINDOW|IDCMP_REFRESHWINDOW,
				WA_Flags,	WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH,
				WA_Gadgets,	MemoryGList,
				WA_Title,	MemoryWdt,
				WA_ScreenTitle,	"MemLeak 1994 by Devitt",
				WA_PubScreen,	Scr,
				TAG_DONE )))
	return( 4L );

	GT_RefreshWindow( MemoryWnd, NULL );

	MemoryRender();

	return( 0L );
}

void CloseMemoryWindow( void )
{
	if ( MemoryWnd        ) {
		CloseWindow( MemoryWnd );
		MemoryWnd = NULL;
	}

	if ( MemoryGList      ) {
		FreeGadgets( MemoryGList );
		MemoryGList = NULL;
	}
}

