IMPLEMENTATION MODULE m2ud;
(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)

(*
 * 6.9.92/bp
 *	Screen statt Interlace schaltet nun auch 1Plane, 2Planes
 *
 * 29.12.90/bp
 *	topaz11 wieder herausgenommen, nun immer defaultFont.
 *	in Interlaced wurde topaz11, sonst default benutzt, das
 *	gab blde Darstellungen.
 * 30.9.90/bp
 *	Selbstmodifizierenden Code entfernt (Menus...)
 *	Optisch lesbar gemacht
 *	String-Eingabe in Requester statt Window!
 * 15.4.89/ms
 *	Anpassungen an ein extern definierbares Layout des Debuggers.
 *	Momentan wird ein Interlaced Screen mit einer Bitplane erffnet.
 * 14.3.89/ms
 *	Die Aenderungen von Bernd Preusing wurden eingefgt.
 *
 *---------------------------------------------------------------------------*
 * User dependent part of debugger                                           *
 *---------------------------------------------------------------------------*
 *)

FROM SYSTEM	IMPORT	ADDRESS,ADR,BITSET,BYTE,CAST,FFP,ASSEMBLE,LONGSET,
			SETREG,TAG;
FROM Arts	IMPORT	Assert, BreakPoint;
(*FROM DiskFontL	IMPORT	OpenDiskFont;*)
FROM DosD	IMPORT	newFile,oldFile,FileHandlePtr;
FROM DosL	IMPORT	Delay,Read,Write;
FROM DosSupport	IMPORT	Open,Close;
FROM ExecD	IMPORT	MsgPortPtr;
FROM ExecL	IMPORT	Forbid,Permit,GetMsg,ReplyMsg,WaitPort;
FROM ExecSupport IMPORT	CreatePort,DeletePort;
IMPORT GD: GraphicsD;
FROM GraphicsD	IMPORT	LayerPtr,ViewModes,ViewModeSet,TextFontPtr,TextAttr,
			FontStyleSet,FontFlagSet,RastPortPtr;
FROM GraphicsL	IMPORT	SetFont,CloseFont,Text,SetAPen,Move;
IMPORT ID: IntuitionD;
FROM IntuitionD	IMPORT	customScreen,maxBody,menuNull,propGadget,selectDown,
			menuDown,stdScreenHeight,GadgetPtr,IDCMPFlags,IDCMPFlagSet,
			IntuiMessagePtr,NewScreen,PropInfoFlags,PropInfoFlagSet,
			PropInfoPtr,ScreenPtr,WindowFlags,WindowPtr,MenuPtr,
			MenuItem,IntuiText,checkWidth,Gadget, GadgetFlagSet,
			Menu,StringInfo,Requester,ActivationFlags,ActivationFlagSet,
			WindowFlagSet,MenuItemFlags,SaTags,NewWindow;
FROM IntuitionL	IMPORT	intuitionBase,intuitionVersion,
			ActivateWindow,ClearMenuStrip,CloseScreen,ModifyIDCMP,
			ModifyProp,OpenScreen,SetMenuStrip,WindowToFront,
			SetWindowTitles,Request,ActivateGadget,RefreshGadgets,
			DisplayBeep;
FROM LayersL	IMPORT	WhichLayer;
FROM Windows	IMPORT	Mode,ModeSet,WinGad,WinGadSet,Clear,ClearEOL,
			CloseWindow,GetPos,GetSize,ModifyWindow,OpenWindow,
			SetClip,SetMode,SetPos,SetScreen,WriteC,WriteS,WriteL,
			XYtoPos;
FROM Conversions	IMPORT	ValToStr;
FROM String	IMPORT	Insert, Length;
IMPORT FFPConversions,RealConversions,LongRealConversions;
IMPORT IntuitionL,GraphicsL,R;
(*FROM Terminal IMPORT FormatNr,FormatS,WriteString;*)
FROM UtilityD	IMPORT	tagEnd;

(*---------------------------------------------------------------------------*)

CONST
  date=COMPILEDATE;
  ver="4.4d";
  verDollar="$VER: m2debug "+ver+" "+date;
  title=
    "Amiga Modula-2 Debugger, "+ver+", "+date;

 newTypeFor=
(*   012345678901234567 *)
(*  "New type for '':"; *)
    "Neuer Typ fr '':";
 newTypeInsert = (* 14 *) 15;
 procChain=
(* "Procedure Chain"; *)
   "Aufruf-Kette";
 modList=
(* "Module List"; *)
   "Modul Tabelle";
 data1=
(* "Data 1"; *)
   "Daten 1";
 data2=
(* "Data 2"; *)
   "Daten 2";
 sourceWindow=
(* "Source"; *)
   "Quelltext";

  layoutName="m2:M2Debug.prefs";
  layoutTag=CAST(LONGINT,"m2dp");

TYPE
  Layout=RECORD
    tag: LONGINT;
    pos: ARRAY Window OF RECORD
      x,y,w,h: INTEGER;
    END;
    interlace: BOOLEAN;
    srcImm: BOOLEAN;
    lDepth2: BOOLEAN;
    useIt: BOOLEAN;
    reserved: ARRAY[0..15] OF LONGINT;
  END;

TYPE
   (*
    * wdw: Intuition window
    * gadget: Intuition gadget
    * width: Number of characters which can be displayed on one line.
    * height: Number of lines that can be displayed in this window.
    * dataHeight: Number of lines which actually contain something.
    * topLine: Number of the lines in the first row of the window.
    * headerLines: Number of header lines.
    * displayProc: Displayprocedure for this window.
    * selectProc: Selectprocedure for this window.
    *)
 WindowInfo=RECORD
   wdw:WindowPtr;
   gadget:GadgetPtr;
   width,height,dataHeight,topLine,headerLines:CARDINAL;
   displayProc:DisplayProc;
   selectProc:SelectProc
 END;


VAR
  layout: Layout;

  screenInterlace: BOOLEAN;
  sDepth2: BOOLEAN;

  thePort:MsgPortPtr;
  theScreen:ScreenPtr;
  theMenu:MenuPtr;
  (*theFont:TextFontPtr;*)
  (*theFontAttr: TextAttr;*)
  wInfo:ARRAY Window OF WindowInfo;




(* Kick 2.0 Features *)
(* ------------------------------------------------------------------------- *)
VAR
  tagBuff:ARRAY[1..11] OF LONGINT;
  mId:LONGCARD;
  min1:CARDINAL;
  ns:NewScreen;

PROCEDURE OpenKick20(interlace:BOOLEAN):ScreenPtr;
VAR
  s:ScreenPtr;
  wbKey:LONGCARD;
  sDepth:LONGINT;
BEGIN
  IF sDepth2 THEN sDepth:=2 ELSE sDepth:=1 END;
  IF intuitionVersion>=36 THEN
    s:=IntuitionL.LockPubScreen(NIL);
    IF s#NIL THEN
      wbKey:=GraphicsL.GetVPModeID(ADR(s^.viewPort));
      IntuitionL.UnlockPubScreen(NIL,s);
    ELSE
      wbKey:=GD.hiresKey
    END;
    mId:=CAST(LONGCARD,CAST(LONGSET,wbKey)*CAST(LONGSET,GD.monitorIDmask));
    IF mId>=GD.a2024MonitorID THEN (* a2024 *)
     (* kein lace *)
    ELSIF mId>=GD.vgaMonitorID THEN
      IF interlace THEN INCL(CAST(LONGSET,wbKey),0)
      ELSE  EXCL(CAST(LONGSET,wbKey),0)
      END;
    ELSE
      IF interlace THEN INCL(CAST(LONGSET,wbKey),2)
      ELSE  EXCL(CAST(LONGSET,wbKey),2)
      END;
    END;
    min1:=0FFFFH;
    s:=IntuitionL.OpenScreenTagList(NIL,TAG(tagBuff,
  	saDepth,	sDepth,
  	saDisplayID,	wbKey,
  	(*saOverscan,	oScanText,*)
  	saPens,		ADR(min1), (* new look! *)
  	saTitle,	ADR(title),
  	(*saErrorCode,	ADR(err),*)
  	tagEnd));
  ELSE
    ns.leftEdge:=0; ns.topEdge:=0;
    ns.width:=640;
    ns.height:=stdScreenHeight;
    ns.depth:=sDepth; ns.detailPen:=0; ns.blockPen:=1;
    IF interlace THEN
      ns.viewModes:=ViewModeSet{hires,lace}
    ELSE
      ns.viewModes:=ViewModeSet{hires};
    END;
    ns.type:=customScreen;
    ns.font:=NIL; ns.customBitMap:=NIL; ns.gadgets:=NIL;
    ns.defaultTitle:=ADR(title);
    s:=OpenScreen(ns);
  END;
  RETURN s;
END OpenKick20;

(* ------------------------------------------------------------------------- *)

(* ------------------------------------------------------------------------- *)


PROCEDURE ReadLayout;
VAR
  f: FileHandlePtr;
BEGIN
  layout.useIt:=FALSE;
  f:=Open(ADR(layoutName),oldFile);
  IF f#NIL THEN
    IF Read(f, ADR(layout), SIZE(layout)) = SIZE(layout) THEN
      layout.useIt:=layout.tag=layoutTag;
    END;
    Close(f)
  END;
END ReadLayout;

PROCEDURE SaveLayout;
VAR
  f: FileHandlePtr;
  wPtr: WindowPtr;
  window: Window;
BEGIN
  FOR window:=MIN(Window) TO MAX(Window) DO
    WITH layout.pos[window] DO
      WITH wInfo[window].wdw^ DO
        x:=leftEdge; y:=topEdge; w:=width; h:=height
      END
    END
  END;
  layout.interlace:=screenInterlace;
  layout.srcImm:=srcImm;
  layout.lDepth2:=sDepth2;
  f:=Open(ADR(layoutName), newFile);
  IF f#NIL THEN
    layout.tag:=layoutTag;
    IF Write(f, ADR(layout), SIZE(layout)) = 0 THEN END;
    Close(f)
  END
END SaveLayout;

(* ------------------------------------------------------------------------- *)

PROCEDURE WindowSize(u:WindowPtr; VAR height,width:CARDINAL);
VAR h,w:INTEGER;
BEGIN
  GetSize(u,h,w); height:=h; width:=w
END WindowSize;

PROCEDURE WhichWindow(VAR u:WindowPtr; VAR x,y:INTEGER);
   (*
    * This procedure takes as arguments the coordinates x, y relativ to
    * window u. It then looks for the topmost window on the screen containing
    * this position. It will set u to this (possibly) new window,make it
    * the active window and it will recompute x, y relativ to this window.
    *
    * NOTE:Assumes that u is active window.
    *)
VAR
  ly:LayerPtr;
BEGIN
  WITH u^ DO
     (*
      * Add to x and y the values of leftEdge and topEdge. This transforms
      * the window relativ coordinates to screen relativ coordinates.
      *)
    INC(x,leftEdge); INC(y,topEdge);
     (*
      * Now use the WhichLayer function to find the layer to which
      * this window belongs.
      *)
    ly:=WhichLayer(ADR(wScreen^.layerInfo),x,y);
    IF (ly#NIL) & (ly^.window#NIL) THEN
     (*
      * A layer was found with a window attached to it.
      *)
      u:=ly^.window; DEC(x,u^.leftEdge); DEC(y,u^.topEdge);
    ELSE
     (*
      * No valid layer found, reset x and y to zero.
      * u remains the last window.
      *)
      x:=0; y:=0;
    END
  END(*WITH u^*);
    (*
     * Assure that selected window is active.
     *)
  IF ~(windowActive IN u^.flags) THEN ActivateWindow(u); END;
END WhichWindow;

PROCEDURE FindWindow(win:WindowPtr; VAR u:Window):BOOLEAN;
   (*
    * For a given Intuition window finds what kind of debugger window
    * this is. If a window was found then FindWindow is TRUE otherwise
    * FALSE.
    *)
VAR i:Window;
BEGIN
  FOR i:=dt1Wdw TO prdWdw DO
    IF wInfo[i].wdw=win THEN u:=i; RETURN TRUE; END
  END;
  RETURN FALSE
END FindWindow;

PROCEDURE ChangeScreen; FORWARD;

PROCEDURE GetCommand(VAR command:Command);
CONST
  noType=CAST(CommandType,-1);
VAR
  msg: IntuiMessagePtr;
  event: IDCMPFlagSet;
  what: CARDINAL;
  win: WindowPtr;
  gad: GadgetPtr;
  pr: PropInfoPtr;
  x,y: INTEGER;
  w,h: CARDINAL;
  scrollHeight,infoHeight: CARDINAL;
  u: Window;
BEGIN
  (*
   * jr: Sorry that it's such a long procedure; but it's straightforward.
   *
   * cn: I added/modified some comments anyway.
   *)
  WITH command DO
    LOOP
      (*
       * We first wait for some message to come. Then we read all
       * messages and retain their significant values in the variables
       * event, what, win, gad, x and y.
       * As we overwrite those variables with each message we get in the
       * loop. only the last message is retained. All other messages are
       * simply ignored.
       *)
      WaitPort(thePort);
      LOOP
        msg:=GetMsg(thePort);
        IF msg=NIL THEN EXIT END;
        WITH msg^ DO
          event:=class; what:=code; win:=idcmpWindow; gad:=iAddress;
          x:=mouseX; y:=mouseY
        END;
        ReplyMsg(msg)
      END;
      (*
       * We will only process the event if it occured in one of our
       * windows. FindWindow will find the window and set u accordingly.
       *)
      IF FindWindow(win,u) THEN
      (*IF (event=IDCMPFlagSet{mouseButtons})&(what=menuDown)
       *   OR (event=IDCMPFlagSet{activeWindow}) THEN
       *ELSE (* 6.12.90/bp Sonst viel rger --> Crash!!! *)
       *)
          WindowToFront(win); (* does it NOT, but queues the request!!! *)
      (*
       *END;
       *)
        WITH wInfo[u] DO
        (*
         * Now we are ready to process the event.
         *)
          IF (event=IDCMPFlagSet{newSize})OR(event=IDCMPFlagSet{changeWindow}) THEN
          (*
           * The user has resized the window. A scroll command is generated.
           * if the size of the window really changed (otherwise we stay in
           * the loop). width and height of the window are set to the new
           * values.
           *)
            type:=scroll; WindowSize(win,h,w);
            IF (h#height) OR (w#width) THEN
              width:=w; height:=h;
              IF dataHeight<=h THEN newTopLine:=0;
              ELSIF (dataHeight-topLine)<=h THEN newTopLine:=dataHeight-h;
              ELSE newTopLine:=topLine;
              END;
              displayLines:=height; Display:=displayProc; EXIT
            END
          ELSIF event=IDCMPFlagSet{gadgetUp} THEN (* Scrollbar *)
            type:=scroll; pr:=gad^.specialInfo;
            scrollHeight:=height-headerLines;
	    (* 3.3.91/bp *)
	    IF dataHeight>headerLines THEN
              infoHeight:=dataHeight-headerLines;
            ELSE
              infoHeight:=0
            END;
            IF dataHeight<=height THEN newTopLine:=0
            ELSE
              newTopLine:=CARDINAL(
              (LONGCARD(pr^.vertPot)*LONGCARD(infoHeight-scrollHeight)+32768)
              /maxBody
              );
(*
 * 14.3.89/ms/Bernd Preusing
 *           CARDINAL(REAL(pr^.vertPot)/REAL(maxBody)*REAL(dataHeight-height))
 *)
            END;
            IF newTopLine#topLine THEN
              displayLines:=height; Display:=displayProc; EXIT
            END
          (* 23.11.90/bp Dies ist nicht korrekt, weil item^.nextSelect nicht
           * ausgewertet wird!
           *)
          ELSIF event=IDCMPFlagSet{menuPick} THEN
            IF what=menuNull THEN (* no menupick=right mouse *)
              WhichWindow(win,x,y);
              IF FindWindow(win,u) THEN
                type:=select; sel:=SelectionSet{source}; XYtoPos(win,x,y,y,x);
                line:=CARDINAL(y)+wInfo[u].topLine; column:=x;
                Select:=wInfo[u].selectProc; EXIT;
              END;
            ELSE
              type:=menu; itemNr:=what DIV 32 MOD 64;
              IF itemNr IN BITSET{2,3,4,6} THEN
                itemNr:=itemNr*2+4+INTEGER(what DIV 2048);
              END;
              IF itemNr=5 THEN
                IF screenInterlace THEN
                  sDepth2:=~sDepth2;
                END;
                screenInterlace:=~screenInterlace;
                ChangeScreen;
              ELSE
                EXIT
              END
            END;
          ELSIF (event=IDCMPFlagSet{mouseButtons}) & (what=selectDown) THEN
            type:=select; sel:=SelectionSet{data}; XYtoPos(win,x,y,y,x);
            line:=CARDINAL(y)+topLine; column:=x;
            Select:=selectProc; EXIT;
          (*
          ELSIF event=IDCMPFlagSet{activeWindow} THEN
            (* WindowToFront(win); already done !! *)
          *)
          END;
        END(*WITH wInfo[u]*);
      END(*IF FindWindow(win,u)*);
    END(*LOOP*);
  END(*WITH command*);
END GetCommand;

PROCEDURE Disp(u:Window; ch:CHAR);
  (*
   * Write a character into the specified window.
   *)
BEGIN
  WriteC(wInfo[u].wdw,ch);
END Disp;

(*$ CopyDyn:=FALSE *)
PROCEDURE DispString(u:Window; s:ARRAY OF CHAR; n:INTEGER);
  (*
   * Write the string into the specified window. The string
   * is written right-adjusted in a field of size n if it is
   * shorter than n, otherwise it is simply written as is.
   *)
VAR
  l:INTEGER;
BEGIN
(*FormatS('DispString: "%s"\n',s);*)
  l:=0;
  WHILE (l<=HIGH(s)) & (s[l]#0C) DO INC(l) END;
  WHILE n>l DO Disp(u,' '); DEC(n) END;
  WriteS(wInfo[u].wdw,s)
END DispString;

PROCEDURE DispLn(u:Window);
  (*
   * Go on a new line in the specified window.
   *)
BEGIN
  WriteL(wInfo[u].wdw)
END DispLn;

PROCEDURE DispNum(u:Window; x:LONGINT; sign:BOOLEAN; n,base:INTEGER);
   (*
    * Display a number in the specified window. The number is written
    * right-adjusted in a field of size n. If it is a hex number than
    * the unused digits are filled with '0' otherwise are left blank.
    * sign indicates whether the number has to be treated as signed
    * number (TRUE) or as unsigned number (FALSE).
    *)
VAR
  fill:CHAR;
  s:ARRAY [0..127] OF CHAR;
  err:BOOLEAN;
BEGIN
(*FormatNr('DispNum: $%06lx\n',x);*)
  IF base=16 THEN fill:='0' ELSE fill:=' ' END;
    (*
     * Assumes no error in conversions.
     *)
  ValToStr(x,sign,s,base,n,fill,err); DispString(u,s,n)
END DispNum;

PROCEDURE DispCard(u:Window; x:LONGCARD; n:INTEGER);
   (*
    * Displays a unsigned number in the specified window.
    * The number is written right-adjusted in a field of
    * size n in decimal representation.
    *)
BEGIN
  DispNum(u,CAST(LONGINT,x),FALSE,n,10)
END DispCard;

PROCEDURE DispInt(u:Window; x:LONGINT; n:INTEGER);
   (*
    * Displays a signed number in the specified window.
    * The number is written right-adjusted in a field of
    * size n in decimal representation.
    *)
BEGIN
  DispNum(u,x,TRUE,n,10)
END DispInt;

(*$ CopyDyn:=FALSE *)
PROCEDURE DispHex(u:Window; x:ARRAY OF BYTE; n:INTEGER);
   (*
    * Displays a unsigned number in the specified window.
    * The number is written right-adjusted in a field of
    * size n in hexadecimal representation. The size of the
    * passed variable determines how much digits are used
    * for the number. E.g. let the value of the number be
    * 1EH and the fieldlength n be 10. Here is how it
    * will be represented, depending on whether it is passed
    * in a variable of type CHAR, INTEGER or LONGINT:
    *
    *     CHAR:    '        1E'
    *     INTEGER: '      001E'
    *     LONGINT: '  0000001E'
    *
    * Of course the quotes are not printed. They are shown to
    * clearly mark the extent of the string.
    *)
VAR
  i:INTEGER;
BEGIN
    (*
     * Subtract from the field length the number of digits needed to
     * display the content of the variable.
     *)
  DEC(n,HIGH(x)*2+2);
    (*
     * If the field is larger than what's needed to represent the number
     * then fill it with blanks.
     *)
  WHILE n>0 DO Disp(u,' '); DEC(n) END;
    (*
     * Now display the contents of the variable. NOTE: We cannot simply
     * pass the whole array, as Dispnum cannot handle numbers larger
     * than a LONGINT.
     *)
  FOR i:=0 TO HIGH(x) DO DispNum(u,CAST(SHORTCARD,x[i]),FALSE,2,16) END
END DispHex;

PROCEDURE DispFFP(u:Window; r:FFP; n:INTEGER);
    (*
     * Realnumbers are displayed as hex numbers. This should change.
     *)
VAR
  err:BOOLEAN;
  l:LONGINT;
  s:ARRAY[0..29] OF CHAR;
BEGIN
  l:=CAST(LONGINT,r);
  (* 11.3.91/bp <=0!! 0.0 ist 0000000! *)
  IF l<=0 THEN FFPConversions.RealToStr(r,s,n,6,TRUE,err);
  ELSE err:=TRUE;
  END;
  IF err THEN Disp(u,"?"); DispHex(u,r,n-1);
  ELSE DispString(u,s,n);
  END;
END DispFFP;

PROCEDURE DispReal(u:Window; r:REAL; n:INTEGER);
    (*
     * Realnumbers are displayed as hex numbers. This should change.
     *)
VAR
  err:BOOLEAN;
  l:LONGCARD;
  s:ARRAY[0..29] OF CHAR;
BEGIN
  l:=CAST(LONGCARD,r); l:=(l DIV 800000H) MOD 100H;
  IF l<0FFH THEN RealConversions.RealToStr(r,s,n,6,TRUE,err);
  ELSE err:=TRUE;
  END;
  IF err THEN
    Disp(u,"?");
(*
 * 14.3.89/ms/Bernd Preusing
 *	DispHex(u,r,n);
 *)
    DispHex(u,r,n-1);
  ELSE DispString(u,s,n);
  END;
END DispReal;

PROCEDURE DispLReal(u:Window; r:LONGREAL; n:INTEGER);
    (*
     * Realnumbers are displayed as hex numbers. This should change.
     *)
TYPE
  Tricky=RECORD hi,lo:LONGCARD; END;
VAR
  err:BOOLEAN;
  l:Tricky;
  s:ARRAY[0..29] OF CHAR;
BEGIN
  l:=CAST(Tricky,r); l.hi:=(l.hi DIV 100000H) MOD 800H;
  IF l.hi<7FFH THEN LongRealConversions.RealToStr(r,s,n,15,TRUE,err);
  ELSE err:=TRUE;
  END;
  IF err THEN
    Disp(u,"?");
(*
 * 14.3.89/ms/Bernd Preusing
 *	DispHex(u,r,n);
 *)
    DispHex(u,r,n-1);
  ELSE DispString(u,s,n);
  END;
END DispLReal;

PROCEDURE CTRL(c:CHAR):BOOLEAN;
BEGIN
  RETURN (c<' ') OR (200C<=c) & (c<240C)
END CTRL;

PROCEDURE DispChar(u: Window; ch: CHAR; n: INTEGER);
   (*
    * n=0: Write characters with quotes.
    * n=1: Use exactly one place (=> CTRL-Chars ='.'
           and normal chars without quotes.
    * n>=2: Use quotes and display ctrl-chars as oooC.
    *)
BEGIN
  IF n=1 THEN
    IF CTRL(ch) THEN Disp(u,'.'); ELSE Disp(u,ch); END;
  ELSIF ~CTRL(ch) THEN
    WHILE n>3 DO Disp(u,' '); DEC(n); END;
    Disp(u,'"'); Disp(u,ch); Disp(u,'"');
  ELSE
    IF n#0 THEN DEC(n); END;
    DispNum(u,LONGINT(ch),FALSE,n,8);
    Disp(u,'C');
  END;
END DispChar;



PROCEDURE RestoreWindow(u:Window);
  (*
   * Gets the height of the window and calls the displayProc with
   * the current topLine and the new height.
   *)
BEGIN
  WITH wInfo[u] DO
   WindowSize(wdw,height,width); displayProc(topLine,height);
  END;
END RestoreWindow;

PROCEDURE WindowHeight(u:Window):CARDINAL;
  (*
   * Return the number of lines that can be displayed in this window.
   *)
BEGIN
  RETURN wInfo[u].height
END WindowHeight;

PROCEDURE WindowWidth(u:Window):CARDINAL;
  (*
   * Return the number of characters per line that can be displayed
   * in this window.
   *)
BEGIN
  RETURN wInfo[u].width
END WindowWidth;

PROCEDURE WindowTopLine(u:Window):CARDINAL;
  (*
   * Return the number of the line which is displayed on the first
   * line of the window.
   *)
BEGIN
  RETURN wInfo[u].topLine
END WindowTopLine;

PROCEDURE Tab(u:Window; position:INTEGER);
  (*
   * This procedure should better be called SetHorizontalPos. It
   * reposition the cursor on the same line at the character position
   * given in `position`.
   *)
VAR l,c:INTEGER;
BEGIN
  WITH wInfo[u] DO GetPos(wdw,l,c); SetPos(wdw,l,position) END
END Tab;

PROCEDURE Mark(u:Window; inverse:BOOLEAN);
  (*
   * This procedure sets the character rendering. if inverse is TRUE,
   * following characters are displayed in inverse mode.
   *)
BEGIN
  WITH wInfo[u] DO
    IF inverse THEN SetMode(wdw,ModeSet{replMd,invMd})
    ELSE SetMode(wdw,ModeSet{replMd})
    END
  END
END Mark;

PROCEDURE InitWindowStatus(u:Window; t,d:CARDINAL);
   (*
    * This procedure sets the number of the first line to be displayed
    * in the window and the number of total lines of the date belonging
    * to this window (e.g. the number of lines of the source, the number
    * of variables etc.). This procedure will also recalculate the
    * size and position of the autoKnob (given in fractions of maxBody).
    * The window is also cleared and the cursor is set to the position
    * 0,0.
    *)
CONST
  flags=PropInfoFlagSet{freeVert,autoKnob};
VAR
  tmp: LONGCARD;
  vertPot,vertBody,scrollHeight: CARDINAL;
BEGIN
  WITH wInfo[u] DO
    topLine:=t; dataHeight:=d; scrollHeight:=height-headerLines;
    IF d<=height THEN
      vertPot:=0; vertBody:=maxBody
    ELSE
      DEC(d,headerLines);
      vertBody:=CARDINAL(LONGCARD(scrollHeight)*maxBody / LONGCARD(d) );
      IF t<(d-scrollHeight) THEN
(*
 * 14.3.89/ms/Bernd Preusing
 *      t:=CARDINAL(REAL(t)/REAL(d-height)*max); (* vertPot *)
 *)
        vertPot:=CARDINAL( LONGCARD(t)*maxBody / LONGCARD(d-scrollHeight) );
      ELSE
        vertPot:=maxBody;
      END;
(*
 * 14.3.89/ms/Bernd Preusing
 *	d:=CARDINAL(REAL(height)/REAL(d)*max)    (* vertBody *)
 *)
    END;
    SetPos(wdw,0,0); Clear(wdw);
    ModifyProp(gadget,wdw,NIL,flags,0,vertPot,0,vertBody);
    (* Intuition 2.0-Macke! /bp *)
    RefreshGadgets(gadget,wdw,NIL);
  END
END InitWindowStatus;



(*
  Men-Aufbau:
  1 Menu: Debug
  Item: .def
  Item: .mod
  Item: Module		Sub: Data1 Data2
  Item: Prozeduren	Sub: Data1 Data2
  Item: Layout		Sub: Sichern Laden
  Item: ScreenMode
  Item: QuellText	Sub: autom aufBefehl
  Item: Ende
*)

CONST
  menWi = 119;
  norm = ID.MenuItemFlagSet{ID.itemText, ID.itemEnabled, ID.highComp};
VAR

  Attr := GD.TextAttr{
	name: ADR("topaz.font"),
	ySize: 8,
	style: GD.FontStyleSet{},
	flags: GD.FontFlagSet{GD.romFont}};

(* ========================================================== *)
  itDef := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: ID.checkWidth, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR(".def"),
	nextText: NIL};
  itMod := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: ID.checkWidth, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR(".mod"),
	nextText: NIL};
  itModule := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: 5, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Module       "),
	nextText: NIL};
  itProc := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: 5, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Prozeduren   "),
	nextText: NIL};
  itLayout := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: 5, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Layout       "),
	nextText: NIL};
  itEnde := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: 5, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Ende"),
	nextText: NIL};
  itData1 := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: ID.checkWidth, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Daten 1"),
	nextText: NIL};
  itData2 := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: ID.checkWidth, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Daten 2"),
	nextText: NIL};
  itInter := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: 5, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Screen"),
	nextText: NIL};
  itQuell := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: 5, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Quelltext    "),
	nextText: NIL};
  itSofort := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: ID.checkWidth, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("automatisch"),
	nextText: NIL};
  itTast := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: ID.checkWidth, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("auf Befehl"),
	nextText: NIL};
  itSave := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: 5, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Sichern"),
	nextText: NIL};
  itLoad := ID.IntuiText{
	frontPen: 0, backPen: 1,
	drawMode: GD.DrawModeSet{},
	leftEdge: 5, topEdge: 1,
	iTextFont: ADR(Attr),
	iText: ADR("Laden"),
	nextText: NIL};

(* =========================================================== *)

  siTast := ID.MenuItem{
	nextItem: NIL,
	leftEdge: 105, topEdge: 10,
	width: 115, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.checkIt},
	mutualExclude: LONGSET{0},
	itemFill: ADR(itTast),
	selectFill: NIL,
	command: " ",
	subItem: NIL};

  siSofort := ID.MenuItem{
	nextItem: ADR(siTast),
	leftEdge: 105, topEdge: 0,
	width: 115, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.checkIt,ID.checked},
	mutualExclude: LONGSET{1},
	itemFill: ADR(itSofort),
	selectFill: NIL,
	command: " ",
	subItem: NIL};


  siLayoutLoad := ID.MenuItem{
	nextItem: NIL,
	leftEdge: 105, topEdge: 10,
	width: 115, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.commSeq},
	mutualExclude: LONGSET{},
	itemFill: ADR(itLoad),
	selectFill: NIL,
	command: "L",
	subItem: NIL};

  siLayoutSave := ID.MenuItem{
	nextItem: ADR(siLayoutLoad),
	leftEdge: 105, topEdge: 0,
	width: 115, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.commSeq},
	mutualExclude: LONGSET{},
	itemFill: ADR(itSave),
	selectFill: NIL,
	command: "S",
	subItem: NIL};


  siProcData2 := ID.MenuItem{
	nextItem: NIL,
	leftEdge: 105, topEdge: 10,
	width: 115, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.checkIt},
	mutualExclude: LONGSET{0},
	itemFill: ADR(itData2),
	selectFill: NIL,
	command: " ",
	subItem: NIL};

  siProcData1 := ID.MenuItem{
	nextItem: ADR(siProcData2),
	leftEdge: 105, topEdge: 0,
	width: 115, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.checkIt,ID.checked},
	mutualExclude: LONGSET{1},
	itemFill: ADR(itData1),
	selectFill: NIL,
	command: " ",
	subItem: NIL};


  siModData2 := ID.MenuItem{
	nextItem: NIL,
	leftEdge: 105, topEdge: 10,
	width: 115, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.checkIt,ID.checked},
	mutualExclude: LONGSET{0},
	itemFill: ADR(itData2),
	selectFill: NIL,
	command: " ",
	subItem: NIL};

  siModData1 := ID.MenuItem{
	nextItem: ADR(siModData2),
	leftEdge: 105, topEdge: 0,
	width: 115, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.checkIt},
	mutualExclude: LONGSET{1},
	itemFill: ADR(itData1),
	selectFill: NIL,
	command: " ",
	subItem: NIL};

(* ======================================================== *)
  miEnde := ID.MenuItem{
	nextItem: NIL,
	leftEdge: 0, topEdge: 70,
	width: menWi, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.commSeq},
	mutualExclude: LONGSET{},
	itemFill: ADR(itEnde),
	selectFill: NIL,
	command: "Q",
	subItem: NIL};

  miImmSrc := ID.MenuItem{
	nextItem: ADR(miEnde),
	leftEdge: 0, topEdge: 60,
	width: menWi, height: 10,
	flags: norm,
	mutualExclude: LONGSET{},
	itemFill: ADR(itQuell),
	selectFill: NIL,
	command: " ",
	subItem: ADR(siSofort)};

  miInter := ID.MenuItem{
	nextItem: ADR(miImmSrc),
	leftEdge: 0, topEdge: 50,
	width: menWi, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.commSeq},
	mutualExclude: LONGSET{},
	itemFill: ADR(itInter),
	selectFill: NIL,
	command: "I",
	subItem: NIL};

  miLayout := ID.MenuItem{
	nextItem: ADR(miInter),
	leftEdge: 0, topEdge: 40,
	width: menWi, height: 10,
	flags: norm,
	mutualExclude: LONGSET{},
	itemFill: ADR(itLayout),
	selectFill: NIL,
	command: " ",
	subItem: ADR(siLayoutSave)};

  miProc := ID.MenuItem{
	nextItem: ADR(miLayout),
	leftEdge: 0, topEdge: 30,
	width: menWi, height: 10,
	flags: norm,
	mutualExclude: LONGSET{},
	itemFill: ADR(itProc),
	selectFill: NIL,
	command: " ",
	subItem: ADR(siProcData1)};

  miModul := ID.MenuItem{
	nextItem: ADR(miProc),
	leftEdge: 0, topEdge: 20,
	width: menWi, height: 10,
	flags: norm,
	mutualExclude: LONGSET{},
	itemFill: ADR(itModule),
	selectFill: NIL,
	command: " ",
	subItem: ADR(siModData1)};

  miMod := ID.MenuItem{
	nextItem: ADR(miModul),
	leftEdge: 0, topEdge: 10,
	width: menWi, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.checkIt,ID.checked},
	mutualExclude: LONGSET{0},
	itemFill: ADR(itMod),
	selectFill: NIL,
	command: " ",
	subItem: NIL};

  miDef := ID.MenuItem{
	nextItem: ADR(miMod),
	leftEdge: 0, topEdge: 0,
	width: menWi, height: 10,
	flags: norm+ID.MenuItemFlagSet{ID.checkIt},
	mutualExclude: LONGSET{1},
	itemFill: ADR(itDef),
	selectFill: NIL,
	command: " ",
	subItem: NIL};

(* ======================================= *)
  mData := ID.Menu{
	nextMenu: NIL,
	leftEdge: 5, topEdge: 0,
	width: 72, height: 8,
	flags: BITSET{0}, (* menuEnabled *)
	menuName: ADR("Debug"),
	firstItem: ADR(miDef)};


PROCEDURE InitStrucs;
BEGIN
  theMenu:=ADR(mData);
  (*
  WITH theFontAttr DO
   name:=ADR("topaz.font");
   ySize:=11;
   style:=FontStyleSet{};
   flags:=FontFlagSet{};
  END;
  theFont:=OpenDiskFont(ADR(theFontAttr));
  *)
END InitStrucs;

(*
 * Ende der vordefinierten Strukturen fr die Menus des Debuggers
 *
 ******************************************************************************)

PROCEDURE InitActions(u:Window; d:DisplayProc; s:SelectProc);
    (*
     * First assigns the displayProc and selectProc to this window and
     * calls InitWindowStatus.
     *)
BEGIN
  WITH wInfo[u] DO
    displayProc:=d; selectProc:=s;
    InitWindowStatus(u,0,0);
  END
END InitActions;



TYPE
  Carr18 = ARRAY [0..17] OF CARDINAL;

CONST
(* Requester *)
  WID	=	290;
  HEI	=	10;
  H	=	HEI+3;
  W	=	WID+4;
  CoordsStr = Carr18{
	0,0,
	W,0,
	W,H,
	0,H,
	0,0,
	W-1,0,
	W-1,H,
	1,H,
	1,0 };
  BorderStr = ID.Border{
	leftEdge: -4,
	topEdge: -3,
	frontPen: 1,
	backPen: 0,
	drawMode: GD.DrawModeSet{},
	count: 9,
	xy: ADR(CoordsStr),
	nextBorder: NIL	};
VAR
  si: ID.StringInfo; (* alles leer *)
  sg := ID.Gadget{
	nextGadget: NIL,
	leftEdge: 15, topEdge: 30,
	width: WID, height: HEI,
	flags: ID.GadgetFlagSet{},
	activation: ID.ActivationFlagSet{ID.relVerify},
	gadgetType: ID.strGadget,
	gadgetRender: ADR(BorderStr),
	selectRender: NIL,
	gadgetText: NIL,
	mutualExclude: LONGSET{},
	specialInfo: ADR(si),
	gadgetID: 2,
	userData: 0};
  nw := ID.NewWindow{
	leftEdge: 50, topEdge: 100,
	width: 390+30, height: 60,
	detailPen: 0, blockPen: 1,
	idcmpFlags: ID.IDCMPFlagSet{ID.gadgetUp},
	flags: ID.WindowFlagSet{ID.activate},
	firstGadget: ADR(sg),
	checkMark: NIL,
	title: NIL,
	screen: NIL, (*theScreen spter!*)
	bitMap: NIL,
	type: ID.customScreen
	};

PROCEDURE InputString(VAR prompt, s: ARRAY OF CHAR);
VAR
  i: INTEGER;
  p: ARRAY [0..79] OF CHAR;
  u:WindowPtr;
  rp: RastPortPtr;
BEGIN
  s[0]:=0C; (* mu leider sein! Zeigt sonst immer Mll an! *)
  si.buffer:=ADR(s); si.undoBuffer:=NIL;
  si.bufferPos:=0; si.maxChars:=HIGH(s); si.dispPos:=0;

  nw.screen:=theScreen;
  Delay(10); (* let Intuition handle all WindowToFront !!! *)
  u:=IntuitionL.OpenWindow(nw); Assert(u#NIL, ADR('no window'));

  rp:=u^.rPort;
  Move(rp, 15, 20); SetAPen(rp, 1);
  p:=newTypeFor; Insert(p, newTypeInsert, prompt);
  Text(rp, ADR(p), Length(p));

  IF ActivateGadget(ADR(sg), u, NIL) THEN END;
  WaitPort(u^.userPort);
  IntuitionL.CloseWindow(u); (* wo bleibt die Message? wird automatisch weg! *)
END InputString;

(*------------ procedures for init and close phase -----------*)

VAR
  ScreenHeight, ScreenWidth:INTEGER;

PROCEDURE ExitM2UD;
  (*
   * Remove all menus from the windows and close them. Deallocate the
   * message port and close the screen.
   *)
VAR u:Window;
   msg:ADDRESS;
BEGIN
  FOR u:=MIN(Window) TO MAX(Window) DO
    WITH wInfo[u] DO
      IF wdw#NIL THEN
       (* 6.12.90/bp sauberes Close! *)
        Forbid;
        LOOP
         (* geht so nur, weil ALLE geschlossen werden! *)
          msg:=GetMsg(wdw^.userPort);
          IF msg=NIL THEN EXIT END;
          ReplyMsg(msg);
        END;
        wdw^.userPort:=NIL;
        ModifyIDCMP(wdw,IDCMPFlagSet{});
        Permit;
        ClearMenuStrip(wdw);
        CloseWindow(wdw);
      END;
    END;
  END;
  IF thePort#NIL THEN DeletePort(thePort); thePort:=NIL; END;
  IF theScreen#NIL THEN CloseScreen(theScreen); theScreen:=NIL END;
END ExitM2UD;


  (*
   * Hey, shoudn't ScreenWidth be variable ??
   * YESS, SSIRRRR!
   *)

PROCEDURE InitScreenAndPort;
   (*
    * Install term procedure, create a message port to be used
    * by all windows and open the screen.
    *)
VAR
  u:Window;
BEGIN
  thePort:=NIL; theScreen:=NIL;
  FOR u:=MIN(Window) TO MAX(Window) DO wInfo[u].wdw:=NIL; END;
  thePort:=CreatePort(NIL,0); Assert(thePort#NIL,ADR('no Port'));

  theScreen:=OpenKick20(screenInterlace);

  Assert(theScreen#NIL,ADR('no screen'));
  ScreenHeight:=theScreen^.height;
  ScreenWidth:=theScreen^.width;
  SetScreen(theScreen);
END InitScreenAndPort;

(*$ CopyDyn:=FALSE *)
PROCEDURE InitWindow(u: Window; x,y,w,h: INTEGER;
                     name: ARRAY OF CHAR;
                     header: CARDINAL);
   (*
    * Open a window with the given location, size and title.
    *)
CONST
  g=WinGadSet{sizing,moving,arranging,scrolling};
BEGIN
  WITH wInfo[u] DO
    IF x+w>ScreenWidth THEN
      IF x=0 THEN
        w:=ScreenWidth;
      ELSE
        x:=ScreenWidth DIV 2;
        w:=x;
      END;
    END;
    IF y+h>ScreenHeight THEN
      IF y<=15 THEN
        h:=ScreenHeight-15;
      ELSE
        y:=ScreenHeight DIV 3;
        h:=y;
      END;
    END;
    OpenWindow(wdw,x,y,w,h,name,g); SetClip(wdw,TRUE);
    Assert(wdw#NIL,ADR("no Window"));
    IF SetMenuStrip(wdw,theMenu) THEN END;
    gadget:=wdw^.firstGadget; (* find scroll gadget *)
    WHILE gadget^.gadgetType#propGadget DO gadget:=gadget^.nextGadget END;
    WindowSize(wdw,height,width);
    headerLines:=header;
    wdw^.userPort:=thePort;
    IF intuitionVersion>=36 THEN
      ModifyIDCMP(wdw,
        IDCMPFlagSet{newSize,mouseButtons,gadgetUp,menuPick,activeWindow,reqClear,
          changeWindow}); (* 5.3.91/bp includes ZipWindow! *)
    ELSE
      ModifyIDCMP(wdw,
        IDCMPFlagSet{newSize,mouseButtons,gadgetUp,menuPick,activeWindow,reqClear});
    END;
    WITH wdw^ DO
      minHeight:=borderTop+borderBottom+2+CAST(INTEGER,(header+1)*rPort^.txHeight);
      minWidth:=borderLeft+borderRight+2+25*CAST(INTEGER,rPort^.txWidth);
    END;
  END
END InitWindow;

VAR
 lineA,lineB,h,w:INTEGER;

PROCEDURE InitM2UD;
VAR window:Window;
BEGIN
   (*
    * Reset the menu, open the screen and a message port for communication
    * with Intuition (all windows share the same port.
    *)
  InitScreenAndPort;
   (*
    * Compute the number of lines in the first, second and third row of
    * the screen. Open all windows.
    *)
  lineA:=(ScreenHeight DIV 24-2)*8+12;
  lineB:=ScreenHeight-lineA; lineA:=lineB-lineA;
  h:=lineB-lineA;
  w:=ScreenWidth DIV 2;
  IF layout.useIt THEN
    IF layout.interlace#screenInterlace THEN
      IF layout.interlace THEN
        FOR window:=MIN(Window) TO MAX(Window) DO
          WITH layout.pos[window] DO y:=y/2; h:=h/2; END
        END
      ELSE
        FOR window:=MIN(Window) TO MAX(Window) DO
          WITH layout.pos[window] DO y:=y*2; h:=h*2; END
        END
      END;
      layout.interlace:=screenInterlace;
    END;
    WITH layout.pos[modWdw] DO
      InitWindow(modWdw,x,y,w,h,"",0)
    END;

    WITH layout.pos[prdWdw] DO
      InitWindow(prdWdw,x,y,w,h,"",1)
    END;


    WITH layout.pos[dt1Wdw] DO
      InitWindow(dt1Wdw,x,y,w,h,"",2)
    END;
    WITH layout.pos[dt2Wdw] DO
      InitWindow(dt2Wdw,x,y,w,h,"",2)
    END;
    WITH layout.pos[srcWdw] DO
      InitWindow(srcWdw,x,y,w,h,"",0)
    END;
  ELSE
    InitWindow(prdWdw,0,lineA,w,h,"", 1);
    InitWindow(modWdw,0,lineB,w,h,"", 0);
    InitWindow(dt1Wdw,w,lineA,w,h,"", 2);
    InitWindow(dt2Wdw,w,lineB,w,h,"", 2);
    InitWindow(srcWdw,0,1,2*w,lineA-1,"", 0);
  END;
  SetWindowTitles(wInfo[modWdw].wdw, ADR(modList), CAST(ADDRESS, -1));

  SetWindowTitles(wInfo[prdWdw].wdw, ADR(procChain), CAST(ADDRESS,-1));

  SetWindowTitles(wInfo[dt1Wdw].wdw, ADR(data1), CAST(ADDRESS, -1));
  SetWindowTitles(wInfo[dt2Wdw].wdw, ADR(data2), CAST(ADDRESS, -1));
  SetWindowTitles(wInfo[srcWdw].wdw, ADR(sourceWindow), CAST(ADDRESS, -1));
  ActivateWindow(wInfo[srcWdw].wdw);
END InitM2UD;


PROCEDURE ChangeScreen;
VAR
  u:Window;
BEGIN
  ExitM2UD;
  InitM2UD;
  FOR u:=MIN(Window) TO MAX(Window) DO RestoreWindow(u) END;
END ChangeScreen;


PROCEDURE Beep;
BEGIN
  DisplayBeep(theScreen);
END Beep;


PROCEDURE RestoreLayout;
   (*
    * Moves all windows to their initial position.
    *)
VAR
  u:Window;
BEGIN
  IF layout.useIt THEN
    IF (layout.interlace # screenInterlace) OR (layout.lDepth2#sDepth2) THEN
      screenInterlace:=layout.interlace;
      sDepth2:=layout.lDepth2;
      ChangeScreen;
      RETURN
    END;
    FOR u:=MIN(Window) TO MAX(Window) DO
      WITH layout.pos[u] DO
        ModifyWindow(wInfo[u].wdw,x,y,w,h);
      END
    END
  ELSE
    ModifyWindow(wInfo[prdWdw].wdw,0,lineA,w,h);
    ModifyWindow(wInfo[modWdw].wdw,0,lineB,w,h);
    ModifyWindow(wInfo[dt1Wdw].wdw,w,lineA,w,h);
    ModifyWindow(wInfo[dt2Wdw].wdw,w,lineB,w,h);
    ModifyWindow(wInfo[srcWdw].wdw,0,1,2*w,lineA-1);
  END;
  Delay(25); (* 29.3.89/ms lasse Intuition ein wenig Zeit *)
  FOR u:=MIN(Window) TO MAX(Window) DO RestoreWindow(u) END;
  ActivateWindow(wInfo[srcWdw].wdw);
END RestoreLayout;


BEGIN
(*
  theMenu:=NIL;
*)
  SETREG(11,ADR(verDollar));
  InitStrucs;

  ReadLayout;
  IF layout.useIt THEN
    srcImm:=layout.srcImm;
    sDepth2:=layout.lDepth2;
    screenInterlace:=layout.interlace;
  ELSE
    srcImm:=TRUE;
    (*
    screenInterlace:=FALSE;
    sDepth2:=FALSE;
    *)
  END;

  IF srcImm THEN
    INCL(siSofort.flags,checked);
    EXCL(siTast.flags,checked);
  ELSE
    EXCL(siSofort.flags,checked);
    INCL(siTast.flags,checked);
  END;
(*  InitM2UD; *)
(*-jr
  WriteString('m2ud>')
*)
CLOSE
  ExitM2UD;
  (*IF theFont#NIL THEN CloseFont(theFont); theFont:=NIL END*)
END m2ud.
