(*$ LargeVars:=FALSE NilChk:=FALSE StackParms:=FALSE Volatile:=FALSE *)
MODULE m2project;
(*
 * 15.8.92/bp
 * Project in Root verboten!
 *
 * 4.9.90/bp
 *
 * Angepat fr cond. Compiling deutsch/englisch
 * und fr fib am Textanfang $ L + gesetzt!
 * 6.11.89/ms
 *
 * Kaum kann unser Compiler globale Variablen auf Langwortadressen ablegen,
 * wird dies bereits benutzt. Hier haben wir einen FileInfoBlock, den
 * wir nich extra allozieren wollen.
 *)

FROM SYSTEM	IMPORT	ADDRESS,ADR,SETREG;
FROM ArgHandler	IMPORT	interActive,InitHandler,FetchName,fName,fNameLen,
			SetReply;
FROM ReplyVals	IMPORT	rcActionErr,rcWarn,rcIllOpt;
FROM Arts	IMPORT	programName,wbStarted,Assert,BreakPoint;
FROM ASCII	IMPORT	eol,eof;
FROM DosD	IMPORT	sharedLock,FileInfoBlock,FileLockPtr,
			noMoreEntries;
FROM DosL	IMPORT	CurrentDir,Examine,ExNext,IoErr,Rename;
FROM DosSupport	IMPORT	CreateDir,Lock,ParentDir,UnLock;
FROM ExecL	IMPORT	AddTail,Remove;
FROM ExecSupport IMPORT NewList;
FROM M2Amiga	IMPORT	MakeIcon;
FROM Terminal	IMPORT	waitCloseGadget,Read,ReadLn,WriteString,WriteLn,
			Format,FormatS;
FROM String	IMPORT	Compare,FirstPos,Copy,Concat,Occurs,LastPos;
FROM PatMatch	IMPORT	CmplPat,Match;
FROM Heap	IMPORT	Allocate,Deallocate;
(*$ DEFINE English:=FALSE *)


TYPE
  FTyp=(bin,obj,ref,sym,txt);

CONST
 ver="4.4";
 date=COMPILEDATE;
 verDollar="$VER: m2project "+ver+" "+date;
 title1="m2project";

 title2=
(*$ IF English *)	"Amiga Modula-2 Project Manager";
(*$ ELSE *)		"Amiga Modula-2 Projekt Werkzeug";
(*$ ENDIF *)

 version=
(*$ IF English *)	", "+ver+"d, "+date+"\n";
(*$ ELSE *)		", "+ver+"d, "+date+"\n";
(*$ ENDIF *)

 usage=
(*$ IF English *)	"Usage:\n %s {+-bimorst ProjectName}\n";
(*$ ELSE *)		"Aufruf:\n %s {+-bimorst ProjectName}\n";
(*$ ENDIF *)

 errMsg=
(*$ IF English *)	'Error opening "%s"\n';
(*$ ELSE *)		'Fehler beim Erffnen von "%s"\n';
(*$ ENDIF *)

 infoMissing=
(*$ IF English *)	"%s.info not found!!\n";
(*$ ELSE *)		"%s.info nicht gefunden!!\n";
(*$ ENDIF *)

 creating=
(*$ IF English *)	"Creating %s\n";
(*$ ELSE *)		"Erffne %s\n";
(*$ ENDIF *)

 noRoot=
(*$ IF English *)	"Project must not be in root!\n";
(*$ ELSE *)		"Projekt darf nicht im Wurzelverzeichnis liegen!\n";
(*$ ENDIF *)

 oom=
(*$ IF English *)	"m2project: not enough memory";
(*$ ELSE *)		"m2project: nicht gengend Speicher";
(*$ ENDIF *)

 exit=
(*$ IF English *)	" --- exit\n";
(*$ ELSE *)		" --- ende\n";
(*$ ENDIF *)

 prompt="dir> ";

 objPat="#?.ob?(%|.info)";
 refPat="#?.ref(%|.info)";
 symPat="#?.sym(%|.info)";
 txtPat="#?.(def|mod|asm)(%|.info)";
 binPat="(path|ref|obj|sym|bin|txt)(%|.info)"; (* Bei bin negiert!! *)

VAR
(*$ LongAlign:=FALSE *)
  i: INTEGER;
(*$ LongAlign:=TRUE *)
  fib: FileInfoBlock;
  reserved:ARRAY[0..31] OF LONGINT; (* Ist Fib lnger geworden??? *)
(*$ POP LongAlign *)
  olddir,base: FileLockPtr;
  icon,move: BOOLEAN;

  wild: ARRAY FTyp OF ARRAY[0..35] OF CHAR;
  doit:ARRAY FTyp OF BOOLEAN;


PROCEDURE Move(typ:FTyp; name:ARRAY OF CHAR);
TYPE
  EntryPtr=POINTER TO Entry;
  Entry=RECORD
    succ,pred:EntryPtr;
    name:ARRAY[0..107] OF CHAR;
  END;
VAR
  eList:RECORD head,tail,tailPred: EntryPtr END;
  e:EntryPtr;
  aux:ARRAY[0..127] OF SHORTCARD;
  newname:ARRAY[0..127] OF CHAR;
  dotPos:INTEGER;
  match:BOOLEAN;

  PROCEDURE NewEntry(name:ARRAY OF CHAR);
  VAR e:EntryPtr;
  (*$ CopyDyn:=FALSE *)
  BEGIN
    Allocate(e,SIZE(e^));
    Assert(e#NIL,ADR(oom));
    Copy(e^.name,name);
    AddTail(ADR(eList),e);
  END NewEntry;

(*$ CopyDyn:=FALSE *)
BEGIN
  NewList(ADR(eList));

(* Dies geht leider nicht in einem Durchgang wegen ExNext! *)
  IF CmplPat(wild[typ],aux) THEN
    IF Examine(base,ADR(fib)) THEN
      WHILE ExNext(base,ADR(fib)) DO
	IF fib.dirEntryType<0 THEN
	  match:=Match(wild[typ],aux,fib.fileName);
	  dotPos:=FirstPos(fib.fileName,0,".");
	  IF ((typ#bin) & match)
	  OR ((typ=bin) & ~match &
	      ( (dotPos=0) OR
	        (dotPos=Occurs(fib.fileName,0,".info",FALSE)) &
	        (dotPos=LastPos(fib.fileName,127,"."))
	      )
	     ) THEN
	    NewEntry(fib.fileName);
	  END;
	END;
      END;
      IF IoErr()#noMoreEntries THEN
        SetReply(rcActionErr);
      END;
    ELSE
      SetReply(rcActionErr);
    END;

    WHILE eList.head^.succ#NIL DO
      e:=eList.head;
      Remove(e);
      Copy(newname,name);
      Concat(newname,"/");
      Concat(newname,e^.name);
      IF Rename(ADR(e^.name),ADR(newname)) THEN
	WriteString("Rename: \"");
      ELSE
	WriteString("Kann nicht: \"");
      END;
      WriteString(e^.name);
      FormatS("\" --> \"%s\"\n",newname);
      Deallocate(e);
    END;
  ELSE
    SetReply(rcActionErr);
  END; (* CmplPat *)
END Move;

(*$ CopyDyn:=FALSE *)
PROCEDURE MakeDir(name,defaultIcon: ARRAY OF CHAR; typ: FTyp);
VAR
 dir: FileLockPtr;
BEGIN
 IF doit[typ] THEN
  dir:=Lock(ADR(name), sharedLock);
  IF dir#NIL THEN
   IF ~Examine(dir,ADR(fib)) OR (fib.dirEntryType<0) THEN
    UnLock(dir); dir:=NIL
   END;
  ELSE
   dir:=CreateDir(ADR(name));
   IF dir#NIL THEN
     Move(typ,name);
   END;
  END;
  IF dir#NIL THEN
   IF icon THEN
     MakeIcon(name,defaultIcon);
   END;
   UnLock(dir)
  ELSE
   FormatS(errMsg,name);
   SetReply(rcActionErr);
  END
 END
END MakeDir;

(*$ CopyDyn:=FALSE *)
PROCEDURE Options(s:ARRAY OF CHAR;len:INTEGER):BOOLEAN;
VAR i:INTEGER; set:BOOLEAN;
BEGIN
  i:=0;
  LOOP
    IF i>=len THEN EXIT END;
    CASE CAP(s[i]) OF
    | '+': set:=TRUE;
    | '-': set:=FALSE;
    | 'I': icon:=set;
    | 'B': doit[bin]:=set;
    | 'O': doit[obj]:=set;
    | 'R': doit[ref]:=set;
    | 'S': doit[sym]:=set;
    | 'T': doit[txt]:=set;
    | "M": move:=set;
    | ELSE
	WriteString(title1); WriteString(version);
	Format(usage,ADR(programName));
	SetReply(rcIllOpt);
	RETURN FALSE;
    END;
    INC(i);
  END;
  RETURN TRUE;
END Options;

VAR
 dejaVue,
 err:    BOOLEAN;

BEGIN
  SETREG(11,ADR(verDollar));
  doit[sym]:=TRUE; doit[obj]:=TRUE; doit[ref]:=TRUE; doit[bin]:=TRUE; doit[txt]:=TRUE;
  icon:=wbStarted;
  move:=TRUE;
  wild[obj]:=objPat;
  wild[ref]:=refPat;
  wild[sym]:=symPat;
  wild[txt]:=txtPat;
  wild[bin]:=binPat;

  InitHandler(Options,ADR(prompt),ADR("ENV:m2project"),ADR("m2project.opt"));

  WriteString(title2); WriteString(version);
  IF ~FetchName() THEN RETURN END;
  IF fNameLen=0 THEN interActive:=TRUE END;

  LOOP
    IF dejaVue OR (fNameLen=0) THEN REPEAT UNTIL FetchName() END;
    dejaVue:=TRUE;
    IF fNameLen=0 THEN EXIT END;
    IF interActive THEN
      waitCloseGadget:=FALSE;
    END;
    err:=FALSE;
    FormatS(creating,fName);
    base:=Lock(ADR(fName),sharedLock);
    IF base#NIL THEN

      IF Examine(base,ADR(fib)) THEN
        IF fib.dirEntryType<0 THEN (* Ist Datei! *)
          err:=TRUE;
        ELSE (* directory *)
          olddir:=ParentDir(base);
          IF olddir#NIL THEN
            UnLock(olddir);
          ELSE
            err:=TRUE;
            WriteString(noRoot);
          END;
        END;
      ELSE
        err:=TRUE;
      END;
      IF err THEN
       UnLock(base); base:=NIL
      END;
    ELSE
      base:=CreateDir(ADR(fName))
    END;
    IF base#NIL THEN
      IF icon THEN
        MakeIcon(fName,"dir");
      END;
      olddir:=CurrentDir(base);
      MakeDir("obj","objDir",obj);
      MakeDir("ref","refDir",ref);
      MakeDir("sym","symDir",sym);
      MakeDir("txt","txtDir",txt);
      MakeDir("bin","binDir",bin);
      base:=CurrentDir(olddir);
      UnLock(base)
    ELSE
      FormatS(errMsg,fName);
      SetReply(rcActionErr);
    END
  END; (* loop *)
  waitCloseGadget:=~interActive;
END m2project.
