IMPLEMENTATION MODULE m2md;
(* 12.05.88/cn *)
(* 6.2.94/bp MemTest mit TypeOfMem() *)

(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)

FROM SYSTEM	IMPORT	ADDRESS,ADR,BYTE,CAST,LONGSET;
FROM DebugDef	IMPORT	ModuleInfo,DebugInfo2Ptr;
FROM Arts	IMPORT	maxModName,ErrorType,ModType,
			SysErr,Assert,BreakPoint;
FROM ExecL	IMPORT	TypeOfMem;
FROM Conversions IMPORT	ValToStr;
FROM M2Base	IMPORT	MName, MPtr;
FROM String	IMPORT	first, Copy, Compare, Insert, Length;
IMPORT R;
FROM m2d	IMPORT	moduleInfo,errFrame;
(*FROM Terminal IMPORT	FormatNr,WriteString,WriteLn;*)

TYPE
 StrPtr=POINTER TO ARRAY [0..79] OF CHAR;

CONST
 sb=R.A4; mp=R.A5;

(*$ RangeChk:=FALSE OverflowChk:=FALSE *)
(*

TYPE
 Double=RECORD
  CASE :BOOLEAN OF
  | FALSE: compound:LONGINT;
  | TRUE: hi,lo:INTEGER;
  END;
 END;

PROCEDURE Low(long:LONGINT):INTEGER;
 VAR
  double:Double;
 BEGIN
  double.compound:=long; RETURN double.lo;
 END Low;

PROCEDURE High(long:LONGINT):INTEGER;
 VAR
  double:Double;
 BEGIN
  double.compound:=long; RETURN double.hi;
 END High;
*)


PROCEDURE MemoryByte(byteAddr:ADDRESS):CARDINAL;
BEGIN
 IF CAST(LONGSET,TypeOfMem(byteAddr)) <> LONGSET{} THEN
   RETURN CARDINAL(CAST(SHORTCARD, byteAddr^))
 ELSE
   RETURN 0
 END;
END MemoryByte;

PROCEDURE MemoryWord(byteAddr:ADDRESS):CARDINAL;
BEGIN
  RETURN MemoryByte(byteAddr)*100H+MemoryByte(byteAddr+1)
 (* high byte first on AMIGA computer *)
END MemoryWord;

PROCEDURE MemoryDoubleWord(byteAddr:ADDRESS):LONGINT;
VAR lPtr{3}:POINTER TO LONGINT;
BEGIN
 (* 23.11.90/bp
  * Die gibt bei AbsExecBase [4] 4 Bytezugriffe, was der Enforcer
  * bemngelt, also nun Langwort-Zugriff!
  *)
 IF (CAST(LONGINT,byteAddr) MOD 4 = 0)
    & (CAST(LONGSET,TypeOfMem(byteAddr)) <> LONGSET{}) THEN
   lPtr:=byteAddr;
   RETURN lPtr^;
 ELSE
   RETURN CAST(LONGINT,MemoryWord(byteAddr)*10000H+MemoryWord(byteAddr+2))
 END;
 (* high word first on AMIGA computer *)
END MemoryDoubleWord;

(*$ POP RangeChk POP OverflowChk *)

PROCEDURE GetProcessStatus;
  (*
   * Copy the error message from errFrame into processStatus.
   *)
VAR
  p:POINTER TO ARRAY[0..SIZE(processStatus)-1] OF CHAR;
BEGIN
  p:=errFrame.body;
  IF p=NIL THEN p:=errFrame.header; END;
  IF p#NIL THEN
    Copy(processStatus,p^)
  ELSE
    processStatus:="----";
  END;
END GetProcessStatus;


(*
 * GetProcedureChain
 *
 * TYPE
 *  ProcedureMark=RECORD
 *    dynamicLink: ProcedureMarkPtr; (* oder wegoptimiert! *)
 *    CASE :ProcType OF
 *    | local:
 *      returnAddr: ADDRESS;
 *      staticLink: ADDRESS
 *    | global:
 *      returnAddr: ADDRESS
 *    END
 *  END;
 *)


PROCEDURE IdentifyModule(errPC:ADDRESS; VAR p:MPtr; VAR mNr:INTEGER);
VAR i:INTEGER;
BEGIN
 (*
  * Find out to which module it belongs. mNr contains the number of the
  * module and p points to its info block. We look for a module which has
  * errPC in its coderange
  *)
(*  FormatNr('Identi errPc:%06lx',errPC);*)
  FOR i:=0 TO modInfoList.length-1 DO
    WITH modInfoList.contents[i].l^ DO
      IF (errPC >= modcode) & (errPC < LONGINT(modcode+modcodeSize)) THEN
        p:=ADR(modname); (* erstes Feld! *)
        mNr:=i;
(*  FormatNr(' modul:%02ld\n',i);*)
        RETURN;
      END;
    END;
  END;
(*  WriteString(' modul nicht gef\n');*)
  p:=NIL; mNr:=0;
END IdentifyModule;

PROCEDURE GetProcedureChain;
TYPE
  ProcedureMarkPtr=POINTER TO ProcedureMark;
  ProcedureMark=RECORD
    dynLink:ProcedureMarkPtr; (* nicht bei optimierten und Modulen! *)
    returnAddr:ADDRESS;
    staticLink:ADDRESS;
  END;

VAR
  p: MPtr;
  errPC:LONGINT;
  mNr: INTEGER;
  i:INTEGER;
  markPtr:ProcedureMarkPtr;
BEGIN
 (*
  * Prozeduren, die kein LINK haben, werden falsch angezeigt
  * oder bersprungen! Es knnte ein Modul sein, dann ist dynLink
  * ein gltiger PC (wenn keine Regs auf dem Stack wren!)!
  *)
  markPtr:=errFrame.aRegs[mp]; errPC:=errFrame.pc;

(*  FormatNr('1. markPtr:%06lx\n',LONGINT(markPtr));*)

  i:=0;
  LOOP
    IdentifyModule(errPC,p,mNr);
    WITH procInfoList.contents[i] DO
(*    FormatNr('list[%ld]:',i);*)
      IF p#NIL THEN
        dataBase:=ADDRESS(markPtr); (* kann ruhig NIL sein, wenn Modul! *)
        modNo:=mNr;
        pc:=(errPC-p^.modcode);
(*      FormatNr('modNo=%ld, ',modNo);*)
(*      FormatNr('pc=%06lx\n',pc);*)
      ELSE
        dataBase:=NIL; (* kann ruhig NIL sein, wenn Modul! *)
        modNo:=-1; pc:=-1;
(*      WriteString('beide=-1\n');*)
      END;
    END; (* with *)
    INC(i);
    IF (markPtr=NIL) OR ODD(LONGINT(markPtr)) OR (i>=maxProcs) THEN EXIT END;
    errPC:=markPtr^.returnAddr;
    markPtr:=markPtr^.dynLink;
  END;(* loop *)

  procInfoList.length:=i;
(*FormatNr('ListLen=%ld\n',i);*)
END GetProcedureChain;

PROCEDURE GetValue(adr:LONGINT; ind:IndType; VAR val:ARRAY OF BYTE);
   (*
    * Get the value to which 'adr' points. If there is an indirection, then
    * resolve it first.
    *)
VAR
  i:INTEGER;
  tr:RECORD
    CASE :INTEGER OF
    | 0: l:LONGINT;
    | 1: a:ARRAY[0..3] OF BYTE
    END;
  END;
BEGIN
 (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
  IF ind=aptr THEN
    adr:=MemoryDoubleWord(adr);
  ELSIF ind=bptr THEN
    adr:=MemoryDoubleWord(adr)*4;
  END;
  IF HIGH(val)=3 THEN (* Vermeide Bytezugriffe auf Adresse 4! 23.11.0/bp *)
    tr.l:=MemoryDoubleWord(adr);
    val[0]:=tr.a[0];
    val[1]:=tr.a[1];
    val[2]:=tr.a[2];
    val[3]:=tr.a[3];
  ELSE
    FOR i:=0 TO HIGH(val) DO
      val[i]:=CAST(BYTE,SHORTCARD(MemoryByte(adr+i)));
    END;
  END;
 (*$ POP RangeChk POP OverflowChk *)
END GetValue;

PROCEDURE GetAddress(adr:LONGINT; ind:IndType; VAR radr:ADDRESS);
   (*
    * If we have an indirection, we must take the memory value at position
    * 'adr', otherwise 'adr' is already the address we need.
    *)
BEGIN
  (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
  IF ind=aptr THEN
    adr:=MemoryDoubleWord(adr);
  ELSIF ind=bptr THEN
    adr:=MemoryDoubleWord(adr)*4;
  END;
  radr:=adr;
  (*$ POP RangeChk POP OverflowChk *)
END GetAddress;

PROCEDURE GetHIGH(adr:LONGINT; VAR high:LONGINT);
   (*
    * 'adr' points to a parameter which is an open array. To get HIGH of this
    * array, we must get the double word at following the address of the
    * array.
    *)
BEGIN
  high:=MemoryDoubleWord(adr+4);
END GetHIGH;

(*$ CopyDyn:=FALSE *)
PROCEDURE FindModule(name: ARRAY OF CHAR): INTEGER;
 (* quick hack, so it does its job !!! *)
VAR
  m: MPtr;
  n: INTEGER;
  libName: MName;
BEGIN
  Copy(libName, name);
  (*Insert(libName, Length(libName), '.library');*)
  FOR n:=0 TO modInfoList.length-1 DO
    IF Compare(modInfoList.contents[n].l^.modname,libName)=0 THEN
      RETURN n
    END;
  END;
  RETURN -1;
END FindModule;

PROCEDURE InitM2MD;
VAR
  i:INTEGER;
  d2:DebugInfo2Ptr;
BEGIN (* m2md *)
 (*-jr
  WriteString('<m2md');WriteLn;
 *)
   (*
    * Initialize an empty procInfoList with one procedure (what for ?)
    *)
  modInfoList.length:=moduleInfo^.modCount;
  d2:=CAST(DebugInfo2Ptr,moduleInfo);
  INC(d2,modInfoList.length*SIZE(ModuleInfo)+4);
  IF d2^.modCount#moduleInfo^.modCount THEN (* alles klar, neuer Linker! *)
    d2:=NIL
  END;
  FOR i:=0 TO modInfoList.length-1 DO
    WITH modInfoList.contents[i] DO
      l:=ADR(moduleInfo^.arr[i]);
      WITH l^ DO
        bssBase:=modbss;
        IF bssmerged THEN INC(bssBase,errFrame.aRegs[sb]) END;
      END;
      IF d2#NIL THEN
        WITH d2^.arr2[i] DO
          iniBase:=modini;
          IF inimerged THEN INC(iniBase,errFrame.aRegs[sb]) END;
        END;
      ELSE
        iniBase:=bssBase; (* NOT used, gibt evtl. falsche Anzeige! *)
      END;
    END;
  END;

  procInfoList.length:=1;
  FOR i:=0 TO maxProcs DO
    WITH procInfoList.contents[i] DO (* error entry *)
      modNo:=maxMods; procNo:=0; pc:=0; errStart:=0; errStop:=0
    END
  END;
 (*-jr
  WriteString('m2md>')WriteLn;
 *)
END InitM2MD;

PROCEDURE ExitM2MD;
END ExitM2MD;

END m2md.
