MODULE m2make;

(*$ LargeVars:=FALSE LongAlign:=FALSE StackParms:=FALSE Volatile:=FALSE
    DEFINE English:=FALSE *)


FROM SYSTEM IMPORT ADR, CAST, SETREG;

FROM Arts IMPORT
  ModName, programName, wbStarted;

FROM ASCII IMPORT
  nul, eol, eof;

FROM AMScan IMPORT
  ScanString;

FROM ArgHandler IMPORT
  interActive, verbose, fName, fNameLen, InitHandler, FetchName, SetReply;

FROM ReplyVals IMPORT
  rcIllOpt, rcImportantNotFound, rcMainNotFound;

FROM String IMPORT
  noOccur, last, Compare, Copy, Concat, LastPos;

FROM Terminal IMPORT
  waitCloseGadget, Read, Write, WriteLn, WriteString, Format, FormatNr, FormatS;

FROM Break IMPORT
  TestBreak;

FROM MkBase IMPORT
  FileName, quiet, isLinkable, warning, external, GetDate;

FROM MkFile IMPORT
  FileType, pathFileName, ReadPathTable;

FROM MkParser IMPORT
  GetDependencies;

FROM MkDpd IMPORT
  InDpd, OutDpd;

FROM MkCheck IMPORT
  Str64, objType, forceCPU, toFile, BinToLink, Make;

FROM MkExecute IMPORT
  outString, InitExec, Call;

FROM MkPrint IMPORT
  PrintDependencies;


CONST
 title = "Amiga Modula-2 Make";
 name = "m2make";
 ver = "4.4";
 dat = COMPILEDATE;
 verDollar = "$VER: m2make "+ver+" "+dat;
 version = ", "+ver+
     (*$ IF English *)
     "e, "+
     (*$ ELSE *)
     "d, "+
     (*$ ENDIF *)
     dat+"\n";
 in = "m2make> ";
 m2cNam = CAST(LONGINT,"\x03m2c");
 m2lNam = CAST(LONGINT,"\x03m2l");

(*$ IF English *)

  usage=
   "Usage:\n %s {+-012348dfilnpqwx -cCompO -oLinkO -sCompStack -tTarget ? ?? Modul}\n";
  exit = "--- exit\n";
  upToDate = "\n%s is up to date.\n\n";
  notFound = '\n"%s" not found.\n\n';
  resErr = "\n!! errors detected: return value=%ld\n\n";
  resOk = "\nMake successfully done.\n\n";

(*$ ELSE *)

  usage =
   "Aufruf:\n %s {+-012348dfilnpqwx -cCompO -oLinkO -sCompStack -tTarget ? ?? Modul}\n";
  exit = "--- ende\n";
  upToDate = "\n%s ist auf dem neuesten Stand.\n\n";
  notFound = '\n"%s" nicht gefunden.\n\n';
  resErr = "\n!! Fehler aufgetreten: Rckgabewert=%ld\n\n";
  resOk = "\nMake erfolgreich durchgefhrt.\n\n";

(*$ ENDIF *)


VAR
  compile: BOOLEAN;
  cpu: ARRAY [0..3] OF CHAR; (* "+3" oder "+0i" etc. *)
  m2cOpt, m2lOpt: Str64;
  CompStack: LONGINT;
  useDpd, doIt, icon, print, linkIt: BOOLEAN;
  lastDir: RECORD CASE :INTEGER OF
   | 0: full: FileName;
   | 1: go: ARRAY [0..1] OF CHAR;
        st: ARRAY [0..SIZE(FileName)-2] OF CHAR;
  END END;
  lastTrenn: INTEGER;


PROCEDURE AddArg(s: ARRAY OF CHAR);
(*$ CopyDyn:=FALSE *)
  BEGIN
    Concat(outString, ' ');
    Concat(outString, s);
  END AddArg;


PROCEDURE CompProc(st: ARRAY OF CHAR; trenn: INTEGER);
(*$ CopyDyn:=FALSE *)
  VAR trick: POINTER TO FileName; old: CHAR;
  BEGIN
    IF ~compile THEN (* for the first time? *)
      compile:=TRUE;
      InitExec(CompStack);
      lastDir.st[0]:=0C;
      lastTrenn:=-1;
      IF ~doIt THEN Copy(outString,'m2:m2c') END;
      AddArg(cpu);
      AddArg(m2cOpt);
    END;
    IF trenn>=0 THEN (* nicht dieses Projekt! *)
      lastTrenn:=trenn;
      INC(trenn); (* 16.10.90/bp War Fehler bei m4: --> wurde zu m4 *)
      old:=st[trenn]; st[trenn]:=0C;
      IF Compare(lastDir.st, st)#0 THEN
        Copy(lastDir.st, st);
        lastDir.go:="-g";
        AddArg(lastDir.full);
      END;
      st[trenn]:=old;
      trick:=ADR(st[trenn]);
      AddArg(trick^);
    ELSE
      IF lastTrenn>=0 THEN
        AddArg('-g'); (* go home! *)
        lastTrenn:=-1;
        lastDir.st[0]:=0C;
      END;
      AddArg(st)
    END;
  END CompProc;


PROCEDURE Options(s: ARRAY OF CHAR; len: INTEGER): BOOLEAN;
(*$ CopyDyn:=FALSE *)
  TYPE
    oStat=(ok, showUsage, showOpts, ill);
  VAR
    set: BOOLEAN;
    stat: oStat;
    i, pos: INTEGER;
    ch:CHAR;
    str: Str64;
    st: LONGINT;
    plusMinus: ARRAY BOOLEAN OF CHAR;
  BEGIN
    IF s[0]='?' THEN
      stat:=showUsage;
      IF (HIGH(s)>0)&(s[1]="?") THEN stat:=showOpts END
    ELSE
      stat:=ok;
      i:=0;
      LOOP
        ch:=CAP(s[i]);
        CASE ch OF (* zunchst kommt ja sicher '+' oder '-'! *)
        | '+': set:=TRUE;
        | '-': set:=FALSE;
        | '0': objType:=objFile; cpu[1]:=ch;
        | '1': objType:=ob1File; cpu[1]:=ch;
        | '2': objType:=ob2File; cpu[1]:=ch;
        | '3': objType:=ob3File; cpu[1]:=ch;
        | '4': objType:=ob4File; cpu[1]:=ch;
        | '8': objType:=ob8File; cpu[1]:=ch;
        | 'Q': verbose:=set; quiet:=~set; warning:=verbose;
        | 'D': useDpd:=set;
        | 'L': linkIt:=set;
        | 'N': doIt:=set;
        | 'I': icon:=set;
        | 'F': forceCPU:=set;
        | 'P': print:=set;
        | 'W': warning:=set;
        | 'X': external:=set;
        | 'C','O','T':
          pos:=0; INC(i);
          WHILE (i<len)&(pos<63) DO
            str[pos]:=s[i] ;
            INC(pos); INC(i);
          END;
          str[pos]:=0C;
          IF    ch='C' THEN m2cOpt:=str
          ELSIF ch='O' THEN m2lOpt:=str;
          ELSE
            toFile.op:='-t';
            toFile.str:=str;
          END;
        | 'S':
          st:=0; INC(i);
          WHILE i<len DO
            IF (s[i]>='0')&(s[i]<='9') THEN
              st:=st*10+ORD(s[i])-30H;
            ELSE
              stat:=ill;
              EXIT
            END;
            INC(i);
          END;
          st:=((st+3) DIV 4) * 4; (* LONGAlign! *)
          CompStack:=st;
          IF CompStack<20000 THEN CompStack:=2000 END;
        ELSE
          stat:=ill;
          EXIT
        END; (* case *)
        INC(i);
        IF i>=len THEN EXIT END;
      END; (* loop *)
      IF interActive THEN verbose:=TRUE END;
    END;
    IF stat#ok THEN
      WriteString(name); WriteString(version);
      Format(usage,ADR(programName));
      SetReply(rcIllOpt);
      IF stat=showOpts THEN
        plusMinus[TRUE]:="+";
        plusMinus[FALSE]:="-";
        WriteString('Status:\n  ');
        Write(plusMinus[useDpd]);    WriteString('D (useDpd)      ');
        Write(plusMinus[linkIt]);    WriteString('L (linkit)      ');
        Write(plusMinus[external]);  WriteString('X (extern)      ');
        Write(plusMinus[icon]);      WriteString('I (icon)\n  ');
        Write(plusMinus[doIt]);      WriteString('N (doIt)        ');
        Write(plusMinus[forceCPU]);  WriteString('F (forceCPU)    ');
        Write(plusMinus[warning]);   WriteString('W (warnings)    ');
        WriteString('CPU: '); Write(cpu[1]);
        FormatNr("\n  Compiler-Stack    (S): %ld\n",CompStack);
        FormatS("  Compiler-Optionen (C): \"%s\"\n",m2cOpt);
        FormatS("  Linker-Optionen   (O): \"%s\"\n",m2lOpt);
        FormatS("  Zieldatei         (T): \"%s\"\n",toFile.str);
      END;
    END;
    RETURN stat=ok;
  END Options;


VAR
  i: INTEGER;
  depOk, dejaVue, link: BOOLEAN;
  modName: ModName;
  result: LONGINT;

BEGIN
  SETREG(11,ADR(verDollar));
  objType:=objFile;
  cpu[0]:='+';
  cpu[1]:='0';
  (* 23.1.91/bp Bei wbstart mssen wir Icons erzwingen m2c,m2l! *)
  IF wbStarted THEN cpu[2]:='i' END;

  forceCPU:=FALSE;
  useDpd:=FALSE; doIt:=TRUE; icon:=wbStarted; quiet:=FALSE; warning:=TRUE;
  external:=TRUE;
  linkIt:=TRUE;
  CompStack:=2000;
  InitHandler(Options, ADR(in), ADR('ENV:m2make'), ADR("m2make.opt"));
  WriteString(title); WriteString(version);

  IF ~FetchName() THEN RETURN END; (* bei Aufruffehler gleich raus *)
  IF fNameLen=0 THEN interActive:=TRUE END;
  ReadPathTable(pathFileName);

  (* Nun erstes Arg holen! *)
  LOOP
    TestBreak;
    IF dejaVue OR (fNameLen=0) THEN
      REPEAT UNTIL FetchName(); (* bis Leerstring oder guter *)
    END;
    dejaVue:=TRUE;
    IF fNameLen=0 THEN EXIT END;
    IF interActive THEN verbose:=TRUE END;
    Copy(modName, fName);
    ReadPathTable(pathFileName);

    i:=LastPos(modName,100,".");
    IF i#noOccur THEN modName[i]:=nul END;

    IF useDpd & InDpd(modName) THEN depOk:=TRUE
    ELSE
      depOk:=GetDependencies(modName);
      IF depOk THEN OutDpd(icon) END
    END;
    IF ~depOk THEN
      FormatS(notFound, modName);
      SetReply(rcMainNotFound);
    ELSE
      IF print THEN
        PrintDependencies
      ELSE
        compile:=FALSE;
        Make(CompProc);
        link:=isLinkable & (compile OR BinToLink());
        IF ~compile & ~link THEN
          IF toFile.str[0]#0C THEN FormatS(upToDate, toFile.str)
          ELSE                     FormatS(upToDate, modName)
          END;
        ELSIF doIt THEN
          IF compile THEN
            result:=Call("m2:m2c", m2cNam);
            link:=link & (result=0)
          END;
          IF linkIt & link THEN
            InitExec(2000);
            AddArg(cpu);
            AddArg(m2lOpt);
            IF toFile.str[0]#0C THEN AddArg(toFile.s) END;
            AddArg(modName);
            result:=Call("m2:m2l", m2lNam);
          END;
          IF result=0 THEN
            WriteString(resOk)
          ELSE
            IF result<0 THEN (* m2c oder m2l nicht gefunden *)
              result:=rcImportantNotFound;
            END;
            FormatNr(resErr, result);
            SetReply(result);
          END
        ELSE
          WriteLn;
          IF compile THEN WriteString(outString); WriteLn END;
          IF link THEN
            WriteString("m2l ");
            WriteString(cpu); Write(' ');
            IF m2lOpt[0]#0C THEN WriteString(m2lOpt); Write(' ') END;
            IF toFile.str[0]#0C THEN WriteString(toFile.s); Write(" ") END;
            WriteString(modName); WriteLn
          END;
        END; (* ~compile *)
      END; (* if print *)
    END;
    toFile.str[0]:=0C;
  END; (* LOOP *)
  IF interActive THEN WriteString(exit) END;
  waitCloseGadget:=verbose & ~interActive;
END m2make.mod
