MODULE m2decref;
(* 30.07.88/cn *)
(* 25.8.90/bp *)
(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)

FROM SYSTEM	IMPORT	ADR, BYTE, CAST, SETREG;
FROM Arts	IMPORT	ModName;
FROM DecBase	IMPORT	ModKeys,Do,Get,OutC,OutCard,OutHex,OutInt,
			OutLn,OutS,Error;
FROM M2File	IMPORT	FileType;
FROM ReplyVals	IMPORT	rcActionErr;

CONST
 date=COMPILEDATE;
 ver="4.4";
 verDollar="$VER: m2decref "+ver+" "+date;
 titleString="m2decref "+ver+"d, "+date+"\n";
 stringTooLong="Zeichenkette zu lang\n";
 usageString="Aufruf:\n m2decref {? ReferenceFile}\n";
 notRefFile="Referenzdatei hat falschen Typ\n";
 illObjTag="Ungltige Objektinformation\n";
 illStrTag="Ungltige Strukturinformation\n";
 illCmpTag="Ungltige Komponenteninformation\n";
 illCtlTag="Ungltige Kontrollinformation\n";

PROCEDURE Decode;

CONST
 keyName=" Key, Name = ";
 comma=" , ";
 name="Name"; modNo="ModNo"; procNo="ProcNo";
 strRef="StrRef"; baseRef="BaseRef"; resRef="ResRef"; modRef="ModRef";
 elemRef="ElemRef"; indexRef="IndexRef";
 address="Address"; offset="Offset"; level="Level"; size="Size";
 REFFILE=10; (* 11, 12 ,13,14,18,19 *)
 CTL=0; anchor=0; modTag=1; procTag=2; refTag=3; linkage=4;
 STR=1; enum=0; range=1; pointer=2; set=3; procTyp=4; funcTyp=5;
 array=6; dynarr=7; record=10; opaque=11; bpointer=12;
 CMP=2; parref=0; par=1; field=2;
 OBJ=3; varref=0; var=1; const=2; string=3; type=4; proc=5; func=6;
 module=7; svc=10; svcfunc=11;
 maxM=64; minS=32 (*first non-standard structure*); maxS=1024;

VAR
 pc: CARDINAL;
 strucRef: CARDINAL;

 PROCEDURE NextPC;
 BEGIN
  OutLn;
  OutHex(pc); OutS(":  ");
 END NextPC;

(* So ein KRANKES Programm habe ich noch nie gesehen!!/bp *)

 PROCEDURE Number(t:CHAR):BOOLEAN;
 VAR
  i: INTEGER;
 BEGIN
  OutHex(t); strucRef:=ORD(t);
  IF (t>=100C) & (t<200C) THEN
   IF Get(t) THEN RETURN TRUE END;
   OutHex(t); INC(pc)
  ELSIF (t>=200C) & (t<300C) THEN
   IF Get(t) THEN RETURN TRUE END;
   OutHex(t); INC(pc);
   IF Get(t) THEN RETURN TRUE END;
   OutHex(t); INC(pc)
  ELSIF (t>=300C) THEN
   FOR i:=1 TO ORD(t)-192 DO
    IF Get(t) THEN RETURN TRUE END;
    OutHex(t); INC(pc);
   END;
  END;
  OutC(" ");
  RETURN FALSE;
 END Number;

(*$ CopyDyn:=FALSE *)
 PROCEDURE Num(s: ARRAY OF CHAR):BOOLEAN;
 VAR
  t: CHAR;
 BEGIN
  NextPC;
  IF Get(t) THEN RETURN TRUE END;
  INC(pc);
  IF Number(t) THEN RETURN TRUE END;
  OutS(s);
  RETURN FALSE;
 END Num;

(*$ CopyDyn:=FALSE *)
 PROCEDURE Name(s: ARRAY OF CHAR):BOOLEAN;
 VAR
  len,c: CHAR;
  i,slen: INTEGER;
 BEGIN
 (* 30.12.90/bp Erweitert fr Strings 0..16383 Bytes *)
  NextPC;
  IF Get(len) THEN RETURN TRUE END;
  OutHex(len); OutC(" "); INC(pc);
  slen:=ORD(len);
  IF len>=100C THEN
   IF len=301C THEN
     IF Get(len) THEN RETURN TRUE END;
     OutHex(len); OutC(" "); INC(pc);
     slen:=ORD(len);
   ELSIF len<200C THEN (* 2er Zahl *)
     DEC(len,100B); (* kann hier nur positiv sein! *)
     IF Get(c) THEN RETURN TRUE END;
     OutHex(c); OutC(" "); INC(pc);
     slen:=ORD(len)*256+ORD(c);
   ELSE
     Error(stringTooLong,rcActionErr)
   END;
  END;
  DEC(slen);
  OutS(s); OutS(' "');
  FOR i:=0 TO slen-1 DO
   IF Get(c) THEN
     OutC('"');
     RETURN TRUE;
   END;
   OutC(c);
   INC(pc);
  END;
  OutC('"');
  RETURN FALSE;
 END Name;

(*$ CopyDyn:=FALSE *)
 PROCEDURE Ref(st:ARRAY OF CHAR):BOOLEAN;
 VAR
  s: ARRAY [0..15] OF CHAR;
 BEGIN
  IF Num(st) THEN RETURN TRUE END;
  IF (0<=strucRef) & (strucRef<23) THEN (* 30.12.90/bp 23 statt 16 *)
   CASE strucRef OF
   | 0: s:="Illegal";
   | 1: s:="Undefined";
   | 2: s:="BOOLEAN";
   | 3: s:="CHAR";
   | 4: s:="INTEGER";
   | 5: s:="CARDINAL";
   | 6: s:="LONGINT";
   | 7: s:="REAL";
   | 8: s:="LONGREAL";
   | 9: s:="BITSET";
   | 10: s:="PROC";
   | 11: s:="String";
   | 12: s:="ADDRESS";
   | 13: s:="BYTE";
   | 14: s:="WORD";
   | 15: s:="LONGCARD";
   | 16: s:="UniversalInteger";
   | 17: s:="UniversalReal";
   | 18: s:="FFP";
   | 19: s:="LONGSET";
   | 20: s:="SHORTCARD";
   | 21: s:="SHORTINT";
   | 22: s:="BPTR";
   | 23: s:="SHORTSET";
   END;
   OutC(" "); OutS(s);
  END;
  RETURN FALSE;
 END Ref;

VAR
 modId: ModName;
 modKey: ModKeys;
 tg: CHAR;
 tag: INTEGER;
 dummy: CARDINAL;
 filetype: LONGINT;
 i: INTEGER;

BEGIN
 pc:=0;
 IF Get(filetype) THEN RETURN END;
 OutHex(pc); OutS(": "); OutHex(filetype);
 IF (filetype<REFFILE)OR(filetype>REFFILE+9) THEN Error(notRefFile,rcActionErr); RETURN END;
 OutS("  Reffile"); OutLn;
 INC(pc,4);
 WHILE ~Get(tg) DO
  OutHex(pc); OutS(": "); INC(pc);
  tag:=ORD(tg);
  CASE tag DIV 16 OF
  | OBJ:
   OutHex(tg); OutS("  ");
   CASE tag-16*OBJ OF
   | varref:
    OutS("VarRef"); IF Ref(strRef) THEN RETURN END;
    IF Num(level) THEN RETURN END; IF Num(address) THEN RETURN END;
    IF Num("VarMode") THEN RETURN END;
    IF (strucRef>=4)&(strucRef<=5) THEN
      IF Name("ext") THEN RETURN END;
    END;
   | var:
    OutS("Var"); IF Ref(strRef) THEN RETURN END;
    IF Num(level) THEN RETURN END; IF Num(address) THEN RETURN END;
    IF Num("VarMode") THEN RETURN END;
    IF (strucRef>=4)&(strucRef<=5) THEN
      IF Name("ext") THEN RETURN END;
    END;
   | const:
    OutS("Const"); IF Ref(strRef) THEN RETURN END;
    IF Num(modRef) THEN RETURN END; IF Num("value") THEN RETURN END;
   | string:
    OutS("String"); IF Ref(strRef) THEN RETURN END;
    IF Name("string") THEN RETURN END;
   | type:
    OutS("Type"); IF Ref(strRef) THEN RETURN END;
    IF Num(modRef) THEN RETURN END;
   | proc:
    OutS("Proc"); IF Num(procNo) THEN RETURN END;
    IF Num(level) THEN RETURN END;
    (* 05.09/92/bp externe Procs.  -1 ist 3F! *)
    IF strucRef=3FH THEN
     IF Name("ext") THEN RETURN END;
    ELSE
     IF Num(address) THEN RETURN END;
    END;
    IF Num(size) THEN RETURN END; IF Num("Registers") THEN RETURN END;
   | func:
    OutS("Func");
    IF Ref(resRef) THEN RETURN END; IF Num(procNo) THEN RETURN END;
    IF Num(level) THEN RETURN END;
    (* 05.09/92/bp externe Procs.  -1 ist 3F! *)
    IF strucRef=3FH THEN
     IF Name("ext") THEN RETURN END;
    ELSE
     IF Num(address) THEN RETURN END;
    END;
    IF Num(size) THEN RETURN END; IF Num("Registers") THEN RETURN END;
   | module: OutS("Module"); IF Num(modNo) THEN RETURN END;
   | svc: OutS("SVC"); IF Num("cnum") THEN RETURN END;
   | svcfunc:
    OutS("SVCFunc"); IF Ref(resRef) THEN RETURN END;
    IF Num("cnum") THEN RETURN END;
   ELSE
    Error(illObjTag,rcActionErr); RETURN
   END;
   IF Name(name) THEN RETURN END;
   IF Num("exported") THEN RETURN END;
  | CMP:
   OutHex(tg); OutS("  ");
   CASE tag-16*CMP OF
   | parref:
    OutS("ParRef"); IF Ref(strRef) THEN RETURN END;
    IF Num("ParMode") THEN RETURN END;
   | par:
    OutS("Par"); IF Ref(strRef) THEN RETURN END;
    IF Num("ParMode") THEN RETURN END;
   | field:
    OutS("Field"); IF Ref(strRef) THEN RETURN END;
    IF Num(offset) THEN RETURN END;
   ELSE
    Error(illCmpTag,rcActionErr); RETURN
   END;
   IF Name(name) THEN RETURN END;
  | STR:
   OutHex(tg); OutS("  ");
   CASE tag-16*STR OF
   | enum:
    OutS("enum"); IF Num(size) THEN RETURN END;
    IF Num("NoConst") THEN RETURN END;
   | range:
    OutS("range"); IF Num(size) THEN RETURN END;
    IF Ref(baseRef) THEN RETURN END; IF Num("min") THEN RETURN END;
    IF Num("max") THEN RETURN END;
    IF Num("sign") THEN RETURN END;
   | pointer: OutS("pointer"); IF Num(size) THEN RETURN END;
   | bpointer: OutS("bpointer"); IF Num(size) THEN RETURN END;
   | set:
    OutS("set"); IF Num(size) THEN RETURN END;
    IF Ref(baseRef) THEN RETURN END;
   | procTyp: OutS("ProcTyp"); IF Num(size) THEN RETURN END;
   | funcTyp:
    OutS("FuncTyp"); IF Num(size) THEN RETURN END;
    IF Ref(resRef) THEN RETURN END;
   | array:
    OutS("Array"); IF Num(size) THEN RETURN END;
    IF Ref(elemRef) THEN RETURN END; IF Ref(indexRef) THEN RETURN END;
   | dynarr:
    OutS("DynArray"); IF Num(size) THEN RETURN END;
    IF Ref(elemRef) THEN RETURN END;
   | record: OutS("Record"); IF Num(size) THEN RETURN END;
   | opaque: OutS("Opaque"); IF Num(size) THEN RETURN END;
   ELSE
    Error(illStrTag,rcActionErr); RETURN
   END;
  | CTL:
   OutHex(tag); OutS("  ");
   CASE ORD(tag)-CTL OF
   | anchor:
    OutS("ModAnchor"); NextPC;
    FOR i:=1 TO 3 DO
     IF Get(dummy) THEN RETURN END;
     OutHex(dummy); OutC(" ");
    END;
    pc:=pc+6;
    OutS("Key"); IF Name(name) THEN RETURN END;
    IF Num("ModMode") THEN RETURN END;
    IF strucRef=2 THEN
     IF Name(name) THEN RETURN END;
    END;
   | modTag: OutS("ModTag"); IF Num(modNo) THEN RETURN END;
   | procTag: OutS("ProcTag"); IF Num(procNo) THEN RETURN END;
   | refTag:
    OutS("RefTag"); IF Num("adr") THEN RETURN END;
    IF Num("pno") THEN RETURN END;
   | linkage:
    OutS("linkage"); IF Ref(strRef) THEN RETURN END;
    IF Ref(baseRef) THEN RETURN END;
   ELSE
    Error(illCtlTag,rcActionErr); RETURN
   END;
  ELSE
   IF Number(tg) THEN RETURN END;
   OutS(" pc @ ");
   IF Num("SourcePos") THEN RETURN END;
  END;
  OutLn;
 END;
END Decode;

BEGIN
 SETREG(11,ADR(verDollar));
 Do(Decode,titleString,usageString,refFile,ADR("decref> "),ADR('ENV:m2decref'),ADR("m2decref.opt"));
END m2decref.
