MODULE m2decobj;
(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE *)

(* Strategie:
   Lies alles ein, fr jeden Hunk Defs und Refs
   Gehe jeden Hunk durch, wenn _BY, dann Ascii!
   30.12.90/bp
	DumpAscii korrigiert fr " und Einzelnullen in der Mitte
	eines Strings.
   Liest nun auch SymbolHunks als Label ein (gut fuer fremde Objs)
 *)

FROM SYSTEM	IMPORT	ASSEMBLE, CAST, ADR, ADDRESS, BITSET, LONGSET, SETREG;
FROM Arts	IMPORT	ModName, BreakPoint,Assert,programName;
FROM Call	IMPORT	Call,Return;
FROM Break	IMPORT	TestBreak;
FROM M2File	IMPORT	FileType,GetInputFile,ReadPathTable,pathFileName,
			GetObj,FreeObj;
FROM M2Amiga	IMPORT	ObjFilePtr;
IMPORT String;
FROM String	IMPORT	Length, Compare, Copy, CopyPos, Concat;
FROM Terminal	IMPORT	WriteString, WriteLn, FormatS, FormatNr, Write, Read,
			waitCloseGadget,Format,WriteHex,WriteInt,Flush;
FROM MLinkBase	IMPORT	NameRecPtr, ALLOCATE, ForgetMem, Diff,
			InitSer, GetLong, SkipBlock, eof, MemPtr,
			FileErrors, GetFile;
FROM ExecSupport IMPORT NewList;
FROM ExecL	IMPORT	Remove,AddTail,RawDoFmt;
FROM ArgHandler	IMPORT	interActive, verbose, InitHandler, FetchName,
			fName,fNameLen,SetReply;
FROM ReplyVals	IMPORT	rcIllOpt,rcWarn,rcActionErr,rcMainNotFound;
FROM Arguments	IMPORT	quoted;
FROM DisAss	IMPORT	Line, Disass;
FROM M2DecSrc	IMPORT	SrcColor,loadErr,empty,OpenSrc,CloseSrc,ShowSrc,Err;
(*$ DEFINE Debug:=FALSE *)

CONST
  in="in> ";
  title1="m2decobj";
  title2="Amiga Modula-2 Object Dekoder";
  ver="4.4";
  date=COMPILEDATE;
  version=", "+ver+"d, "+date+"\n";
  verDollar="$VER: m2decobj "+ver+" "+date;
  usage="Aufruf:\n %s {+-012348oqs -cColour ? ModulName}\n";
  noSuchFile=": nicht gefunden\n";
  exit=" --- ende\n";

  (* Fr Object-Files: *)
  hunkUnit=999;
  hunkName=1000;
  hunkCode=1001;     hunkData=1002;     hunkBSS=1003;

  hunkReloc32=1004;  hunkReloc16=1005;  hunkReloc8=1006;
  (* blink neu fr datareloc: *)
  hunkDReloc32=1015; hunkDReloc16=1016; hunkDReloc8=1017;

  hunkExt=1007;
    (* SHORTCARDs, je SHL 24! *)
    extSymb=0; extDef=1; extAbs=2; extRes=3;
    extCommon=130;
    extRef32=129;   extRef16=131;   extRef8=132;
    (* blink neu fr datareloc-refs: *)
    extDRel32=133;  extDRel16=134;  extDRel8=135;

  hunkSymbol=1008; hunkDebug=1009;
  hunkEnd=1010;

  (* Fr Load-Files: *)
  hunkHeader=1011;
  hunkOverlay=1013; hunkBreak=1014; (* Will ich nicht! *)

  (* blink neu fr Link-Libraries: *)
  libHunk=1018; libIndex=1019;


  chipMemBit = 30;
  fastMemBit = 31;

TYPE
  SymName = ARRAY[0..8] OF CHAR;
  SymNamePtr = POINTER TO SymName;

  CasePtr = POINTER TO
    RECORD
      CASE :INTEGER OF
      | 0: carr: ARRAY[-2..1000] OF CARDINAL;
      | 1: barr: ARRAY[-2..1000] OF BITSET;
      | 2: iarr: ARRAY[-2..1000] OF INTEGER;
      END;
    END;

  BytePtr = POINTER TO SHORTINT;
  WordPtr = POINTER TO INTEGER;
  LongPtr = POINTER TO LONGINT;
  TrickPtr = POINTER TO RECORD
    CASE :INTEGER OF
    |0: barr: SHORTINT;
    |1: warr: INTEGER;
    |2: larr: LONGINT;
    END
  END;

  WidType=(byte,word,long);
  ExtTypes = (reloc, ref, def, label);


  RefRecPtr = POINTER TO
    RECORD
      cnt:LONGINT;
      addrs: ARRAY[0..5000] OF LONGINT
    END;

  ReferencesPtr = POINTER TO References;
  References = RECORD
    succ,
    pred: ReferencesPtr;
    pos: LONGINT; (* addr im Hunk *)
    wid: WidType;
    CASE typ:ExtTypes OF
    | reloc   : hunk: LONGINT;
    | ref, def: name: NameRecPtr;
    | label   : str : SymNamePtr;
    END;
  END;

  RefList=RECORD
    head,
    tail,
    tailPred: ReferencesPtr
  END;

  HunkTypes =
    (code,chipcode,fastcode,data,chipdata,fastdata,bss,chipbss,fastbss);
  HunkTypeSet = SET OF HunkTypes;

  HunkDescPtr = POINTER TO HunkDesc;

  RelocPtr = POINTER TO LONGINT;
  HunkDesc = RECORD
    succ,
    pred:HunkDescPtr;
    mem: ADDRESS; (* adr of hunk-data in memory *)
    type: HunkTypes; (* code,data,bss *)
    absnr:LONGINT; (* Nr des 1. Hunks der Unit+relnr *)
    name: NameRecPtr;
    lwSize: LONGINT;
    refs: RefList;
  END;

(*
 wenn reloc auf spteren, mu die Kette erweitert werden und ein ref erzeugt
 dafr leere dummy-hunks generieren!
    fall spter def, mu der Name berschrieben werden!
    bei label: immer replace
    bei ref: pcrel,datarel,abs: replace+-wert oder label
    bei reloc: label in dem Hunk suchen! evtl ersetzen pcrel
    relocs und refs sind MUSSLABEL!!
    JSR L000000 -> JSR Arts_StkChk+10 (+0 unterbinden )
    bei byte immer?? +1 !!
    ascii und bss auch label erzeugen und ausgeben!
*)
  HunkList = RECORD
    head,tail,tailPred:HunkDescPtr
  END;

VAR
  CaseNr,ActCase:CARDINAL;
  CaseArr: ARRAY[0..99] OF RECORD adr:ADDRESS; cnt:INTEGER END;
  ActLabel:SymName;
  Buff: Line; (* disass-buffer *)
  strBuffer: ARRAY [0..127] OF CHAR;
  FullName: ARRAY[0..255] OF CHAR;
  Hunks: HunkList;
  ActHunk: HunkDescPtr; (* weniger Parameter *)
  HunkCount,
  LabNr: LONGINT;
  HunkName: ARRAY HunkTypes OF POINTER TO ARRAY[0..10] OF CHAR;
  offset:LONGINT;
  UnitName:NameRecPtr;
  nextPC,globPos:LONGINT;
  objAnzeigen,withSrc,globWithSrc,dejaVue: BOOLEAN;
  ft:FileType;
  srcCol:SrcColor;


PROCEDURE CopyName(VAR s:ARRAY OF CHAR; nam:NameRecPtr);
BEGIN
  IF nam#NIL THEN
    Copy(s,nam^.name);
    WITH nam^ DO
      IF lws*4<=HIGH(s) THEN
        s[nam^.lws*4]:=0C; (* auf jeden Fall 0C am Ende! *)
      ELSE
        s[HIGH(s)]:=0C
      END;
    END;
  ELSE
    s[0]:=0C
  END;
END CopyName;

PROCEDURE FindHunk(nr:LONGINT):HunkDescPtr;
VAR h:HunkDescPtr;
BEGIN
  h:=Hunks.head;
  WHILE (h^.succ#NIL)&(h^.absnr#nr) DO h:=h^.succ END;
  IF h^.succ#NIL THEN RETURN h ELSE RETURN NIL END;
END FindHunk;


PROCEDURE RefToStr(r:ReferencesPtr; val:LONGINT):LONGINT;
VAR nr,ziff,i:CARDINAL; h:HunkDescPtr; href:ReferencesPtr; ret:LONGINT;
BEGIN
  ret:=1;
  IF r^.typ=label THEN
    Copy(strBuffer,r^.str^);
  ELSIF r^.typ=reloc THEN
    h:=FindHunk(r^.hunk);
    IF h#NIL THEN
      href:=h^.refs.head;
      WHILE (href^.succ#NIL)&(href^.pos#val) DO href:=href^.succ END;
      IF href^.succ#NIL THEN
        IF href^.typ=label THEN Copy(strBuffer,href^.str^)
        ELSE CopyName(strBuffer,href^.name)
        END;
        ret:=0;
      ELSE
        h:=NIL
      END;
    END;
    IF h=NIL THEN
      strBuffer:='Hunk0000';
      nr:=r^.hunk;
      FOR i:=7 TO 4 BY -1 DO
        ziff:=nr MOD 10;
        nr:=nr DIV 10;
        strBuffer[i]:=CHAR(ziff+30H);
      END;
    END;
  ELSE (* ref,def *)
    CopyName(strBuffer,r^.name);
  END;
  RETURN ret;
END RefToStr;

PROCEDURE Tab3;
BEGIN
  IF objAnzeigen THEN WriteString('\t\t\t') END;
END Tab3;

PROCEDURE ShowLab(r:ReferencesPtr);
BEGIN
  SETREG(0,RefToStr(r,0)); (* kann kein reloc sein! *)
  Tab3;
  WriteString(strBuffer);
END ShowLab;

PROCEDURE NamErr(s:ARRAY OF CHAR; nam:NameRecPtr);
VAR str:ARRAY[0..79] OF CHAR;
BEGIN
  CopyName(str,nam);
  Err(s,str);
END NamErr;


(*$ EntryExitCode:=FALSE *)
PROCEDURE SpacesToTabs(src{8}:ADDRESS);
BEGIN ASSEMBLE(
(*; Column	EQUR	D0*)
(*; Spaces	EQUR	D1*)
(*; TermQuote	EQUR	D2*)
(*; nt		EQUR	D3*)
(*; npos	EQUR	D4*)
(*; ch		EQUR	D5*)
(*; space	EQUR	D6 ; const*)
(*; tab		EQUR	D7 ; const*)
(*; src		EQUR	A0*)
(*; dst		EQUR	A1*)
(*; OldDst	EQUR	A2*)

(*; In der M2Amiga-Umgebung ist die Rettung der hier benutzten Register Unsinn!*)
(* DENKSTE!! *)
	MOVEM.L	D2-D7/A2,-(A7)
	MOVE.L	A0,A1
	MOVE.L	A1,A2		(*; OldDst:=dst*)
	MOVEQ	#0,D0		(*; Column:=0*)
	MOVEQ	#0,D1		(*; Spaces:=0*)
	MOVEQ	#32,D6		(*; D6=space-konstante*)
	MOVEQ	#9,D7		(*; D7=tab-konstante*)

L000001:			(*; repeat*)
	MOVE.B	(A0)+,D5	(*; ch:=src^; inc(src)*)
	CMP.B	D6,D5		(*; if ch=' ' then*)
	BNE.S	L000002
	ADDQ.W	#1,D1		(*; inc(Spaces)*)
	BRA.S	L000014
L000002:
	CMP.B	D7,D5		(*; elsif	ch=ht*)
	BNE.S	L000003
	ADD.W	D0,D1		(*; Spaces:=(Column+Spaces)or 7 +1-Column*)
	ORI.W	#$0007,D1
	ADDQ.W	#1,D1
	SUB.W	D0,D1
	BRA.S	L000014
L000003:
	CMPI.B	#$0A,D5		(*; if ch=eol or ch=cr then*)
	BEQ.S	L000004
	CMPI.B	#$0D,D5
	BNE.S	L000005
L000004:
	MOVEQ	#-1,D0		(*; Column:=-1*)
	MOVEQ	#0,D1		(*; Spaces:=0*)
	BRA.S	L000013
L000005:
	TST.W	D1		(*; while	Spaces>0 do*)
	BLE.S	L000009
	MOVE.W	D0,D3
	ORI.W	#$0007,D3
	ADDQ.W	#1,D3		(*; nt:=col or 7 +1*)
	MOVE.W	D0,D4
	ADD.W	D1,D4		(*; npos:=Column+Spaces*)
	CMP.W	D4,D3
(* 20.6.90/bp: EIN Space nicht durch Tab ersetzen! *)
	BGT.S	L000006
	CMPI.W	#1,D1
	BNE.S	L000007		(*; if nt>npos then*)
(*	BLE.S	L000007		(*; if nt>npos then*)*)
L000006:			(*; repeat*)
	MOVE.B	D6,(A1)+	(*; dst^:=' '; inc(dst)*)
	ADDQ.W	#1,D0		(*; inc(Column)*)
	CMP.W	D0,D4
	BNE.S	L000006		(*; until	Column=npos*)
	MOVEQ	#0,D1		(*; Spaces:=0*)
	BRA.S	L000008		(*; else*)
L000007:
	MOVE.B	D7,(A1)+	(*; dst^:=ht; inc(dst)*)
	SUB.W	D3,D1
	ADD.W	D0,D1		(*; dec(Spaces,nt-Column)*)
	MOVE.W	D3,D0		(*; Column:=nt*)
L000008:
	BRA.S	L000005		(*; end while putSpaces*)

L000009:
	CMPI.B	#$22,D5		(*; if ch="'" or ch='"' then*)
	BEQ.S	L000010
	CMPI.B	#$27,D5
	BNE.S	L000013
L000010:
	MOVE.B	D5,D2		(*; TermQuote:=ch*)
L000011:			(*; repeat*)
	MOVE.B	D5,(A1)+	(*; dst^:=ch; inc(dst)*)
	CMP.B	D7,D5		(*; if ch=ht then*)
	BNE.S	L000012
	ORI.W	#$0007,D0	(*; col:=col or 7*)
L000012:			(*; end*)
	ADDQ.W	#1,D0		(*; inc(Column)*)
	MOVE.B	(A0)+,D5	(*; ch:=src^;inc(src)*)
	BEQ.S	L000013		(*; until	ch=0 or	ch=TermQuote*)
	CMP.B	D2,D5
	BNE.S	L000011
L000013:
	ADDQ.W	#1,D0		(*; inc(Column)*)
	MOVE.B	D5,(A1)+	(*; dst^:=ch; inc(dst)*)
L000014:
	BNE	L000001		(*; until	ch=nul*)

	SUBQ.L	#2,A1		(*; dec(dst,2) vor	nul*)
L000015:			(*; das geht sicher noch schneller v !!!*)
	CMPA.L	A2,A1
	BLT.S	L000017
	CMP.B	(A1),D6		(*; ch=' ' ?*)
	BEQ.S	L000016
	CMP.B	(A1),D7		(*; ch=ht?*)
	BNE.S	L000017
L000016:
	CLR.B	(A1)		(*; dst^:=nul*)
	SUBQ.L	#1,A1		(*; dec(dst)*)
	BRA.S	L000015
L000017:
	MOVE.L	A1,D0		(*; return dst+1-OldDst*)
	ADDQ.L	#1,D0
	SUB.L	A2,D0

	MOVEM.L	(A7)+,D2-D7/A2
	RTS
	END);
END SpacesToTabs;

(*$ EntryExitCode:=FALSE *)
PROCEDURE EnqueueRef(VAR l{8}:RefList; w{9}:ReferencesPtr);
(* sortiert nach pos *)
BEGIN
  ASSEMBLE(
	MOVE.L	References.pos(A1),D1
	MOVE.L	(A0),D0
sr:	MOVEA.L	D0,A0
	MOVE.L	(A0),D0
	BEQ.S	raus
	CMP.L	References.pos(A0),D1
	BGT.S	sr
raus:	MOVE.L	4(A0),D0
	MOVE.L	A1,4(A0)
	MOVE.L	A0,(A1)
	MOVE.L	D0,4(A1)
	MOVE.L	D0,A0
	MOVE.L	A1,(A0)
	RTS
  END);
END EnqueueRef;


(* muss auf Laenge des Namens stehen! *)
PROCEDURE GetName(VAR n:NameRecPtr);
VAR cnt:LONGINT;
BEGIN
  n:=CAST(NameRecPtr,MemPtr);
  GetLong(cnt);
  SkipBlock(cnt);
END GetName;


PROCEDURE SearchLab(ad:LONGINT):ReferencesPtr;
VAR r:ReferencesPtr;
BEGIN
  r:=ActHunk^.refs.head;
  WHILE (r^.succ#NIL)&((r^.pos#ad)OR(r^.typ<def)) DO
    r:=r^.succ
  END;
  IF r^.succ#NIL THEN RETURN r ELSE RETURN NIL END;
END SearchLab;

PROCEDURE SearchRef(ad:LONGINT):ReferencesPtr;
VAR r:ReferencesPtr;
BEGIN
  r:=ActHunk^.refs.head;
  WHILE (r^.succ#NIL)&(r^.pos#ad) DO
    r:=r^.succ
  END;
  IF r^.succ#NIL THEN RETURN r ELSE RETURN NIL END;
END SearchRef;

PROCEDURE InsertAd(name:SymName; ad:LONGINT);
VAR r:ReferencesPtr;
BEGIN
  ALLOCATE(r,SIZE(r^)+SIZE(SymName));
  r^.str:=CAST(SymNamePtr,CAST(LONGINT,r)+SIZE(r^));
  r^.pos:=ad;
  r^.typ:=label;
  (* r^.wid:=egal *)
  r^.str^:=name;
  EnqueueRef(ActHunk^.refs,r);
  (*$ IF Debug *)
    FormatS('InsertAd: "%s": ',name); WriteHex(ad,8); WriteLn;
  (*$ ENDIF *)
END InsertAd;

(* Ersetzt den Namen erzwungen. *)
PROCEDURE NamSym(s:SymName;ad:LONGINT);
VAR r: ReferencesPtr;
BEGIN
  r:= SearchLab(ad);
  IF r=NIL THEN
    InsertAd(s,ad);
  ELSIF r^.typ=label THEN (* def bleibt! *)
    r^.str^:=s
  END;
END NamSym;

(* alle leeren Strings durch 'L00xxxx' ersetzen *)
PROCEDURE GenSyms;
VAR r:ReferencesPtr;
    i:CARDINAL;
BEGIN
  r:=ActHunk^.refs.head;
  WHILE r^.succ#NIL DO
    IF (r^.typ=label)&(r^.str^[0]=0C) THEN
      r^.str^:=ActLabel;
      i:=6;
      LOOP (* Namen erhhen *)
        INC(ActLabel[i]);
        IF ActLabel[i]>'9' THEN
          ActLabel[i]:='0';
          DEC(i)
        ELSE
          EXIT
        END
      END;
    END;
    r:=r^.succ;
  END;
END GenSyms;

PROCEDURE ReadSymbols;
VAR
  len,val:LONGINT;
  nr:NameRecPtr;
  r:ReferencesPtr;
BEGIN
  LOOP
    len:=MemPtr^;
    GetName(nr); (* macht bei 0 gar nichts! skippt die 0! *)
    IF len=0 THEN EXIT END;
    GetLong(val);
    IF SearchLab(val)=NIL THEN
      ALLOCATE(r,SIZE(r^));
      r^.typ:=def;
      r^.pos:=val;
      (* r^.wid:=egal *)
      r^.name:=nr;
      EnqueueRef(ActHunk^.refs,r);
    END;
  END;
END ReadSymbols;



PROCEDURE NewRef(nr:NameRecPtr;wid:WidType; typ:ExtTypes; val:LONGINT);
VAR r:ReferencesPtr;
BEGIN
(*
suchen, ob schon vorhanden!! oder defs auf derselben pos immer davorhngen
und nur einen ausgeben!
*)
  ALLOCATE(r,SIZE(r^));
  r^.pos:=val;
  r^.name:=nr;
  r^.wid:=wid;
  r^.typ:=typ;
  EnqueueRef(ActHunk^.refs,r);
END NewRef;

PROCEDURE Entry(nr:NameRecPtr; wid: WidType; typ:ExtTypes);
VAR
  i,cnt,val:LONGINT;
BEGIN
  GetLong(cnt);
  FOR i:=1 TO cnt DO
    GetLong(val);
    NewRef(nr,wid,typ,val);
  END;
END Entry;


PROCEDURE External;
VAR
 i,type:INTEGER;
 len:LONGINT;
 lc,val:LONGINT;
 nr:NameRecPtr;
BEGIN
 LOOP
   lc:=MemPtr^;
   type:=CAST(LONGCARD,lc) DIV 1000000H;
   len:=CAST(LONGINT,CAST(LONGCARD,lc) MOD 10000H);
   MemPtr^:=len; (* pure Lnge im Namen! *)
   GetName(nr); (* macht bei 0 gar nichts! *)
   IF lc=0 THEN EXIT END;
   IF type=extSymb THEN
     Err('Symboldefinition im External Hunk',empty);
   ELSIF (type=extDef)OR(type=extAbs) THEN
     GetLong(val);
     IF type=extDef THEN NewRef(nr,long,def,val) END;(*bei abs darf nicht!*)
   ELSIF type=extRes THEN
     Err('Resident library definition im Hunk',empty);
   ELSIF type=extRef32  THEN Entry(nr,long,ref);
   ELSIF type=extCommon THEN Err("COMMON im Hunk",empty);
   ELSIF type=extRef16  THEN Entry(nr,word,ref);
   ELSIF type=extRef8   THEN Entry(nr,byte,ref);
   ELSIF type=extDRel32 THEN Entry(nr,long,ref);
   ELSIF type=extDRel16 THEN Entry(nr,word,ref);
   ELSIF type=extDRel8  THEN Entry(nr,byte,ref);
   ELSE
     Err("Unbekannte externe Referenz im Hunk",empty)
   END;
 END; (* loop *)
END External;

PROCEDURE Relocation(wid:WidType);
VAR i,lc,val,hnr:LONGINT; r:ReferencesPtr;
BEGIN
  LOOP
    GetLong(lc);
    IF lc=0 THEN EXIT END;
    GetLong(hnr); (* Absnr des Hunks! *)
    FOR i:=1 TO lc DO
      GetLong(val);
      ALLOCATE(r,SIZE(r^));
      r^.pos:=val;
      r^.hunk:=hnr;
      r^.wid:=wid;
      r^.typ:=reloc;
      EnqueueRef(ActHunk^.refs,r);
    END;
  END;
END Relocation;

PROCEDURE StripBits(VAR lc:LONGINT);
BEGIN
   lc:=CAST(LONGINT, CAST(LONGSET,lc)*LONGSET{0..29});
END StripBits;


(* global fr ReadHunk, ReadHunks, DecodeFile *)
VAR
   LastLong:LONGINT;

(* liest EINEN Hunk!!!! *)
(* erstes Long schon gelesen, raus mit hunkEnd *)
PROCEDURE ReadHunk(VAR relHunkNr:LONGINT);
VAR
  chip,fast:BOOLEAN;
  dummy:NameRecPtr;
BEGIN
  ALLOCATE(ActHunk,SIZE(ActHunk^));
  NewList(ADR(ActHunk^.refs));
  AddTail(ADR(Hunks),ActHunk);
  ActHunk^.absnr:=relHunkNr;
  INC(relHunkNr);
(*BreakPoint(ADR('ent ReadHunk'));*)
 LOOP
   chip:=chipMemBit IN CAST(LONGSET,LastLong);
   fast:=fastMemBit IN CAST(LONGSET,LastLong);
   StripBits(LastLong);
   CASE LastLong OF
   | hunkUnit:
	Err('HunkUnit im Hunk',empty);
   | hunkName:
        GetName(ActHunk^.name);
   | hunkCode:
   	IF chip THEN ActHunk^.type:=chipcode
	ELSIF fast THEN ActHunk^.type:=fastcode
	ELSE ActHunk^.type:=code
	END;
	GetLong(ActHunk^.lwSize);
	StripBits(ActHunk^.lwSize);
	ActHunk^.mem:=MemPtr;
	SkipBlock(ActHunk^.lwSize);
   | hunkData:
   	IF chip THEN ActHunk^.type:=chipdata
	ELSIF fast THEN ActHunk^.type:=fastdata
	ELSE ActHunk^.type:=data
	END;
	GetLong(ActHunk^.lwSize);
	StripBits(ActHunk^.lwSize);
	ActHunk^.mem:=MemPtr;
	SkipBlock(ActHunk^.lwSize);
   | hunkBSS:
   	IF chip THEN ActHunk^.type:=chipbss
	ELSIF fast THEN ActHunk^.type:=fastbss
	ELSE ActHunk^.type:=bss
	END;
	GetLong(ActHunk^.lwSize);
	StripBits(ActHunk^.lwSize);
	ActHunk^.mem:=MemPtr; (* !! *)
   | hunkReloc32, hunkDReloc32:
   	Relocation(long);
   | hunkReloc16,hunkDReloc16:
   	Relocation(word);
   | hunkReloc8, hunkDReloc8:
   	Relocation(byte);
   | hunkExt:
   	External;
   | hunkSymbol:
   	ReadSymbols;
   | hunkDebug:
   	GetLong(LastLong);
   	SkipBlock(LastLong);
   | hunkEnd:
   	 EXIT;
   | hunkHeader: Err('Header im Hunk',empty);
   | hunkOverlay: Err('OVERLAY im Hunk',empty);
   | hunkBreak: Err('BREAK im Hunk',empty);
   ELSE
      Err('Unbekannter Hunktyp',empty);
   END; (* case *)
   GetLong(LastLong);
 END; (* loop *)
 (* hier LastLong= hunkend *)
(*BreakPoint(ADR('exit ReadHunk'));*)
END ReadHunk;

(* Liest alle Hunks einer Unit. Startet nach UnitName *)
PROCEDURE ReadHunks;
VAR RelHunkNr:LONGINT;
BEGIN
  ActLabel:='L000000';
  CaseNr:=0;
  NewList(ADR(Hunks));
  RelHunkNr:=0;

  REPEAT
    ReadHunk(RelHunkNr);
    IF ~eof THEN GetLong(LastLong) END;
  UNTIL eof OR (LastLong=hunkUnit); (* HunkUnit *)

END ReadHunks;

(*$ CopyDyn:=FALSE *)
PROCEDURE LoadObj(modName:ARRAY OF CHAR);
(* ldt das Modul, liefert neuen, eingelinkten ModulPtr zurck *)
VAR
    FAddr:ADDRESS;
    FLen:LONGINT;
    Res: FileErrors;
    o:ObjFilePtr;
BEGIN
  o:=NIL;
  TestBreak;
  IF ~quoted THEN
    IF  (String.FirstPos(fName,0,".")<0)
      & (String.FirstPos(fName,0,"/")<0)
      & (String.FirstPos(fName,0,":")<0) THEN
      o:=GetObj(FullName,ft,modName);
    ELSE
      GetInputFile(FullName,ft,modName);
    END;
  ELSE
    Copy(FullName,modName);
  END;
  IF verbose THEN FormatS(' - %s',FullName); Flush END;
  Res:=GetFile(FullName,FAddr,FLen,o);
  FreeObj(o,FALSE);
  IF Res=noError THEN
    IF verbose THEN WriteLn END;
  ELSE
    IF ~verbose THEN WriteString(FullName) END;
    SetReply(rcMainNotFound);
    Err(noSuchFile,empty);
  END;
  InitSer(FAddr,FLen);
END LoadObj;


VAR nexta:LONGINT;
    refRec:ReferencesPtr;

PROCEDURE InitLab;
BEGIN
  refRec:=NIL
END InitLab;

(* sucht nchstes def oder label *)
PROCEDURE NextLab(e{0}:LONGINT); (* setzt nexta, refRec *)
BEGIN
  IF refRec=NIL THEN refRec:=ActHunk^.refs.head
  ELSIF refRec^.succ#NIL THEN refRec:=refRec^.succ
  END;
  WHILE (refRec^.succ#NIL)&(refRec^.typ<def) DO refRec:=refRec^.succ END;
  IF refRec^.succ#NIL THEN nexta:=refRec^.pos-offset ELSE nexta:=e END;
END NextLab;

(* sucht nchsten ref *)
PROCEDURE NextRef(e{0}:LONGINT); (* setzt nexta, refRec *)
BEGIN
  IF refRec=NIL THEN refRec:=ActHunk^.refs.head
  ELSIF refRec^.succ#NIL THEN refRec:=refRec^.succ
  END;
  IF refRec^.succ#NIL THEN nexta:=refRec^.pos-offset ELSE nexta:=e END;
END NextRef;

PROCEDURE GenCase(wp:CasePtr; max,base:INTEGER);
VAR s: SymName; val,i,j,pos:INTEGER; AdrBase:LONGINT;
BEGIN
   AdrBase:=CAST(LONGINT,wp)+offset+4; (* wg. -2..1000 *)
   CaseArr[ActCase].cnt:=max;
   s:='CsTab00';
   s[5]:=CHAR(ActCase/10+30H);
   s[6]:=CHAR(ActCase REM 10+30H);
   NamSym(s,AdrBase);
   s:='Cxx1234';
   s[1]:=CHAR(ActCase/10+30H);
   s[2]:=CHAR(ActCase REM 10+30H);
   WITH wp^ DO
     FOR i:=0 TO max DO
       val:=base+i;
       IF val<0 THEN
         val:=-val;
         s[3]:='M';
         pos:=4;
       ELSE
         pos:=3;
       END;
       FOR j:=6 TO pos BY -1 DO
	 s[j]:=CHAR(val REM 10+30H);
	 val:=val/10
       END;
       IF val>0 THEN s[3]:='?' END;
       NamSym(s,AdrBase+iarr[i]);
     END;
     CopyPos(s,'DFLT',3);
     NamSym(s,AdrBase+iarr[-1]);
   END;
   INC(ActCase);
END GenCase;

PROCEDURE DumpBss(a,e:ADDRESS);
BEGIN
  WHILE a<e DO
    NextLab(e); (* setzt nexta und refRec *)
    IF nexta=a THEN ShowLab(refRec); WriteString(':\n')
    ELSE Tab3; FormatNr('\tDS.B\t%ld\n',CAST(LONGINT,nexta)-CAST(LONGINT,a));
    END;
    a:=nexta;
    TestBreak;
  END;
END DumpBss;

PROCEDURE DumpAscii(a,e:ADDRESS);
TYPE sPtr=POINTER TO ARRAY[0..5000] OF CHAR;
VAR s:sPtr; i:LONGINT; inString:BOOLEAN;
BEGIN
  WHILE a<e DO
    NextLab(e); (* setzt nexta und refRec *)
    IF nexta=a THEN
      ShowLab(refRec); WriteString(':\n');
    ELSE
      WHILE a<nexta DO
        s:=CAST(sPtr,a);
        i:=Length(s^);
        WriteHex(a+offset,6); WriteString('\tDC.B\t');
        inString:=FALSE;
        WHILE s^[0]#0C DO
          IF (s^[0]<' ') OR ((s^[0]>CHAR(126))&(s^[0]<CHAR(128+32))) THEN
	    IF inString THEN WriteString('",'); inString:=FALSE END;
	    FormatNr('$%02lx,',ORD(s^[0]));
          ELSE
	    IF ~inString THEN Write('"'); inString:=TRUE END;
	    IF s^[0]='"' THEN WriteString('\\"') ELSE Write(s^[0]) END;
          END;
          INC(s);
        END;
        IF inString THEN WriteString('",') END;
        IF ODD(i) THEN WriteString('0\n'); INC(i)
        ELSE
          INC(s);
          IF s^[0]=0C THEN
            WriteString('0,0\n');
          ELSE
            FormatNr("0,$%02lx\n",ORD(s^[0]));
          END;
          INC(i,2)
        END;
        INC(a,i);
        TestBreak;
      END;
    END;
    a:=nexta;
  END;
END DumpAscii;

PROCEDURE Sym(wohin,wo:LONGINT);
BEGIN
  IF (SearchRef(wo)=NIL)&(SearchLab(wohin)=NIL) THEN
    (*$ IF Debug *)
    IF ODD(wohin) OR ODD(wo) THEN
      Format('Sym neu: wo=$%06lx, wohin=$%06lx\n',ADR(wo));
    END;
    (*$ ENDIF *)
    InsertAd(empty,wohin);
  END;
END Sym;

PROCEDURE PutCh; (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVE.B	D0,(A3)+
	RTS
  END);
END PutCh;

PROCEDURE ReplaceLab(r:ReferencesPtr; pos{2}:LONGINT;
			del:BOOLEAN; val:LONGINT);
VAR addi:INTEGER;
    nrString:ARRAY[0..15] OF CHAR;
BEGIN
  IF ~del & (refRec^.typ=label) THEN RETURN END; (* string-label! *)
  nrString[0]:=0C;
  IF del THEN
    String.Delete(Buff.s,pos,7); addi:=-7;
    IF val#0 THEN
      RawDoFmt(ADR('%ld'),ADR(val),ADR(PutCh),ADR(nrString));
      IF nrString[0]#'-' THEN String.Insert(nrString,0,'+') END;
    END;
  ELSIF (r^.wid=long) THEN
    String.Delete(Buff.s,pos,9); addi:=-9;
    IF val#0 THEN
      RawDoFmt(ADR('%ld'),ADR(val),ADR(PutCh),ADR(nrString));
      IF nrString[0]#'-' THEN String.Insert(nrString,0,'+') END;
    END;
  ELSIF Buff.s[pos]#'-' THEN String.Insert(Buff.s,pos,'+'); addi:=1;
  ELSE addi:=0;
  END;
  IF RefToStr(r,val)#0 THEN
    Concat(strBuffer,nrString);
  END;
  INC(addi,Length(strBuffer));
  String.Insert(Buff.s,pos,strBuffer);
  IF (BITSET{0,1}*Buff.flags#BITSET{})&(Buff.adrPos>pos) THEN
    INC(Buff.adrPos,addi)
  END;
  IF (3 IN Buff.flags)&(Buff.drelPos1>pos) THEN INC(Buff.drelPos1,addi) END;
  IF (4 IN Buff.flags)&(Buff.drelPos2>pos) THEN INC(Buff.drelPos2,addi) END;
  IF (5 IN Buff.flags)&(Buff.abslPos1>pos) THEN INC(Buff.abslPos1,addi) END;
  IF (6 IN Buff.flags)&(Buff.abslPos2>pos) THEN INC(Buff.abslPos2,addi) END;
END ReplaceLab;

PROCEDURE ShowRec(r:ReferencesPtr;a,nexta,newa,e:LONGINT);
VAR rec:RECORD typ,wid:INTEGER END;
BEGIN
  FormatNr('a=%06lx,',a);
  FormatNr('newa=%06lx,',newa);
  FormatNr('nexta=%06lx,',nexta);
  FormatNr('e=%06lx\n',e);

  IF r^.succ#NIL THEN
    rec.typ:=ORD(r^.typ); rec.wid:=ORD(r^.wid);
    Format('typ:%d,wid:%d ',ADR(rec));
    SETREG(0,RefToStr(r,0));
    FormatS('sym="%s",',strBuffer);
    FormatNr('pos=%ld',r^.pos);
  ELSE
    WriteString('illrec');
  END
END ShowRec;

PROCEDURE DisHunk(anf,e:ADDRESS);
VAR
  a,apc,newa,absadr:LONGINT; i,val:LONGINT; NewName, CaseName: SymName;
  wp: CasePtr;
  ci, CaseBase, CaseMax:INTEGER;
  CaseFlag: BOOLEAN;
  CaseRec,href:ReferencesPtr;
  CaseAd:LONGINT;
  alert,TempAlert:BOOLEAN;
  trick:TrickPtr;
BEGIN
  alert:=FALSE;
  (* Pass #1 *)
  ActCase:=CaseNr;
  a:=anf;
  WHILE a<e DO
    a:=Disass(ADR(Buff),a,offset);
    TestBreak;
    IF BITSET{0,1}*Buff.flags#BITSET{} THEN
      Sym(Buff.adr+offset,Buff.adrAdr+offset);
    END;
    IF 2 IN Buff.flags THEN
      TempAlert:=TRUE;
      wp:=CAST(CasePtr,LONGINT(a)-4);
      WITH wp^ DO
        IF ((carr[-2]=4E75H) OR (iarr[-2]=0) OR
         (carr[-2]/100H = 60H) OR
              (*$ RangeChk:=FALSE *)(carr[-3]=6000H)) (*$ POP RangeChk *)
          AND (carr[-1]>=0F000H) THEN (* kann case sein *)
	  ci:=0;
	  WHILE carr[ci]>=0E000H DO INC(ci) END;
	  CaseMax:=ci-1;
	  IF barr[ci]-BITSET{0..5,9..11}=CAST(BITSET,41C0H) THEN (* lea *)
	    (* a ist auf jumplabel nach 1. dc.w *)
	    (* danach subq ode subi.w oder nichts,
	       danach cmpi.w
	    *)
	    INC(ci,2);
	    IF barr[ci]-BITSET{0..7,9..11}=CAST(BITSET,5100H) THEN (* subq*)
	      CaseBase:=carr[ci]/512 REM 8;
	      IF CaseBase=0 THEN CaseBase:=8 END;
	      INC(ci);
	    ELSIF barr[ci]-BITSET{0..5}=CAST(BITSET,0440H) THEN (* subi.w *)
	      CaseBase:=iarr[ci+1];
	      INC(ci,2);
	    ELSE
	      CaseBase:=0;
	    END;
	    IF (barr[ci]-BITSET{0..5}=CAST(BITSET,0C40H)) (* cmpi.w *)
	    	AND (carr[ci+2]=6302H) (* bls.s *+2 *)
	    	AND (iarr[ci+1]=CaseMax) THEN (* absolutely a CASE *)
	      CaseArr[ActCase].adr:=a;
	      GenCase(wp,CaseMax,CaseBase);
	      INC(a,CaseMax*2+2);
	      TempAlert:=FALSE;
	    END;
	  END; (* if lea *)
	END; (* if rts *)
      END; (* with *)
      alert:=alert OR TempAlert;
    END; (* dc.w *)
  END; (* while *)
(* == *)
  IF alert THEN
    WriteString('\n\n;!!!!! Achtung:  Daten im Code. !!!!\n\n');
  END;

(* Pass 2 == *)
  ActCase:=CaseNr;
  GenSyms();
  a:=anf;

(* Bits in flags:
  0,1 adrPos, adrAdr, adr : pcrel, Label oder Def REPLACE 'Lxxxxxx' mit Namen
  2 heit dc.w
 HINTEN anfangen, dann bleiben die Offsets richtig!
  3 drelPos1, drelAdr1 alle anderen: INSERT Name dort
  4 drelPos2, drelAdr2
  5 abslPos1, abslAdr1
  6 abslPos2, abslAdr2
*)

  CaseFlag:=FALSE;

  NextRef(e); (* erstes holen *)

  WHILE a<e DO
    IF withSrc THEN
      apc:=a+offset+globPos; (* =echter PC wie ref *)
      WHILE apc>=nextPC DO
        WriteLn;
        nextPC:=ShowSrc(srcCol)
      END;
    END;
    (* Labels ausgeben *)
    WHILE nexta<=a DO
      IF (refRec^.typ>=def) THEN
        IF nexta=a THEN ShowLab(refRec); WriteString(':\n');
        ELSIF nexta<a THEN
          Tab3;
          WriteString('; loosed Label: "'); ShowLab(refRec);
          FormatNr('" =$%04lx\n',nexta+offset);
        END;
      END;
      NextRef(e);
      TestBreak;
    END;

(* spter mal mit Zhler laufen lassen
 IF (adr+2)=CaseArr[ActCase].adr THEN
   CaseFlag:=TRUE;
   CaseCnt:=CaseArr[ActCase].cnt;
   CaseAd:=newa+offset;
   Copy(CaseName,refRec^.str^);
   INC(ActCase);
 END;
*)
    newa:=Disass(ADR(Buff),a,offset);
    TestBreak;
    IF 2 IN Buff.flags THEN (* dc.w *)
      IF (CaseArr[ActCase].adr=newa) THEN
        CaseFlag:=TRUE;
        Copy(CaseName,refRec^.str^);
        CaseAd:=newa+offset;
        INC(ActCase);
      END;
      IF CaseFlag THEN
        wp:=CAST(CasePtr,CAST(LONGINT,newa)-4);
        CaseRec:=SearchLab(CaseAd+wp^.iarr[-1]);
        IF CaseRec#NIL THEN
          Buff.s2:='DC.W\t';
          Concat(Buff.s2,CaseRec^.str^);
          Concat(Buff.s2,'-');
          Concat(Buff.s2,CaseName);
        END;
      END;
    ELSE
      CaseFlag:=FALSE;
    END;

  (*$ IF Debug *)
    ShowRec(refRec,a,nexta,newa,e);
  (*$ ENDIF *)

    (* Nun alles ersetzen! generierte Label erzeugen kein ref! *)
    IF (BITSET{0,1}*Buff.flags # BITSET{})
       &(Buff.adrAdr#refRec^.pos+ActHunk^.mem) THEN
      href:=SearchLab(Buff.adr+offset);
      IF href#NIL THEN
        ReplaceLab(href,Buff.adrPos,TRUE,0);
      ELSE
        (*$ IF Debug *)
        FormatNr('reldest=$%06ld ',Buff.adr+offset);
        FormatNr('relpos=$%06ld ',Buff.adrAdr+offset);
        (*$ ENDIF *)
        (* WriteString(';label not found!!!!!!\n');*)
      END;
    END;
    WHILE (nexta<newa)&(nexta<e) DO
      (* Suche bit fr diese Pos *)
      absadr:=refRec^.pos+ActHunk^.mem;
      trick:=CAST(TrickPtr,absadr);
      IF refRec^.wid=byte THEN val:=LONGINT(trick^.barr);
      ELSIF refRec^.wid=word THEN val:=trick^.warr
      ELSE val:=trick^.larr
      END;
      IF (BITSET{0,1}*Buff.flags # BITSET{})&(Buff.adrAdr=absadr) THEN
        IF refRec^.typ=label THEN
          href:=SearchLab(Buff.adr+offset);
          IF href#NIL THEN
            ReplaceLab(href,Buff.adrPos,TRUE,0);
          ELSE
	   (*$ IF Debug *) ShowRec(refRec,a,nexta,newa,e); (*$ ENDIF *)
            (* WriteString('label not found!!!!!!\n');*)
          END;
        ELSE (* mu dann reloc oder ref sein *)
          IF refRec^.wid=byte THEN INC(val) END;
          ReplaceLab(refRec,Buff.adrPos,TRUE,val);
        END;
      ELSIF (3 IN Buff.flags)&(Buff.drelAdr1=absadr) THEN
        ReplaceLab(refRec,Buff.drelPos1,FALSE,val);
      ELSIF (4 IN Buff.flags)&(Buff.drelAdr2=absadr) THEN
        ReplaceLab(refRec,Buff.drelPos2,FALSE,val);
      ELSIF (5 IN Buff.flags)&(Buff.abslAdr1=absadr) THEN
        ReplaceLab(refRec,Buff.abslPos1,FALSE,val);
      ELSIF (6 IN Buff.flags)&(Buff.abslAdr2=absadr) THEN
        ReplaceLab(refRec,Buff.abslPos2,FALSE,val);
      ELSE (*$ IF Debug *) ShowRec(refRec,a,nexta,newa,e); (*$ ENDIF *)
           (* WriteString('!!Label, aber kein Flag!\n');*)
      END;
      NextRef(e);
    END;
    IF objAnzeigen THEN
      FormatNr("$%04lx  ",a+offset+globPos);
      SpacesToTabs(ADR(Buff.s));
      WriteString(Buff.s);
    ELSE
      SpacesToTabs(ADR(Buff.s2));
      Write(11C);
      WriteString(Buff.s2);
    END;
    WriteLn;
    a:=newa;
  END; (* while a<e *)
  CaseNr:=ActCase;
END DisHunk;

PROCEDURE IsBY():BOOLEAN;
VAR s:ARRAY[0..35] OF CHAR; r:ReferencesPtr;
BEGIN
  r:=SearchLab(0); (* erstes Label holen *)
  IF (r#NIL)&(r^.typ=def) THEN
    CopyName(s,r^.name);
    RETURN String.Occurs(s,0,'_BY',TRUE)=INTEGER(Length(s))-3
  ELSE
    RETURN FALSE
  END;
END IsBY;


PROCEDURE DecUnit;
VAR
  a,e:LONGINT;
BEGIN
  globPos:=0;
  ActHunk:=Hunks.head;
  WHILE ActHunk^.succ#NIL DO
    WriteLn;
    Tab3;
    FormatNr('; Hunk: %ld\n',ActHunk^.absnr);
    CopyName(strBuffer,ActHunk^.name);
    Tab3;
    WriteString('\tSECTION\t');
    IF strBuffer[0]#0C THEN
      WriteString(strBuffer); Write(',');
    END;
    FormatS('%s\n\n',HunkName[ActHunk^.type]^);
    IF IsBY() THEN ActHunk^.type:=data END;
    a:=ActHunk^.mem; e:=a+ActHunk^.lwSize*4; offset:=-a;
    InitLab;
    CASE ActHunk^.type OF
    | code,chipcode,fastcode:
      DisHunk(a,e);
    | data, chipdata, fastdata:
      DumpAscii(a,e);
    | ELSE (* bss *)
      DumpBss(a,e);
    END;
    INC(globPos,ActHunk^.lwSize*4);
    ActHunk:=ActHunk^.succ;
  END;
  Tab3; WriteString('\tEND\n\n');
END DecUnit;

(* Dies ist ein bichen doof! Wir haben aber genau 1 Unit je File! *)
(* Liest alle Units eines Files *)
PROCEDURE DecodeFile;
VAR cnt,i:LONGINT; rec:RECORD c,f,l:LONGINT END;
BEGIN
  LoadObj(fName);
  FormatS('; Disassembly of %s\n',FullName);
  IF withSrc THEN
    withSrc:=OpenSrc(fName,ft);
    IF ~withSrc & ~quoted THEN SetReply(rcWarn) END;
  END;
  nextPC:=-1;
(*
  IF withSrc THEN
    nextPC:=ShowSrc();
  ELSE
    nextPC:=MAX(LONGINT);
  END;
*)
(*BreakPoint(ADR('ent DecodeFile'));*)
  GetLong(LastLong);
  WHILE ~eof DO
    IF LastLong=hunkUnit THEN
      UnitName:=CAST(NameRecPtr,MemPtr);
      CopyName(strBuffer,UnitName);
      WriteLn;
      Tab3; FormatS('\tUNIT\t"%s"\n',strBuffer);
      GetLong(cnt);
      SkipBlock(cnt);
      GetLong(LastLong);
      ReadHunks;
      DecUnit;
    ELSIF LastLong=hunkHeader THEN
      REPEAT
        UnitName:=CAST(NameRecPtr,MemPtr);
        GetLong(cnt); SkipBlock(cnt);
        IF cnt>0 THEN
          CopyName(strBuffer,UnitName);
          FormatS('\tLIBRARY\t"%s"\n',strBuffer);
        END;
      UNTIL cnt=0;
      GetLong(rec.c); GetLong(rec.f); GetLong(rec.l);
      Format('; Hunks: %ld, First Hunk: %ld, Last Hunk: %ld\n',ADR(rec));
      FOR i:=rec.f TO rec.l DO
        GetLong(cnt);
        FormatNr('; Hunk #%4ld: ',i);
        FormatNr('%6ld Langworte\n',cnt);
      END;
      GetLong(LastLong);
      ReadHunks;
      DecUnit;
    ELSE
      Err('HunkUnit oder HunkHeader erwartet!',empty);
    END;
  END;
  IF withSrc THEN
    WHILE nextPC # MAX(LONGINT) DO
     nextPC:=ShowSrc(srcCol); (* evtl. Rest zeigen *)
    END;
  END;
(*BreakPoint(ADR('exit DecodeFile'));*)
END DecodeFile;

(*$ CopyDyn:=FALSE *)
PROCEDURE Options(s:ARRAY OF CHAR; len:INTEGER):BOOLEAN;
VAR set,ok:BOOLEAN; i,val:INTEGER;
BEGIN
  IF s[0]='?' THEN
    ok:=FALSE;
  ELSE
    ok:=TRUE;
    i:=0;
    LOOP
      CASE CAP(s[i]) OF (* zunchst kommt ja sicher '+' oder '-'! *)
      | '+': set:=TRUE;
      | '-': set:=FALSE;
      | '0': ft:=objFile;
      | '1': ft:=ob1File;
      | '2': ft:=ob2File;
      | '3': ft:=ob3File;
      | '4': ft:=ob4File;
      | '8': ft:=ob8File;
      | "C": INC(i);
	     val:=INTEGER(s[i])-30H;
	     IF (val>=0)&(val<=3) THEN
	       srcCol:=SrcColor(val)
	     ELSE
	       ok:=FALSE
	     END;
      | 'Q': verbose:=set;
      | 'O': objAnzeigen:=set;
      | "S": globWithSrc:=set;
      | ELSE
	  ok:=FALSE;
	  EXIT
      END; (* case *)
      INC(i);
      IF i>=len THEN EXIT END;
    END; (* loop *)
    IF interActive THEN verbose:=TRUE END;
  END;
  IF ~ok THEN
    WriteString(title1); WriteString(version);
    Format(usage,ADR(programName));
    SetReply(rcIllOpt);
  END;
  RETURN ok;
END Options;



BEGIN (* Main *)
  SETREG(11,ADR(verDollar));
  HunkName[code]:=ADR('CODE');
  HunkName[chipcode]:=ADR('CHIPCODE');
  HunkName[fastcode]:=ADR('FASTCODE');
  HunkName[data]:=ADR('DATA');
  HunkName[chipdata]:=ADR('CHIPDATA');
  HunkName[fastdata]:=ADR('FASTDATA');
  HunkName[bss]:=ADR('BSS');
  HunkName[chipbss]:=ADR('CHIPBSS');
  HunkName[fastbss]:=ADR('FASTBSS');

  (* quiet:=FALSE; interActive:=FALSE objAnzeigen:=FALSE *)
  ft:=objFile; globWithSrc:=TRUE; srcCol:=2;
  InitHandler(Options,ADR(in),ADR('ENV:m2decobj'),ADR("m2decobj.opt"));
  WriteString(title2); WriteString(version);

  IF ~FetchName() THEN RETURN END; (* bei Aufruffehler gleich raus *)
  IF fNameLen=0 THEN interActive:=TRUE END;
  ReadPathTable(pathFileName);
  (* Nun erstes Arg holen! *)
  LOOP
    IF dejaVue OR (fNameLen=0) THEN
      REPEAT
      UNTIL FetchName(); (* bis Leerstring oder guter *)
    END;
    dejaVue:=TRUE;
    IF fNameLen=0 THEN EXIT END;
    IF interActive THEN verbose:=TRUE END;
    loadErr:=FALSE;

    withSrc:=globWithSrc;
    Call(DecodeFile);

    ForgetMem;
    IF loadErr THEN
      SetReply(rcActionErr);
      interActive:=TRUE;
    END;
  END; (* loop *)
  IF interActive&verbose THEN
    WriteString(exit);
  END;
  waitCloseGadget:=verbose & ~interActive;

CLOSE

END m2decobj.
