IMPLEMENTATION MODULE m2cd;
(*$ LargeVars:=FALSE StackParms:=FALSE *)

(* 10.04.88/cn
 * 31.12.88/ms
 * 04.03.89/ms
 *	Alle Allocate(); Assert() Paare durch einen ALLOCATE Aufruf
 *	ersetzt. Dies versichert den Test und spart einige Bytes
 *	Code gleichzeitig.
 * 17.04.89/ms
 *	Korrektur beim Einlesen eines Typen.
 * 10.10.89/jr
 *      ALLOCATE ersetzt duch GetMem, Verlagerung der Daten nach M2Base,
 *      Umstellung auf spezNIL..
 * 29.12.90/bp
 *	Abfrage >=extVar eingeschrnkt, da neue VarModes kommen knnen!
 *	InId fr Strings lnger 255 erweitert
 * 3.2.91/bp
 *	VERDAMMT!!!!!!
 *	Etliche Abstrze, weil urealtyp und stringtyp nicht initialisert
 *	waren!
 * 5.9.92/bp
 *	Angepasst an externe Procs. Werden als CODE eingelesen und
 *	ignoriert.
 *)

FROM SYSTEM	IMPORT	ADDRESS,ADR,BYTE,CAST,REG,SETREG,WORD,ASSEMBLE;
FROM Arts	IMPORT	ModType,BreakPoint;
FROM ASCII	IMPORT	eol;
IMPORT FileSystem;
FROM FileSystem	IMPORT	Response,Close,Lookup,ReadChar,SetPos;
FROM M2Base	IMPORT	spezNIL,MName,GetMem,ForgetMem;
FROM M2File	IMPORT	FileType,GetFileName,ReadPathTable,ForgetPathTable,
			pathFileName;
FROM m2md	IMPORT	maxMods,modInfoList;
(*FROM Terminal	IMPORT	Write,WriteString,WriteLn;*)
FROM String	IMPORT	first,ComparePart,Delete,Length;
IMPORT SeqIO;
FROM SeqIO	IMPORT	SeqKey,OpenSeqIn,CloseSeq,SeqOk,SeqInCount;

CONST
 procString='PROCEDURE';
 minSCard=0; maxSCard=255; minSInt=-128; maxSInt=127;
 minCard=0; maxCard=65535; minInt=-32768; maxInt=32767;
 minLCard=0; maxLCard=0FFFFFFFFH; minLInt=-080000000H; maxLInt=07FFFFFFFH;
 REFFILE=10; (* 11, 12, 13, 14 ,18 fr CPUs! *)
 CTL=0;
  anchor=0; modTag=1; procTag=2; refTag=3;  linkage=4;
 STR=1;
  enum=0;   range=1;  pointer=2; set=3;     procTyp=4;   funcTyp=5;
  array=6;  dynarr=7; record=10; opaque=11; bpointer=12;
 CMP=2;
  parref=0; par=1;    field=2;
 OBJ=3;
  varref=0; var=1;    const=2;   string=3;  type=4;
  proc=5;   func=6;   module=7;  svc=10;    svcfunc=11;
 maxM=256;  (* maximum number of modules *)
 maxP=256;  (* maximum number of procedures *)
 minS=32;   (* first non-standard structure *)
 maxS=1024; (* maximum number of structures *)

TYPE
 ObjPtr=POINTER TO Object;
 StrPtr=POINTER TO Structure;
 IdPtr=POINTER TO ARRAY [0..20000] OF CHAR;
 ObjClass=(Header,Const,Typ,Var,Field,Proc,Code,Module,Temp);
 Object=RECORD
  name:IdPtr; (* pointer to name *)
  typ:StrPtr;
  next:ObjPtr;
  CASE class:ObjClass OF
  | Header: last:ObjPtr;
  | Const: val:LONGINT; (* only use for enumeration constants *)
  | Typ: (* nothing *)
  | Var: varpar:BOOLEAN; vadr:LONGINT; vmode:VarModes;
  | Field: offset:LONGINT;
  | Proc: procNo,procAdr,procSize:INTEGER; firstLocal:ObjPtr;
  | Code: (* nothing *)
  | Module: firstObj:ObjPtr; mode:ModType;
  | Temp:
  END;
 END;
 (*
  * Attention: Some dirty tricks assume that the sign field does not overlap
  *            any of the other fields.
  *)
 Structure=RECORD
  strobj: ObjPtr;
  named: BOOLEAN;
  size: LONGINT;
  sign: BOOLEAN;
  CASE form: StrForm OF
  | Undef..UInt,FFP..UReal,ProcTyp..String: (* no field *)
  | Enum: firstConst:ObjPtr; NofConst:LONGINT;
  | Range: RBaseTyp:StrPtr; min,max:LONGINT;
  | BPointer,Pointer: PBaseTyp:StrPtr;
  | Set: SBaseTyp:StrPtr;
  | Array: ElemTyp,IndexTyp:StrPtr; dyn:BOOLEAN;
  | Record: firstFld:ObjPtr;
  END;
 END;
 StrFormSet=SET OF StrForm;

CONST
 byte=0; word=1; long=2;
VAR
  (*
   * Standard types
   *)
 notyp,undftyp,booltyp,chartyp,uinttyp,ffptyp,realtyp,lrealtyp,urealtyp,
 ssettyp,bsettyp,lsettyp,sbasetyp,proctyp,stringtyp,bytetyp,wordtyp,addrtyp,bptrtyp:StrPtr;
 numtyp:ARRAY [byte..long],[FALSE..TRUE] OF StrPtr;
  (*
   * Structured objects
   *)
 enuObj,bptrObj,ptrObj,setObj,arrObj,recObj,ptyObj,opaObj:ObjPtr;


  (*
   * The following four types are needed for the pos info list. This is not
   * a pure list. To avoid memory fragmentation, arrays of posListLen are
   * allocated and linked into a list.
   *)

CONST
 posListLen=10; (* length of position info block *)

TYPE
 PosInfo=RECORD pc:INTEGER; sourcePos:LONGINT; END;
 PosInfoList=ARRAY [0..posListLen-1] OF PosInfo;
 PosInfoPtr=POINTER TO PosInfoBlock;
 PosInfoBlock=RECORD posInfoList:PosInfoList; next:PosInfoPtr; END;


  (*
   * ModInfo stores information about the modules involved in the debugging
   *
   * srcName: The name of the source file correctly expanded. not needed!!
   * impl: Is true if the currently displayed source is the implementation
   *       module source.
   * refAttempt: Is true if the debugger already tried to open the reference
   *             file.
   * modObj: The modules symbol table.
   * posInfoPtr: Points to a list containing all (pc,srcPos) pairs.
   *)
CONST
(*
 * 27.12.88/ms Die maximale Lnge eines Namens war auf 32 beschrnkt !
 * 18.4.91/bp  Die maximale Lnge eines Namens war auf 64 beschrnkt !
 *)
 fileNameLen=128;

(* ----------------- pos handling -------------------------- *)

VAR
  (*
   * 'thePos' points to the current block of position infos.
   * 'pIdx' is an index into this block onto the element which will be
   * filled in next.
   *)
 thePos: PosInfoPtr;
 pIdx:INTEGER;

PROCEDURE InsertPosInfo(p:INTEGER; s:LONGINT);
   (*
    * This procedure adds a (pc,sourcepos) pair to the end of the pos info list.
    *)
BEGIN
   (*
    * Allocate a new block if the current block is already full.
    *)
  IF pIdx=posListLen THEN
    GetMem(thePos^.next, SIZE(PosInfoBlock));
    thePos:=thePos^.next;
    WITH thePos^ DO
      FOR pIdx:=0 TO posListLen-1 DO posInfoList[pIdx].sourcePos:=0 END;
      next:=NIL;
    END;
    pIdx:=0;
   END;
   (*
    * Insert the pc and position at the next position and increment
    * pIdx.
    *)
  WITH thePos^.posInfoList[pIdx] DO
    pc:=p; sourcePos:=s;
  END;
  INC(pIdx);
END InsertPosInfo;

PROCEDURE GetFirstPosInfo(modNo:INTEGER; VAR posInfo:PosInfo);
   (*
    * This procedure sets thePos to the first block of the selected
    * module and returns the first posInfo in it.
    *
    * NOTE: If no info exists, pIdx is not valid,
    *       posInfo.sourcePos is 0 and posInfo.pc is undefined.
    *)
BEGIN
  thePos:=modInfoList.contents[modNo].l^.posInfo;
  IF thePos=NIL THEN
    posInfo.sourcePos:=0
  ELSE
    posInfo:=thePos^.posInfoList[0]; pIdx:=1
  END;
END GetFirstPosInfo;

PROCEDURE GetNextPosInfo(VAR posInfo:PosInfo);
   (*
    * This procedure gets the next posInfo for the current module.
    *)
BEGIN
   (*
    * If we are at the end of the current block get the next one first.
    *)
  IF pIdx=posListLen THEN
    thePos:=thePos^.next;
    IF thePos=NIL THEN posInfo.sourcePos:=0; RETURN; END;
    pIdx:=0;
  END;
  posInfo:=thePos^.posInfoList[pIdx]; INC(pIdx);
END GetNextPosInfo;

PROCEDURE GetErrPosition(modNo:INTEGER; pc:INTEGER; VAR errStart,errStop:LONGINT);
   (*
    * Given the module number and pc position, this procedure returns the
    * start and the end of the statement containing that pc position. If
    * errStart is 0, no position could be found. errStop has the value
    * MAX(LONGINT) if it's the last statement of the source.
    *)
 VAR
   posInfo: PosInfo;
 BEGIN
   errStart:=1;
   GetFirstPosInfo(modNo, posInfo);
   LOOP
     (* check end of list *)
     IF posInfo.sourcePos=0 THEN (* mark error *) errStart:=0; EXIT END;
     IF pc<=posInfo.pc THEN errStop:=posInfo.sourcePos; EXIT END;
     errStart:=posInfo.sourcePos;
     GetNextPosInfo(posInfo)
   END
 END GetErrPosition;

(*---------------------- Read reference File ---------------------------------*)


CONST
 bufSize=2048;
TYPE
 CHARPtr=POINTER TO CHAR;

VAR
  inFile:SeqKey;
  inFileOpen:BOOLEAN;
  err:INTEGER;

PROCEDURE GetB():BYTE;
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVE.L	inFile(A4),A0
	JSR	SeqIO.SeqInB(PC)
	RTS
	END);
(*  RETURN SeqInB(inFile);*)
END GetB;

PROCEDURE InB(VAR b{10}:BYTE);
(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	BSR.S	GetB
	MOVE.B	D0,(A2)
	RTS
  END)
(*
  b:=GetB();
*)
END InB;

PROCEDURE InCount(adr:ADDRESS; cnt:INTEGER);
BEGIN
  SeqInCount(inFile,adr,CAST(CARDINAL,cnt));
END InCount;

PROCEDURE InNumber0(VAR x:ARRAY OF BYTE; b:BYTE); (* nur f. PCpos *)
VAR
(* c,i,k,l:SHORTINT;
 ch:CHAR;
 fill:BOOLEAN;*)  (* HACK: assumes TRUE=-1 ! *)
BEGIN
  ASSEMBLE(
	MOVE.B	b(A5),D0 (*; byte *)
	MOVEA.L	x(A5),A1 (*; adr *)
	ADDA.L	x+4(A5),A1 (*; high *)

	BCLR	#7,D0
	BNE.S	b10od11
(*; 00 oder 01 *)
	BCLR	#6,D0
	BNE.S	b01
(*; 00 *)
	BTST	#5,D0
	SNE	D4
	BEQ.S	b00a
	ORI.B	#$C0,D0
b00a:	MOVE.B	D0,(A1)
	BRA.S	fill

b01:	BTST	#5,D0
	SNE	D4
	BEQ.S	b01a
	ORI.B	#$C0,D0
b01a:	SUBQ.L	#1,x+4(A5)
	BMI.S	InError
	MOVE.B	D0,-1(A1)
	MOVE.L	A1,D5
	BSR	GetB
	MOVEA.L	D5,A1
	MOVE.B	D0,(A1)
	BRA.S	fill

b10od11:
	BCLR	#6,D0
	BNE.S	b11
(*; 10 *)
	BTST	#5,D0
	SNE	D4
	BEQ.S	b10a
	ORI.B	#$C0,D0
b10a:
	SUBQ.L	#2,x+4(A5)
	BMI.S	InError
	MOVE.B	D0,-2(A1)
	PEA	-1(A1)
	MOVEQ	#2,D0
	MOVE.W	D0,-(A7)
	BSR	InCount
	BRA.S	fill

(*; D0.B=anzahl zu lesende *)
b11:	MOVEQ	#0,D1
	MOVE.B	D0,D1
	MOVE.L	D1,D0
	SUBQ.L	#1,D1
	SUB.L	D1,x+4(A5)
	BMI.S	InError
	SUBA.L	D1,A1
	MOVE.L	A1,D5
	MOVE.L	A1,-(A7)
	MOVE.W	D0,-(A7)
	BSR	InCount
	MOVEA.L	D5,A1
	BTST	#7,(A1)
	SNE	D4

(*; D4=fill [0]... mit D4 (Vorzeichen) *)
fill:	MOVE.L	x+4(A5),D1
	BEQ.S	InNuOk
	MOVEA.L	x(A5),A1
	SUBQ.L	#1,D1
filllp:	MOVE.B	D4,(A1)+
	DBRA	D1,filllp

InError: (*; macht gar nichts! Besser als Speicher zerstren! *)
InNuOk:
 	END);
END InNumber0;

(*$ EntryExitCode:=FALSE *)
PROCEDURE InNumber(VAR x:ARRAY OF BYTE);
BEGIN
  ASSEMBLE(
	BSR     GetB
	MOVEA.L	(A7)+,A0
	MOVE.B  D0,-(A7)
	MOVE.L	A0,-(A7)
	BRA     InNumber0
	END);
(*
  InNumber0(x,GetB());
*)
END InNumber;

PROCEDURE InW(VAR w:WORD);
BEGIN
 SeqIO.SeqGetW(inFile,w);
END InW;

PROCEDURE InL(VAR l:LONGINT);
BEGIN
 SeqIO.SeqGetL(inFile,CAST(ADDRESS,l));
END InL;

(*$ EntryExitCode:=FALSE *)
PROCEDURE InBool(VAR b{10}:BOOLEAN); (* bleibt so, 0=FALSE *)
BEGIN
  ASSEMBLE(
	BSR	GetB
	NEG.B	D0
	MOVE.B	D0,(A2)
	RTS
	END);
END InBool;


(*$ OverflowChk:=FALSE RangeChk:=FALSE *)
PROCEDURE InId(VAR id:IdPtr);
VAR
 L:INTEGER;
 ch:INTEGER;
 id0:POINTER TO ARRAY[0..255] OF CHAR;
BEGIN
 id:=NIL;
 InNumber(ch);
 L:=ch-1;
 IF L>0 THEN
  GetMem(id,ch);
  id0:=CAST(ADDRESS,id);
  (* neu InCount statt WHILE ... 16.2.90 /bp *)
  InCount(id0,L);
  id0^[L]:=0C;
 END;
 (* 23.11.90/bp Hier war ein schwerer Fehler, der Dank "Enforcer" gefunden
  * werden konnte!
  *)
END InId;
(*$ POP OverflowChk POP RangeChk *)

(*$ CopyDyn:=FALSE *)
PROCEDURE InRef(filename:ARRAY OF CHAR; VAR mod:ObjPtr; VAR posPtr:PosInfoPtr;
		refKenn:LONGINT);
VAR
 Struct:ARRAY [1..maxS ] OF StrPtr;
 LocMod:ARRAY [0..maxM-1] OF ObjPtr;
 LocProc:ARRAY [0..maxP-1] OF ObjPtr;
 block:CARDINAL;
 CurStr,CurMod,i,m,p,s:INTEGER;
 newobj,obj:ObjPtr;
 newstr:StrPtr;
 objList:ObjPtr; (* Chain of all objects local to the current scope *)
 fldList:ObjPtr; (* Chain of all fields local to the current record *)
 blk,ch:CHAR;
 dummyId,mainModName:IdPtr;
 fileType:LONGINT;
 dummy:LONGINT;
 dummyW:INTEGER;
 dummyConst:RECORD
  CASE :INTEGER OF
  | 0: sign,i:LONGINT;
  | 1: lr:LONGREAL;
  END;
 END;

BEGIN (* InRef *)
(*WriteString(filename); WriteLn;*)
 mod:=NIL; posPtr:=NIL;
 inFileOpen:=OpenSeqIn(inFile,filename,bufSize);
(* WriteString(" - "); WriteString(filename); *)
 IF ~inFileOpen THEN RETURN END;
 InL(fileType);
 IF (fileType=refKenn) THEN
   Struct[1]:=undftyp;             Struct[2]:=booltyp;
   Struct[3]:=chartyp;             Struct[4]:=numtyp[word,TRUE];
   Struct[5]:=numtyp[word,FALSE];  Struct[6]:=numtyp[long,TRUE];
   Struct[7]:=realtyp;             Struct[8]:=lrealtyp;
   Struct[9]:=bsettyp;             Struct[10]:=proctyp;
   Struct[11]:=stringtyp;          Struct[12]:=addrtyp;
   Struct[13]:=bytetyp;            Struct[14]:=wordtyp;
   Struct[15]:=numtyp[long,FALSE]; Struct[16]:=uinttyp;
   Struct[17]:=urealtyp;           Struct[18]:=ffptyp;
   Struct[19]:=lsettyp;            Struct[20]:=numtyp[byte,FALSE];
   Struct[21]:=numtyp[byte,TRUE];  Struct[22]:=bptrtyp;
   Struct[23]:=ssettyp;

   GetMem(objList,SIZE(Object));
   WITH objList^ DO class:=Header; next:=NIL; last:=objList END;
   GetMem(fldList,SIZE(Object));
   WITH fldList^ DO class:=Header; next:=NIL; last:=fldList END;
   GetMem(posPtr,SIZE(PosInfoBlock));
   WITH posPtr^ DO
    FOR i:=0 TO posListLen-1 DO posInfoList[i].sourcePos:=0 END;
    next:=NIL
   END;

   CurMod:=0; CurStr:=minS; err:=0;
   thePos:=posPtr; pIdx:=0;
   LOOP
    InB(blk); block:=CARDINAL(blk);
    CASE block DIV 16 OF
    | OBJ:
     DEC(block,16*OBJ);
     IF block<=svcfunc THEN
       (*
        * It's an object. Allocate an object record and read the fields in.
        *)
      GetMem(newobj,SIZE(Object));
      m:=0;
      WITH newobj^ DO
       next:=NIL;
       CASE block OF
       | varref,var:
        class:=Var; InNumber(s); typ:=Struct[s];
        varpar:=block=varref;
        InNumber(dummy); (* level *)
        InNumber(vadr);
        InNumber(vmode); (* 30.9.90/bp Namen der ExtVar lesen! *)
        IF (vmode>=extVar)&(vmode<=smallExtVar) THEN InId(dummyId) END;
       | const:
        class:=Const; InNumber(s); typ:=Struct[s];
        InNumber(dummy); (* ModRef *)
        InNumber(dummyConst);
        IF (typ^.form=Enum) THEN
         val:=dummyConst.i;
         IF (typ^.firstConst=NIL) THEN
          typ^.firstConst:=newobj;
         END;
        END;
       | string:
        class:=Const; InNumber(s); typ:=Struct[s];
        InId(dummyId);
       | type:
        class:=Typ; InNumber(s); typ:=Struct[s];
(*
 * 17.4.89/ms
 *	Falls der Typ bereits einen Namen hat sollten wir ihm hier nicht
 *	einen neuen Namen zuteilen. Am Anfang werden alle strukturierten
 *	Typen mit einem Anfangswert initialisiert. strobj=NIL ist dann nicht
 *	mehr gewhrleistet.
 * 29.4.89/ms
 *	Kokrrektur der ersten Lsung. Nun gibt es ein weiteres Feld in
 *	'Structure', das angibt, ob der Name temporr oder fest ist.
 *	Jeder Name der hier eingelesen wird, soll als fester Name eingetragen
 *	werden, falls noch kein Name vereinbar wurde.
 *)
        IF ~typ^.named THEN
         WITH typ^ DO
          strobj:=newobj; named:=TRUE
         END
        END;
        InNumber(dummy); (* ModRef *)
       | proc,func:
        class:=Proc;
        IF block=func THEN InNumber(dummy); (* typ *) END;
        InNumber(procNo);
        InNumber(dummy); (* level *)
        (*
         * 05.09.92/bp externe Procs haben level=-1 und
         * ident statt procAdr
         *)
        IF dummy<0 THEN
          InId(dummyId); (* extName statt adr *)
          class:=Code; (* darf er gar nicht sehen bei pc-Suche! *)
          InNumber(dummy); (* size *)
          InNumber(dummy); (* regs *)
        ELSE
          InNumber(procAdr);
          InNumber(procSize);
          InNumber(dummy); (* regs *)
          firstLocal:=LocProc[procNo];
        END;
       | module:
        class:=Module;
        InNumber(m); firstObj:=LocMod[m];
       | svc,svcfunc:
        class:=Code;
        IF block=svcfunc THEN InNumber(dummy); (* typ *) END;
        InNumber(dummy); (* cnum *)
       END(*CASE block*);
       InId(name);
       InNumber(dummy); (*exported*)
         (*
          * Add the object to the object list.
          *)
       WITH objList^ DO last^.next:=newobj; last:=newobj END;
      END(*WITH newobj^*);
     ELSE
      err:=1;
     END(*IF block<svcfunc*);
    | CMP:
     DEC(block,16*CMP);
     IF block<=field THEN
      IF block=field THEN
        (*
         * It's a record field, allocate an object for it, read the fields in
         * and add it to the field list.
         *)
       GetMem(newobj,SIZE(Object));
       WITH newobj^ DO
        class:=Field; next:=NIL;
        InNumber(s); typ:=Struct[s];
        InNumber(offset); InId(name);
        fldList^.last^.next:=newobj;
        fldList^.last:=newobj;
       END;
      ELSE (*parameter*)
         (*
          * Skip the parameters, we don't need them. The information we need
          * we find in the variables object which represent the parameters.
          *)
       InNumber(dummy); (*typ*)
       InNumber(dummy); (*parMode*)
       InId(dummyId); (*name*)
      END(*IF block=field*);
     ELSE
      err:=2;
     END(*IF block<=field*);
    | STR:
     DEC(block,16*STR);
     IF block<=bpointer THEN
       (*
        * It's a structure. Allocate a structure record for it.
        *)
      GetMem(newstr,SIZE(Structure));
      WITH newstr^ DO
       strobj:=NIL; InNumber(size); sign:=FALSE; named:=FALSE;
       CASE block OF
       | enum:
        form:=Enum; InNumber(NofConst); firstConst:=NIL; strobj:=enuObj;
       | range:
        form:=Range; InNumber(s); RBaseTyp:=Struct[s];
        InNumber(min); InNumber(max); InNumber(sign);
        strobj:=RBaseTyp^.strobj;
       | bpointer:
        form:=BPointer; strobj:=bptrObj;
       | pointer:
        form:=Pointer; strobj:=ptrObj;
       | set:
        form:=Set; InNumber(s); SBaseTyp:=Struct[s]; strobj:=setObj;
       | procTyp:
        form:=ProcTyp; strobj:=ptyObj;
       | funcTyp:
        form:=ProcTyp; InNumber(dummy); (*resTyp*)  strobj:=ptyObj;
       | array:
        form:=Array; dyn:=FALSE;
        InNumber(s); ElemTyp:=Struct[s];
        InNumber(s); IndexTyp:=Struct[s];
        strobj:=arrObj;
       | dynarr:
        form:=Array; dyn:=TRUE;
        InNumber(s); ElemTyp:=Struct[s];
        IndexTyp:=NIL;
        strobj:=arrObj;
       | record:
        form:=Record;
        firstFld:=fldList^.next; fldList^.next:=NIL;
        fldList^.last:=fldList;
        strobj:=recObj;
       | opaque:
        form:=Opaque;
        strobj:=opaObj;
       END(*CASE block*)
      END(*WITH newstr^*);
      Struct[CurStr]:=newstr;
      IF CurStr<maxS THEN INC(CurStr); ELSE err:=3; END;
     ELSE
      err:=4;
     END(*IF block<=opaque*)
    | CTL:
     DEC(block,16*CTL);
     IF block<=linkage THEN
      CASE block OF
      | anchor:
       InW(dummyW); InW(dummyW); InW(dummyW); (*key*)
       InId(dummyId); (*name*)
       IF CurMod=0 THEN mainModName:=dummyId; END;
       INC(CurMod);
       InNumber(dummy); (*mode*)
       IF dummy=LONGINT(lib) THEN InId(dummyId); END;
      | modTag:
        (*
         * Attach all objects found til here to this module.
         *)
       InNumber(m); LocMod[m]:=objList^.next; (* LocMod[0] is mainmod *)
       objList^.next:=NIL; objList^.last:=objList;
      | procTag:
        (*
         * Attach all objects found til here to this procedure.
         *)
       InNumber(p); LocProc[p]:=objList^.next;
       objList^.next:=NIL; objList^.last:=objList;
      | refTag:
       InNumber(dummy); (*adr*) InNumber(dummy); (*pno*)
       EXIT; (* refFile is read *)
      | linkage:
       InNumber(s); InNumber(p);
       Struct[p]^.PBaseTyp:=Struct[s];
      END(*CASE block*);
     ELSE
      err:=5;
     END(*IF block<=linkage*)
    ELSE (*line block*)
     InNumber0(s,blk); InNumber(dummy); InsertPosInfo(s,dummy);
    END(*CASE block DIV 16*);
    IF err#0 THEN EXIT END;
   END(*LOOP*);
   IF err=0 THEN
     (*
      * If no error occurred then create an object for this module,
      * and link in the symbol table built up form the reference file.
      *)
    GetMem(mod, SIZE(Object));
    WITH mod^ DO
     name:=mainModName; typ:=NIL; next:=NIL;
     class:=Module; firstObj:=LocMod[0];
    END
   END
 END;(*IF FileType=REFFILE*)
 CloseSeq(inFile);
END InRef;


(*----------------------------------------------------------------------------*)

PROCEDURE ExtractName(id:IdPtr; VAR name:ARRAY OF CHAR);
 (* name:=id^ *)
 VAR
  p,q:CHARPtr;
(* RangeChk:=FALSE OverflowChk:=FALSE *)
 BEGIN
  p:=ADR(name); q:=ADDRESS(id);
  LOOP
   p^:=q^;
   IF p^=0C THEN EXIT; END;
   INC(p); INC(q);
  END;
 END ExtractName;
(* POP RangeChk POP OverflowChk *)

(*-------- exported procedures --------------*)

PROCEDURE GetModuleItem(modNo: INTEGER; VAR mod: Item);
 VAR
  fName: ARRAY [0..127] OF CHAR;
  mName: MName;
  po: PosInfoPtr; ob: ObjPtr; (* dummy for InRef *)
 BEGIN
  IF modNo<0 THEN ob:=NIL
  ELSE
   WITH modInfoList.contents[modNo].l^ DO
    ob:=mObj;
    IF ob=ObjPtr(spezNIL) THEN ob:=NIL
    ELSIF ob=NIL THEN
      (*
       * We never tried to read in this reference file, so let's do it now.
       *)
     GetFileName(fName, refFile, modname, FALSE);
     InRef(fName, ob, po, LONGINT(cpuType)+REFFILE);
     IF ob=NIL THEN
       (*
        * The xxx.ref file doesn't exist, so let's try to find a
        * xxx.sym file. As the name of library modules is the library
        * name, and not the module name, we must deduce the module name.
        * We assume that it is the module name with ".library" appended
        * to it, so we chop it off if we find it.
        *)
       mName:=modname;
       IF ComparePart(mName, Length(mName)-8, 8, ".library", TRUE)=0 THEN
        Delete(mName, Length(mName)-8,8)
       END;
       GetFileName(fName, symFile, mName, FALSE);
       InRef(fName, ob, po, REFFILE) (* Dies ist sym, also keine CPU! *)
     END;
     mObj:=ob; posInfo:=po; (* put them in loader structure *)
      (*
       * mObj must be #NIL to say: We already tried to read the ref-File
       *)
     IF mObj=NIL THEN mObj:=spezNIL END
    END
   END
  END;
  mod.obj:=ob; mod.str:=NIL
 END GetModuleItem;

PROCEDURE GetProcedureItem(mod:Item; pc:INTEGER; VAR proc:Item);
(* Finds the procedure in the given module to which the pc belongs. *)
 VAR proc0: ObjPtr;

 PROCEDURE FindProcedure(obj: ObjPtr; pc:INTEGER);
  BEGIN
   (*
    * Visit all objects.
    *)
   WHILE obj#NIL DO
    WITH obj^ DO
     IF class=Proc THEN
        (*
         * It is a procedure, so look if the pc is contained in it.
         * BTW I don't yet understand, why this is so complicated to do ?
         *)
      IF (procAdr<=pc) & (pc<procAdr+procSize) &
         ((proc0^.class=Proc) & (procSize<proc0^.procSize) OR
         (proc0^.class=Module)) THEN
       proc0:=obj
      END;
      FindProcedure(firstLocal,pc)
     ELSIF class=Module THEN
       (*
        * We are in a local module. Let's scan its scope too, to find the pc.
        *)
      FindProcedure(firstObj,pc)
     END
    END;
    obj:=obj^.next;
   END
  END FindProcedure;

 BEGIN
(* BreakPoint(ADR("FindProcedureItem"));*)
  proc0:=mod.obj; FindProcedure(proc0,pc); proc.obj:=proc0; proc.str:=NIL;
 END GetProcedureItem;

PROCEDURE GetItemInfo(item: Item; VAR info: ItemInfo);
(* Copy the relevant information in item into info *)

 BEGIN
  WITH item DO
   WITH info DO
     (*
      * First initialize all fields to default values.
      *)
    nameSpelling:=''; typeSpelling:=''; adr:=0; ind:=FALSE;
    size:=0; sign:=FALSE; form:=Undef;
    (* 3.10.90/bp auch mode und dyn mssen gesetzt werden!*)
    mode:=normVar;
    dyn:=FALSE;
    IF obj#NIL THEN
      (*
       * This is an object. Get its name into nameSpelling.
       *)
     ExtractName(obj^.name,nameSpelling);
     CASE obj^.class OF
     | Const: (* no more info needed *)
     | Var:
      str:=obj^.typ; adr:=obj^.vadr;
(*
 * 29.3.89/ms
 *	Dynamische Arrays sind immer indirekt
 *)
      ind:=obj^.varpar OR ((str^.form=Array) & (str^.dyn));
      mode:=obj^.vmode;
      IF (mode=farIniVar)OR(mode=normIniVar) THEN
        INC(adr,ibase-dbase);
      END;
     | Field: str:=obj^.typ; adr:=obj^.offset; ind:=FALSE
     | Proc: typeSpelling:=procString; form:=Prc
     | Module: typeSpelling:='MODULE'; form:=Mod
     END
    END;
    IF str#NIL THEN
    (*
     * This item has a type. Copy its name into typeSpelling.
     *)
     ExtractName(str^.strobj^.name,typeSpelling);
     form:=str^.form; size:=str^.size; sign:=str^.sign;
     CASE form OF
     | Enum: nofConst:=str^.NofConst;
     | Range: min:=str^.min; max:=str^.max;
     | Array: dyn:=str^.dyn
     ELSE
     END;
     IF obj#NIL THEN str:=NIL END
    END
   END
  END
 END GetItemInfo;

PROCEDURE GetBrotherItem(VAR item:Item; n:LONGINT);
 VAR
  obj: ObjPtr;
  typ: StrPtr;
 BEGIN
  obj:=item.obj;
  IF (obj#NIL) & (obj^.class=Const) & (obj^.typ^.form=Enum) THEN
     (*
      * Get the n-th identifier of this enumeration type.
      *)
   typ:=obj^.typ;
   WHILE
    (obj#NIL) & ((obj^.class#Const) OR (obj^.typ#typ) OR (obj^.val#n))
   DO
    obj:=obj^.next
   END
  ELSE
    (*
     * Get the n-th useful object (Var,Field or Module) of this scope.
     *)
   LOOP
    WHILE
     (obj#NIL) & (obj^.class#Var) & (obj^.class#Field) & (obj^.class#Module)
    DO
     obj:=obj^.next
    END;
    IF (obj=NIL) OR (n=0) THEN EXIT END;
    obj:=obj^.next; DEC(n)
   END
  END;
  item.obj:=obj
 END GetBrotherItem;

PROCEDURE GetSonItem(VAR item: Item; n:LONGINT);
 VAR
  sign:BOOLEAN;
 BEGIN
  WITH item DO
   IF obj#NIL THEN
    CASE obj^.class OF
    | Var, Field: str:=obj^.typ; obj:=NIL; (* Get the variables type *)
    | Proc: str:=NIL; obj:=obj^.firstLocal; (* Get the first local object *)
    | Module: str:=NIL; obj:=obj^.firstObj; (* Get the first local object *)
    ELSE
     str:=NIL; obj:=NIL;
    END;
      (*
       * If the father item was a procedure or module then adjust the object
       * pointer so that it points to the first useful object (VAR, Field
       * or Module) in this scope.
       *)
    WHILE
     (obj#NIL) & (obj^.class#Var) & (obj^.class#Field) & (obj^.class#Module)
    DO
     obj:=obj^.next
    END
   END;
     (*
      * If the father object was a variable or field, and its type is a
      *
      * - Enum then get the first constant of this enumeration type.
      * - Range then get its base type.
      * - Pointer then get its base type.
      * - Array then get its index type if n=1 and its element type if n=0.
      * - Record then get ist first field.
      * - Set then get its base type
      *)
   IF str#NIL THEN
    CASE str^.form OF
    | Enum: obj:=str^.firstConst; str:=NIL
    | Range:
     obj:=NIL; (* Keep sign of Range as sign of base type. *)
     sign:=str^.sign; str:=str^.RBaseTyp; str^.sign:=sign
    | BPointer,Pointer: obj:=NIL; str:=str^.PBaseTyp
    | Array:
     obj:=NIL; IF n=0 THEN str:=str^.ElemTyp ELSE str:=str^.IndexTyp END
    | Record: obj:=str^.firstFld; str:=NIL
    | Set: obj:=NIL; str:=str^.SBaseTyp
    ELSE
     obj:=NIL; str:=NIL
    END
   END
  END (* WITH *)
 END GetSonItem;

PROCEDURE EmptyItem(item:Item):BOOLEAN;
 BEGIN
  RETURN (item.obj=NIL) & (item.str=NIL)
 END EmptyItem;

PROCEDURE NumberOfSons(item:Item):LONGINT;
 VAR n:LONGINT;
 BEGIN
  GetSonItem(item,0); n:=0;
  WHILE ~EmptyItem(item) DO GetBrotherItem(item,1); INC(n) END;
  RETURN n
 END NumberOfSons;

PROCEDURE FindType(VAR i: Item; VAR tName: ARRAY OF CHAR);
 (*
   i is a non empty module item, look for a type with tName in
   its scope and return the pointer to the type in i.str!!
 *)
 VAR o: ObjPtr;
 BEGIN
  o:=i.obj^.firstObj; i.str:=NIL;
  LOOP
   IF o=NIL THEN EXIT END;
   IF (o^.class=Typ) &
      (ComparePart(o^.name^, first, HIGH(tName), tName, TRUE)=0) THEN
     i.str:=o^.typ; EXIT
   END;
   o:=o^.next
  END
 END FindType;

PROCEDURE ChangeType(i: Item; newS: StrPtr);
 (* 'i' must be a non empty item *)
 BEGIN
  IF i.obj#NIL THEN (* change type of this object *)
   i.obj^.typ:=newS
  ELSE
   CASE i.str^.form OF
   | Array: i.str^.ElemTyp:=newS
   | Pointer, BPointer: i.str^.PBaseTyp:=newS
   ELSE
    HALT
   END
  END
 END ChangeType;

(*-------- file stuff -----------*)

CONST
 maxLinePos=500; (* von 100 auf 500 erhht /bp *)
VAR
 src: RECORD
  modNo: INTEGER;
  impl: BOOLEAN;
  name: ARRAY [0..fileNameLen-1] OF CHAR;
  f: FileSystem.File;
  lines: INTEGER;
  step: INTEGER;
  pos: ARRAY [0..maxLinePos-1] OF LONGINT
 END;

PROCEDURE OpenSource(modNo: INTEGER; mod: BOOLEAN);
VAR
  ch: CHAR;
  ft: FileType;
  i, j:INTEGER;
BEGIN
  (* do only something, if something has changed!! *)
  IF (src.modNo=modNo) AND (src.impl=mod) THEN RETURN END;
  src.modNo:=modNo; src.impl:=mod;
   (*
    * If there is a currently open source file then close it.
    *)
  IF srcPos#illSourcePos THEN Close(src.f) END;
  IF mod THEN ft:=modFile ELSE ft:=defFile END;
  GetFileName(src.name, ft, modInfoList.contents[modNo].l^.modname, FALSE);
   (*
    * Attempt to open the file.
    *)
  Lookup(src.f, src.name, 1024, FALSE);
   (*
    * Set srcPos according to whether the file was opened or not.
    *)
  srcPos:=illSourcePos;
  IF src.f.res=done THEN

    srcPos:=0; src.lines:=0; src.step:=2; (* /8/2/  ms *)
    j:=src.step;
(*
 * 27.12.88/ms Hier muss die Position 0 eingetragen werden!
 *)
    src.pos[0]:=0; i:=1;

    LOOP
     ReadChar(src.f,ch);
     IF src.f.eof OR (src.f.res#done) THEN  EXIT  END;
     INC(srcPos);
     IF ch=eol THEN
      INC(src.lines); DEC(j);
      IF j=0 THEN
       IF i=maxLinePos THEN
        src.step:=src.step*2; j:=2;
        FOR i:=1 TO (maxLinePos DIV 2)-1 DO
         src.pos[i]:=src.pos[j]; INC(j,2)
        END;
        FOR i:=(maxLinePos DIV 2) TO maxLinePos-1 DO
         src.pos[i]:=0
        END;
        i:=maxLinePos DIV 2
       END;
       src.pos[i]:=srcPos;
       j:=src.step;
       INC(i)
      END (* j=0 *)
     END (* ch=eol *)
    END; (* LOOP *)

    SetPos(src.f, 0); srcPos:=0
  END (* res=done *)
(*   WriteString("SourceLines"); WriteInt(sourceLines,10); WriteLn; *)
(*   WriteString("lineStep"); WriteInt(lineStep,10); WriteLn; *)
 END OpenSource;

PROCEDURE SourceLength(): LONGINT;
 BEGIN
  RETURN src.lines;
 END SourceLength;

PROCEDURE ReadSourceChar(VAR ch: CHAR);
 BEGIN
  ReadChar(src.f, ch);
  IF src.f.res=done THEN INC(srcPos) ELSE ch:=0C END
 END ReadSourceChar;

PROCEDURE GotoLine(line:INTEGER);
 VAR
  ch:CHAR;
  srcLine:INTEGER;
 BEGIN
  srcPos:=src.pos[line DIV src.step];
  srcLine:=src.step*(line DIV src.step);
  SetPos(src.f, srcPos);
  LOOP
   IF srcLine=line THEN EXIT; END;
   ReadChar(src.f, ch);
   IF src.f.eof OR (src.f.res#done) THEN EXIT END; (*Problem with FileSystem?*)
   IF ch=eol THEN INC(srcLine); END;
   INC(srcPos)
  END;
 END GotoLine;

PROCEDURE FindLine(pos:LONGINT):INTEGER;
 VAR
  ch:CHAR;
  srcLine,last:INTEGER;
 BEGIN
  srcLine:=0; last:=src.lines DIV src.step;
  WHILE (srcLine<last) & (src.pos[srcLine]<pos) DO
   INC(srcLine);
  END;
  IF srcLine>0 THEN DEC(srcLine); END;
  srcPos:=src.pos[srcLine];
  srcLine:=src.step*srcLine;
  SetPos(src.f, srcPos);
  LOOP
   IF srcPos=pos THEN EXIT; END;
   ReadChar(src.f, ch);
   IF src.f.eof OR (src.f.res#done) THEN EXIT END;
   IF ch=eol THEN
    INC(srcLine)
   END;
   INC(srcPos)
  END;
  RETURN srcLine
 END FindLine;


(*-------- procedures for init phase -----------*)
(*$ CopyDyn:=FALSE *)
PROCEDURE EnterObject(VAR obj: ObjPtr; name: ARRAY OF CHAR);
 VAR
  i: INTEGER;
  id: IdPtr;
 BEGIN
  GetMem(obj, SIZE(Object)); GetMem(id, HIGH(name)+2);
  i:=0; WHILE i<=HIGH(name) DO id^[i]:=name[i]; INC(i) END;
  id^[i]:=0C;
  obj^.name:=id;
 END EnterObject;

(*$ CopyDyn:=FALSE *)
PROCEDURE EnterTyp(VAR str:StrPtr; name:ARRAY OF CHAR;
                   f:StrForm; sz:INTEGER; keepName: BOOLEAN);
 VAR
  i: INTEGER;
  id: IdPtr;
 BEGIN
  GetMem(str, SIZE(Structure));
  WITH str^ DO
   GetMem(strobj, SIZE(Object));
   form:=f; size:=sz; sign:=FALSE; named:=keepName; PBaseTyp:=NIL;
   GetMem(id, HIGH(name)+2);
   i:=0; WHILE i<=HIGH(name) DO id^[i]:=name[i]; INC(i) END;
   id^[i]:=0C;
   strobj^.name:=id
  END
 END EnterTyp;

(*$ CopyDyn:=FALSE *)
PROCEDURE EnterNumTyp(VAR str:StrPtr; name:ARRAY OF CHAR; wid:INTEGER;
                      sgn:BOOLEAN; lo,hi:LONGINT; keepName: BOOLEAN);
 VAR
  i: INTEGER;
  id: IdPtr;
 BEGIN
  GetMem(str, SIZE(Structure));
  WITH str^ DO
   GetMem(strobj, SIZE(Object));
   form:=Range;
   CASE wid OF
   | byte: size:=1;
   | word: size:=2;
   | long: size:=4;
   END;
   RBaseTyp:=uinttyp; min:=lo; max:=hi; sign:=sgn; named:=keepName;
   GetMem(id, HIGH(name)+2);
   i:=0; WHILE i<=HIGH(name) DO id^[i]:=name[i]; INC(i) END;
   id^[i]:=0C;
   strobj^.name:=id
  END
 END EnterNumTyp;

VAR inited:BOOLEAN;

PROCEDURE InitM2CD;
VAR
 i: INTEGER;
BEGIN
(*-jr
 WriteString('<m2cd');
*)
 IF inited THEN RETURN END;
 inited:=TRUE;
 src.modNo:=0;
 srcPos:=illSourcePos;
 ReadPathTable(pathFileName);
 EnterTyp(uinttyp, "INTBASE", UInt,   1, FALSE);
 EnterTyp(booltyp, "BOOLEAN", Bool,   1, TRUE); booltyp^.sign:=TRUE;
 EnterTyp(chartyp, "CHAR",    Char,   1, TRUE);
 EnterTyp(realtyp, "REAL",    Real,   4, TRUE);
 EnterTyp(proctyp, "PROC",    ProcTyp,4, TRUE);
 EnterTyp(lrealtyp,"LONGREAL",LReal,  8, TRUE);
 EnterTyp(urealtyp,"UREAL",   UReal,  8, TRUE);
 EnterTyp(ssettyp, "SHORTSET",Set,    1, TRUE);
 EnterTyp(bsettyp, "BITSET",  Set,    2, TRUE);
 EnterTyp(lsettyp, "LONGSET", Set,    4, TRUE);
 EnterTyp(bytetyp, "BYTE",    Undef,  1, TRUE);
 EnterTyp(wordtyp, "WORD",    Undef,  2, TRUE);
 EnterTyp(ffptyp,  "FFP",     FFP,    4, TRUE);
 EnterTyp(stringtyp,"STRING", String, 1, FALSE);
 EnterNumTyp(sbasetyp,"SBASE",byte,FALSE,0,31,FALSE);
 ssettyp^.SBaseTyp:=sbasetyp;
 bsettyp^.SBaseTyp:=sbasetyp;
 lsettyp^.SBaseTyp:=sbasetyp;
 EnterNumTyp(numtyp[byte,TRUE], "SHORTINT", byte,TRUE, minSInt, maxSInt, TRUE);
 EnterNumTyp(numtyp[byte,FALSE],"SHORTCARD",byte,FALSE,minSCard,maxSCard,TRUE);
 EnterNumTyp(numtyp[word,TRUE], "INTEGER",  word,TRUE, minInt,  maxInt,  TRUE);
 EnterNumTyp(numtyp[word,FALSE],"CARDINAL", word,FALSE,minCard, maxCard, TRUE);
 EnterNumTyp(numtyp[long,TRUE], "LONGINT",  long,TRUE, minLInt, maxLInt, TRUE);
 EnterNumTyp(numtyp[long,FALSE],"LONGCARD", long,FALSE,minLCard,
                                                 CAST(LONGINT, maxLCard),TRUE);
 EnterTyp(addrtyp, "ADDRESS",  Undef, 4, TRUE);
 EnterTyp(bptrtyp, "BPTR",     Undef, 4, TRUE);

 EnterObject(enuObj, 'ENUMERATION'); EnterObject(ptrObj, 'POINTER'  );
 EnterObject(setObj, 'SET'        ); EnterObject(arrObj, 'ARRAY'    );
 EnterObject(recObj, 'RECORD'     ); EnterObject(ptyObj, procString );
 EnterObject(opaObj, 'OPAQUE'     ); EnterObject(bptrObj,'BPOINTER' );

(*-jr
 WriteString('m2cd>')
*)
END InitM2CD;

PROCEDURE ExitM2CD;
BEGIN
  (* mu leider sein, da das Programm evtl. schon beendet ist! *)
  (* 5.1.91/bp Dies habe ich hier herausgenommen, damit es spter bei
     single-step schneller geht
   *)
  (*
  IF srcPos#illSourcePos THEN Close(src.f); srcPos:=illSourcePos END;
  ForgetPathTable;
  *)
END ExitM2CD;

PROCEDURE ForgetM2CD;
VAR i:INTEGER;
BEGIN
  IF inited THEN
    inited:=FALSE;
    IF srcPos#illSourcePos THEN Close(src.f); srcPos:=illSourcePos END;
    ForgetPathTable;
    FOR i:=0 TO modInfoList.length-1 DO
      WITH modInfoList.contents[i] DO
        IF l#NIL THEN (* Daten wiederherstellen! *)
          l^.mObj:=NIL;
          l^.posInfo:=NIL;
          l:=NIL;
        END;
      END;
    END;
  END;
  ForgetMem;
END ForgetM2CD;


(* 5.1.91/bp Die mObj und posInfo mssen im Programm wieder gelscht werden,
   falls es resident geladen wurde, gibt es ansonsten groen rger!
   Andere Lsung wre, die Felder in modInfoList abzulegen.
 *)
BEGIN
CLOSE
  ForgetM2CD;
END m2cd.mod
