MODULE testTerminator;

FROM Terminator IMPORT
 newReference,Reference,UserData,Add,Remove,Use;

IMPORT
 Heap,t:Terminal;

TYPE
 Title=ARRAY [0..39] OF CHAR;
 Rec=RECORD
  title:Title;
  from,to:INTEGER;
 END;
 Ptr=POINTER TO Rec;

PROCEDURE NewRec(t:Title; from,to:INTEGER):Ptr;
VAR
 p:Ptr;
BEGIN
 Heap.Allocate(p,SIZE(Rec));
 p^.title:=t;
 p^.from:=from;
 p^.to:=to;
 RETURN p;
END NewRec;

PROCEDURE Clean(ud:UserData);
VAR
 i:INTEGER;
 p:Ptr;
BEGIN
 p:=ud;
 FOR i:=p^.from TO p^.to DO
  t.FormatS(" %s: ",p^.title);
  t.FormatNr("%ld\n",i);
 END;
 Heap.Deallocate(p);
END Clean;

PROCEDURE Clean2(ud:UserData);
BEGIN
 t.WriteString(" This is Clean2\n");
END Clean2;

PROCEDURE P;

 PROCEDURE Q;
 VAR
  dummy,ref,ref2:Reference;
 BEGIN
  dummy:=Add(Clean,NewRec("Clean what Q created",40,41),newReference);
  ref:=Add(Clean,NewRec("This clean was deleted",90,90),newReference);
  ref:=Add(Clean,NewRec("This clean was deleted",99,99),ref);
  ref2:=Add(Clean2,NIL,newReference);
  Remove(ref);
  t.WriteString("Now you should see 'This is Clean2'\n");
  Use(ref2);
 END Q;

VAR
 dummy,ref:Reference;
BEGIN
 ref:=Add(Clean,NewRec("last P clean",10,10),newReference);
 ref:=Add(Clean,NewRec("first P clean",20,20),ref);
 Q;
 dummy:=Add(Clean,NewRec("Clean what P created",30,31),newReference);
 t.WriteString(
  "Now you should see 'first P clean: 20' followed by 'last P clean: 10'\n"
 );
 Use(ref);
END P;

VAR
 dummy:Reference;
 p:Ptr;
BEGIN
(*
 Add the cleanup procedure executed as last.
*)
 dummy:=Add(Clean,NewRec("Add first execute last",1,3),newReference);
 P;
 t.WriteString("Now you should see 'Clean what Q created' from 40 to 41\n");
 t.WriteString("followed by 'Clean what P created' from 30 to 31\n");
 t.WriteString("followed by 'Add first execute last' from 1 to 3\n");
 t.WriteString("You shouldn't see any with text 'This clean was deleted'.\n");
END testTerminator.
