(*
 * 20.11.91/bp
 *	Die Angabe WINDOW= in Tooltypes darf nicht noch erweitert
 *	werden, sonst hat SCREENxxx keine Wirkung!??
 *	con:0/100/600/200/name/CLOSE/AUTO/SCREENTURBOTEXT geht
 *	con:0/100/600/200/name/CLOSE/AUTO/SCREENTURBOTEXT/x geht nicht!
 * 26.1.91/bp
 *	WriteString ruft bei \n implizit nun Flush auf, genau wie
 *	Formatxx
 * 13.11.90/bp
 *	Neue Prozedur Flush (statt Write(0C))
 * 27.8.90/bp
 *	Dies File enthlt die gepufferte Terminal-Variante!
 *	m2c +oEnglisch terminal --> englische Version
 *
 *
 * 27.3.89/ms
 *	Deutsche Version.
 * 15.2.89/ms
 *	Die Prozedur WriteString war falsch. Die Annahme, dass der Aufrufende
 *	fr gengend Stackplatz testet war nicht korrekt. Der Aufrufende stellt
 *	sicher, dass die bergebenen Daten Platz haben. In diesem Fall muss
 *	aber WriteString testen ob eine Kopie des Strings Platz hat. Die
 *	neue Lsung eliminiert dieses Problem.
 * 12.1.89/ms
 *	Das definierte Ziel dieses Moduls ist hchste Kompaktheit und die
 *	Mglichkeit ohne globale Variablen auszukommen. Um das erste Ziel
 *	zu erreichen steht eigentlich nur eine Implementation in Assembler
 *	zur Wahl. Fr das zweite Ziel muss eine Lsung basierend auf den
 *	Daten aus der Prozess- bzw. Task-Struktur gefunden werden.
 *
 *	Ein erster Ansatz ist die Verwedung der cis/cos Felder der Prozess-
 *	Struktur. Dies wurde in m2make als Hack bereits verwendet. In der
 *	CLI Umgebung muss ohnehin nichts spezielles gemacht werden. In der
 *	Workbench Umgebung sind sowohl cis und cos als auch der windowPtr
 *	unbenutzt.
 *)

(*$ LargeVars:=FALSE LongAlign:=FALSE RangeChk:=FALSE OverflowChk:=FALSE
    StackChk:=FALSE StackParms:=FALSE Volatile:=FALSE
*)
(*$ DEFINE English:=FALSE *)

IMPLEMENTATION MODULE Terminal;

IMPORT	ASCII,DosD,DosL,ExecD,Arts;
FROM SYSTEM	IMPORT	ADDRESS,ADR,CAST,ASSEMBLE;
FROM Arts	IMPORT	startupMsg,wbStarted,Error,programName,thisTask;
FROM ExecL	IMPORT	RawDoFmt, OpenLibrary, CloseLibrary;
FROM WorkbenchD	IMPORT	WBStartup, WBArg, WBStartupPtr,DiskObjectPtr;

CONST
 bufSize=128;
 defaultSpecs="CON:000/050/640/150/";
 iconName='icon.library';
 toolTypeEntry="WINDOW";
(*$ IF English *)
 errStr= "Terminal: Open() -Error";
(*$ ELSE *)
 errStr= "Terminal: Open() -Fehler";
(*$ ENDIF *)
 endMsg="\n<< RETURN >>";
 endLength=SIZE(endMsg);


TYPE
  CHARPtr = POINTER TO CHAR;
  File = RECORD
    b: ARRAY[0..bufSize-1] OF CHAR;
    ptr, (* wohin das nchste Byte kommt *)
    end: CHARPtr; (* hinter Ende Buffer *)
  END;

VAR
 ch:CHAR;
 input,output: DosD.FileHandlePtr;
 outFile: File;


(*$ EntryExitCode:=FALSE *)
PROCEDURE Flush;
BEGIN
  ASSEMBLE(
 (* len:=outFile.ptr-outFile.b *)
	MOVEM.L	D2/D3/A6,-(A7)
	MOVE.L	outFile.ptr(A4),D3
	LEA	outFile.b(A4),A0
	SUB.L	A0,D3 (* len *)
	BLE.S	BuffEmpty
	MOVE.L	A0,D2 (* adr *)
 (* len>0, also len Bytes schreiben *)
	MOVE.L	A0,outFile.ptr(A4) (* bufferptr auf Anfang *)
	MOVE.L	output(A4),D1
	BEQ.S	BuffEmpty	(* Fall ungltiges ToolType!! *)
	MOVEA.L	DosL(A4),A6
	JSR	DosL.Write(A6)
  BuffEmpty:
	MOVEM.L	(A7)+,D2/D3/A6
  	RTS
  END);
END Flush;


(*$ EntryExitCode:=FALSE *)
PROCEDURE Write(ch:CHAR);
BEGIN
  ASSEMBLE(
	MOVE.L	outFile.ptr(A4),A1
	CMPA.L	outFile.end(A4),A1
	BLT.S   NotFull		(* ptr<end: geht noch was rein *)
	BSR.S	Flush
  NotFull:
	MOVE.L	outFile.ptr(A4),A1  (* evtl. von Flush verndert! *)
	MOVE.B	4(A7),D0
	MOVE.B  D0,(A1)+
	MOVE.L  A1,outFile.ptr(A4)
	CMPI.B	#ASCII.lf,D0
	BNE.S	WriteNo
	BSR.S	Flush
  WriteNo:
(*$ IF m68010 *)
	RTD	#2
(*$ ELSE *)
	MOVE.L	(A7)+,A0
	ADDQ.L	#2,A7
	JMP	(A0)
(*$ ENDIF *)
  	END
	);
END Write;

PROCEDURE WriteLn; (*$ EntryExitCode:=FALSE *)
BEGIN
 ASSEMBLE(
	MOVE.B	#ASCII.lf,-(A7)
	BSR.S	Write
	RTS
 END);
END WriteLn;

PROCEDURE BusyRead(VAR ch: CHAR);
BEGIN
 IF DosL.IsInteractive(input) & ~DosL.WaitForChar(input,100) THEN
  ch:=ASCII.nul
 ELSE
  Read(ch)
 END
END BusyRead;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Read(VAR ch: CHAR);
BEGIN
 ASSEMBLE(
 	BSR	Flush	(* jajaja,wichtig!! *)
 	MOVEM.L	D2/D3/A2/A6,-(A7)
	MOVE.L	4+4*4(A7),A2	(* addr ch *)
	MOVE.L	input(A4),D1
	BEQ.S	ok		(* Falls ungltiges Tooltype! *)
	MOVE.L	A2,D2
	MOVEQ	#1,D3
	MOVE.L	DosL(A4),A6
	JSR	DosL.Read(A6)
	SUBQ.L	#1,D0
	BEQ.S	ok (* war 1 *)
	MOVE.B	#ASCII.eof,(A2)	(* mu A2 bleiben wg. ReadLn! *)
  ok: 	MOVEM.L	(A7)+,D2/D3/A2/A6
(*$ IF m68010 *)
	RTD	#4
(*$ ELSE *)
	MOVE.L	(A7)+,A0
  	ADDQ.L	#4,A7
  	JMP	(A0)
(*$ ENDIF *)
  END);
END Read;

(* Groer Unterschied: Nun am Ende IMMER 0C *)
PROCEDURE ReadLn(VAR st: ARRAY OF CHAR; VAR len: INTEGER);
BEGIN
 ASSEMBLE( (* len=d6, cp=a2 *)
	MOVEQ	#0,D6
	MOVE.L	st(A5),A2
  Loop:	PEA	(A2)
	BSR.S	Read
	MOVE.B	(A2),D0
	CMPI.B	#ASCII.eol,D0
	BEQ.S	Exit
	CMPI.B	#ASCII.eof,D0
	BEQ.S	Exit
	CMP.L	st+4(A5),D6
	BGE.S	Loop
	ADDQ.L	#1,A2
	ADDQ.L	#1,D6
	BRA.S	Loop
  Exit:	CLR.B	(A2) (* IMMER! *)
	MOVE.L	len(A5),A1
	MOVE.W	D6,(A1)
  END);
(*
 len:=0; cp:=ADR(st);
 LOOP
  Read(ch);
  IF (ch=ASCII.eol) OR (ch=ASCII.eof) THEN
   EXIT
  ELSIF len<=HIGH(st) THEN
   cp^:=ch; INC(len); INC(cp);
  END
 END;
 IF len<=HIGH(st) THEN cp^:=ASCII.nul END
*)
END ReadLn;


PROCEDURE PutCh; (*$ EntryExitCode:=FALSE *)
(* Mu auch 0C unterdrcken!! *)
BEGIN
  ASSEMBLE(
  	TST.B	D0
  	BEQ.S	nixMehr
  	MOVE.L	A4,-(A7)
  	MOVE.L	A3,A4	(* LinkerDB, WICHTIG!! Als Para in A3! *)
  	MOVE.B	D0,-(A7)
  	BSR	Write
  	MOVE.L	(A7)+,A4
   nixMehr:
  	RTS
  END);
END PutCh;

PROCEDURE WriteString(string: ARRAY OF CHAR); (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVEM.L	D2/A2,-(A7)
	MOVE.L	4+8(A7),A2 (* A2=Str *)
	MOVE.L	8+8(A7),D2 (* High=max-1 *)
    Lp:	MOVE.B	(A2)+,D0
	BEQ.S	rdy
	MOVE.B	D0,-(A7)
	BSR	Write
	DBRA	D2,Lp
    rdy:MOVEM.L	(A7)+,D2/A2
(*$ IF m68010 *)
	RTD	#8
(*$ ELSE *)
	MOVE.L	(A7)+,A0
	ADDQ.L	#8,A7
	JMP	(A0)
(*$ ENDIF *)
	END);
END WriteString;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Format(str:ARRAY OF CHAR; dats:ADDRESS);
BEGIN
  ASSEMBLE(
	LEA	4(A7),A0
	MOVEM.L	A2/A3/A6,-(A7)
 	MOVE.L	(A0)+,A1 (* dats *)
 	MOVE.L	(A0)+,A0 (* adr str *)
	MOVE.L	ExecD.execBase,A6 (* ist krzer!! *)
	MOVE.L	A4,A3		(* !!! einzige Mgl., A4 zu halten!! *)
	LEA	PutCh(PC),A2
	(* a3 hier egal, hlt retaddr *)
	JSR	RawDoFmt(A6)
	MOVEM.L	(A7)+,A2/A3/A6
(*$ IF m68010 *)
	RTD	#12
(*$ ELSE *)
	MOVE.L	(A7)+,A0
	LEA	12(A7),A7 (* high steht noch da *)
	JMP	(A0)
(*$ ENDIF *)
  END);
END Format;

(* z.B. FormatS('- %s\n',inName) Spart einmal knstliches ADR()! *)
(*$ EntryExitCode:=FALSE *)
PROCEDURE FormatS(str:ARRAY OF CHAR; VAR innerStr:ARRAY OF CHAR);
BEGIN
  ASSEMBLE(
	MOVEM.L	A2/A3/A6,-(A7)
 	MOVE.L	A4,A3	(* LinkerDB nach A3 fr PutCh!!!!! *)
 	LEA	4+12(A7),A1
 	MOVE.L	8+4+12(A7),A0
	MOVE.L	ExecD.execBase,A6 (* ist krzer!! *)
	LEA	PutCh(PC),A2
	(* a3 hier egal, hlt retaddr *)
	JSR	RawDoFmt(A6)
	MOVEM.L	(A7)+,A2/A3/A6
(*$ IF m68010 *)
	RTD	#16
(*$ ELSE *)
	MOVEA.L	(A7)+,A0
	LEA.L	16(A7),A7
	JMP	(A0)
(*$ ENDIF *)
  END);
END FormatS;

(*$ EntryExitCode:=FALSE *)
PROCEDURE FormatNr(str:ARRAY OF CHAR; nr:LONGINT);
BEGIN
  ASSEMBLE(
	MOVEM.L	A2/A3/A6,-(A7)
	MOVE.L	A4,A3	(* LinkerDB! *)
	LEA	4+12(A7),A1
	MOVE.L	4+4+12(A7),A0
	MOVE.L	ExecD.execBase,A6 (* ist krzer!! *)
	LEA	PutCh(PC),A2
	(* a3 hier LinkerDB!! *)
	JSR	RawDoFmt(A6)
	MOVEM.L	(A7)+,A2/A3/A6
(*$ IF m68010 *)
	RTD	#12
(*$ ELSE *)
	MOVEA.L	(A7)+,A0
	LEA.L	12(A7),A7
	JMP	(A0)
(*$ ENDIF *)
  END);
END FormatNr;

(*$ EntryExitCode:=FALSE *) (* nur fr doppeltes RawDoFmt bei WriteInt/Hex! *)
PROCEDURE RFproc(ch{0}:CHAR; str{11}:ADDRESS);
BEGIN
  ASSEMBLE(
	MOVE.B	D0,(A3)+
	RTS
  END);
END RFproc;

PROCEDURE WriteInt(x:LONGINT; n:INTEGER);
VAR s:ARRAY[0..9] OF CHAR;
BEGIN
  RawDoFmt(ADR('%%%dld'),ADR(n),ADR(RFproc),ADR(s));
  Format(s,ADR(x));
END WriteInt;

PROCEDURE WriteHex(x:LONGINT; n:INTEGER);
VAR s:ARRAY[0..11] OF CHAR;
BEGIN
  IF n>=0 THEN (* RawDoFmt spinnt etwas bei neg. Zahlen und fhr. 0 *)
    RawDoFmt(ADR('%%0%dlx'),ADR(n),ADR(RFproc),ADR(s));
  ELSE
    n:=-n;
    RawDoFmt(ADR('%%-%dlx'),ADR(n),ADR(RFproc),ADR(s));
  END;
  Format(s,ADR(x));
END WriteHex;


PROCEDURE WBCleanup; (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVEM.L	A6,-(A7)
	TST.L	output(A4)
	BEQ.S	noOut
	BSR	Flush
	TST.B	waitCloseGadget(A4)
	BEQ.S	noWait

	MOVEQ	#endLength-1,D0
	MOVE.L	D0,-(A7)
	PEA	endMsg(PC)
	BSR	WriteString
	PEA	ch(A4)
	BSR	Read
noWait:	LEA	output(A4),A0
	MOVE.L	(A0),D1
	CLR.L	(A0)
	MOVEA.L	DosL(A4),A6
	JSR	DosL.Close(A6)
noOut:	MOVE.L	(A7)+,A6
	RTS
  END);
END WBCleanup;

(* icon.library MUSS nicht da sein! *)
PROCEDURE GetDiskObject(base{16B}:ADDRESS;
			name{8}:ADDRESS):DiskObjectPtr; CODE -78;
PROCEDURE FindToolType(base{16B}:ADDRESS;
		toolTypes{8},
		typeName{9}:ADDRESS):ADDRESS; CODE -96;
PROCEDURE FreeDiskObject(base{16B}:ADDRESS;
		obj{8}:DiskObjectPtr); CODE -90;

PROCEDURE InitTerminal;
CONST maxLen=99;
VAR Name:ARRAY[0..maxLen] OF CHAR; (* reicht IMMER! *)
    diskObject:DiskObjectPtr;
    iconBase:ADDRESS;
    windowSpecs:POINTER TO CHAR;

    (* Packt str und programName nach Name *)
    PROCEDURE MakeName(str{10B}:ADDRESS;conc:BOOLEAN);
    BEGIN
    ASSEMBLE( (* Name =concat(default+arg[0]) *)
	MOVE.L	8(A5),A1 (* lokale Proc! *)
	LEA	Name(A1),A1
      tool:
    	MOVEQ	#maxLen-1,D0
      lp1:
        MOVE.B	(A0)+,(A1)+
	DBEQ	D0,lp1
	BNE.S	rdy
	TST.B	conc(A5)
	BEQ.S	rdy	(* conc=FALSE: kein Concat! *)
	SUBQ.W	#1,A1	(* 0C wieder weg *)
	ADDQ.W	#1,D0
	MOVE.L	programName(A4),A0
      lp2:
        MOVE.B	(A0)+,(A1)+
	DBEQ	D0,lp2
      rdy:
    	CLR.B	(A1)	(* sicher eine 0 am Ende! *)
      END);
    END MakeName;

BEGIN
  ASSEMBLE( (* File-Buffer initialisieren *)
	LEA     outFile.b(A4),A3
	MOVE.L  A3,outFile.ptr(A4)
	LEA	bufSize(A3),A3
	MOVE.L  A3,outFile.end(A4)
  END);
  waitCloseGadget:=TRUE;
  IF wbStarted THEN
    Name[0]:=0C;
    iconBase:=OpenLibrary(ADR(iconName),33);
    IF iconBase#NIL THEN
      diskObject:=GetDiskObject(iconBase,programName);
      IF diskObject#NIL THEN
        WITH diskObject^ DO
          windowSpecs:=FindToolType(iconBase,toolTypes,ADR(toolTypeEntry));
        END;
        IF (windowSpecs#NIL) & (windowSpecs^#ASCII.nul) THEN
          MakeName(windowSpecs,FALSE);
        END;
        FreeDiskObject(iconBase,diskObject)
      END;
      CloseLibrary(iconBase);
    END;
    IF Name[0]=0C THEN
      MakeName(ADR(defaultSpecs),TRUE);
    END;
    output:=DosL.Open(ADR(Name),DosD.oldFile);
    IF output=NIL THEN
      (* Zur Sicherheit, falls in CLOSE noch einer Ausgaben macht! *)
      output:=DosL.Open(ADR('NIL:'),DosD.oldFile);
      Error(ADR(errStr),ADR(Name));
    END;
    ASSEMBLE(
	MOVE.L	output(A4),input(A4)
	MOVE.L	thisTask(A4),A0
	MOVE.L	input(A4),DosD.Process.cis(A0)
	MOVE.L	output(A4),DosD.Process.cos(A0)
(* NEU: consoletask noch setzen *)
	MOVE.L	input(A4),A1
	ADDA.L	A1,A1
	ADDA.L	A1,A1
	MOVE.L	DosD.FileHandle.type(A1),DosD.Process.consoleTask(A0)
    END);
  ELSE
    input:=DosL.Input();
    output:=DosL.Output();
  END;
END InitTerminal;

BEGIN
  InitTerminal;
CLOSE
  IF wbStarted THEN
    WBCleanup
  ELSE
    Flush;
  END;
END Terminal.
