IMPLEMENTATION MODULE Storage;
(*
 * 27.3.89/ms
 *	Deutsche Version.
 * 12.2.89/ms
 *	Konstante 'errorMsg' eingefhrt.
 *)
(*$
   StackChk:=FALSE
   RangeChk:=FALSE
   OverflowChk:=FALSE
   LongAlign:=TRUE
   LargeVars:=FALSE
   NilChk:=FALSE
   Volatile:=FALSE
   StackParms:=FALSE
*)

FROM SYSTEM IMPORT
 ADDRESS,ADR;
IMPORT
 Arts,Heap;

CONST
 errorMsg=
   "Storage: Speichermangel";
(* "Storage: Insufficient Memory"; *)

PROCEDURE ALLOCATE(VAR adr: ADDRESS; size: LONGINT);
BEGIN
 Heap.Allocate(adr,size);
 Arts.Assert(adr#NIL,ADR(errorMsg))
END ALLOCATE;

PROCEDURE DEALLOCATE(VAR adr: ADDRESS; size: LONGINT);
BEGIN
 Heap.Deallocate(adr)
END DEALLOCATE;

PROCEDURE Available(size: LONGINT): BOOLEAN;
BEGIN
 RETURN Heap.Largest(FALSE)>=size
END Available;

END Storage.
