IMPLEMENTATION MODULE MLinkBase;
(*$ LargeVars:=FALSE Volatile:=FALSE StackParms:=FALSE StackChk:=FALSE *)
(*$ DEFINE English:=FALSE *)

FROM SYSTEM	IMPORT	ASSEMBLE, CAST, ADR, ADDRESS, LONGSET, BYTE;
FROM Arts	IMPORT	BreakPoint, Assert, Requester, Terminate;
FROM Heap	IMPORT	AllocMem,Deallocate,Largest;
IMPORT DosD,DosL,ExecL, m2:M2Amiga;

CONST
  bufSize = 2048;
  maxChunk=8000;
  saveMem=20000;

 header=
    "Amiga Modula-2 Linker";
 body=
(*$ IF English *)	"Insufficient Memory";
(*$ ELSE *)	"Nicht gengend Speicher";
(*$ ENDIF *)
 abort=
(*$ IF English *)	" Abort ";
(*$ ELSE *)	" abbrechen ";
(*$ ENDIF *)
 retry=
(*$ IF English *)	" Retry ";
(*$ ELSE *)	" weiter ";
(*$ ENDIF *)


(* Gelschter Speicher ist bei dieser Methode garantiert! *)
TYPE
  StorageNodePtr=POINTER TO StorageNode;
  StorageNode=RECORD
    next: StorageNodePtr;
    ssize,
    free: LONGINT;
    data: LONGINT;
  END;

  CHARPtr = POINTER TO CHAR;
  File = RECORD
    f: DosD.FileHandlePtr;
    b: ARRAY[0..bufSize-1] OF CHAR;
    ptr, (* wohin das nchste Byte kommt *)
    end: CHARPtr; (* hinter Ende Buffer *)
  END;

(*$ LongAlign:=TRUE *)
VAR
  outFile: File;
  globHeap: StorageNodePtr;


(*$ StackChk:=FALSE ReturnChk:=FALSE *)
PROCEDURE FlushBuffer();
BEGIN
  ASSEMBLE(
  	TST.B	SeqOutOk(A4)
  	BEQ.S	FlushRdy (* nicht ok: nix tun *)
 (* len:=outFile.ptr-outFile.b *)
	MOVE.L	outFile.ptr(A4),D3
	LEA	outFile.b(A4),A2
	SUB.L	A2,D3 (* len *)
	BLE.S	BuffEmpty
	MOVE.L	A2,D2 (* adr *)
 (* len>0, also len Bytes schreiben *)
	MOVE.L	A2,outFile.ptr(A4) (* bufferptr auf Anfang *)
	MOVE.L	D3,D6	(* len merken, falls Dos D3 verndert(?) *)
	MOVE.L	outFile.f(A4),D1
	MOVEA.L	DosL(A4),A6
	JSR	DosL.Write(A6)
	CMP.L	D0,D6 (* len=written? *)
	BEQ.S	WrOk
	MOVE.L	outFile.f(A4),D1
	JSR	DosL.Close(A6)
	CLR.B	SeqOutOk(A4) (* FALSE *)
  WrOk:
  BuffEmpty:
  FlushRdy:
  	END
	);
END FlushBuffer;

PROCEDURE CloseSeqOut;
BEGIN
  ASSEMBLE(
	BSR	FlushBuffer
  	TST.B	SeqOutOk(A4)
  	BEQ.S	CloseRdy (* nicht ok: nix tun *)
	MOVE.L  outFile.f(A4),D1
	MOVEA.L DosL(A4),A6
	JSR     DosL.Close(A6)
	CLR.B   SeqOutOk(A4)
  CloseRdy:
	END
	);
END CloseSeqOut;

PROCEDURE OutL(l{4}:LONGINT);
BEGIN
  ASSEMBLE(
	TST.B   SeqOutOk(A4)
	BEQ.S   OutBNo
	MOVE.L  outFile.ptr(A4),D0
	CMP.L   outFile.end(A4),D0
	BLT.S   NotFull		(* ptr<end: geht noch was rein *)
	BSR	FlushBuffer
  NotFull:
  	MOVE.L	outFile.ptr(A4),A1 (* evtl. von Flush verndert! *)
	MOVE.L  D4,(A1)+
	MOVE.L  A1,outFile.ptr(A4)
  OutBNo:
  	END
	);
END OutL;

(* outcount sind nun langworte!!! *)
PROCEDURE OutCount(from{3+8}:ADDRESS; count{7}:CARDINAL);
BEGIN
  ASSEMBLE(
  	TST.W	D7
	BEQ.S   ready (* nichts zu tun???? *)
 (* Versuch: wenn noch genug Platz im Puffer, dann direkt kopieren, sonst
    Bytes einzeln raus *)
	MOVE.L	outFile.ptr(A4),A0
	MOVE.L	outFile.end(A4),D1
	SUB.L	A0,D1 (* end-ptr=Platz *)
	ASR.L	#2,D1 (* /4 = langworte *)
	CMP.W	D7,D1 (* .W, weil hoffentlich gecheckt! *)
	BCS.S	SingleCopy (* Platz < Bytes *)
	SUBQ.W	#1,D7
  Cpy:	MOVE.L	(A3)+,(A0)+
	DBRA	D7,Cpy
	MOVE.L	A0,outFile.ptr(A4)
	BRA.S	ready

  SingleCopy:
	SUBQ.W	#1,D7
  OutWhile:
	MOVE.L	(A3)+,D4
	BSR	OutL
	DBRA	D7,OutWhile
  ready:
	END
	);
END OutCount;

(* ok *)
PROCEDURE OpenSeqOut(VAR filename: ARRAY OF CHAR):BOOLEAN;
BEGIN
  ASSEMBLE(
	LEA     outFile.b(A4),A3
	MOVE.L  A3,outFile.ptr(A4)
	LEA	bufSize(A3),A3
	MOVE.L  A3,outFile.end(A4)
	MOVE.L  filename(A5),D1
	MOVE.L  #DosD.newFile,D2
	MOVEA.L DosL(A4),A6
	JSR     DosL.Open(A6)
	MOVE.L  D0,outFile.f(A4)
	SNE     D1
	MOVEQ	#0,D0
	MOVE.B	D1,D0
	MOVE.B  D1,SeqOutOk(A4)
	END (* Kein rts, da kein $ E - *)
	);
END OpenSeqOut;
(*$ POP StackChk POP ReturnChk *)


PROCEDURE AllocateMemory(VAR a: ADDRESS; min,max: LONGINT): LONGINT;
VAR
 size: LONGINT;
BEGIN
 REPEAT
  LOOP
  (*
   * Only if we can leave at least 20K continuos memory we will
   * allocate the memory. Otherwise we will tell the user, that
   * we can't allocate the memory and offer a possibility to retry.
   *)
   size:=Largest(FALSE)-saveMem;
   IF size>=min THEN
    EXIT
   ELSIF ~Requester(ADR(header),ADR(body),ADR(retry),ADR(abort)) THEN
    Terminate;
   END
  END;
  IF size>max THEN
   size:=max
  END;
  AllocMem(a,size,FALSE)
 UNTIL a#NIL;
 RETURN size;
END AllocateMemory;

PROCEDURE ALLOCATE(VAR adr: ADDRESS; size: LONGINT);
VAR
 temp: StorageNodePtr;
 blockSize,
 maxSize: LONGINT;
BEGIN
 adr:=NIL;
 IF ODD(size) THEN INC(size) END;
 IF (globHeap=NIL) OR (globHeap^.free<size) THEN
  IF size<=maxChunk THEN
   maxSize:=maxChunk
  ELSE
   maxSize:=size;
  END;
  blockSize:=size+SIZE(StorageNode);
  INC(maxSize,SIZE(StorageNode));
  blockSize:=AllocateMemory(temp,blockSize,maxSize);
  WITH temp^ DO
   next:=globHeap;
   data:=CAST(LONGINT,temp)+SIZE(StorageNode);
   free:=blockSize-SIZE(StorageNode);
   ssize:=free;
  END;
  globHeap:=temp;
 END;
 WITH globHeap^ DO
  DEC(free,size);
  adr:=CAST(ADDRESS,data+free);
 END;
END ALLOCATE;

PROCEDURE ForgetMem;
VAR temp{10}: StorageNodePtr;
BEGIN
  WHILE globHeap#NIL DO
    temp:=globHeap^.next;
    Deallocate(globHeap);
    globHeap:=temp
  END;
END ForgetMem;


(*############################################################*)

(*$ CopyDyn:=FALSE *)
(* load file, alloc buffer *)
PROCEDURE GetFile(Name:ARRAY OF CHAR; VAR Addr:ADDRESS;
		  VAR Len:LONGINT; VAR o:m2.ObjFilePtr):FileErrors;
VAR f: DosD.FileHandlePtr; actual:LONGINT;
BEGIN
  IF o#NIL THEN
    Len:=o^.buffLen+3;
    ALLOCATE(Addr,Len);
    ExecL.CopyMem(o^.buffer,Addr,Len); (* linker muss FreeObj() machen! *)
    RETURN noError;
  ELSE
    f:=DosL.Open(ADR(Name),DosD.oldFile);
    IF f # NIL THEN
      actual:=DosL.Seek(f,0,DosD.end);
      Len:=DosL.Seek(f,0,DosD.beginning);
      IF Len<0 THEN
        DosL.Close(f);
        RETURN seekError
      END;
      ALLOCATE(Addr,Len);
      actual:=DosL.Read(f,Addr,Len);
      DosL.Close(f);
      IF (actual=Len) THEN
        RETURN noError;
      ELSE
        RETURN readError
      END;
    ELSE
      RETURN notFound
    END;
  END;
END GetFile;

PROCEDURE InitSer(a:ADDRESS; len:LONGINT);
BEGIN
  MemPtr:=a;
  MemEnd:=CAST(LONGINT,a)+len;
  eof:=CAST(LONGINT,MemPtr)>=MemEnd;
END InitSer;

PROCEDURE SkipBlock(cnt:LONGINT);
CONST
  Corrupt='Corrupt Object File!';
BEGIN
  ASSEMBLE(
	MOVE.L	cnt(A5),D0
	ADD.L	D0,D0
	ADD.L	D0,D0
	ADD.L	D0,MemPtr(A4)
	MOVE.L	MemPtr(A4),D0
	CMP.L	MemEnd(A4),D0
	SGE	eof(A4)
	BLE.S	ok
	ST	-(A7)
	PEA	Corrupt(PC)
	JSR	Assert(PC)
    ok:
  END);
  (*
  INC(MemPtr,cnt*4);
  eof:=CAST(LONGINT,MemPtr)>=MemEnd;
  IF CAST(LONGINT,MemPtr)
  Assert(CAST(LONGINT,MemPtr)<=MemEnd,ADR(Corrupt));
  *)
END SkipBlock;

PROCEDURE GetLong(VAR lc:LONGINT);
BEGIN
  lc:=MemPtr^;
  SkipBlock(1);
END GetLong;

(*############################################################*)

(*$ EntryExitCode:=FALSE *)
PROCEDURE Diff(a{8},b{9}:NameRecPtr):INTEGER;
BEGIN
  ASSEMBLE(
	MOVE.L	(A0),D1 (* lws-1 *)
  lp:	CMPM.L	(A0)+,(A1)+
	DBNE	D1,lp
	BHI.S	gr
	BLO.S	lo
	MOVEQ	#0,D0
	RTS
  gr:	MOVEQ	#1,D0
	RTS
  lo:	MOVEQ	#-1,D0
	RTS
  END);
END Diff;

PROCEDURE ExtractModuleName(n:NameRecPtr; VAR mod:SymName):BOOLEAN;
(* name der Form mmm_ooo: mod wird bis zum 1. "_", also 'mmm' *)
VAR i,max:INTEGER;
BEGIN
  WITH n^ DO
    i:=0;
    max:=lws*4; (*IF max>31 THEN max:=31 END;*)
    WHILE (i<max)&(name[i]#'_') DO (* 0C knnen wir ignorieren! *)
      mod[i]:=name[i];
      INC(i);
    END;
    (* "_" war in der Mitte, nicht vorne! *)
    mod[i]:=0C;
    RETURN (name[i]='_')&(i>0); (* gltiger Name? *)
  END;
END ExtractModuleName;

BEGIN
  (* ist alles 0!
  globHeap:=NIL;
  SeqOutOk:=FALSE;
  *)
CLOSE
  CloseSeqOut;
END MLinkBase.mod
