IMPLEMENTATION MODULE M2FM;
(*
 * 11.3.90/bp
 *	Der groe Optimizer schlgt voll zu.
 * 27.11.89/ms
 *	Anpassungen von Claudio eingetragen
 * 31.5.89/ms
 *	Anpassung an die neue Behandlung der Bezeichner. Alle Prozedur-
 *	und Modulnamen werden direkt aus dem Konstantenbereich verwendet.
 *	Die Namen allflliger Bibliotheken werden in einer lokalen Variablen
 *	abgelegt.
 *)
(*$ LargeVars:=FALSE LongAlign:=FALSE StackChk:=FALSE StackParms:=FALSE
    Volatile:=FALSE
*)
(*$ DEFINE Debug:=FALSE *)
FROM SYSTEM IMPORT ADR,ADDRESS,WORD,ASSEMBLE;
FROM Arts IMPORT BreakPoint;
FROM Assembler IMPORT
 d0,d1,d2,d3,d7,a0,a1,a6,ls6,ls7,ls9,ls10,adir,aoff,prel,jsr,moveaL,tstL,tstB,
 nop;
FROM M2DM IMPORT
 StrForm,StrPtr,ConstValue,Structure,Standard,ModModes,ExportTypes,
 tp,ObjPtr,ObjClass,
 RegType,Register,RegisterSet,WidType,byte,word,long,Ident,Diff,Condition;
IMPORT M2SM;
FROM M2SM IMPORT Dbg,MarkForm,MarkId,Enter,Mark;
FROM M2OM IMPORT CompOpts,Option,Options;
FROM M2TM IMPORT FindInScope;
FROM M2LM IMPORT ExtCall,PutWord,Delete,ip;
FROM M2RM IMPORT InRef,ModList,ModNo;
FROM M2HM IMPORT InitModule,CloseModule;
FROM M2XM IMPORT
 ItemMode,ItSet,Item,SetregMd,SetcocMd,SetfltMd,GetReg,GetFReg,
 Release,SaveRegs,RestoreRegs,LoadX,Move,FMove,NeedD0,SwapD0,IsBusy,Expo,
 LoadA6,AmigaDestroyed,RegsDestroyed,RegDestroyed,Gea,Ext,ReleaseReg,
 Islocked;
IMPORT MD:MathIEEEDoubTrans;

CONST
 lb=a6; fp0=0; fp1=1;
 FWord=0F200H;

TYPE
 SubType=(ffpOp,singleOp,doubleOp,fpuOp);
 Flop=(short,longx,flt,fix,neg,abs,cmp,add,sub,mul,div,
       facos,fasin,fatan,fcos,fcosh,fexp,flog10,flogn,fsin,fsinh,
       fsqrt,ftan,fatanh,fetoxm1,flog2,flognp1,ftentox,ftwotox,fsqr,ftanh
      );
 IRec=RECORD len:INTEGER; buf:ARRAY[0..31] OF CHAR END;
 ImpStates=(unknown,normalImported,notUsed,laterImported);

VAR
 names:ARRAY Flop OF Ident;
 offsets:ARRAY SubType,Flop OF INTEGER;

 realMod:ARRAY SubType OF RECORD
   no: INTEGER;
   initIp:INTEGER;
   state: ImpStates;
   pad1,pad2,pad3:SHORTINT; (* auf Langwort! *)
   name: Ident;
   node: ObjPtr;
 END;
 libName: ARRAY [ffpOp..fpuOp] OF IRec;
 constOp:BOOLEAN;
 resultTyp:StrPtr;
 maxLCard:RECORD CASE :INTEGER OF
 | 1:hi,lo:LONGINT
 | 2:r:LONGREAL
 END END;
 fop: ARRAY[neg..MAX(Flop)] OF CARDINAL;

 modsInitialized:BOOLEAN;

PROCEDURE InitM2FM;
BEGIN
 modsInitialized:=FALSE;
 realMod[ffpOp].name   :=ADR("\o\x07MathFFP");
 realMod[singleOp].name:=ADR("\o\x08MathREAL");
 realMod[doubleOp].name:=ADR("\o\x0fMathIEEEDoubBas");
 realMod[fpuOp].name   :=ADR("\o\x0BMathLibLong");
 realMod[ffpOp].no:=0;
 realMod[singleOp].no:=0;
 realMod[doubleOp].no:=0;
 realMod[fpuOp].no:=0;
 realMod[ffpOp].initIp:=0;
 realMod[singleOp].initIp:=0;
 realMod[doubleOp].initIp:=0;
 realMod[fpuOp].initIp:=0;
 realMod[ffpOp].state:=unknown;
 realMod[singleOp].state:=unknown;
 realMod[doubleOp].state:=unknown;
 realMod[fpuOp].state:=unknown;
END InitM2FM;

(* debug *)
TYPE Str32Ptr=POINTER TO ARRAY[0..31] OF CHAR;

PROCEDURE GenMathInits;
VAR t:SubType; ob:ObjPtr;
BEGIN
  FOR t:=MIN(SubType) TO MAX(SubType) DO
    WITH realMod[t] DO
      ob:=ModList^.next^.next;
      WHILE (ob#NIL) & (Diff(ob^.realName,name)#0) DO ob:=ob^.next END;
      IF (ob=NIL) OR (ob^.firstObj=NIL) THEN
        state:=notUsed;
        initIp:=ip;
        (* InitModule(???? kein Name, kein Key!! *)
        PutWord(nop); PutWord(nop);
      ELSE
        state:=normalImported;
      END;
    END;
  END;
  modsInitialized:=TRUE;
END GenMathInits;

PROCEDURE FixMathInits;
VAR t:SubType; oldIp:INTEGER;
BEGIN
  FOR t:=MIN(SubType) TO MAX(SubType) DO
    WITH realMod[t] DO
      IF state=laterImported THEN (* Init vor ip! *)
        oldIp:=ip; (* Mit viel Gottvertrauen! *)
        ip:=initIp;
        InitModule(no);
        ip:=oldIp;
      ELSIF state=notUsed THEN
        Delete(initIp,4)
      END;
    END;
  END;
END FixMathInits;

PROCEDURE MakeSubType(t:StrPtr):SubType;
(* Nicht fuer fpuOp! *)
BEGIN
  IF t=tp.ffptyp THEN RETURN ffpOp;
  ELSIF t=tp.realtyp THEN RETURN singleOp;
  ELSIF t=tp.lrealtyp THEN RETURN doubleOp;
  ELSE Mark(5008);
    MarkForm(t^.form);
    RETURN doubleOp;
  END;
END MakeSubType;

PROCEDURE CallReals(t:SubType; f:Flop);
(*
 * Geht davon aus, dass es nur mit gltigen Kombinationen von t und f auf-
 * gerufen wird!!!!
 *)
VAR
  hdr,obj:ObjPtr;
  a:LONGINT;
  p: INTEGER;
  i,lo,hi:Flop;
  newLoad: BOOLEAN;
  regs:RegisterSet;
BEGIN

  (* Anpassen! *)
  IF f>=facos THEN t:=fpuOp END;

  WITH realMod[t] DO
    IF no=0 THEN
      obj:=ModList^.next;
      WHILE (obj#NIL)&(Diff(obj^.realName,name)#0) DO obj:=obj^.next END;
      newLoad:=(obj=NIL) OR (obj^.firstObj=NIL);
      InRef(name,hdr,a,p);
      IF hdr=NIL THEN
        no:=-1; Mark(5003); MarkId(name);
      ELSE
        node:=hdr^.right;
        no:=node^.compmod;
        hdr:=node^.root;
        IF t=singleOp THEN
          lo:=short; hi:=div;
        ELSIF t=fpuOp THEN
          lo:=facos; hi:=ftanh;
        ELSE
          lo:=flt; hi:=div;
        END;
        FOR i:=lo TO hi DO
          obj:=FindInScope(names[i],hdr);
          IF obj=NIL THEN
            Mark(5002); MarkId(names[i])
          ELSE
            WITH obj^ DO
              IF class=Proc THEN
              ELSIF class=Code THEN
                offsets[t,i]:=cnum;
              ELSE
                Mark(5001); MarkId(hdr^.name)
              END
            END
          END
        END (*FOR i*);
      END; (*IF hdr=NIL*)
      IF newLoad THEN
        IF modsInitialized THEN state:=laterImported END;
        node^.root:=NIL; (* Damit Bezeichner unsichtbar! *)
        node^.name:=ADR("\o\x01-"); (* name ungltig! *)
      END;
    END; (*IF no=0*)
    (* MathLibLong hat auch Imp-Procs! *)
    IF offsets[t,f]=0 (*t=singleOp*) THEN
      SaveRegs(regs,RegisterSet{a0+8,a1+8,fp0+8,fp1+8});
      ExtCall(no,names[f],exported);
      AmigaDestroyed;
    ELSE
      SaveRegs(regs,RegisterSet{a0+8,a1+8,a6+8,fp0+8,fp1+8});
      LoadA6(no);
      PutWord(jsr+aoff+lb);
      PutWord(offsets[t,f]);
      AmigaDestroyed;
      IF t=doubleOp THEN
        RegsDestroyed(RegisterSet{d2,d3});
      END;
    END;
    RestoreRegs(regs);
  END; (* WITH realMod[t] *)
END CallReals;

PROCEDURE PreLoad1(VAR x:Item; willdestr:BOOLEAN);
VAR
 z: Item; fr:Register;
BEGIN
  WITH x DO
    IF (typ=tp.lrealtyp) OR (typ=tp.urealtyp) THEN
      IF Option[m68881] THEN
        IF (mode#fltMd) OR (FR<fp0+16) OR willdestr&(mode=fltMd)&Islocked(FR) THEN
          GetFReg(fr);
          SetfltMd(z,fr,tp.lrealtyp);
          FMove(x,z); Release(x); x:=z;
        END;
      ELSE
        IF (mode#fltMd) OR (FR#d0) THEN
          NeedD0(x); SetfltMd(z,d0,tp.lrealtyp);
          FMove(x,z); Release(x); x:=z;
        END;
      END;
    ELSE
      IF (mode#DregMd) OR (R#d0) THEN
        NeedD0(x); SetregMd(z,d0,typ);
        Move(x,z); Release(x); x:=z;
      END;
    END;
  END;
END PreLoad1;

(* longreal --> real *)
PROCEDURE FShort1(VAR x:Item);
VAR
 Dn:Register;
BEGIN
  WITH x DO
    IF mode#vconMd THEN
      PreLoad1(x,FALSE); (* ist ja LONGREAL, geht also in FREG *)
      IF Option[m68881] THEN
	GetReg(Dn,Dreg);
	PutWord(FWord+Dn);
	PutWord(0110010000000000L+(CARDINAL(FR) MOD 8)*ls7); (* FMOVE.S FR,Dn *)
	RegDestroyed(Dn);
	Release(x);
	SetregMd(x,Dn,tp.realtyp);
      ELSE
        CallReals(singleOp,short);
        SetregMd(x,d0,tp.realtyp);
      END;
    END;
  END (*WITH*);
END FShort1;

(* real --> longreal *)
PROCEDURE FLong1(VAR x:Item);
VAR
 fr:Register;
BEGIN
  WITH x DO
    IF mode#vconMd THEN
      PreLoad1(x,FALSE); (* nun in D0! *)
      IF Option[m68881] THEN
        GetFReg(fr);
        PutWord(FWord+d0);
        PutWord(0100010000000000L+(CARDINAL(fr) MOD 8)*ls7); (* FMOVE.S D0,fr *)
        Release(x);
	SetfltMd(x,fr,tp.lrealtyp);
      ELSE
        CallReals(singleOp,longx);
        SetfltMd(x,d0,tp.lrealtyp);
      END;
    END;
  END (*WITH*);
END FLong1;

PROCEDURE FFix1(VAR x:Item);
VAR
 (* regs:RegisterSet; *)
 exp:INTEGER; Dn:Register;
BEGIN
 WITH x DO
  IF mode=vconMd THEN
   typ:=tp.uinttyp;
   exp:=Expo(val.conLR);
   IF exp<31 THEN
    val.conLI:=LONGINT(val.conLR);
    IF val.conLI<0 THEN val.conSign:=-1; ELSE val.conSign:=0; END;
   ELSIF exp=31 THEN
    val.conLI:=LONGINT(val.conLR-maxLCard.r); val.conSign:=0;
   ELSE
    Mark(5004);
    val.conLI:=0; val.conSign:=0;
   END;
  ELSE
   PreLoad1(x,TRUE); (* Ich wei, es geht noch besser, aber wofr? *)
   (* 8.10.90/bp 68040 kennt kein FINTRZ! *)
   IF (typ=tp.lrealtyp) & Option[m68881]&~Option[m68040] THEN
     GetReg(Dn,Dreg);
     (* fmove.l fpcr,dn *)
     (* mode auf xx010000 (round to 0) setzen, move, alten wert wieder *)
     (* ODER: gleich mit intrz in freg *)
     (* ODER: fintrz fpn,fpm  fmove.l fpm,dn *)
     PutWord(FWord); (* FINTRZ.X x.FR,FR *)
     PutWord(0000000000000011L+(CARDINAL(FR) MOD 8)*ls10+(CARDINAL(FR) MOD 8)*ls7);
     PutWord(FWord+Dn);
     PutWord(0110000000000000L+(CARDINAL(FR) MOD 8)*ls7); (* FMOVE.L FR,Dn *)
     Release(x);
     RegDestroyed(Dn); (* !! *)
     SetregMd(x,Dn,tp.numtyp[long,TRUE]);
   ELSE
     (* SaveRegs(regs,RegisterSet{a0+8,a1+8,a6+8,fp0+16,fp1+16});*)
     CallReals(MakeSubType(typ),fix);
     SetregMd(x,d0,tp.numtyp[long,TRUE]);
     (* RestoreRegs(regs); *)
   END;
  END;
 END (*WITH*);
END FFix1;

PROCEDURE FFlt1(VAR x:Item; astyp:StrPtr);
VAR
 (* regs:RegisterSet;*)
 fr:Register;
 y:Item;
BEGIN
  WITH x DO
    IF mode=vconMd THEN
      val.conLR:=LONGREAL(val.conLI);
      IF (val.conLI<0) & (val.conSign=0) THEN val.conLR:=val.conLR+maxLCard.r; END;
      typ:=tp.urealtyp;
      (* 04.07.92/bp size muss auf 8 gesetzt werden!! *)
      size:=8;
    ELSE
      PreLoad1(x,FALSE); (* ist kein longreal, also nach Dn *)
      LoadX(x,long,FALSE);     (* Extend to long *)
      IF (astyp^.form=LReal) & Option[m68881] THEN
        GetFReg(fr);
        PutWord(FWord+R);
        PutWord(0100000000000000L+(CARDINAL(fr) MOD 8)*ls7); (* FMOVE.L x.conLR,fr *)
        Release(x);
        SetfltMd(x,fr,tp.lrealtyp);
      ELSE
        (* SaveRegs(regs,RegisterSet{a0+8,adir+a1,a6+8,fp0+16,fp1+16});*)
        CallReals(MakeSubType(astyp),flt);
        IF astyp#tp.lrealtyp THEN
          SetregMd(x,d0,astyp)
        ELSE
           SetfltMd(x,d0,astyp)
        END;
        (* RestoreRegs(regs) *)
      END
    END
 END
END FFlt1;

PROCEDURE Call1(VAR x:Item; op:Flop);
(* Nicht fuer ConstOp!
 * Nur fuer neg,abs und alles Fxxxx
 *)
VAR
  y:Item;
  fr:Register;
  mask,ea:CARDINAL;
  torelease:BOOLEAN;
BEGIN
  WITH x DO
    (* y ist neues Item = Ziel *)
    IF Option[m68881] THEN (* Achtung bei 68040!!! *)
      IF (mode=fltMd) THEN
        IF (FR<fp0+16) THEN
          PreLoad1(x,TRUE); (* neues Reg FOP.X Fr,Fr *)
          fr:=FR;
          y:=x;
          torelease:=FALSE;
        ELSIF Islocked(FR) THEN
          GetFReg(fr);
          SetfltMd(y,fr,tp.lrealtyp);
          (*.. von altem nach neuem FOP.X Fx,Fn*)
          torelease:=TRUE;
        ELSE (* freies Reg FPx *)
          fr:=FR;
          y:=x;
          torelease:=FALSE;
        END;
        ea:=0;
        mask:=0000000000000000L+(CARDINAL(FR) MOD 8)*ls10; (* Fop.X FR,FR *)
      ELSE
        GetFReg(fr);
        SetfltMd(y,fr,tp.lrealtyp);
        torelease:=TRUE;
        (* Vorsicht bei stkMd!! *)
        Gea(x,ea,FALSE);
	mask:=0101010000000000L; (* Fop.D ea,x.FR *)
      END;
      PutWord(FWord+ea);
      PutWord(mask+(CARDINAL(fr) MOD 8)*ls7+fop[op]);
      Ext(x); (* Ext ist bei #imm8 ok, Gea() auch!! *)
      IF torelease THEN Release(x) END;
      x:=y;
    ELSE (* kein 68881 *)
      PreLoad1(x,TRUE);
      CallReals(MakeSubType(typ),op);
    END;
  END (*WITH*);
END Call1;

PROCEDURE FAbs1(VAR x:Item);
BEGIN
  IF x.mode=vconMd THEN
    x.val.conLR:=ABS(x.val.conLR);
  ELSE
    Call1(x,abs);
  END;
END FAbs1;

PROCEDURE FNeg1(VAR x:Item);
BEGIN
  IF x.mode=vconMd THEN
    x.val.conLR:=-x.val.conLR;
  ELSE
    Call1(x,neg);
  END
END FNeg1;

PROCEDURE Call2(VAR x,y:Item; op:Flop; cc:Condition; destr:BOOLEAN);
(* op kann nur sein: cmp, add, sub, mul, div *)
VAR
 z:Item;
 d0set:BOOLEAN;
 (* regs: RegisterSet;*)
 ea,mask:CARDINAL;
 Dn:Register;
BEGIN
  (* x:=x op y *)
  WITH x DO
    IF (resultTyp=tp.lrealtyp)&Option[m68881] THEN
 (*$ IF Debug *)
      IF y.mode=vconMd THEN BreakPoint(ADR('Enter Call2')) END;
 (*$ ENDIF *)
      IF (op=add) OR (op=mul) THEN (* swap to best case *)
	IF ((mode#fltMd)OR(FR<fp0+16))&(y.mode=fltMd)&(y.FR>=fp0+16) THEN
	  z:=x; x:=y; y:=z
	END;
      END;
      PreLoad1(x,destr);
      (* dn,dn+1 geht nicht als Source! *)
      IF (y.mode=vconMd)&(op=cmp)&(y.val.conLI=0)&(y.val.conSign=0) THEN
          PutWord(FWord);
          PutWord(0111010L+(CARDINAL(FR) MOD 8)*ls10); (* FTST.X x.FR *)
      ELSE
        IF (y.mode=fltMd) THEN
          IF (y.FR<fp0+16) THEN PreLoad1(y,FALSE) END;
          ea:=0;
          mask:=0000000000000000L+(CARDINAL(y.FR) MOD 8)*ls10; (* Fop.X y.FR,x.FR *)
        ELSE
          (* Vorsicht bei stkMd!! *)
          Gea(y,ea,FALSE);
	  mask:=0101010000000000L; (* Fop.L ea,x.FR *)
        END;
        PutWord(FWord+ea);
        PutWord(mask+(CARDINAL(FR) MOD 8)*ls7+fop[op]);
        Ext(y); (* Ext ist bei #imm8 ok, Gea() auch!! *)
        Release(y);
      END;
      IF op=cmp THEN (* wie kommt daraus cocMd?? *)
      (*
       * cc kann nur sein: NE, EQ, LE, LT, GE, GT
       * Und diese sind invers!!
       * Die F-Flags mssen in Prozessor-Flags umgewandelt werden!
       *)
	GetReg(Dn,Dreg);
	PutWord(FWord+ls6+Dn); (* FScc Dn *)
	CASE cc OF
	| NE: mask:=000001L; (* EQ Achtung: nonaware tests, geben Trap!!!*)
	| EQ: mask:=001110L; (* NE *)
	| GE: mask:=010100L; (* LT *)
	| GT: mask:=010101L; (* LE *)
	| LE: mask:=010010L; (* GT *)
	| LT: mask:=010011L; (* GE *)
	END;
        PutWord(mask);
        (* Nun haben wir Dn=$FF, wenn Cond TRUE *)
        PutWord(tstB+Dn);
        ReleaseReg(Dn); RegDestroyed(Dn);
        SetcocMd(x,EQ);
      END;
(*$ IF Debug *)
      IF y.mode=vconMd THEN BreakPoint(ADR('Exit Call2')) END;
(*$ ENDIF *)
    ELSE
      IF (op=add) OR (op=mul) THEN SwapD0(x,y) END;
      IF resultTyp=tp.lrealtyp THEN
        IF (y.mode#fltMd) OR (y.FR#d2) THEN
          IF IsBusy(d2) OR IsBusy(d3) THEN Mark(5006); END;
          SetfltMd(z,d2,resultTyp); y.typ:=resultTyp;
          FMove(y,z); Release(y); y:=z;
        END;
        IF (mode#fltMd) OR (FR#d0) THEN
          NeedD0(x); SetfltMd(z,d0,resultTyp); x.typ:=resultTyp;
          FMove(x,z); Release(x); x:=z;
        END;
      ELSE
        d0set:=((mode#DregMd) OR (R#d0)) & ((y.mode#DregMd) OR (y.R#d0));
        IF d0set THEN NeedD0(x); END;
        SetregMd(z,d1,resultTyp); y.typ:=resultTyp;
        FMove(y,z); Release(y); y:=z;
        IF (mode#DregMd) OR (R#d0) THEN
          IF ~d0set THEN NeedD0(x); END;
          SetregMd(z,d0,resultTyp); x.typ:=resultTyp;
          FMove(x,z); Release(x); x:=z;
        END;
      END;
      (* SaveRegs(regs,RegisterSet{a0+8,a1+8,a6+8,fp0+16,fp1+16});*)
      CallReals(MakeSubType(typ),op);
      (* RestoreRegs(regs);*)
      IF op=cmp THEN
        PutWord(tstL+d0);
        SetcocMd(x,cc);
      END;
    END;
  END;
END Call2;

PROCEDURE FPreProcess(VAR op:M2SM.Symbol; VAR x,y:Item);
BEGIN;
 constOp:=(x.mode=vconMd) & (y.mode=vconMd);
 IF x.mode=stkMd THEN Dbg(20003); END;
 IF y.mode=stkMd THEN Dbg(20004); END;
 resultTyp:=x.typ;
 IF resultTyp^.form=UReal THEN resultTyp:=y.typ; END;
END FPreProcess;

PROCEDURE FCmp2(VAR x,y:Item; c:Condition);
BEGIN
  IF constOp THEN
    WITH x.val DO
      CASE c OF (* teste umgekehrte Relation! *)
      | NE: conLI:=ORD(conLR = y.val.conLR);
      | EQ: conLI:=ORD(conLR # y.val.conLR);
      | LE: conLI:=ORD(conLR > y.val.conLR);
      | LT: conLI:=ORD(conLR >=y.val.conLR);
      | GE: conLI:=ORD(conLR < y.val.conLR);
      | GT: conLI:=ORD(conLR <=y.val.conLR);
      ELSE
        Mark(5005); conLI:=0
      END;
      conSign:=0; x.typ:=tp.booltyp
    END
  ELSE
    IF resultTyp=tp.ffptyp THEN (* Ausnahme fr mathffp.library   *)
      IF c=GE THEN c:=LE;     (* dies ist nicht (!) InvertCC(c) *)
      ELSIF c=LT THEN c:=GT;
      ELSIF c=GT THEN c:=LT;
      ELSIF c=LE THEN c:=GE;
      END;
    END;
    Call2(x,y,cmp,c,FALSE);
  END
END FCmp2;

PROCEDURE FAdd2(VAR x,y:Item);
BEGIN
 WITH x DO
  IF constOp THEN
   val.conLR:=val.conLR+y.val.conLR;
  ELSE
   Call2(x,y,add,T,TRUE)
  END;
 END;
END FAdd2;

PROCEDURE FSub2(VAR x,y:Item);
BEGIN
 WITH x DO
  IF constOp THEN
   val.conLR:=val.conLR-y.val.conLR;
  ELSE
   Call2(x,y,sub,T,TRUE);
  END;
 END;
END FSub2;

PROCEDURE FMul2(VAR x,y:Item);
BEGIN
 WITH x DO
  IF constOp THEN
   val.conLR:=val.conLR*y.val.conLR;
  ELSE
   Call2(x,y,mul,T,TRUE);
  END;
 END;
END FMul2;

PROCEDURE FDiv2(VAR x,y:Item);
BEGIN
 WITH x DO
  IF constOp THEN
   IF y.val.conLR=0.0 THEN Mark(5007);
   ELSE val.conLR:=val.conLR/y.val.conLR;
   END;
  ELSE
   Call2(x,y,div,T,TRUE);
  END;
 END;
END FDiv2;

PROCEDURE FFpu1(VAR x:Item; func:Standard);
(* Nur fuer Longreal,ureal erlaubt! *)

  PROCEDURE TestG0():BOOLEAN;
  BEGIN
    IF (x.val.conLR<=0.0) THEN
      Mark(5010);
      RETURN FALSE
    END;
    RETURN TRUE;
  END TestG0;

  PROCEDURE TestLE11():BOOLEAN;
  BEGIN
    IF (x.val.conLR<-1.0) OR (x.val.conLR>1.0) THEN
      Mark(5009);
      RETURN FALSE
    END;
    RETURN TRUE;
  END TestLE11;

VAR
  op:Flop;
BEGIN
  WITH x DO
    IF mode=vconMd THEN
      CASE func OF
      | Facos:
	  IF TestLE11() THEN
	    val.conLR:=MD.Acos(val.conLR);
	  END;
      | Fasin:
	  IF TestLE11() THEN
	    val.conLR:=MD.Asin(val.conLR);
	  END;
      | Fatan:
	  val.conLR:=MD.Atan(val.conLR);
      | Fcos:
	  val.conLR:=MD.Cos(val.conLR);
      | Fcosh:
	  val.conLR:=MD.Cosh(val.conLR);
      | Fexp:
	  val.conLR:=MD.Exp(val.conLR);
      | Flog10:
	  IF TestG0() THEN
	    val.conLR:=MD.Log10(val.conLR);
	  END;
      | Flogn:
	  IF TestG0() THEN
	    val.conLR:=MD.Log(val.conLR);
	  END;
      | Fsin:
	  val.conLR:=MD.Sin(val.conLR);
      | Fsinh:
	  val.conLR:=MD.Sinh(val.conLR);
      | Fsqrt:
	  IF val.conLR>=0.0 THEN
	    val.conLR:=MD.Sqrt(val.conLR);
	  ELSE
	    Mark(5011);
	  END;
      | Ftan:
	  val.conLR:=MD.Tan(val.conLR);
      | Fatanh:
	  IF (val.conLR>-1.0)&(val.conLR<1.0)  THEN
	    val.conLR:=MD.Log((1.0+val.conLR)/(1.0-val.conLR))/2.0;
	  ELSE
	    Mark(5012);
	  END;
      | Fetoxm1:
	  val.conLR:=MD.Exp(val.conLR)-1.0;
      | Flog2:
	  IF TestG0() THEN
	    val.conLR:=MD.Log(val.conLR)/MD.Log(2.0);
	  END;
      | Flognp1:
          IF val.conLR>-1.0 THEN
	    val.conLR:=MD.Log(val.conLR+1.0);
	  ELSE
	    Mark(5013);
	  END;
      | Ftentox:
	  val.conLR:=MD.Pow(10.0,val.conLR);
      | Ftwotox:
	  val.conLR:=MD.Pow(2.0,val.conLR);
      | Fsqr:
	  val.conLR:=val.conLR*val.conLR;
      | Ftanh:
	  val.conLR:=MD.Tanh(val.conLR);
      END;
    ELSE
      IF func=Fsqr THEN
        PreLoad1(x,TRUE); (* auf jeden Fall, weil mul als Single! *)
      END;
      op:=Flop(ORD(func)-ORD(Facos)+ORD(facos));
      Call1(x,op);
    END;
  END (*WITH*);
END FFpu1;

BEGIN
  maxLCard.hi:=41F0000H; maxLCard.lo:=0;
  names[short]:=ADR("\o\x05Short");
  names[longx]:=ADR("\o\x04Long");
  names[flt]:=ADR("\o\x03Flt");
  names[fix]:=ADR("\o\x03Fix");
  names[neg]:=ADR("\o\x03Neg");
  names[abs]:=ADR("\o\x03Abs");
  names[cmp]:=ADR("\o\x03Cmp");
  names[add]:=ADR("\o\x03Add");
  names[sub]:=ADR("\o\x03Sub");
  names[mul]:=ADR("\o\x03Mul");
  names[div]:=ADR("\o\x03Div");

  (* in MathLibLong: *)
  names[facos] :=ADR("\o\x04acos");
  names[fasin] :=ADR("\o\x04asin");
  names[fatan] :=ADR("\o\x06arctan");
  names[fcos]  :=ADR("\o\x03cos");
  names[fcosh] :=ADR("\o\x04cosh");
  names[fexp]  :=ADR("\o\x03exp");
  names[flog10]:=ADR("\o\x05log10");
  names[flogn] :=ADR("\o\x03log");
  names[fsin]  :=ADR("\o\x03sin");
  names[fsinh] :=ADR("\o\x04sinh");
  names[fsqrt] :=ADR("\o\x04sqrt");
  names[ftan]  :=ADR("\o\x03tan");

  names[fatanh] :=ADR("\o\x05atanh");
  names[fetoxm1]:=ADR("\o\x06etoxm1");
  names[flog2]  :=ADR("\o\x04log2");
  names[flognp1]:=ADR("\o\x06lognp1");
  names[ftentox]:=ADR("\o\x06tentox");
  names[ftwotox]:=ADR("\o\x06twotox");
  names[fsqr]   :=ADR("\o\x03sqr");

  names[ftanh] :=ADR("\o\x04tanh");

  fop[neg]:=0011010L;
  fop[abs]:=0011000L;

  fop[cmp]:=0111000L;
  fop[add]:=0100010L;
  fop[sub]:=0101000L;
  fop[mul]:=0100011L;
  fop[div]:=0100000L;

  fop[facos] :=0011100L;
  fop[fasin] :=0001100L;
  fop[fatan] :=0001010L;
  fop[fcos]  :=0011101L;
  fop[fcosh] :=0011001L;
  fop[fexp]  :=0010000L;
  fop[flog10]:=0010101L;
  fop[flogn] :=0010100L;
  fop[fsin]  :=0001110L;
  fop[fsinh] :=0000010L;
  fop[fsqrt] :=0000100L;
  fop[ftan]  :=0001111L;

  fop[fatanh] :=0001101L;
  fop[fetoxm1]:=0001000L;
  fop[flog2]  :=0010110L;
  fop[flognp1]:=0000110L;
  fop[ftentox]:=0010010L;
  fop[ftwotox]:=0010001L;
  fop[fsqr]   :=0100011L; (* fmul x,x!!!! *)

  fop[ftanh] :=0001001L;

END M2FM.
