IMPLEMENTATION MODULE M2EM;
(*
 * 4.3.90/bp
 *	In ConvertTyp 2* SetBusyReg, durch neues Cmp2 notwendig
 *)
(*$ LargeVars:=FALSE LongAlign:=TRUE StackChk:=FALSE Volatile:=FALSE
    StackParms:=FALSE
*)
FROM SYSTEM	IMPORT	BITSET,ADR,CAST,SHIFT,WORD,ASSEMBLE;
FROM Arts	IMPORT	BreakPoint;
FROM Assembler	IMPORT	d0,d1,a4,a5,a7,imm,ls8,ls9,bcc,bra,chkW,trap,
			ainc,adec,movemmL,movemL,moveL;
FROM M2DM	IMPORT	ObjPtr,StrPtr,ParPtr,PDPtr,KeyPtr,ObjClass,
			StrForm,Standard,ConstValue,PDesc,Object,
			Structure,tp,maxSInt,maxSCard,maxCard,minInt,
			minLInt,maxInt,maxLInt,nil,Condition,ModModes,
			VarModes,RegType,Register,byte,word,long,
			WidType,RegisterSet;
IMPORT M2SM;
FROM M2SM	IMPORT	Symbol,MarkForm,Mark;
FROM M2OM	IMPORT	Options,Option,CompOpts,PopOption,PushOption;
FROM M2LM	IMPORT	AllocChar,AppendString,FixLink,PutInBuffer,
			fixup,ip,PutWord,FixupWith,GetConstVal;
FROM M2XM	IMPORT	DiffCC,ItemMode,Item,curLev,UnsignedT,NumT,GetReg,
			Release,ReleaseReg,LockReg,UnlockReg,SetbusyReg,
			SetregMd,SetconMd,SetglbMd,SetstkMd,AssignComp,
			SignedT,Isz,LoadAdr,LoadD,LoadP,LoadX,Move,MoveAdr,
			ConstSize,NeedD0,RegDestroyed,RegsDestroyed,
			Islocked,FreeD0,SetErrMd,trickAidr,ConvLRConstTo;
FROM M2HM	IMPORT	GenHalt,Neg1,Not1,Abs1,Cap1,Com1,Inc1,Dec1,And1,Or1,
			And2,Or2,Add2,Sub2,Trap,IAnd2,IOr2,IEor2,Div2,Mod2,
			Rem2,Quo2,Mul2,Cmp2,In2,ShiType,Shi2,Ash2,ConIndex,
			VarIndex,GetHigh,Normalize,CheckHigh,CheckClimit,
			PreProcess,constOp,resultTyp;
FROM M2FM	IMPORT	FShort1,FLong1,FFix1,FFlt1,FAbs1,FNeg1,FAdd2,FSub2,
			FMul2,FDiv2,FCmp2,FPreProcess,FFpu1;

CONST
 sb=a4; mp=a5; sp=a7;

VAR mask:ARRAY [0..32] OF LONGINT;


PROCEDURE IncAdr(VAR adr:LONGINT; s:LONGINT);
BEGIN
 IF (adr>=0) & (s<=maxLInt-adr) OR (adr<0) & (s>=minLInt-adr) THEN
  INC(adr,s)
 ELSE
  Mark(4001) (* address underflow/overflow *)
 END;
END IncAdr;

(* neue Version fr positive Alloc bei global/bp 25.4.90 *)
PROCEDURE AllocVar(obj:ObjPtr; VAR adr:LONGINT);
CONST
 ByteSize=1;
VAR
 s:LONGINT;
BEGIN   (* obj^.class=Var *)
 WITH obj^ DO
  s:=typ^.size;
  IF vlev=0 THEN (* global! *)
    (*
     * Ab Version 3.3 werden globale Variablen auf Langwort Addressen
     * abgelegt. Dies erlaubt ein direkte bergabe an Dos Prozeduren.
     * WORD-alignment for structured types and types with a size>ByteSize.
     *)
    IF (s#ByteSize) OR (typ^.form>Opaque) THEN
      IF Option[longWordAlign] THEN
        (* s:=adr MOD 4; DAS geht nur bei negativen!! *)
        INC(adr,3); adr:=(adr DIV 4)*4;
      ELSIF ODD(adr) THEN
        INC(adr)
      END;
    END;
    vadr:=adr;
    IncAdr(adr,s);
  ELSE (* local var *)
    IncAdr(adr,-s);
   (*
    * WORD-alignment for structured types and types with a size>ByteSize.
    *)
    IF (s#ByteSize) OR (typ^.form>Opaque) THEN
      IF ODD(adr) THEN DEC(adr) END;
    END;
    vadr:=adr;
  END; (* if global *)
 END (*WITH*);
END AllocVar;

(*
PROCEDURE AllocVar(obj:ObjPtr; VAR adr:LONGINT);
CONST
 ByteSize=1;
VAR
 s:LONGINT;
BEGIN   (* obj^.class=Var *)
 WITH obj^ DO
 (*
  * negative allocation for global and local variables
  *)
  s:=typ^.size;
  IncAdr(adr,-s);

 (*
  * Ab Version 3.3 werden globale Variablen auf Langwort Addressen
  * abgelegt. Dies erlaubt ein direkte bergabe an Dos Prozeduren.
  * WORD-alignment for structured types and types with a size>ByteSize.
  *)
  IF (s#ByteSize) OR (typ^.form>Opaque) THEN
   IF (vlev=0) & Option[longWordAlign] THEN
    s:=adr MOD 4;
    DEC(adr,s);
   ELSIF ODD(adr) THEN
    DEC(adr)
   END;
  END;
  vadr:=adr;
 END (*WITH*);
END AllocVar;
*)

PROCEDURE AllocPar(par:ParPtr; VAR adr:LONGINT);
CONST
 PointerSize=4;
VAR
 s:LONGINT;
BEGIN
 WITH par^ DO
  s:=typ^.size;
  (* assumes s=size of formal type for dynamic array parameter *)
  (* always WORD-alignment for parameters on stack: *)
  IF ODD(s) THEN INC(s) END;
  IF varpar THEN
   IF (typ^.form=Array) & typ^.dyn THEN
    IncAdr(adr,-8);
   ELSE
    IncAdr(adr,-PointerSize);
   END;
  ELSE
   IncAdr(adr,-s)
  END;
 END (*WITH*);
END AllocPar;

PROCEDURE AllocFld(obj:ObjPtr; VAR adr:LONGINT);
CONST
 ByteSize=1;
VAR
 s:LONGINT;
BEGIN
 (* obj^.class=Field *)
 WITH obj^ DO
  s:=typ^.size;
  IF ~((typ^.form<=Opaque) & (s=ByteSize)) THEN
                        (* WORD-alignment for structured types and *)
                        (* types with a size>ByteSize. *)
   IF ODD(adr) THEN INC(adr) END;
  END;
  offset:=adr;
  IncAdr(adr,s)
 END (*WITH*);
END AllocFld;

PROCEDURE SRTest(VAR x:Item);
BEGIN
 WITH x DO
  IF typ^.form=Range THEN typ:=typ^.RBaseTyp END;
 END (*WITH*);
END SRTest;

PROCEDURE ToLoadTest(VAR x:Item);
BEGIN
  IF x.adrtoload THEN LoadAdr(x) END;
END ToLoadTest;

PROCEDURE setCC(VAR x:Item; fcc:Condition);
(* transform all modes to 'cocMd': *)
BEGIN
 Release(x);
 WITH x DO
  typ:=tp.booltyp; mode:=cocMd; CC:=fcc;
  Tjmp:=0; Fjmp:=0;
 END;
END setCC;

PROCEDURE SetLimits(t:StrPtr; VAR min,max:ConstValue);
VAR
 a,b:LONGINT;
 sign:BOOLEAN;
BEGIN
 a:=0; b:=0; sign:=FALSE;
 CASE t^.form OF
 | Bool: b:=1;
 | Char: b:=maxSCard;
 | Enum: a:=t^.eMin; b:=t^.eMax; (* not signed, also ok! *)
 | Range: a:=t^.min; b:=t^.max; sign:=t^.sign;
 | BPointer: a:=0; b:=40000000H-1; sign:=FALSE;
 | Pointer: a:=minLInt; b:=maxLInt; sign:=TRUE;
 ELSE
  Mark(4088); MarkForm(t^.form);
 END;
 min.conLI:=a;
 IF sign & (a<0) THEN min.conSign:=-1; ELSE min.conSign:=0; END;
 max.conLI:=b;
 IF sign & (b<0) THEN max.conSign:=-1; ELSE max.conSign:=0; END;
END SetLimits;

PROCEDURE ConvertTyp(VAR x:Item; newtyp:StrPtr);
VAR
 xmin, xmax, newmin, newmax: ConstValue;
 boolFrom, boolTo, checkLow, checkHigh, szDiff: BOOLEAN;
 dh, dl: LONGINT;
 szx,szy: WidType;
 lc,hc: Condition;
 xf,nf:StrForm;
 y,z:Item;
BEGIN
  (*
   * If the given type is the same as the requested typ, then everything
   * is already ok. Quit this procredure.
   *)
 ToLoadTest(x);
 IF x.typ=newtyp THEN RETURN END;
 xf:=x.typ^.form; nf:=newtyp^.form;

  (*
   * Test if it's necessary to generate a negate.
   * boolFrom indicates, that the source is a boolean.
   * boolTo indicates, that the destination is a boolean.
   * If both are true, then we reset them, it is not necessary
   * to negate twice !
   *)
 boolFrom:=(xf=Bool) OR ((xf=Range) & (x.typ^.RBaseTyp=tp.booltyp));
 boolTo:=(nf=Bool) OR ((nf=Range) & (newtyp^.RBaseTyp=tp.booltyp));
 IF boolFrom & boolTo THEN boolFrom:=FALSE; boolTo:=FALSE; END;
  (*
   * If either form is greater than a Pointer, then it is a structured
   * type, so no conversion is possible. The same is true if both types
   * are different Pointer or BPointer types. Quit the procedure.
   *
   *)
 IF (xf>Pointer) OR (nf>Pointer) OR ((xf>=BPointer) & (nf>= BPointer))
(* 22.4.89/ms
 * Nach meiner Meinung mssen diese Umwandlungen auch erlaubt werden. Falls
 * dies der Sprachdefinition wiederspricht muss dies wieder aus dem Kommentar
 * entfernt werden.
 *  OR (x.typ=addrtyp) & (nf=BPointer) OR (newtyp=addrtyp) & (xf=BPointer)
 *  OR (x.typ=bptrtyp) & (nf=Pointer) OR (newtyp=bptrtyp) & (xf=Pointer)
 *)
 THEN
  Mark(4076); MarkForm(xf); MarkForm(nf);
 END;
  (*
   * Now we have to distinguish 4 cases, depending on whether the source
   * or the destination are floating point or ordinal types.
   *)
 IF (FFP<=nf) & (nf<=LReal) THEN
      (*
       * The destination is a floating point type. Depending on the source
       * we will have to call float or not.
       *)
  IF xf>=FFP THEN
      (*
       * The source type is also a floating point type. The only possible
       * conversions are from REAL to LONGREAL and from LONGREAL to REAL.
       *)
   IF    xf=UReal THEN
     x.val.conConvType:=newtyp; (* 12.2.91/bp wenigstens den Typ fr CAST merken! *)
     RETURN;    (* Constants are not transformed. *)
   ELSIF xf=LReal THEN FShort1(x);
   ELSIF xf=FFP   THEN Mark(4085); (* FtoR(x) *)
   END;
   IF    nf=LReal THEN FLong1(x);
   ELSIF nf=FFP   THEN Mark(4086); (* RtoF(x) *)
   END;
  ELSE
      (*
       * The source is an ordinal type, so we have to call float.
       * But before that, we have to convert it to a longint.
       *)
   ConvertTyp(x,tp.numtyp[long,TRUE]);
   (* 21.2.91/bp mu UReal bleiben! *)
   IF x.mode=vconMd THEN newtyp:=tp.urealtyp END;
   FFlt1(x,newtyp); (* 04.07.92/bp setzt nun size auf 8! *)
  END;
 ELSE
   (*
    * The destination is an ordinal type. Depending on the source we
    * have to call fix or not.
    *)
  IF (FFP<=xf) & (xf<=UReal) THEN (* Fix *)
      (*
       * The source is a floating point type. We must first convert it
       * to an ordinal type by calling fix. This gives us a longint
       * which we then have to convert to the desired type.
       *)
   FFix1(x); ConvertTyp(x,newtyp);
(* 22.4.89/ms
 * Neu darf die Form des Ursprungs- bzw. Zieltyps auch ein (B)Pointertyp
 * sein, wenn von/nach ADDRESS(BPTR) konvertiert wird.
 *)
  ELSIF ((newtyp=tp.bptrtyp) OR (nf=BPointer))
      & ((x.typ=tp.addrtyp) OR (xf=Pointer)) THEN
(* Force a LONGCARD Division by 4 *)
   SetconMd(y,4,tp.uinttyp); x.typ:=tp.numtyp[long,FALSE];
   constOp:=x.mode=vconMd; resultTyp:=x.typ;
   PushOption(rngchk,FALSE); PushOption(ovflchk,FALSE);
   Div2(x,y);
   PopOption(rngchk); PopOption(ovflchk);
  ELSIF ((newtyp=tp.addrtyp) OR (nf=Pointer))
       & ((x.typ=tp.bptrtyp) OR (xf=BPointer)) THEN
(* Force a LONGCARD Multiplication with 4 *)
   SetconMd(y,4,tp.uinttyp); x.typ:=tp.numtyp[long,FALSE];
   constOp:=FALSE; resultTyp:=x.typ;
   PushOption(rngchk,FALSE); PushOption(ovflchk,FALSE);
   Mul2(x,y);
   PopOption(rngchk); PopOption(ovflchk);
  ELSIF (newtyp=tp.bytetyp) OR (x.typ=tp.bytetyp) THEN
 (*
  * 4.4.89/ms
  *    Konversion von/nach Bytetyp ist erlaubt, wenn die Grssen
  *    identisch sind. So gewnscht von Roli Kappeler.
  *)
   IF x.typ^.size#newtyp^.size THEN
    Mark(4026)
   END
  ELSE
   IF x.mode=vconMd THEN xmin:=x.val; xmax:=xmin
   ELSE SetLimits(x.typ,xmin,xmax)
   END;
   SetLimits(newtyp,newmin,newmax);
   DiffCC(xmin,newmin,dh,dl); checkLow:=dh<0;
   DiffCC(newmax,xmax,dh,dl); checkHigh:=dh<0;
   IF x.mode=vconMd THEN
    IF (checkLow OR checkHigh) & Option[rngchk] THEN
     Mark(4025); x.val:=newmin;
    END;
    IF nf=Range THEN newtyp:=newtyp^.RBaseTyp END;
    Isz(x,szx);
   ELSE
    SetregMd(y,d0,newtyp); (* dummy, no NeedD0 *)
    Isz(y,szy); Isz(x,szx); szDiff:=szx#szy; IF szy<szx THEN szy:=szx END;
    IF boolFrom THEN Neg1(x); END;
    IF szDiff OR checkLow OR checkHigh THEN LoadX(x,szy,TRUE); END;
    IF Option[rngchk] THEN
     IF checkHigh & (newmin.conLI=0) & (szx<=word) & (newmax.conLI<=maxInt)
        & (szy>=word) THEN
      PutWord(chkW+x.R*ls9+imm); PutWord(INTEGER(newmax.conLI));
     ELSE
      constOp:=FALSE;
(*
 * 26.5.89/ms
 *	Fr die neue Trap Prozedur mssen die Bedingungen negiert werden.
 *
 *    IF SignedT(x) THEN lc:=GE; hc:=LE ELSE lc:=CC; hc:=LS END;
 *)
      IF SignedT(x) THEN lc:=LT; hc:=GT ELSE lc:=CS; hc:=HI END;
      IF checkLow THEN
       SetconMd(y,newmin.conLI,x.typ); z:=x; Cmp2(z,y,EQ);
(*
 * 26.5.89/ms
 *     PutWord(bra+bra+CARDINAL(lc)*ls8+2); PutWord(trap+14);
 *)
(* 4.3.90/bp
 * Da das neue Cmp2 evtl. ein Dreg anfordert, mu SetBusyReg hier auch schon!
 *)
       SetbusyReg(x.R);
       Trap(14, lc);
      END;
      IF checkHigh THEN
       SetconMd(y,newmax.conLI,x.typ); z:=x; Cmp2(z,y,EQ);
(*
 * 26.5.89/ms
 *     PutWord(bra+CARDINAL(hc)*ls8+2); PutWord(trap+14)
 *)
       SetbusyReg(x.R);
       Trap(14, hc);
      END;
    (* 4.3.90/bp kann weg, da 2* oben
     *IF checkLow OR checkHigh THEN
     * SetbusyReg(x.R) (* mache Release(x) von Cmp2[SetcocMd] rckgngig *)
     *END;
     *)
     END;
    END;
    IF boolTo THEN Neg1(x); END;
   END;
  END;
 END;
 x.typ:=newtyp;
END ConvertTyp;

PROCEDURE GenIndex(VAR x,y:Item);
VAR
 up,low,i,elsize:LONGINT;
 inxt,elet,ytyp:StrPtr;
 sgn: BOOLEAN;
 dsz: WidType;
 z:Item;
 f:StrForm;
BEGIN
 IF x.typ^.form#Array THEN Mark(4011); MarkForm(x.typ^.form); Release(y);
 ELSE
  elet:=x.typ^.ElemTyp;
  elsize:=elet^.size;
  IF x.typ^.dyn THEN    (* dynamic array always descriptor indirect: *)
   IF NumT(y) THEN
    z:=x; GetHigh(z); (* inhibit change of x *)
    (* the minimal width of an index must be word! *)
    IF (y.typ^.size<=2) THEN
     LoadX(y,word,TRUE); y.typ:=tp.numtyp[word,TRUE];
    ELSE
     LoadD(y,TRUE);
    END;
    CheckHigh(y,z);
    VarIndex(x,y,elsize);
   ELSE
    Mark(4005); Release(y);
   END;
  ELSE                  (* not dynamic *)
   up:=0; low:=0;
   WITH x.typ^.IndexTyp^ DO
    inxt:=RBaseTyp;
    IF form=Range THEN up:=max; low:=min END;
   END;
   IF ~AssignComp(inxt,y.typ) THEN Mark(4006) END;
   IF y.mode=vconMd THEN       (* constant index: *)
    i:=y.val.conLI;
    IF ((low<=i) & (i<=up)) OR ~Option[rngchk] THEN
     DEC(i,low); (* normalize index to 0 *)
    ELSE
     Mark(4007); i:=0;
    END;
    IF (elsize=0) OR (ABS(i)<=maxLInt DIV elsize) THEN
     i:=elsize*i;
    ELSE
     Mark(4008); i:=0;
    END;
    ConIndex(x,i);
   ELSE                     (* variable index: *)
    IF (low>=0) OR (up<=low+maxLInt) THEN i:=up-low;
    ELSE Mark(4010); i:=0;
    END;
    sgn:=SignedT(y);
    Isz(y,dsz);
    (* the minimal width of an index must be word! *)
    IF dsz<word THEN dsz:=word END;
    IF (i>=maxInt) OR (x.typ^.size>=maxInt) THEN
     dsz:=long
    END;
    f:=y.typ^.form;
    IF f=Range THEN f:=y.typ^.RBaseTyp^.form END;
    IF f=Bool THEN  Neg1(y); sgn:=FALSE END;
    LoadX(y,dsz,TRUE);
    y.typ:=tp.numtyp[dsz,sgn];
    Normalize(y,low);
    CheckClimit(y,i);
    VarIndex(x,y,elsize)
   END
  END;
  x.typ:=elet
 END;
END GenIndex;

PROCEDURE GenField(VAR x:Item; f:ObjPtr);
BEGIN
 WITH x DO
  (* typ^.form=Record *)
  IF (f#NIL) & (f^.class=Field) THEN
   ConIndex(x,f^.offset);
   typ:=f^.typ;
  ELSE
   Mark(4012);
   SetErrMd(x,tp.undftyp); (* macht auch Release! *)
  END;
 END (*WITH*);
END GenField;

PROCEDURE GenDeRef(VAR x:Item);
BEGIN
 WITH x DO
  IF (typ^.form=Pointer) OR (typ=tp.addrtyp) THEN
   IF (mode<vconMd) & ~indir THEN
    indir:=TRUE; off:=0;
    nilToCheck:=TRUE;
   ELSIF mode#vconMd THEN
    LoadP(x); mode:=RindMd; (* transform to 'RindMd' *)
   ELSE
    Mark(4013); (* illegal dereferencing *)
   END;
   IF typ=tp.addrtyp THEN typ:=tp.bytetyp; ELSE typ:=typ^.PBaseTyp; END;
  ELSIF (typ^.form=BPointer) OR (typ=tp.bptrtyp) THEN
   IF mode#vconMd THEN
    LoadP(x); mode:=RindMd; (* transform to 'RindMd' *)
   ELSE
    Mark(4004); (* illegal dereferencing *)
   END;
   IF (typ=tp.addrtyp) OR (typ=tp.bptrtyp) THEN typ:=tp.bytetyp;
   ELSE typ:=typ^.PBaseTyp END;
  ELSE
   Mark(4014); MarkForm(typ^.form); (* illegal dereferencing *)
  END;
  (* 17.3.90/bp undefiniertes xx bei pointer TO xx *)
  IF typ=tp.undftyp THEN Mark(4089) END;
 END (*WITH*);
END GenDeRef;

PROCEDURE GenNeg(VAR x:Item);
VAR
 f:StrForm;
BEGIN
 ToLoadTest(x);
 f:=x.typ^.form; IF f=Range THEN f:=x.typ^.RBaseTyp^.form; END;
 IF f=UInt THEN Neg1(x)
 ELSIF (FFP<=f) & (f<=UReal) THEN FNeg1(x)
 ELSE Mark(4016); MarkForm(f);
 END;
END GenNeg;

PROCEDURE GenNot(VAR x:Item);
BEGIN
 SRTest(x);
 IF x.typ^.form=Bool THEN Not1(x);
 ELSE Mark(4017); MarkForm(x.typ^.form);
 END;
END GenNot;

PROCEDURE GenAnd(VAR x:Item);
BEGIN
 ToLoadTest(x);
 SRTest(x);
 IF x.typ^.form=Bool THEN And1(x);
 ELSE Mark(4018); MarkForm(x.typ^.form); Release(x); SetconMd(x,0,tp.booltyp);
 END;
END GenAnd;

PROCEDURE GenOr(VAR x:Item);
BEGIN
 ToLoadTest(x);
 SRTest(x);
 IF x.typ^.form=Bool THEN Or1(x);
 ELSE Mark(4019); Release(x); SetconMd(x,-1,tp.booltyp);
 END;
END GenOr;

PROCEDURE GenSingSet(VAR x,e:Item);
VAR
 xt:StrPtr;
 y:Item;
 Dn:Register;
BEGIN (* x.typ^.form=Set *)
 xt:=x.typ;
 IF AssignComp(e.typ,xt^.SBaseTyp) THEN
  ConvertTyp(e,xt^.SBaseTyp);
  IF e.mode=vconMd THEN
   (*$ RangeChk:=FALSE*) SetconMd(x,SHIFT(1,e.val.conLI),xt); (*$ POP RangeChk *)
  ELSE
   GetReg(Dn,Dreg); SetregMd(x,Dn,xt); SetconMd(y,1,xt); Move(y,x);
   LoadX(e,byte,TRUE);
   Shi2(x,e,Lsl);
  END
 ELSE
  Mark(4021); SetErrMd(x,xt);
 END;
 Release(e);
END GenSingSet;

PROCEDURE GenSet(VAR x,e1,e2:Item);
VAR
 xt,r1typ,r2typ:StrPtr;
 y:Item;
 Dn,Dy:Register;
 v1,v2,lv:LONGINT;
 lo,hi:ConstValue;
 op:Symbol;
 rtyp,btyp:Structure;
BEGIN (* x.typ^.form=Set *)
 xt:=x.typ^.SBaseTyp;
 IF ~(AssignComp(e1.typ,xt) & AssignComp(e2.typ,xt)) THEN
  Mark(4023); SetErrMd(x,x.typ);
 ELSE
  IF (e1.mode=vconMd) & (e2.mode=vconMd) THEN
   SetLimits(xt,lo,hi);
   v1:=e1.val.conLI; v2:=e2.val.conLI;
   IF (lo.conLI<=v1) & (v1<=v2) & (v2<=hi.conLI) THEN
    lv:=mask[v2+1-v1];
    SetconMd(x,SHIFT(lv,v1),x.typ);
   ELSE
    SetconMd(x,0,x.typ);
    Mark(4022);
   END
  ELSE (* variable set-constructor: *)
   IF xt^.form=Range THEN r1typ:=xt^.RBaseTyp;
   ELSE
    WITH r1typ^ DO
     form:=Range; RBaseTyp:=xt; sign:=FALSE; min:=0;
     (* 31.12.90/bp Sets sind nur fr normale Enums zugelassen! *)
     IF RBaseTyp^.form=Enum THEN max:=RBaseTyp^.eMax;
     ELSE max:=1;
     END;
    END;
   END;
   r2typ:=r1typ;
   IF e1.mode#vconMd THEN SetLimits(e1.typ,lo,hi); r1typ^.max:=hi.conLI; END;
   ConvertTyp(e1,ADR(r1typ));
   IF e2.mode#vconMd THEN SetLimits(e2.typ,lo,hi); r2typ^.min:=lo.conLI; END;
   ConvertTyp(e2,ADR(r2typ));
   GetReg(Dy,Dreg); SetregMd(y,Dy,e2.typ); Move(e2,y); Inc1(y);
   constOp:=FALSE; resultTyp:=e2.typ; Sub2(e2,e1);
   IF Option[rngchk] THEN
(* 26.5.89/ms PutWord(bcc+2); PutWord(trap+14); *)
    Trap(14, CS);
   END;
   GetReg(Dn,Dreg); SetregMd(x,Dn,x.typ);
   SetconMd(y,SHIFT(1,8*x.typ^.size-1),x.typ); (* set sign bit *)
   Move(y,x);
   Shi2(x,e2,Asr); Shi2(x,y,Rol);
   Release(y);
  END
 END;
 Release(e1);
 Release(e2);
END GenSet;

PROCEDURE InitM2EM;
VAR
 k:INTEGER;
 exp:LONGINT;
BEGIN
 exp:=0; mask[0]:=0; mask[32]:=-1;
 FOR k:=1 TO 31 DO INC(exp,exp+1); mask[k]:=exp END;
END InitM2EM;

TYPE
 OpType=(undfOp,boolOp,enumOp,charOp,setOp,numericOp,realOp,opaqueOp);

PROCEDURE CalcComp(l,r:Item; VAR optype:OpType; VAR resTyp:StrPtr;
                  VAR signed:BOOLEAN):BOOLEAN;
VAR
 lsign,rsign:BOOLEAN;
 szl,szr:WidType;
 lf,rf:StrForm;
 t:Item;
BEGIN
 IF l.typ^.form<r.typ^.form THEN t:=l; l:=r; r:=t END;
 WITH l.typ^ DO
  lf:=form;
  IF (lf=Range) & (RBaseTyp^.form#UInt) THEN
   l.typ:=RBaseTyp; lf:=RBaseTyp^.form
  END
 END;
 WITH r.typ^ DO
  rf:=form;
  IF (rf=Range) & (RBaseTyp^.form#UInt) THEN
   r.typ:=RBaseTyp; rf:=RBaseTyp^.form
  END
 END;
 resTyp:=l.typ;
 CASE lf OF
 | Bool: optype:=boolOp; RETURN rf=Bool;
 | Char: optype:=charOp; RETURN rf=Char;
 | UInt: signed:=TRUE; RETURN rf=UInt;
 | Enum: optype:=enumOp; RETURN l.typ=r.typ;
 | Range:
  signed:=l.typ^.sign;
  Isz(l,szl);
  IF r.mode=vconMd THEN szr:=ConstSize(r.val.conLI,signed) DIV 2 ELSE Isz(r,szr) END;
  IF szl<szr THEN szl:=szr END;
  resTyp:=tp.numtyp[szl,signed];
  RETURN (rf=UInt) OR (rf=Range) & (l.typ^.sign=r.typ^.sign);
 | FFP,Real,LReal: optype:=realOp; RETURN rf=lf;
 | UReal: optype:=realOp; resTyp:=r.typ; RETURN (FFP<=rf) & (rf<=UReal);
 | Set: optype:=setOp; RETURN l.typ=r.typ;
 | BPointer:
  optype:=opaqueOp;
  RETURN (l.typ=r.typ) OR (l.typ=tp.bptrtyp) OR (r.typ=tp.bptrtyp)
         OR ((l.mode=vconMd) & (l.typ=tp.addrtyp) & (l.val.conLI=nil))
         OR ((r.mode=vconMd) & (r.typ=tp.addrtyp) & (r.val.conLI=nil));
 | Pointer,ProcTyp,Opaque:
  optype:=opaqueOp; RETURN (l.typ=r.typ) OR (l.typ=tp.addrtyp) OR (r.typ=tp.addrtyp);
 ELSE
(*BreakPoint(ADR("4084"));*)
  Mark(4084); MarkForm(lf)
 END;
 RETURN FALSE
END CalcComp;

PROCEDURE DoLoad(VAR x: Item);
BEGIN
  IF x.mode#vconMd THEN LoadD(x,TRUE) END
END DoLoad;

PROCEDURE GenOp(op:Symbol; VAR x,y:Item);
VAR
 f,g:StrForm;
 c:Condition;
 xval,yval:ConstValue;
 optype:OpType;
 signed,xext,yext: BOOLEAN;
BEGIN
(* Debug.Item("GenOp X", x); Debug.Item("GenOp Y", y);*)
 ToLoadTest(x);
 ToLoadTest(y);
 (* 20.12.90/bp conString+conString ==> catenate! *)
 (* 3.1.91/bp Auch CHAR zugelassen! *)
 IF (op=plus) THEN
   IF (x.mode=vconMd)&(x.typ=tp.chartyp) THEN
     AllocChar(CHR(x.val.conLI),x.val,FALSE);
     x.mode:=memconMd; x.typ:=tp.stringtyp; x.conOffset:=0;
   END;
   IF (y.mode=vconMd)&(y.typ=tp.chartyp) THEN
     AllocChar(CHR(y.val.conLI),y.val,FALSE);
     y.mode:=memconMd; y.typ:=tp.stringtyp; y.conOffset:=0;
   END;
   IF (x.mode=memconMd)&(y.mode=memconMd)
    &(y.typ=tp.stringtyp)&(x.typ=tp.stringtyp) THEN
     AppendString(x.val,y.val);
     Release(y); (* momentan noch berflssig... *)
     RETURN
   END;
 END;
 optype:=numericOp; signed:=FALSE;
 IF (op#in) & ~CalcComp(x,y,optype,resultTyp,signed) THEN
  Mark(4027); optype:=undfOp;
 END;
 IF (x.typ^.form<=UReal) & (y.typ^.form<=UReal) THEN
  ConvertTyp(x,resultTyp); ConvertTyp(y,resultTyp);
 END;
 IF optype=realOp THEN FPreProcess(op,x,y);
 ELSIF optype#undfOp THEN PreProcess(op,x,y);
 END;
 CASE op OF
 | in:
  IF (y.typ^.form=Set) & AssignComp(y.typ^.SBaseTyp,x.typ) THEN
   ConvertTyp(x,y.typ^.SBaseTyp); In2(x,y);
  ELSE
   Mark(4024);
  END
 | div: IF optype=numericOp THEN Div2(x,y) ELSE Mark(4030) END
 | rem: IF optype=numericOp THEN Rem2(x,y) ELSE Mark(4031) END
 | mod: IF optype=numericOp THEN Mod2(x,y) ELSE Mark(4032) END
 | and: IF optype=boolOp    THEN And2(x,y) ELSE Mark(4033) END
 | or:  IF optype=boolOp    THEN Or2(x,y)  ELSE Mark(4036) END
 | times: (* x=conMd -> y=conMd *)
  IF optype=numericOp THEN Mul2(x,y)
  ELSIF optype=realOp THEN FMul2(x,y)
  ELSIF optype=setOp THEN DoLoad(x); IAnd2(x,y)(*damit x nicht verndert wird *)
  ELSE Mark(4028)
  END
 | slash:
  IF optype=numericOp THEN Quo2(x,y);
  ELSIF optype=realOp THEN FDiv2(x,y);
  ELSIF optype=setOp THEN IEor2(x,y);
  ELSE Mark(4029);
  END
 | plus: (* x=conMd -> y=conMd *)
  IF optype=realOp THEN FAdd2(x,y)
  ELSE
   DoLoad(x); (* damit '+' NICHT INC oder INCL wird *)
   IF optype=numericOp THEN Add2(x,y)
   ELSIF optype=setOp THEN IOr2(x,y)
   ELSE Mark(4034)
   END
  END
 | minus:
  IF optype=realOp THEN FSub2(x,y);
  ELSIF optype=numericOp THEN DoLoad(x); Sub2(x,y);
 (* 30.4.89/ms DoLoad anstelle IF ~constOp THEN LoadD(x) END *)
 (* 20.12.90/bp Hierdurch wird die ConstOp Set-Set verboten!!!?? *)
  ELSIF optype=setOp THEN Com1(y); DoLoad(x); IAnd2(x,y)
  ELSE Mark(4035);
  END
 | eql:
  IF optype=realOp THEN FCmp2(x,y,NE);
  ELSIF optype#undfOp THEN Cmp2(x,y,NE);
  ELSE Mark(4037); setCC(x,NE);
  END;
 | neq:
  IF optype=realOp THEN FCmp2(x,y,EQ);
  ELSIF optype#undfOp THEN Cmp2(x,y,EQ);
  ELSE Mark(4038); setCC(x,EQ);
  END;
 | lss:
  IF optype=realOp THEN FCmp2(x,y,GE);
  ELSIF (optype=numericOp) & signed THEN Cmp2(x,y,GE);
  ELSIF optype=boolOp THEN Cmp2(x,y,CS);
  ELSIF (optype#setOp) & (optype#undfOp) & (optype#opaqueOp) THEN Cmp2(x,y,CC);
  ELSE Mark(4039); setCC(x,CC);
  END;
 | leq:
  IF optype=realOp THEN FCmp2(x,y,GT);
 (* 30.4.89/ms
  * Hier musste ein DoLoad() eingefgt werden um bei set1<=set2 set1 nicht
  * zu verndern.
  *)
  ELSIF optype=setOp THEN Com1(y); DoLoad(x); IAnd2(x,y); setCC(x,NE);
  ELSIF (optype=numericOp) & signed THEN Cmp2(x,y,GT);
  ELSIF optype=boolOp THEN Cmp2(x,y,LS);
  ELSIF (optype#undfOp) & (optype#opaqueOp) THEN Cmp2(x,y,HI);
  ELSE Mark(4040); setCC(x,HI);
  END;
 | gtr:
  IF optype=realOp THEN FCmp2(x,y,LE);
  ELSIF (optype=numericOp) & signed THEN Cmp2(x,y,LE);
  ELSIF optype=boolOp THEN Cmp2(x,y,HI);
  ELSIF (optype#setOp) & (optype#undfOp) & (optype#opaqueOp) THEN Cmp2(x,y,LS);
  ELSE Mark(4041); setCC(x,LS);
  END;
 | geq:
  IF optype=realOp THEN FCmp2(x,y,LT);
  ELSIF optype=setOp THEN Com1(x); IAnd2(x,y); setCC(x,NE);
  ELSIF (optype=numericOp) & signed THEN Cmp2(x,y,LT);
  ELSIF optype=boolOp THEN Cmp2(x,y,CC);
  ELSIF (optype#undfOp) & (optype#opaqueOp) THEN Cmp2(x,y,CS);
  ELSE Mark(4042); setCC(x,CS);
  END;
 END (*CASE op*);
 Release(y);
END GenOp;

PROCEDURE GenStParam(VAR p,x:Item; fctno:Standard; parno:INTEGER;
                     morepar:BOOLEAN);
VAR
 restyp:StrPtr;
 f,sf:StrForm;
 y,z:Item;
 r:Register;
 sz:WidType;
 shi:ShiType;
 li:LONGINT;
 hi,lo:ConstValue;
 i,j:INTEGER;
 op:Symbol;
 regmask: BITSET;
BEGIN
 (* Edgar hat noch einige Macken bei ADR() aufgedeckt 1.7.90/bp
  * Deshalb nun hier immer ToLoadTest!
  * 12.2.91/bp
  * .. auer bei CAST. CAST mu GERADE! Das geht auch nicht!!!
  * OpenWindow(CAST(NwPtr,ADR(NewWin))^); <-- err 7011 in LoadP
  *)
 ToLoadTest(x);
 WITH x DO
  IF parno=0 THEN (* 1. Parameter *)
   restyp:=p.proc^.typ; (* kein SRTest!!, jede Funktion macht's selber *)
   f:=typ^.form;
   IF f=Range THEN sf:=typ^.RBaseTyp^.form; ELSE sf:=f; END;
   CASE fctno OF
   | Abs:
    restyp:=typ; (* same type as argument type! JR what about subrange ?? *)
    IF NumT(x) THEN Abs1(x);
    ELSIF (FFP<=f) & (f<=UReal) THEN FAbs1(x)
    ELSE Mark(4043)
    END;
   | Adr:
    IF ((mode=modMd) & (module^.mode#library))
       OR (mode=vconMd)&(typ#tp.chartyp) THEN Mark(4003); END;
    IF (mode=vconMd)&(typ=tp.chartyp) THEN
      AllocChar(CHR(val.conLI),val,TRUE);
      mode:=memconMd; typ:=tp.stringtyp; conOffset:=0;
    END;
    IF mode=memconMd THEN PutInBuffer(val) END;
    (* LoadAdr(x);*)
    adrtoload:=TRUE;
   | Cast,Val:
    restyp:=tp.undftyp;
    IF ~morepar THEN
     Mark(4002) (* 2 parameters required *)
    ELSE
     IF mode=typMd THEN restyp:=typ; (* see you later *)
     ELSE Mark(4015); restyp:=tp.notyp
     END;
    END;
   | Cap: IF sf=Char THEN Cap1(x) ELSE Mark(4044) END
   | Chr: IF NumT(x) THEN ConvertTyp(x,tp.chartyp) ELSE Mark(4045) END
   | Float:
    IF NumT(x) THEN FFlt1(x,tp.realtyp);
    ELSE Mark(4046);
    END;
    restyp:=tp.realtyp;
   | Halt: GenHalt(0);
   | High:
    IF (mode<vconMd) & (f=Array) THEN
     IF typ^.dyn THEN
      GetHigh(x);
      LoadD(x,TRUE);
     ELSE
      restyp:=typ^.IndexTyp;
      IF restyp^.form=Range THEN
       Mark(4047);
       li:=restyp^.max; restyp:=restyp^.RBaseTyp;
      ELSE
       Mark(4048); Release(x); li:=0
      END;
      SetconMd(x,li,restyp);
     END;
    ELSE
     Mark(4049)
    END;
   | Max:
    IF mode=typMd THEN (* transform to 'vconMd' *)
     mode:=vconMd;
     (* 30.8.92/bp Die beiden naechsten Anweisungen eingefuegt,
      * da sonst bei LReal nur size=4?
      *)
     conOffset:=0;
     size:=typ^.size;
     val.inMem:=FALSE;
     val.conConvType:=NIL;
     val.conSign:=0;
     CASE f OF
     | Bool: val.conLI:=1;
     | Char: val.conLI:=0FFH;
     | Enum: val.conLI:=typ^.eMax; (* sign:=0! *)
     | FFP: val.conSign:=43DFFFFFH; val.conLI:=CAST(LONGINT,0E0000000H);
     | Real: val.conSign:=47EFFFFFH; val.conLI:=CAST(LONGINT,0E0000000H);
     | LReal: val.conSign:=07FEFFFFFH; val.conLI:=CAST(LONGINT,0FFFFFFFFH);
     | Range:
      val.conLI:=typ^.max; IF typ^.sign & (val.conLI<0) THEN val.conSign:=-1; END;
      typ:=typ^.RBaseTyp;
     ELSE
      Mark(4050); SetconMd(x,0,tp.undftyp);
     END;

     restyp:=typ;
    ELSE
     Mark(4051)
    END;
   | Min:
    IF mode=typMd THEN (* transform to 'vconMd' *)
     mode:=vconMd;
     (* 30.8.92/bp Die beiden naechsten Anweisungen eingefuegt,
      * da sonst bei LReal nur size=4?
      *)
     conOffset:=0;
     size:=typ^.size;
     val.inMem:=FALSE;
     val.conConvType:=NIL;
     val.conSign:=0;
     CASE f OF
     | Bool: val.conLI:=0;
     | Char: val.conLI:=0;
     | Enum: val.conLI:=typ^.eMin; (* sign:=0!! *)
     | FFP: val.conSign:=CAST(LONGINT,0C3DFFFFFH); val.conLI:=CAST(LONGINT,0E0000000H);
     | Real: val.conSign:=CAST(LONGINT,0C7EFFFFFH); val.conLI:=CAST(LONGINT,0E0000000H);
     | LReal: val.conSign:=CAST(LONGINT,0FFEFFFFFH); val.conLI:=CAST(LONGINT,0FFFFFFFFH);
     | Range:
      val.conLI:=typ^.min; IF typ^.sign & (val.conLI<0) THEN val.conSign:=-1; END;
      typ:=typ^.RBaseTyp;
     ELSE
      Mark(4052); SetconMd(x,0,tp.undftyp);
     END;
     restyp:=typ;
    ELSE
     Mark(4053)
    END;
   | Odd:
    IF NumT(x) THEN
     SetconMd(y,0,typ); op:=in; PreProcess(op,y,x); In2(y,x); x:=y;
    ELSE Mark(4054)
    END;
   | Ord:IF sf<Range THEN ConvertTyp(x,restyp); restyp:=typ ELSE Mark(4055) END;
   | Reg:
    IF (typ=tp.uinttyp) & (0<=val.conLI) & (val.conLI<=15) THEN
     (* register numbers in [0.. 15] *)
     r:=val.conLI;
     SetregMd(x,r,restyp);
     SetbusyReg(r);
    ELSE
     Mark(4056)
    END;
   | Size:
    IF mode<=vconMd THEN
     IF (f=Array) & typ^.dyn THEN
      SetconMd(y,typ^.ElemTyp^.size,tp.uinttyp);
      GetHigh(x); LoadD(x,TRUE); Inc1(x);
      constOp:=FALSE; resultTyp:=typ; Mul2(x,y);
     ELSE SetconMd(x,typ^.size,tp.uinttyp);
     END;
    ELSIF mode=memconMd THEN
     SetconMd(x,val.conSize,tp.uinttyp);
    ELSIF mode=typMd THEN
     SetconMd(x,typ^.size,tp.uinttyp);
    ELSE
     Mark(4058); Release(x);
     SetconMd(x,0,tp.uinttyp);
    END;
    restyp:=typ;
   | Tag: (* Gre der VAR bestimmen und festhalten! *)
    IF ~morepar THEN
      Mark(4090);
    ELSIF (mode <= RidxMd)& ~((f=Array) & typ^.dyn) THEN
      restyp:=typ; (* Gre behalten! *)
      LoadAdr(x);
      x.mode:=RindMd; x.off:=0; x.adr:=0;
    ELSE
      Mark(4091);
      restyp:=tp.notyp;
      (*...???*) (* weiteres unterbinden! *)
    END;
   | Tsize:
    IF mode=typMd THEN li:=typ^.size
    ELSE Mark(4059); Release(x); li:=0
    END;
    SetconMd(x,li,restyp);
   | Shift:
    restyp:=tp.undftyp;
    IF ~morepar THEN Mark(4061) (* 2 parameters required *)
    ELSE
     IF NumT(x) THEN
      restyp:=tp.numtyp[long,SignedT(x)]; (* see you later *)
      ConvertTyp(x,restyp);
     ELSE Mark(4062); restyp:=tp.notyp
     END;
    END;
   | Dec,Inc: (* bei memconMd ist f>=String, also ok! 16.4.91/bp NEIN!! *)
    IF (mode#vconMd) & (mode#memconMd) & ((f<=Range) OR (f=BPointer) OR (f=Pointer)) THEN
     IF morepar THEN restyp:=typ
     ELSIF fctno=Dec THEN Dec1(x)
     ELSE Inc1(x)
     END
    ELSE Mark(4066)
    END
   | Excl,Incl:
    IF ~morepar THEN Mark(4067) (* 2 parameters required *)
    ELSE
     (* 13.3.91/bp auch DregMd erlaubt!!! *)
     IF ((mode<vconMd) OR (mode=DregMd)) & (f=Set) THEN restyp:=typ;
     ELSE Mark(4068)
     END;
    END;
   | Setreg:
    IF ~morepar THEN
     Mark(4070) (* 2 parameters required *)
    ELSE
     IF typ=tp.uinttyp THEN restyp:=typ; (* see you later *)
     ELSE Mark(4071)
     END;
    END;
   | Trunc: IF (FFP<=f) & (f<=UReal) THEN FFix1(x) ELSE Mark(4072) END;
   | Facos..Ftanh:
     IF (f=LReal) OR (f=UReal) THEN
       FFpu1(x,fctno);
     ELSE
       Mark(4093)
     END;
   | Loadregs,Saveregs:
    IF (mode=vconMd) & (typ = tp.bsettyp) THEN
     IF fctno=Saveregs THEN
      (*$ RangeChk:=FALSE OverflowChk:=FALSE *)
      regmask:=BITSET{}; j:=0;
      FOR i:=15 TO 0 BY -1 DO
       IF i IN val.conSet THEN
        INCL(regmask,j);
       END;
       INC(j);
      END;
      (*$ POP RangeChk POP OverflowChk *)
      PutWord(movemmL+adec+sp); PutWord(CAST(INTEGER,regmask));
     ELSE
      PutWord(movemL+ainc+sp);
      (*$ RangeChk:=FALSE *)
      PutWord(INTEGER(val.conLI));
      (*$ POP RangeChk *)
      (* 12.3.90/bp Fast vergessen: ! *)
      RegsDestroyed(CAST(RegisterSet,val.conLI));
     END;
    ELSE
     Mark(4057)
    END;
   | NonStand:
   END (*CASE*);
   p:=x;
   IF (((mode=DregMd) & (R=d0)) OR ((mode=fltMd)&(FR=d0)))
     & ~Islocked(d0) THEN Release(x); NeedD0(p); END;
   p.typ:=restyp;
   IF restyp=tp.notyp THEN Release(x) END;
  ELSIF (parno=1)OR(fctno=Tag) THEN (* 2. Parameter *)
   restyp:=p.typ;
   (*IF (fctno#Cast) & (fctno#Val) THEN SRTest(x); END;*)
   f:=typ^.form; IF f=Range THEN sf:=typ^.RBaseTyp^.form; ELSE sf:=f; END;
   CASE fctno OF
   | Tag:
    IF restyp#tp.notyp THEN
      IF parno*4>p.typ^.size THEN
        Mark(4092);
      ELSE
        y:=p;
        y.typ:=tp.addrtyp; (* Schein-Array! *)
        IF f=Set THEN (* auch Sets ohne CAST erlauben! *)
          typ:=tp.numtyp[typ^.size DIV 2,FALSE]
        END;
	PushOption(rngchk,FALSE); PushOption(ovflchk,FALSE);
        ConvertTyp(x,tp.addrtyp);
	IF morepar THEN trickAidr:=TRUE; RegDestroyed(p.R) END;
        Move(x,y); (* lscht trickAidr selbst! *)
	PopOption(rngchk); PopOption(ovflchk);
        Release(x); (* Wieso macht Move das nicht? *)
        (*IF (y.mode#p.mode) OR (y.R#p.R) THEN Release(y) END;*)
      END;
      IF ~morepar THEN
        p.typ:=tp.addrtyp;
        (*p.mode:=AregMd; bleibt RindMd! *)
        p.indir:=FALSE;
        p.adr:=-(parno-1)*4;
        p.adrtoload:=TRUE;
      END;
    ELSIF ~morepar THEN
      p.typ:=tp.addrtyp; (* damit keine unsinnige Fehlermeldung! *)
    END;
   | Shift:
    IF NumT(x)&(mode#memconMd) THEN
     IF (mode=vconMd) & (p.mode=vconMd) THEN
      p.val.conLI:=SHIFT(p.val.conLI,val.conLI);
     ELSE
      LoadD(p,TRUE); (* load p *)
      IF SignedT(p) THEN shi:=Asl ELSE shi:=Lsl END;
      Ash2(p,x,shi); (* arithmetic/logical shift *)
      (* p.typ:=restyp;   resulting type is already set *)
     END;
    ELSE
     Mark(4073); Release(x);
    END;
   | Cast:
     IF (mode=vconMd)OR(mode=memconMd) THEN
       f:=restyp^.form; i:=restyp^.size;
       IF mode=memconMd THEN
         IF val.conSize#i THEN Mark(4009); END;
         IF i>4 THEN Mark(4020); i:=4; END;
         (* 16.4.91/bp Neue Methode! *)
         val.conLI:=GetConstVal(val,0);
         val.conSign:=0;
         val.conPrev:=NIL;
         mode:=vconMd;
         val.inMem:=FALSE;
         size:=i;
       ELSIF typ^.form=UReal THEN (* 12.2.91/bp *)
         IF i<=4 THEN (* verkleinern! *)
           IF val.conConvType=tp.realtyp THEN
	     ConvLRConstTo(x,Real);
	   ELSIF val.conConvType=tp.ffptyp THEN
	     ConvLRConstTo(x,FFP);
	   END; (* else: size bleibt 8, gibt spter Fehler! *)
         END;
       ELSE (* kein String, kein LReal *)
         size:=0; Isz(x,sz); (* sz is wom. Beschissne Ausnutzung eines Sideeffects *)
       END;
       IF size>i THEN Mark(4064); size:=i END;
       IF (f=Range) & restyp^.sign THEN
         IF i=1 THEN IF (val.conLI>maxSInt) THEN DEC(val.conLI,maxSCard+1) END
         ELSIF (i=2) & (val.conLI>maxInt) THEN DEC(val.conLI,maxCard+1)
         END;
         IF val.conLI<0 THEN val.conSign:=-1; ELSE val.conSign:=0; END;
       ELSIF i<=4 THEN
         val.conSign:=0;
         IF i=1 THEN val.conLI:=LONGINT(CAST(LONGCARD,val.conLI) MOD (maxSCard+1));
         ELSIF i=2 THEN val.conLI:=LONGINT(CAST(LONGCARD,val.conLI) MOD (maxCard+1));
         END;
       END;
       IF f=Range THEN
         restyp:=restyp^.RBaseTyp;
       ELSIF (FFP<=f) & (f<=UReal) THEN
         IF typ^.form=UReal THEN
           restyp:=tp.urealtyp;
         ELSE
           Mark(4065)
         END;
       END;
       typ:=restyp;
     ELSIF typ^.size=restyp^.size THEN typ:=restyp;
     ELSE Mark(4063);
     END;
     p:=x               (* resulting item is p !! *)
   | Val: ConvertTyp(x,restyp); p:=x;
   | Dec,Inc:
    IF restyp#tp.notyp THEN
     IF sf=UInt THEN
      IF mode=vconMd THEN SetconMd(x,val.conLI,restyp);
      ELSE
       Isz(p,sz); LoadX(x,sz,FALSE); typ:=restyp;
       (* LoadX(FALSE) weil: SOLL ja zerstrt werden!/bp *)
      END;
      constOp:=FALSE; resultTyp:=restyp;
      IF fctno=Inc THEN Add2(p,x) ELSE Sub2(p,x) END
     ELSE
      Mark(4074);
     END;
    END;
   | Excl,Incl:
    IF restyp#tp.notyp THEN
     IF AssignComp(typ,restyp^.SBaseTyp) THEN
      constOp:=FALSE;
      IF mode=vconMd THEN
       SetLimits(restyp^.SBaseTyp,lo,hi);
       IF (val.conLI<lo.conLI) OR (hi.conLI<val.conLI) THEN Mark(4075); val.conLI:=0 END;
       (*
        * 27.3.89/ms
        *	Dieser Ausdruck produziert einen berlauf wenn Bit 31
        *       EXCLuded wird.
        *)
       (*$ OverflowChk:=FALSE RangeChk:=FALSE *)
       li:=SHIFT(1,val.conLI);
       IF fctno=Excl THEN li:=-1-li END;
       (*$ POP OverflowChk POP RangeChk *)
       SetconMd(y,li,restyp);
       IF fctno=Excl THEN IAnd2(p,y) ELSE IOr2(p,y) END;
      ELSE
       ConvertTyp(x,restyp^.SBaseTyp);
       GetReg(r,Dreg); SetregMd(y,r,restyp); SetconMd(z,1,restyp); Move(z,y);
       Shi2(y,x,Lsl);
       IF fctno=Excl THEN Com1(y); IAnd2(p,y) ELSE IOr2(p,y) END;
       ReleaseReg(r);
      END;
     ELSE (*typ#restyp*)
      Mark(4077);
     END;
    END;
   | Setreg:
    IF restyp#tp.notyp THEN
     IF (p.typ=tp.uinttyp) & (0<=p.val.conLI) & (p.val.conLI<=15) THEN
      r:=p.val.conLI;
      SetregMd(p,r,tp.numtyp[long,TRUE]);
      SetbusyReg(r);
      (* 16.4.91/bp Das mit memconMd ist nicht dokumentiert! *)
      IF (mode=procMd) OR (mode=memconMd) THEN
        IF mode=memconMd THEN PutInBuffer(val) END;
        MoveAdr(x,p)
      ELSIF (typ^.size=4) THEN Move(x,p)
      ELSE Mark(4079)
      END;
     ELSE
      Mark(4087);
     END;
    END;
   ELSE (*CASE fctno OF*)
    Mark(4080);
   END;
   IF (fctno#Val) & (fctno#Cast) & (fctno#Shift) & (fctno#Tag) THEN
    Release(p);                          (* for all standard procedures: *)
    Release(x);
    p.typ:=tp.notyp; (* no result-typ for procs. *)
   ELSIF (p.mode=DregMd) & (p.R=d0) THEN
    Release(x);
    NeedD0(p);
   END;
  ELSE (* 3. and following Parameters *)
   SRTest(x);
   Mark(4082);
   Release(x);
  END;
 END (*WITH*);
END GenStParam;

PROCEDURE GenStFct(fctno:Standard; parno:INTEGER);
VAR
 must:INTEGER;
BEGIN
 CASE fctno OF
 | Abs,Adr,Cap,Chr,Float,High,Max,Min,Odd,Ord,Reg,Size,Tsize,Trunc: must:=1;
 | Cast,Excl,Incl,Setreg,Shift,Val,Tag: must:=2;
 | Dec,Inc,Loadregs,Saveregs,Facos..Ftanh: must:=1;
 | Halt: must:=0;
 | NonStand: ;
 END (*CASE*);
 IF (fctno<NonStand) OR (must#0) THEN
  IF parno<must THEN Mark(4083) END;
 END;
END GenStFct;

END M2EM.
