(*                _____________________________________________
 *         //    /                                             \         //
 *        //     \          Amiga Run Time System              /        //
 *    \\ //      /           4.10 / 02.08.91 / bp              \    \\ //
 *     \X/       \_____________________________________________/     \X/
 *
 *   default options for Arts:
 * ====== Library Version ======
 *)


(*$ LargeVars:=FALSE
    StackChk:=FALSE
    OverflowChk:=FALSE
    RangeChk:=FALSE
    ReturnChk:=FALSE
    NilChk:=FALSE
    LongAlign:=FALSE
    Volatile:=FALSE
    StackParms:=FALSE
 *)

(*$ IF m68010 *) Dieser Text fhrt absichtlich zu einem Syntax-Fehler!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!  Arts darf niemals fr 68010 oder hhere compiliert werden,    !!
!!  weil sonst endlose Requester-Schleife "Ungltige Instruktion",!!
!!  wenn das Programm nicht auf der richtigen CPU luft!          !!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	     Einzige Lsung wre: ALLES in Assembler.
(*$ ENDIF *)

IMPLEMENTATION MODULE Arts;

FROM SYSTEM IMPORT
 ADDRESS,ADR,ASSEMBLE;
FROM ExecD IMPORT Library;
FROM ExecL IMPORT OpenLibrary,CloseLibrary;
(* nur die Offsets aus ExecL bentigt! *)

CONST
  vbit=2;

VAR
  exec[4]: ADDRESS;
  stackTop:LONGINT;
  openEnd:ADDRESS;
  inGuru:SHORTINT;

(*
 * Startup initialisiert die Library
 * D0=libraryPtr (own) in dosCmdLen
 * A0=segList in dosCmdBuf
 * Result: libBase oder NIL
 *)
(*$ EntryExitCode:=FALSE *)
PROCEDURE Startup(lp{0}:LONGINT; sl{8}: ADDRESS): LONGINT;
BEGIN
  ASSEMBLE(
	XREF	_LinkerDB,__main
	XREF	__BSSBAS, __BSSLEN

 	MOVEM.L	D2/A4,-(A7)
	LEA	_LinkerDB,A4

	LEA	__BSSBAS,A1
	MOVEQ	#0,D1
	MOVE.L	#__BSSLEN,D2
	BRA.S	clr_lp
clr_bss:MOVE.L	D1,(A1)+	(* BSS-Bereich lschen! Halbresident! *)
clr_lp:	DBRA	D2,clr_bss

	MOVE.L	D0,dosCmdLen(A4)
	MOVE.L	A0,dosCmdBuf(A4)
	MOVE.L	A7,stackTop(A4)
	MOVE.L	4,A0
	MOVE.W	Library.version(A0),kickVersion(A4)
	LEA	openErr(PC),A0
	MOVE.L	A0,openEnd(A4)
(*
 * Library-Initialisierung
 *)
	JSR	__main(PC)
	MOVE.L	dosCmdLen(A4),D0 (* libBase oder NIL bei Fehler *)
	BNE.S	iniOk	(* alles klar, raus *)

(* bei Open-Error alles schlieen *)
openErr:MOVE.L	stackTop(A4),A7
	BSR	Terminate

	MOVEQ	#0,D0
iniOk:
 	MOVEM.L	(A7)+,D2/A4
	RTS

	END);
END Startup;


(*$ EntryExitCode:=FALSE *)
PROCEDURE Terminate;
BEGIN
  ASSEMBLE(
	XREF	_LinkerDB,__mainEnd
	MOVE.L	A4,-(A7) (* gleiche Regs wie Startup!! *)
	LEA	_LinkerDB,A4
	BSET	#0,inGuru(A4)
	BNE.S	isGuru
	JSR	__mainEnd(PC)
	MOVEQ	#0,D0
isGuru:	MOVE.L	(A7)+,A4
	RTS
  END);
END Terminate;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Guru;
BEGIN
  ASSEMBLE(
	ILLEGAL
  END);
END Guru;

PROCEDURE Requester(header,body,pos,neg: ADDRESS): BOOLEAN;
BEGIN
  RETURN FALSE
END Requester;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Exit(retVal{0}:LONGINT);
BEGIN
  ASSEMBLE(
    BRA	Guru
  END);
END Exit;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SystemError(err{0}: SysErr);
BEGIN
  ASSEMBLE(
    BRA	Guru
  END);
END SystemError;

(*$ EntryExitCode:=FALSE *)
PROCEDURE StkChk(need{0}: LONGINT);
BEGIN
 ASSEMBLE(
	RTS
 END);
END StkChk;

PROCEDURE Assert(condition: BOOLEAN; msg: ADDRESS);
BEGIN
 IF ~condition THEN
   Guru
 END
END Assert;

PROCEDURE BreakPoint(msg: ADDRESS);
END BreakPoint;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Error(header,body: ADDRESS);
BEGIN
  ASSEMBLE(
    BRA	Guru
  END);
END Error;

(* 32-bit arithmetic subroutines for LONGINT and LONGCARD *)
CONST
  X=0; Y=1;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Mulu32(x{X}, y{Y}: LONGINT): LONGINT;
(*
 * [A*hi + B]*[C*hi + D] = [A*C*hi^2 + (A*D + B*C)*hi + B*D]
 *)
(* CONST T1=d2; A=d3; C=d4;*)
BEGIN
  ASSEMBLE(
	MOVEM.L D2-D4,-(A7)
	MOVE.L  x,D2
	MOVE.L  x,D3
	SWAP    D3
	MOVE.L  y,D4
	SWAP    D4
	MULU    y,x
	MULU    D3,y
	MULU    D4,D2
	MULU    D4,D3
	SWAP    x
	ADD.W   y,x
	MOVEQ   #0,D4
	ADDX.L  D4,D4
	ADD.W   D2,x
	ADDX.L  D4,D3
	SWAP    x
	CLR.W   y
	SWAP    y
	CLR.W   D2
	SWAP    D2
	ADD.L   D2,y
	ADD.L   D3,y
	BEQ.S   Mulu32a
	ORI     #vbit,CCR
  Mulu32a:
	MOVEM.L (A7)+,D2-D4
	RTS
  END);
END Mulu32;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Muls32(x{X}, y{Y}: LONGINT): LONGINT;
(* CONST X1=d2; Y1=d3;*)
BEGIN
  ASSEMBLE(
	MOVEM.L D2-D3,-(A7)
	MOVE.L  x,D2
	MOVE.L  y,D3
	BSR.S   Mulu32
	TST.L   D2
	BPL.S   L000029
	SUB.L   D3,y
  L000029:
	TST.L   D3
	BPL.S   L000030
	SUB.L   D2,y
  L000030:
	TST.L   x
	BPL.S   L000031
	NOT.L   y
  L000031:
	TST.L   y
	BEQ.S   L000032
	ORI     #vbit,CCR
  L000032:
	MOVEM.L (A7)+,D2-D3
	RTS
  END);
END Muls32;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Divu32(x{X}, y{Y}: LONGINT): LONGINT;
(*
 * [A*hi + B] DIV y = [(A DIV y)*hi + (A MOD y*hi + B) DIV y]
 *)
(* CONST QUO=d2; T1=d3;*)
BEGIN
  ASSEMBLE(
	MOVEM.L D2-D3,-(A7)
	MOVEQ   #0,D2
	CMP.L   #$0000FFFF,y
	BHI.S   L000025
	DIVU    y,x
	BVC.S   L000024
	MOVE.W  x,D3
	CLR.W   x
	SWAP    x
	DIVU    y,x
	MOVE.W  x,D2
	SWAP    D2
	MOVE.W  D3,x
	DIVU    y,x
  L000024:
	MOVE.W  x,D2
	CLR.W   x
	SWAP    x
	BRA.S   L000028
  L000025:
	MOVE.W  x,D2
	SWAP    D2
	CLR.W   x
	SWAP    x
	MOVEQ	#15,D3
  L000026:
	LSL.L   #1,D2
	ROXL.L  #1,x
	CMP.L   y,x
	BCS.S   L000027
	SUB.L   y,x
	ADDQ.W  #1,D2
  L000027:
	DBRA    D3,L000026
  L000028:
	MOVE.L  D2,y
	MOVEM.L (A7)+,D2-D3
	RTS		                 (* d0=REM, d1=QUO *)
  END);
END Divu32;

(*$ EntryExitCode:=FALSE *)
PROCEDURE Divs32(x{X}, y{Y}: LONGINT): LONGINT;
(* CONST sX=d2; sY=d3;*)
BEGIN
  ASSEMBLE(
	MOVEM.L D2-D3,-(A7)
	TST.L   x
	SMI     D2
	BPL.S   L000033
	NEG.L   x
  L000033:
	TST.L   y
	SMI     D3
	BPL.S   L000034
	NEG.L   y
  L000034:
	BSR.S   Divu32
	CMP.B   D2,D3	 (* adjust DIV *)
	BEQ.S   L000035
	NEG.L   y
  L000035:
	TST.B   D2	 (* adjust MOD *)
	BEQ.S   L000036
	NEG.L   x
  L000036:
	MOVEM.L (A7)+,D2-D3
	RTS
  END);
END Divs32;

(*$ EntryExitCode:=FALSE *)
PROCEDURE OpenLib(version{0}:LONGINT; name{9}:ADDRESS):ADDRESS;
BEGIN
  ASSEMBLE(
	MOVE.L	A6,-(A7) (* A4 ist sicher ok! *)
	MOVEA.L	exec,A6
	JSR	OpenLibrary(A6)
	MOVE.L	(A7)+,A6
	TST.L	D0
	BNE.S	ok
	CLR.L	dosCmdLen(A4)
	MOVE.L	openEnd(A4),A0
	JMP	(A0)
  ok:	RTS
	END);
END OpenLib;

(*$ EntryExitCode:=FALSE *)
PROCEDURE CloseLib(base{9}:ADDRESS);
(* Wenn Fehler whrend der Openphase kann hier bei Close NIL kommen! *)
BEGIN
  ASSEMBLE(
	MOVE.L	base,D0
	BEQ.S	nono
	MOVE.L	A6,-(A7)
	MOVEA.L	exec,A6
	JSR	CloseLibrary(A6)
	MOVE.L	(A7)+,A6
  nono:	RTS
	END);
END CloseLib;


(*$ EntryExitCode:=FALSE *)
BEGIN (* Arts tut nichts! *)
  ASSEMBLE(RTS END);
CLOSE
  ASSEMBLE(RTS END);
END Arts.mod
