MODULE KillM2Debug;
(* 2.10.90/bp Beendet den residenten Debug-Prozess *)

(*$ LargeVars:=FALSE StackParms:=FALSE Volatile:=FALSE StackChk:=FALSE
    RangeChk:=FALSE NilChk:=FALSE OverflowChk:=FALSE
 *)

FROM SYSTEM	IMPORT	ADR,ADDRESS,SETREG;
FROM Arts	IMPORT	Assert;
FROM DebugDef	IMPORT	debPortName,magicDebug, magicOk,magicErr,
			magicTerminate,DebugMsgPtr;
FROM ExecD	IMPORT	MessagePtr,MsgPortPtr,NodeType;
FROM ExecL	IMPORT	FindPort,Forbid,GetMsg,Permit,PutMsg,WaitPort;
FROM ExecSupport IMPORT	CreatePort, DeletePort;
FROM Terminal	IMPORT	WriteString;
FROM Heap	IMPORT	Allocate;

CONST
  date=COMPILEDATE;
  ver="4.4";
VAR
  debPort,
  myPort: MsgPortPtr;
  msg,got:DebugMsgPtr;
  error:LONGINT;

BEGIN
  SETREG(11,ADR("$VER: KillM2Debug "+ver+" "+date));
  WriteString("KillM2Debug "+ver+" "+date+'\n');
  error:=magicErr;
  Allocate(msg,SIZE(msg^));
  Assert(msg#NIL,ADR('KillM2Debug: no mem'));
  myPort:=CreatePort(NIL,0);
  Assert(myPort#NIL,ADR('KillM2Debug: Kann ReplyPort nicht erzeugen'));
  msg^.msg.node.type:=message;
  msg^.msg.replyPort:=myPort;
  msg^.magic:=magicTerminate;
  Forbid;
  debPort:=FindPort(ADR(debPortName));
  IF debPort#NIL THEN
    PutMsg(debPort,msg);
    Permit;
    REPEAT
      WaitPort(myPort);
      got:=GetMsg(myPort);
    UNTIL got=msg; (* wer wei, was da kommt? *)
    error:=got^.magic;
    IF error=magicOk THEN
      WriteString('Debugger-Prozess beendet.\n');
    ELSE
      WriteString('Debugger-Prozess NICHT beendet. ???\n');
    END;
  ELSE
    Permit;
    WriteString('Kein Debugger-Prozess vorhanden.\n');
  END;
CLOSE
  IF myPort#NIL THEN
    DeletePort(myPort);
    myPort:=NIL
  END;
END KillM2Debug.
