IMPLEMENTATION MODULE InOut;
(*
 * 14.8.90/bp
 *	Neue Prozeduren SetInput, SetOutput
 *	Auch Open..Put schlieen nun vorher die Files.
 * 08.06.90/bp
 *	TermProcedure entfernt
 * 30.04.89/ms
 *	WriteHex(-32768,8) schreibt neu FFFF8000 anstatt 00008000
 *	Ebenso wurde WriteOct korrigiert.
 * 07.03.89/ms
 *	In allen ReadNUMBER Prozeduren ist ein Test auf ein gltiges
 *	Stringlesen eingebaut geworden.
 *	In ReadString wird bei einem eol als Abschlusszeichen weiter-
 *	gefahren.
 *
 * jr/28mai87
 *)
(*$ LargeVars:=FALSE
    LongAlign:=TRUE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    StackParms:=FALSE
    Volatile:=FALSE
*)

FROM SYSTEM      IMPORT ADR, BYTE, CAST;
FROM Conversions IMPORT ValToStr, StrToVal;
FROM ASCII       IMPORT nul, lf, eof;

IMPORT DosL, DosD, Terminal, Scan;

TYPE String=ARRAY [0..99] OF CHAR;

VAR inF, outF: DosD.FileHandlePtr;

PROCEDURE ReadAndAppend(VAR name, end: ARRAY OF CHAR);
 VAR l, i: INTEGER;
 BEGIN
  Scan.ScanString(Terminal.Read, name, l, termCh);
  IF (l>0) & (name[l-1]='.') THEN
   i:=0;
   WHILE (l<=HIGH(name)) & (i<=HIGH(end)) & (end[i]#0C) DO
    name[l]:=end[i]; INC(l); INC(i)
   END;
   name[l]:=0C
  ELSIF l=0 THEN
   termCh:=0C
  END
 END ReadAndAppend;

(*$ CopyDyn:=FALSE *)
PROCEDURE OpenInput(defExt: ARRAY OF CHAR);
 VAR s: String;
 BEGIN
  Terminal.WriteString('in>'); ReadAndAppend(s, defExt);
  inF:=DosL.Open(ADR(s), DosD.oldFile); done:=inF#NIL
 END OpenInput;

(*$ CopyDyn:=FALSE *)
PROCEDURE OpenOutput(defExt: ARRAY OF CHAR);
 VAR s: String;
 BEGIN
  Terminal.WriteString('out>'); ReadAndAppend(s, defExt);
  outF:=DosL.Open(ADR(s), DosD.newFile); done:=outF#NIL
 END OpenOutput;

(*$ CopyDyn:=FALSE *)
PROCEDURE SetInput(name: ARRAY OF CHAR);
BEGIN
  CloseInput;
  inF:=DosL.Open(ADR(name), DosD.oldFile); done:=inF#NIL
END SetInput;

(*$ CopyDyn:=FALSE *)
PROCEDURE SetOutput(name: ARRAY OF CHAR);
BEGIN
  CloseOutput;
  outF:=DosL.Open(ADR(name), DosD.newFile); done:=outF#NIL
END SetOutput;

PROCEDURE CloseInput;
 BEGIN
  IF inF#NIL THEN DosL.Close(inF) END;
  inF:=NIL; done:=TRUE
 END CloseInput;

PROCEDURE CloseOutput;
 BEGIN
  IF outF#NIL THEN DosL.Close(outF) END;
  outF:=NIL; done:=TRUE
 END CloseOutput;


PROCEDURE Write(ch: CHAR);
 BEGIN
  IF outF#NIL THEN done:=DosL.Write(outF, ADR(ch), 1)=1
  ELSE Terminal.Write(ch); done:=TRUE
  END
 END Write;

PROCEDURE WriteBytes(VAR blk: ARRAY OF BYTE);
 BEGIN
  IF outF#NIL THEN done:=DosL.Write(outF, ADR(blk), HIGH(blk)+1)=HIGH(blk)+1
  ELSE done:=FALSE
  END
 END WriteBytes;

(*$ CopyDyn:=FALSE *)
PROCEDURE WriteString(s: ARRAY OF CHAR);
 VAR l: LONGINT;
 BEGIN
  IF outF#NIL THEN
   l:=0; WHILE (l<=HIGH(s)) & (s[l]#nul) DO INC(l) END;
   done:=DosL.Write(outF, ADR(s), l)=l
  ELSE Terminal.WriteString(s); done:=TRUE
  END
 END WriteString;

PROCEDURE WriteLn;
 BEGIN
  Write(lf);
 END WriteLn;


PROCEDURE Read(VAR ch: CHAR);
 BEGIN
  IF inF#NIL THEN IF DosL.Read(inF, ADR(ch), 1)#1 THEN ch:=eof END
  ELSE Terminal.Read(ch)
  END;
  done:=TRUE
 END Read;

PROCEDURE ReadBytes(VAR blk: ARRAY OF BYTE);
 BEGIN
  IF inF#NIL THEN done:=DosL.Read(inF, ADR(blk), HIGH(blk)+1)=HIGH(blk)+1
  ELSE done:=FALSE
  END;
 END ReadBytes;

PROCEDURE ReadString(VAR s: ARRAY OF CHAR);
 VAR l: INTEGER;
 BEGIN
  Scan.ScanString(Read, s, l, termCh);
  done:=l#0
 END ReadString;

PROCEDURE ReadStr(VAR s: ARRAY OF CHAR);
 VAR l: INTEGER;
 BEGIN
  REPEAT
   Scan.ScanString(Read, s, l, termCh);
  UNTIL (l#0) OR (termCh=eof);
  done:=l#0
 END ReadStr;


PROCEDURE WriteInt(i: LONGINT; width: INTEGER);
 VAR s: String;
 BEGIN
  ValToStr(i, TRUE, s, 10, width, ' ', done); done:=~done;
  IF done THEN WriteString(s) END
 END WriteInt;

PROCEDURE WriteCard(c: LONGCARD; width: INTEGER);
 VAR s: String;
 BEGIN
  ValToStr(CAST(LONGINT, c), FALSE, s, 10, width, ' ', done); done:=~done;
  IF done THEN WriteString(s) END
 END WriteCard;

PROCEDURE WriteOct(i: LONGINT; width: INTEGER);
 VAR
  s: String;
  fillCh: CHAR;
(* 30.4.89/ms
 * fillCh abhngig vom Vorzeichen von i
 *)
 BEGIN
  IF i<0 THEN fillCh:='7' ELSE fillCh:='0' END;
  ValToStr(i, FALSE, s, 8, width, fillCh, done); done:=~done;
  IF done THEN WriteString(s) END
 END WriteOct;

PROCEDURE WriteHex(i: LONGINT; width: INTEGER);
 VAR
  s: String;
  fillCh: CHAR;
(* 30.4.89/ms
 * fillCh abhngig vom Vorzeichen von i
 *)
 BEGIN
  IF i<0 THEN fillCh:='F' ELSE fillCh:='0' END;
  ValToStr(i, FALSE, s, 16, width, fillCh, done); done:=~done;
  IF done THEN WriteString(s) END
 END WriteHex;

(*
 * 07.03.89/ms
 *	Test auf positives Resultat bei allen Einleseprozeduren.
 *)
PROCEDURE ReadInt(VAR i: INTEGER);
 VAR
  s: String;
  l: LONGINT; sign: BOOLEAN;
 BEGIN
  ReadStr(s);
  IF done THEN
   StrToVal(s, l, sign, 10, done);
   done:=~done & ( sign & (-32768<=l) OR (CAST(LONGCARD,l)<=32767) );
   IF done THEN i:=l END
  END
 END ReadInt;

PROCEDURE ReadCard(VAR c: CARDINAL);
 VAR
  s: String;
  l: LONGINT; sign: BOOLEAN;
 BEGIN
  ReadStr(s);
  IF done THEN
   StrToVal(s, l, sign, 10, done);
   done:=~done & (CAST(LONGCARD, l)<=65535);
   IF done THEN c:=l END
  END
 END ReadCard;

PROCEDURE ReadLongInt(VAR i: LONGINT);
 VAR
  s: String;
  sign: BOOLEAN;
 BEGIN
  ReadStr(s);
  IF done THEN
   StrToVal(s, i, sign, 10, done);
   done:=~done & (sign OR (i>=0));
  END
 END ReadLongInt;

PROCEDURE ReadLongCard(VAR c: LONGCARD);
 VAR
  s: String;
  l: LONGINT; sign: BOOLEAN;
 BEGIN
  ReadStr(s);
  IF done THEN
   StrToVal(s, l, sign, 10, done);
   done:=~done & ~sign;
   IF done THEN c:=CAST(LONGCARD, l) END
  END
 END ReadLongCard;

BEGIN
  (* inF:=NIL; outF:=NIL; unntig! *)
CLOSE
  CloseInput; CloseOutput
END InOut.mod
