IMPLEMENTATION MODULE Heap;
(* 27.3.89 / ms *)
(*$
   StackChk:=FALSE
   RangeChk:=FALSE
   OverflowChk:=FALSE
   ReturnChk:=FALSE
   LongAlign:=TRUE
   LargeVars:=FALSE
   NilChk:=FALSE
   Volatile:=FALSE
   StackParms:=FALSE
*)

FROM SYSTEM IMPORT
 ADDRESS,ADR,CAST;
FROM Arts IMPORT
 Assert;
IMPORT ExecD,ExecL;


CONST
  blockErr = 'Heap: Block zu gross';

TYPE
 NodePtr=POINTER TO Node;
 Node=RECORD
  next: NodePtr;
  size: LONGINT
 END;

VAR
 root: NodePtr;

(* ================= internal routines =================================== *)
PROCEDURE LocatePrevBlock(block: NodePtr): NodePtr;
(* search the list of blocks for the given block. If it is a valid block its
 * predecessor block is returned. If the block is not found NIL will be the
 * result. For the root of the list it returnes the address of the root pointer.
 *)
VAR
 current,prev: NodePtr;
BEGIN
 prev:=ADR(root); current:=root;
 LOOP
  IF block=current THEN
   RETURN prev
  ELSIF current=NIL THEN
   RETURN NIL
  ELSE
   prev:=current; current:=current^.next
  END
 END
END LocatePrevBlock;

(* ======================== exported ======================================= *)
PROCEDURE AllocMem(VAR adr: ADDRESS; size: LONGINT; chipMem: BOOLEAN);
VAR
 p: NodePtr;
 attr: ExecD.MemReqSet;
BEGIN
 Assert((size>=0)&(size<(MAX(LONGINT)-SIZE(Node))),ADR(blockErr));
 INC(size,SIZE(Node));
 attr:=ExecD.MemReqSet{ExecD.memClear,ExecD.public};
 IF chipMem THEN
  INCL(attr,ExecD.chip)
 END;
 p:=ExecL.AllocMem(size,attr);
 IF p#NIL THEN
   p^.size:=size;
   p^.next:=root;
   root:=p;
   adr:=CAST(ADDRESS,p)+SIZE(Node)
 ELSE
  adr:=NIL
 END
END AllocMem;

PROCEDURE Allocate(VAR adr: ADDRESS; size: LONGINT);
BEGIN
 AllocMem(adr,size,FALSE)
END Allocate;

PROCEDURE Deallocate(VAR adr: ADDRESS);
VAR
 prev,current: NodePtr;
BEGIN
 current:=CAST(NodePtr,adr-SIZE(Node));
 prev:=LocatePrevBlock(current);
 IF prev#NIL THEN
  WITH current^ DO
   prev^.next:=next;
   ExecL.FreeMem(current,size)
  END;
  adr:=NIL
 END
END Deallocate;

PROCEDURE BlockSize(adr: ADDRESS): LONGINT;
VAR
 prev,current: NodePtr;
BEGIN
 current:=CAST(NodePtr,adr-SIZE(Node));
 prev:=LocatePrevBlock(current);
 IF prev#NIL THEN
  RETURN current^.size-SIZE(Node)
 ELSE
  RETURN 0
 END
END BlockSize;

PROCEDURE Largest(chipMem: BOOLEAN): LONGINT;
VAR
 attr: ExecD.MemReqSet;
BEGIN
 attr:=ExecD.MemReqSet{ExecD.largest,ExecD.public};
 IF chipMem THEN
  INCL(attr,ExecD.chip)
 END;
 RETURN ExecL.AvailMem(attr)-SIZE(Node)
END Largest;

PROCEDURE Available(chipMem: BOOLEAN): LONGINT;
VAR
 attr: ExecD.MemReqSet;
BEGIN
 attr:=ExecD.MemReqSet{ExecD.public};
 IF chipMem THEN
  INCL(attr,ExecD.chip);
 END;
 RETURN ExecL.AvailMem(attr)-SIZE(Node)
END Available;

PROCEDURE CleanUp;
(* ======================== cleanup ========================================= *)
VAR
 p0,p1: NodePtr;
BEGIN
 p0:=root;
 WHILE p0#NIL DO
   p1:=p0; p0:=p0^.next; INC(ADDRESS(p1),SIZE(Node));
   Deallocate(p1)
 END;
END CleanUp;

BEGIN
 (* root:=NIL; *)
CLOSE
 CleanUp;
END Heap.
