IMPLEMENTATION MODULE GfxMacros;
(* 2.0 / 9.4.87 / ms *)
(* 4.1 / 19.8.92 / bp *)

(*$
    LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    NilChk:=FALSE
    StackParms:=FALSE
    EntryClear:=FALSE
    ReturnChk:=FALSE
*)
FROM SYSTEM	IMPORT	ADDRESS,ASSEMBLE,BITSET,CAST;
FROM Hardware	IMPORT	custom,DmaFlags,DmaFlagSet,IntFlags,IntFlagSet;
FROM GraphicsD	IMPORT	BobPtr, BobFlags, BobFlagSet, CopListPtr,
			RastPortFlags, RastPortFlagSet,	RastPortPtr,
			UCopListPtr;
FROM GraphicsL	IMPORT	graphicsBase,AreaEllipse,CBump,CMove,CWait,
			DrawEllipse,SetOutlinePen,SetWriteMask,
			UCopperListInit,graphicsVersion;
IMPORT R;


PROCEDURE AreaCircle(rp{R.A1}:RastPortPtr; cx{R.D0},cy{R.D1},r{R.D2}:INTEGER):BOOLEAN;
(* KEIN EntryExit FALSE! Register mssen gerettet werden! *)
BEGIN
  ASSEMBLE(
	MOVE.L	graphicsBase(A4),A6
	MOVE.L	D2,D3
	JSR	AreaEllipse(A6)
  END);
(* RETURN AreaEllipse(rp,cx,cy,r,r); *)
END AreaCircle;

PROCEDURE CEND(c{R.A1}:UCopListPtr);
(* KEIN EntryExit FALSE! Register mssen gerettet werden! *)
BEGIN
  ASSEMBLE(
	MOVE.W	#10000,D0
	MOVE.W	#255,D1
	MOVE.L	A1,A2
	MOVE.L	graphicsBase(A4),A6
	JSR	CWait(A6)
	MOVE.L	A2,A1
	JSR	CBump(A6)
  END);
(* CWait(c,10000,255); CBump(c) *)
END CEND;

PROCEDURE CINIT(c{R.A0}:UCopListPtr; n{R.D0}:LONGINT):CopListPtr;
BEGIN
  ASSEMBLE(
	MOVE.L	graphicsBase(A4),A6
	JSR	UCopperListInit(A6)
  END);
(* RETURN UCopperListInit(c,n) *)
END CINIT;

PROCEDURE CMOVE(c{R.A1}:UCopListPtr;a{R.D0}:ADDRESS;b{R.D1}:INTEGER);
BEGIN
  ASSEMBLE(
	MOVE.L	A1,A2
	MOVE.L	graphicsBase(A4),A6
	JSR	CMove(A6)
	MOVE.L	A2,A1
	JSR	CBump(A6)
  END);
(* CMove(c,a,b); CBump(c) *)
END CMOVE;

PROCEDURE CWAIT(c{R.A1}:UCopListPtr; a{R.D0},b{R.D1}:INTEGER);
(* KEIN EntryExit FALSE! Register mssen gerettet werden! *)
BEGIN
  ASSEMBLE(
	MOVE.L	A1,A2
	MOVE.L	graphicsBase(A4),A6
	JSR	CWait(A6)
	MOVE.L	A2,A1
	JSR	CBump(A6)
  END);
(* CWait(c,a,b); CBump(c) *)
END CWAIT;

PROCEDURE DrawCircle(rp{R.A1}:RastPortPtr; cx{R.D0},cy{R.D1},r{R.D2}:INTEGER);
BEGIN
  ASSEMBLE(
	MOVE.L	graphicsBase(A4),A6
	MOVE.L	D2,D3
	JSR	DrawEllipse(A6)
  END);
(* DrawEllipse(rp,cx,cy,r,r) *)
END DrawCircle;

PROCEDURE InitAnimate(animKey{R.A0}:ADDRESS);
TYPE
  LONGINTPtr = POINTER TO LONGINT;
BEGIN
  CAST(LONGINTPtr,animKey)^:=0;
END InitAnimate;

PROCEDURE RemBob(bob{R.A0}:BobPtr);
BEGIN
  INCL(bob^.flags,bobsAway);
END RemBob;

PROCEDURE RasSize(w{R.D1},h{R.D2}:CARDINAL):CARDINAL;
BEGIN
  RETURN h*CAST(CARDINAL,CAST(BITSET,(w+15) DIV 8)*{1..15})
END RasSize;

PROCEDURE OnDisplay;
BEGIN
  custom.dmacon:=DmaFlagSet{dmaSet,raster}
END OnDisplay;

PROCEDURE OffDisplay;
BEGIN
  custom.dmacon:=DmaFlagSet{raster}
END OffDisplay;

PROCEDURE OnSprite;
BEGIN
  custom.dmacon:=DmaFlagSet{dmaSet,sprite}
END OnSprite;

PROCEDURE OffSprite;
BEGIN
  custom.dmacon:=DmaFlagSet{sprite}
END OffSprite;

PROCEDURE OnVBlank;
BEGIN
  custom.intena:=IntFlagSet{intSet,vertb}
END OnVBlank;

PROCEDURE OffVBlank;
BEGIN
  custom.intena:=IntFlagSet{vertb}
END OffVBlank;

PROCEDURE SetOPen(rp{R.A0}:RastPortPtr;pen{R.D0}:SHORTCARD);
BEGIN
  IF graphicsVersion<39 THEN
    rp^.aOlPen:=pen;
    INCL(rp^.flags,areaOutline);
  ELSE
    ASSEMBLE(
	MOVE.L	graphicsBase(A4),A6
	MOVE.B	D0,D1 (* auf Langwort erweitern! *)
	MOVEQ	#0,D0
	MOVE.B	D1,D0
	JSR	SetOutlinePen(A6)
    END);
  END;
END SetOPen;

PROCEDURE SetDrPt(rp{R.A0}:RastPortPtr;pattern{R.D0}:CARDINAL);
BEGIN
  rp^.linePtrn:=pattern;
  INCL(rp^.flags,firstDot);
  rp^.linPatCnt:=15
END SetDrPt;

PROCEDURE SetWrMsk(rp{R.A0}:RastPortPtr;mask{R.D0}:SHORTCARD);
BEGIN
  IF graphicsVersion<39 THEN
    rp^.mask:=mask;
  ELSE
    ASSEMBLE(
	MOVE.L	graphicsBase(A4),A6
	MOVE.B	D0,D1 (* auf Langwort erweitern! *)
	MOVEQ	#0,D0
	MOVE.B	D1,D0
	JSR	SetWriteMask(A6)
    END);
  END;
END SetWrMsk;

PROCEDURE SetAfPen(rp{R.A0}:RastPortPtr;areaPattern{R.D0}:ADDRESS;
           size{R.D1}:SHORTCARD);
BEGIN
  rp^.areaPtrn:=areaPattern;
  rp^.areaPtSz:=size;
END SetAfPen;

PROCEDURE BndryOff(rp{R.A0}:RastPortPtr);
BEGIN
  EXCL(rp^.flags,areaOutline);
END BndryOff;

END GfxMacros.mod
