IMPLEMENTATION MODULE FileNames;
(* 2.1 / 29.5.88 / ms *)
(* 2.2 / 15.7.88 / ms / check for eof in ReadFileName, compute length always *)
(* 2.2 /  9.6.91 / bp / GetExtension hatte schweren Fehler! *)
(*$
    LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    NilChk:=FALSE
    StackParms:=FALSE
    LongAlign:=FALSE
*)

FROM SYSTEM IMPORT ASSEMBLE;
FROM String IMPORT Length;
FROM ASCII  IMPORT nul,bel,bs,lf,cr,can,esc,del,eof;

(*
 * ReadFileName reads a filename using the supplied I/O routines.
 * Read should not echo,Write should interpret <bs> and <del> as
 * erasing the last character. len gives the number of characters
 * in the filename. If the user hits <esc> the filename is returned
 * empty with len=0. <cr> is ignored on an empty input else it
 * terminates the string. All characters [" "..CHAR(del-1)] are
 * accepted.
 *
 * ReadFileName(fname,len,Terminal.Read,Terminal.Write);
 *	user: df1:exec/Alerts.sym<cr>
 *	fname = "df1:exec/sym/Alerts.sym"; len = 23;
 *)
PROCEDURE ReadFileName(VAR fname: ARRAY OF CHAR; VAR len: INTEGER;
                       readProc: ReadProc; writeProc: WriteProc);

 PROCEDURE Write(ch: CHAR);
 BEGIN
  IF writeProc#noEcho THEN
   writeProc(ch)
  END
 END Write;

VAR
 ch: CHAR;
BEGIN
 len:=0;
 LOOP
  readProc(ch);
  IF (ch=esc) THEN
   len:=0; EXIT
  ELSIF (ch=lf) OR (ch=cr) OR (ch=eof) THEN (* 15.7.88/ms: added eof *)
   EXIT
  ELSIF ((ch=bs) OR (ch=del)) & (len>0) THEN
   Write(del); DEC(len)
  ELSIF ch=can THEN
   WHILE len>0 DO
    Write(del); DEC(len)
   END;
  ELSIF (len<=HIGH(fname))
        & (((' '<=ch) & (ch<del)) OR (ch>=240C)) THEN
   fname[len]:=ch; INC(len); Write(ch);
  ELSE
   Write(bel)
  END
 END;
 IF len<HIGH(fname) THEN fname[len]:=nul END
END ReadFileName;

(*
 * GetPath removes the path info in fname and stores it in path.
 * len is asssumed to hold the lenght of fname and is set according
 * the new length of fname.
 *
 * GetPath(fname,path,len);
 * 	fname = "Alerts.sym"; len = 10;
 *	path  = "df1:exec/sym/";
 *)
PROCEDURE GetPath(VAR fname,path: ARRAY OF CHAR; VAR len: INTEGER);
VAR
 i,j: INTEGER;
BEGIN
 i:=Length(fname);
 len:=i;
 LOOP
  IF (fname[i]=":") OR (fname[i]="/") THEN
   FOR j:=0 TO i DO
    path[j]:=fname[j]
   END;
   INC(i); path[i]:=nul;
   FOR j:=i TO len-1 DO
    fname[j-i]:=fname[j]
   END;
   DEC(len,i); fname[len]:=nul;
   EXIT
  ELSIF i=0 THEN
   path[0]:=nul; EXIT
  ELSE
   DEC(i)
  END
 END
END GetPath;

(*
 * GetExtension works as GetPath except that it removes any extension
 * from the filename. An extension is assumed to be separated by a
 * dot.
 *)
PROCEDURE GetExtension(VAR fname,extension: ARRAY OF CHAR; VAR len: INTEGER);
VAR
  i,j: INTEGER;
BEGIN
  i:=Length(fname);
  len:=i;
  LOOP
    IF fname[i]="." THEN
      extension[len-i-1]:=nul;
      FOR j:=i+1 TO len-1 DO
        (* 9.6.91/bp war total falsch! *)
        extension[j-i-1]:=fname[j]
      END;
      len:=i; (* Rest abschneiden *)
      fname[i]:=nul;
      EXIT
    ELSIF i=0 THEN
      extension[0]:=nul; EXIT
    ELSE
      DEC(i)
    END
  END
END GetExtension;

(*
 * MakeFileName is a simple concat of the four strings. It is useful to
 * concat filenames.
 *
 * MakeFileName(fname,len,"df1:","exec/sym/","Alerts",".sym")
 *	fname = "df1:exec/sym/Alerts.sym"; len = 23;
 *
 *)
PROCEDURE MakeFileName(VAR fname: ARRAY OF CHAR; VAR len: INTEGER;
                       dev,dir,name,ext: ARRAY OF CHAR);
VAR
 j: INTEGER;
BEGIN
 len:=0;
 WHILE (len<=HIGH(fname)) & (len<=HIGH(dev)) & (dev[len]#nul) DO
  fname[len]:=dev[len]; INC(len)
 END;
 j:=0;
 WHILE (len<=HIGH(fname)) & (j<=HIGH(dir)) & (dir[j]#nul) DO
  fname[len]:=dir[j]; INC(len); INC(j)
 END;
 j:=0;
 WHILE (len<=HIGH(fname))&(j<=HIGH(name))&(name[j]#nul) DO
  fname[len]:=name[j]; INC(len); INC(j)
 END;
 j:=0;
 WHILE (len<=HIGH(fname)) & (j<=HIGH(ext)) & (ext[j]#nul) DO
  fname[len]:=ext[j]; INC(len); INC(j)
 END;
 IF len<=HIGH(fname) THEN
  fname[len]:=nul
 END
END MakeFileName;

(*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(RTS END);
CLOSE
  ASSEMBLE(RTS END);
END FileNames.
