IMPLEMENTATION MODULE FileMessage;
(* 2.0 / 8.4.87 / ms *)
(*$
    LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    NilChk:=FALSE
    StackParms:=FALSE
    LongAlign:=TRUE
*)

FROM SYSTEM IMPORT
 ADR;
FROM FileSystem IMPORT
 Response;

PROCEDURE ResponseText(res: Response; VAR p: StrPtr);
BEGIN
 CASE res OF
 | done: p:=ADR("done")
 | notdone: p:=ADR("notdone")
 | lockErr: p:=ADR("lockErr")
 | openErr: p:=ADR("openErr")
 | readErr: p:=ADR("readErr")
 | writeErr: p:=ADR("writeErr")
 | seekErr: p:=ADR("seekErr")
 | memErr: p:=ADR("memErr")
 | inUse: p:=ADR("inUse")
 | notFound: p:=ADR("notFound")
 | diskWriteProtected: p:=ADR("diskWriteProtected")
 | deviceNotMounted: p:=ADR("deviceNotMounted")
 | diskFull: p:=ADR("diskFull")
 | deleteProtected: p:=ADR("deleteProtected")
 | writeProtected: p:=ADR("writeProtected")
 | notDosDisk: p:=ADR("notDosDisk")
 | noDisk: p:=ADR("noDisk")
 ELSE p:=ADR("unknown Response")
 END
END ResponseText;

END FileMessage.
