IMPLEMENTATION MODULE FPUExc;
(*$ LargeVars:=FALSE *)

(* 18.7.90/bp Exception-Verwaltung fr 68881 *)
(* 06-Jun-93/bp Importiert nun alle Math-Libs! *)

FROM SYSTEM	IMPORT	ASSEMBLE,CAST;
FROM ExecD	IMPORT	AttnFlags,AttnFlagSet,execBase,ExecBase;
IMPORT
  MathLibFFP,
  MathTrans,
  MathIEEESingBas,
  MathIEEESingTrans,
  MathIEEEDoubBas,
  MathIEEEDoubTrans;

(*
TYPE fpuExc=(inex1,inex2,dz,unfl,ovfl,operr,snan,bsun);
     fpuExcSet=SET OF fpuExc;

CONST
     stdExc=fpuExcSet{dz..bsun};
     noExc =fpuExcSet{};
*)


(*$ LongAlign:=FALSE *)
VAR
      isFPU:BOOLEAN;
      oldState: LONGCARD;

CONST
      fpuAttnMask=CAST(CARDINAL,AttnFlagSet{m68040..m68882});
      (* 68040,68881,68882 *)
      fpuNormLong=CAST(SHORTCARD,stdExc)*256; (* mode control byte ist 0! *)

(*$ EntryExitCode:=FALSE *)
PROCEDURE EnableExc; (* alle dz..bsun ON *)
BEGIN
  ASSEMBLE(
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	FMOVE.L	FPCR,D0
	ORI.W	#fpuNormLong,D0
	FMOVE.L	D0,FPCR
  nofpu:RTS
  END);
END EnableExc;

(*$ EntryExitCode:=FALSE *)
PROCEDURE DisableExc; (* alle OFF *)
BEGIN
  ASSEMBLE(
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	FMOVE.L	FPCR,D0
	ANDI.W	#$00FF,D0
	FMOVE.L	D0,FPCR
  nofpu:RTS
  END);
END DisableExc;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SetExc(e{0}:fpuExc); (* einzelne setzen/lschen *)
BEGIN
  ASSEMBLE(
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	ADDQ.B	#8,D0	(* bits sind 8..15! *)
	FMOVE.L	FPCR,D1
	BSET	D0,D1
	FMOVE.L	D1,FPCR
  nofpu:RTS
  END);
END SetExc;

(*$ EntryExitCode:=FALSE *)
PROCEDURE ClearExc(e{0}:fpuExc);
BEGIN
  ASSEMBLE(
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	ADDQ.B	#8,D0	(* bits sind 8..15! *)
	FMOVE.L	FPCR,D1
	BCLR	D0,D1
	FMOVE.L	D1,FPCR
  nofpu:RTS
  END);
END ClearExc;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SetExcSet(s{0}:fpuExcSet); (* genau den Set setzen *)
BEGIN
  ASSEMBLE(
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	ASL.W	#8,D0
	FMOVE.L	FPCR,D1
	ANDI.W	#$00FF,D1
	OR.W	D0,D1
	FMOVE.L	D1,FPCR
  nofpu:RTS
  END);
END SetExcSet;

(*$ EntryExitCode:=FALSE *)
PROCEDURE GetExcSet():fpuExcSet; (* aktuellen Zustand holen *)
BEGIN
  ASSEMBLE(
	MOVEQ	#0,D0
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	FMOVE.L	FPCR,D0
	LSR.W	#8,D0
	ANDI.W	#$00FF,D0
  nofpu:RTS
  END);
END GetExcSet;

(*$ EntryExitCode:=FALSE *)
PROCEDURE SetRounding(r{0}:roundingMode);
BEGIN
  ASSEMBLE(
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	ASL.W	#4,D0
	FMOVE.L	FPCR,D1
	ANDI.W	#$FFCF,D1
	OR.W	D0,D1
	FMOVE.L	D1,FPCR
  nofpu:RTS
  END);
END SetRounding;

(*$ EntryExitCode:=FALSE *)
PROCEDURE GetRounding():roundingMode;
BEGIN
  ASSEMBLE(
	MOVEQ	#0,D0
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	FMOVE.L	FPCR,D0
	LSR.W	#4,D0
	ANDI.W	#$0003,D0
  nofpu:RTS
  END);
END GetRounding;

(* HIER NIEMALS $ E - !! *)
BEGIN
  ASSEMBLE(
	MOVE.L	execBase,A0
	MOVE.W	ExecBase.attnFlags(A0),D0
	ANDI.W	#fpuAttnMask,D0 (* 68040,68881 oder 68882 da? *)
	SNE	isFPU(A4)
	BEQ.S	nofpu
	MOVEQ	#0,D0
	FMOVE.L	D0,FPSR (* alle alten Excs lschen! *)
	FMOVE.L	FPCR,oldState(A4)
	FMOVE.L	#fpuNormLong,FPCR
  nofpu:
	END);

CLOSE (* Exit *)
  ASSEMBLE(
	TST.B	isFPU(A4)
	BEQ.S	nofpu
	FMOVE.L	oldState(A4),FPCR
  nofpu:
	END);
END FPUExc.
