IMPLEMENTATION MODULE FFPConversions; (* jr/28mai+1dez87 *)
(*$ StackChk:=FALSE
    OverflowChk:=FALSE
    RangeChk:=FALSE
    LargeVars:=FALSE
    Volatile:=FALSE
*)

FROM SYSTEM IMPORT FFP,CAST;

PROCEDURE StrToReal(VAR s: ARRAY OF CHAR; VAR r: FFP;
                    VAR err: BOOLEAN);

 CONST maxExp=18; maxReal=MAX(FFP);
 VAR
  ch: CHAR;
  i, anf, pkt, end, d, expo: INTEGER;
  dig, t: FFP;
  bool, neg: BOOLEAN;

 PROCEDURE nxt;BEGIN IF i>HIGH(s) THEN ch:=0C ELSE ch:=s[i] END; INC(i) END nxt;

 BEGIN
  err:=TRUE; i:=0; nxt;             (* ------- lexical analysis ------- *)
  WHILE ch=' ' DO nxt END;
  neg:=ch='-'; IF neg OR (ch='+') THEN nxt END;
  anf:=i-1; pkt:=-1; bool:=TRUE;
  LOOP
   IF ch='.' THEN pkt:=i-1
   ELSIF (ch<'0') OR ('9'<ch) THEN EXIT
   ELSE bool:=FALSE (* mindestens eine Ziffer wurde gelesen *)
   END; nxt
  END;
  IF bool THEN RETURN END;
  end:=i-2; expo:=0;
  IF ch='E' THEN
   nxt; d:=-1; bool:=ch='-'; IF bool OR (ch='+') THEN nxt END;
   WHILE ('0'<=ch) & (ch<='9') DO
    d:=ORD(ch)-48; IF (MAX(INTEGER)-d) DIV 10<expo THEN RETURN END;
    expo:=expo*10+d; nxt
   END;
   IF d=-1 THEN RETURN END;
   IF bool THEN expo:=-expo END;
  END;
  IF (ch#0C) & (ch#' ') THEN RETURN END;
  r:=0.0;                       (* ------- numerical evaluation ------- *)
  IF pkt#-1 THEN expo:=expo-end+pkt END;
  LOOP
    IF end#pkt THEN
     dig:=FFP(ORD(s[end])-48);
     IF expo>maxExp THEN IF dig#0.0 THEN RETURN END
     ELSE
      IF expo<-maxExp THEN t:=0.0                         (* t:=10^expo *)
      ELSE
       t:=1.0;
       FOR d:=1 TO expo DO t:=t*10.0 END;
       FOR d:=expo TO -1 DO t:=t/10.0 END;
      END;
      IF (expo>0) & ((maxReal-r)/t<dig) THEN RETURN END;
      r:=r+dig*t
     END;
     INC(expo)
    END;
    IF end=anf THEN EXIT END;
    DEC(end)
  END;
  IF neg THEN r:=-r END; err:=FALSE
 END StrToReal;


PROCEDURE RealToStr(r: FFP; VAR s: ARRAY OF CHAR;
                    m, n: INTEGER; expo: BOOLEAN; VAR err: BOOLEAN);

(* Erklrung der Variablen:

		    d = 2   1   0   0  -1  -2  -3
      +---+---+---+---+---+---+---+---+---+---+---+
  s = |   |   |   |   | 1 | 2 | 3 | . | 4 | 5 | 6 |
      +---+---+---+---+---+---+---+---+---+---+---+
      \_______ ______/                \_____ _____/
              V                             V
      |     l = 4                         n = 3   |
      |<----------------- m = 11 ---------------->|
*)

(* 16.2.91/bp
 * Eine ungltige FFP-Zahl resultiert in eine Endlosschleife!
 *)
 TYPE
   Mix=RECORD
     CASE :INTEGER OF
     |0: f:FFP;
     |1: a,b,c,d:SHORTCARD;
     END;
   END;

 CONST
  expPlaces=2; expMax=100; (* 10^expPlaces *)

 VAR
  neg, left: BOOLEAN;
  e, d, l, i, q: INTEGER;
  round: FFP;

 PROCEDURE put(c: CHAR); BEGIN s[i]:=c; INC(i) END put;

 BEGIN
  (* Abfangen von unnormierten Zahlen: *)
  IF CAST(Mix,r).d=0 THEN r:=0.0 END;

  err:=TRUE; s[0]:=0C; IF (m=0) OR (n<0) THEN RETURN END;
  left:=m<0; m:=ABS(m); IF m>HIGH(s)+1 THEN m:=HIGH(s)+1 END;
  neg:=r<0.0; IF neg THEN r:=-r; DEC(m) END; d:=0;
  WHILE r>=10.0 DO r:=r/10.0; INC(d) END;            (* r<10, Zahl ist r*10^d *)
  IF expo THEN
   IF r#0.0 THEN WHILE r<1.0 DO r:=r*10.0; DEC(d) END END;
   e:=d; d:=0; l:=m-(expPlaces+4);                       (* -> 6 fr '1.E+00' *)
  ELSE l:=m-d-2;               (* d+1 Stellen vor'm Komma + 1 Stelle frs '.' *)
  END;
  IF l<-1 THEN RETURN END;          (* sogar wenn '.' fehlt, hat's kein Platz *)
  IF n>l THEN n:=l END;             (* begrenze Anzahl Stellen hinter'm Komma *)
  DEC(l,n);
  IF n=0 THEN INC(l) END;        (* wenn nichts nach dem Komma, dann kein '.' *)
  IF n=-1 THEN n:=0 END;
  round:=0.5; FOR i:=1 TO n+d DO round:=round/10.0 END; r:=r+round;
  IF r>=10.0 THEN            (* durch's Runden muss man alles NOCHMALS prfen *)
   IF n+l=0 THEN RETURN END;
   IF l#0 THEN DEC(l) ELSE DEC(n); IF n=0 THEN l:=1 END END;
   IF expo THEN INC(e) ELSE INC(d) END; r:=r/10.0;
  END;
  i:=0;               (* ------------- Alles geprft! Flle 's' ------------- *)
  IF ~left THEN WHILE l>0 DO put(' '); DEC(l) END END;
  IF neg THEN put('-') END;
  LOOP
   q:=TRUNC(r); put(CHR(48+q)); r:=(r-FFP(q))*10.0;
   IF d=-n THEN EXIT END;
   IF d=0 THEN put('.') END;
   DEC(d)
  END;
  IF expo THEN
   put('E'); IF e<0 THEN e:=-e; put('-') ELSE put('+') END;
   d:=expMax;          (* because 'd' and 'q' are nolonger used, let's us it! *)
   FOR q:=1 TO expPlaces DO
    d:=d DIV 10; put(CHR(48+e DIV d)); e:=e MOD d
   END
  END;
  IF left THEN WHILE l>0 DO put(' '); DEC(l) END END;
  IF i<=HIGH(s) THEN put(0C) END; err:=FALSE
 END RealToStr;

END FFPConversions.mod
