IMPLEMENTATION MODULE ExecSupport;
(* 2.0 / 15.6.87 / ms *)
(* 3.0 / 7.6.90 / bp *)
(* 4.1 / 2.2.92 / cn *)

(*$
    LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    NilChk:=FALSE
    StackParms:=FALSE
    LongAlign:=TRUE
    EntryClear:=FALSE
*)
FROM SYSTEM IMPORT
 ADDRESS,ADR,ASSEMBLE,CAST,LONGSET;
FROM ExecD IMPORT
 beginIO,abortIO,DevicePtr,List,ListPtr,IOStdReq,IOStdReqPtr,MemEntry,
 MemReqSet,MemReqs,MsgPort,MsgPortAction,MsgPortPtr,Node,NodePtr,NodeType,
 Task,TaskPtr,UnitPtr;
FROM ExecL IMPORT
 AddHead,AddPort,AddTask,AllocEntry,AllocMem,AllocSignal,
 FindTask,FreeMem,FreeSignal,RemPort,RemTask;

PROCEDURE NewList(list{8}: ListPtr); (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVE.L	A0,(A0)
	ADDQ.L	#4,(A0)
	CLR.L	4(A0)
	MOVE.L	A0,8(A0)
	RTS
  END);
END NewList;

PROCEDURE IsListEmpty(list{8}:ListPtr):BOOLEAN; (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVE.L	List.tailPred(A0),D0
	CMP.L	A0,D0
	BEQ.S	isempty
	MOVEQ	#0,D0
	RTS
    isempty:
    	MOVEQ	#-1,D0
    	RTS
  END);
END IsListEmpty;

PROCEDURE BeginIO(ioRequest{9}: ADDRESS); (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVE.L	A6,-(A7)
	MOVE.L	IOStdReq.device(A1),A6
	JSR	beginIO(A6)
	MOVE.L	(A7)+,A6
	RTS
  END);
END BeginIO;

PROCEDURE AbortIO(ioRequest{9}: ADDRESS); (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	MOVE.L	A6,-(A7)
	MOVE.L	IOStdReq.device(A1),A6
	JSR	abortIO(A6)
	MOVE.L	(A7)+,A6
	RTS
  END);
END AbortIO;

CONST
 noSignal=-1;
 anySignal=-1;

PROCEDURE CreatePort(portName: ADDRESS; priority: SHORTINT): MsgPortPtr;
VAR
 port: MsgPortPtr;
 sig: INTEGER;
BEGIN
 sig:=AllocSignal(anySignal);
 IF sig#noSignal THEN
  port:=AllocMem(SIZE(MsgPort),MemReqSet{memClear,public});
  IF port#NIL THEN
   WITH port^ DO
    WITH node DO
     name:=portName;
     pri:=priority;
     type:=msgPort
    END;
    flags:=signal;
    sigTask:=FindTask(NIL);
    sigBit:=sig;
    IF node.name#NIL THEN
     AddPort(port)
    ELSE
     NewList(ADR(msgList))
    END
   END;
   RETURN port
  ELSE
   FreeSignal(sig)
  END
 END;
 RETURN NIL
END CreatePort;

PROCEDURE DeletePort(msgPort: MsgPortPtr);
BEGIN
 WITH msgPort^ DO
  IF node.name#NIL THEN
   RemPort(msgPort);
  END;
  node.type:=CAST(NodeType,255);
  msgList.head:=CAST(NodePtr,-1);
  FreeSignal(sigBit);
  FreeMem(msgPort,SIZE(MsgPort))
 END
END DeletePort;

PROCEDURE IsMsgPortEmpty(msgPort{8}:MsgPortPtr):BOOLEAN; (*$ EntryExitCode:=FALSE *)
BEGIN
  ASSEMBLE(
	LEA	MsgPort.msgList(A0),A0
	MOVE.L	List.tailPred(A0),D0
	CMP.L	A0,D0
	BEQ.S	isempty
	MOVEQ	#0,D0
	RTS
    isempty:
	MOVEQ	#-1,D0
	RTS
  END);
END IsMsgPortEmpty;

PROCEDURE CreateExtIO(ioReplyPort: MsgPortPtr; size: INTEGER): ADDRESS;
VAR
 io: IOStdReqPtr;
BEGIN
 IF ioReplyPort#NIL THEN
  io:=AllocMem(size,MemReqSet{memClear,public});
  IF io#NIL THEN
   WITH io^.message DO
    node.type:=message;
    replyPort:=ioReplyPort;
    length:=size
   END;
   RETURN io
  END
 END;
 RETURN NIL
END CreateExtIO;

PROCEDURE DeleteExtIO(extIOReq: ADDRESS);
VAR
 io: IOStdReqPtr;
BEGIN
 IF extIOReq#NIL THEN
  io:=extIOReq;
  WITH io^ DO
   message.node.type:=CAST(NodeType,255);
   device:=CAST(DevicePtr,-1);
   unit:=CAST(UnitPtr,-1);
   FreeMem(io,message.length)
  END
 END
END DeleteExtIO;

PROCEDURE CreateStdIO(ioReplyPort: MsgPortPtr): IOStdReqPtr;
BEGIN
 RETURN CreateExtIO(ioReplyPort,SIZE(IOStdReq))
END CreateStdIO;

PROCEDURE DeleteStdIO(ioStdReq: IOStdReqPtr);
BEGIN
 DeleteExtIO(ioStdReq)
END DeleteStdIO;

PROCEDURE CreateTask(taskName: ADDRESS; priority: SHORTINT;
                     initPC: ADDRESS; stackSize: LONGINT): TaskPtr;
TYPE
 FakeMemList=RECORD
  node: Node;
  numEntries: INTEGER;
  me: ARRAY [0..1] OF MemEntry
 END;
VAR
 newTask: TaskPtr;
 ml: POINTER TO FakeMemList;
 fakeMemList: FakeMemList;
BEGIN
 stackSize:=CAST(LONGINT,CAST(LONGSET,stackSize+3)*LONGSET{2..31});
 fakeMemList.node.succ:=NIL;
 fakeMemList.node.pred:=NIL;
 fakeMemList.node.type:=unknown;
 fakeMemList.node.pri:=0;
 fakeMemList.node.name:=NIL;
 fakeMemList.numEntries:=2;
 fakeMemList.me[0].reqs:=MemReqSet{public,memClear};
 fakeMemList.me[0].length:=SIZE(Task);
 fakeMemList.me[1].reqs:=MemReqSet{memClear};
 fakeMemList.me[1].length:=stackSize;

 ml:=ADDRESS(AllocEntry(ADR(fakeMemList)));
 IF CAST(LONGINT,ml)<0 THEN RETURN NIL END;
 newTask:=ml^.me[0].addr;
 WITH newTask^ DO
  spLower:=ml^.me[1].addr;
  spUpper:=spLower+stackSize;
  spReg:=spUpper;
  node.type:=task;
  node.pri:=priority;
  node.name:=taskName;
  NewList(ADR(memEntry));
  AddHead(ADR(memEntry),ADDRESS(ml));
  AddTask(newTask,initPC,NIL);
  RETURN newTask
 END
END CreateTask;

PROCEDURE DeleteTask(t: TaskPtr);
BEGIN
 RemTask(t)
END DeleteTask;

END ExecSupport.
