IMPLEMENTATION MODULE DosShow;
(* 9.6.90/bp
 * Dies sind alle Dos-Prozeduren, die ein neues Lock oder FileHandle erzeugen.
 * Alle Objekte werden in einer Liste vermerkt und bei Programmende
 * wieder freigegeben.
 * 31.10.90/bp
 * Optimiert
 *)
(*$
    LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    NilChk:=FALSE
    StackParms:=FALSE
    LongAlign:=TRUE
*)
FROM SYSTEM	IMPORT	ASSEMBLE, ADR, ADDRESS, BPTR, CAST;
FROM Exec	IMPORT	Remove, AddTail, AllocMem, FreeMem, MemReqs, MemReqSet;
FROM Arts	IMPORT	Assert,thisTask;
IMPORT Dos,R;
FROM Terminal IMPORT Format,FormatNr,WriteString,Write,ReadLn;

VAR me:Dos.ProcessPtr;

PROCEDURE Show(text:ARRAY OF CHAR; b:BPTR);
BEGIN
  WriteString(text);
  FormatNr(" cd=%08lx ",CAST(LONGINT,me^.currentDir));
  FormatNr("lock=%08lx\n",b);
END Show;

PROCEDURE Show2(text:ARRAY OF CHAR; w:ADDRESS; b:BPTR);
BEGIN
  WriteString(text);
  FormatNr(" cd=%08lx ",CAST(LONGINT,me^.currentDir));
  FormatNr("lock=%08lx",b);
  Format(" Name=\"%s\"\n",ADR(w));
END Show2;

PROCEDURE Show3(text:ARRAY OF CHAR; old,new:BPTR);
BEGIN
  WriteString(text);
  FormatNr(" cd=%08lx ",CAST(LONGINT,me^.currentDir));
  FormatNr("lock1=%08lx",old);
  FormatNr(" lock2=%08lx\n",new);
END Show3;

(*
PROCEDURE Open(name:ADDRESS; accessMode:LONGINT):Dos.FileHandlePtr;
VAR f:Dos.FileHandlePtr;
BEGIN
  RETURN NewObj(Dos.Open(name,accessMode),fileHandle);
END Open;

PROCEDURE Close(file:Dos.FileHandlePtr);
BEGIN
  KillObj(file,fileHandle);
END Close;
*)

PROCEDURE Lock(name:ADDRESS; accessMode:LONGINT):Dos.FileLockPtr;
VAR l:Dos.FileLockPtr;
BEGIN
  l:=Dos.Lock(name,accessMode);
  Show2("Lock\t",name,l);
  RETURN l;
END Lock;

PROCEDURE UnLock(lock:Dos.FileLockPtr);
BEGIN
  Show("UnLock\t",lock);
  Dos.UnLock(lock);
END UnLock;

PROCEDURE DupLock(lock:Dos.FileLockPtr):Dos.FileLockPtr;
VAR l:Dos.FileLockPtr;
BEGIN
  l:=Dos.DupLock(lock);
  Show3("DupLock\t",lock,l);
  RETURN l;
END DupLock;

PROCEDURE ParentDir(lock:Dos.FileLockPtr):Dos.FileLockPtr;
VAR l:Dos.FileLockPtr;
BEGIN
  l:=Dos.ParentDir(lock);
  Show3("Parent\t",lock,l);
  RETURN l;
END ParentDir;

PROCEDURE CurrentDir(lock:Dos.FileLockPtr):Dos.FileLockPtr;
VAR l:Dos.FileLockPtr;
BEGIN
  l:=Dos.CurrentDir(lock);
  Show3("Current\t",lock,l);
  RETURN l;
END CurrentDir;

(*
PROCEDURE CreateDir(name:ADDRESS):Dos.FileLockPtr;
BEGIN
  RETURN NewObj(Dos.CreateDir(name),fileLock);
END CreateDir;
*)

BEGIN
  me:=thisTask;
END DosShow.mod
