IMPLEMENTATION MODULE DateConversions;
(*$
    LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    NilChk:=FALSE
    StackParms:=FALSE
    LongAlign:=TRUE
*)

FROM SYSTEM IMPORT ADR;

FROM ASCII IMPORT eol,esc,ht,nul;
FROM DosD IMPORT Date;
FROM Timer IMPORT TimeVal;

CONST
 amigaOffset=28430*1440; (* Minutes between 1.1.1978 and 1.3.1900 *)

PROCEDURE FromDos(d:Date; VAR di:DateInfo);
BEGIN
 di.minutes:=d.days*1440+d.minute+amigaOffset;
 di.micros:=d.tick*20000;
END FromDos;

PROCEDURE FromTimer(t:TimeVal; VAR di:DateInfo);
BEGIN
 di.minutes:=t.secs DIV 60+amigaOffset;
 di.micros:=(t.secs MOD 60)*1000000+t.micro;
END FromTimer;

PROCEDURE ToDos(di:DateInfo; VAR d:Date);
BEGIN
 DEC(di.minutes,amigaOffset);
 d.days:=di.minutes DIV 1440;
 d.minute:=di.minutes MOD 1440;
 d.tick:=di.micros DIV 20000;
END ToDos;

PROCEDURE ToTimer(di:DateInfo; VAR t:TimeVal);
BEGIN
 t.secs:=(di.minutes-amigaOffset)*60+di.micros DIV 1000000;
 t.micro:=di.micros MOD 1000000;
END ToTimer;

CONST
 refYear=1900;
 dayOffset=0;
 (* dayOffset=Nr. of days from ref. Date 1.3.refYear to day 0 = 1.3.1900 *)

PROCEDURE DecodeDate(minutes:LONGINT; VAR day,month,year:INTEGER);
 (*
  * Variable minutes is used to hold the temporary results.
  *)
BEGIN
 minutes:=(minutes DIV 1440)+dayOffset;
 year:=(4*minutes+3) DIV 1461;
 DEC(minutes,1461*LONGINT(year) DIV 4);
 INC(year,refYear);
 month:=(5*minutes+2) DIV 153;
 day:=minutes-(153*month+2) DIV 5 +1;
 INC(month,3);
 IF month>12 THEN INC(year); DEC(month,12); END;
END DecodeDate;

PROCEDURE EncodeDate(day,month,year:INTEGER; VAR minutes:LONGINT);
BEGIN
 DEC(month,3);
 IF month<0 THEN DEC(year); INC(month,12); END;
 DEC(year,refYear);
 minutes:=1440*((day-1)+((LONGINT(year)*1461) DIV 4)
                +((month*153+2) DIV 5)-dayOffset);
END EncodeDate;

PROCEDURE DateToStr(di:DateInfo; formatString,monthText:ARRAY OF CHAR;
                    VAR output:ARRAY OF CHAR);
TYPE
 CHARPtr=POINTER TO CHAR;
VAR
 p,o: CHARPtr;

 PROCEDURE AddMonth(m:INTEGER);
 VAR
  cp: CHARPtr;
 BEGIN
  cp:=ADR(monthText);
  WHILE (m>1) DO
   WHILE (cp^#nul) & (cp^#"|") DO
    INC(cp);
   END;
   DEC(m); IF cp^=nul THEN RETURN; END;
   INC(cp);
  END;
  WHILE (cp^#nul) & (cp^#"|") DO
   o^:=cp^; INC(o); INC(cp)
  END;
  DEC(o)
 END AddMonth;

 PROCEDURE AddSn(cp: CHARPtr; n:INTEGER);
 BEGIN
  WHILE n>0 DO
   o^:=cp^; INC(o); INC(cp); DEC(n);
  END;
  DEC(o)
 END AddSn;

 PROCEDURE AddI(val,size: INTEGER);
 CONST
  maxSize=4;
 VAR
  st: ARRAY [0..maxSize-1] OF CHAR;
  i: INTEGER;
 BEGIN
  FOR i:=size-1 TO 0 BY -1 DO
   st[i]:=CHAR(INTEGER('0')+val MOD 10); val:=val DIV 10
  END;
  AddSn(ADR(st),size);
 END AddI;

 PROCEDURE AddI2(val:LONGINT; size:INTEGER);
 CONST
  maxSize=6;
 VAR
  st: ARRAY [0..maxSize-1] OF CHAR;
  i: INTEGER;
 BEGIN
  FOR i:=5 TO 0 BY -1 DO
   st[i]:=CHAR(INTEGER('0')+val MOD 10); val:=val DIV 10
  END;
  AddSn(ADR(st),size);
 END AddI2;

VAR
 day,month,year,hour,minute,second:INTEGER;
 micro:LONGINT;
BEGIN
 DecodeDate(di.minutes,day,month,year);
 hour:=(di.minutes DIV 60) MOD 24;
 minute:=di.minutes MOD 60;
 second:=di.micros DIV 1000000;
 micro:=di.micros MOD 1000000;
 p:=ADR(formatString); o:=ADR(output);
 LOOP
  IF p^=nul THEN o^:=nul; EXIT;
  ELSIF p^='%' THEN
   INC(p);
   IF p^='E' THEN o^:=esc;
   ELSIF p^='N' THEN o^:=eol;
   ELSIF p^='T' THEN o^:=ht;
   ELSIF p^='m' THEN AddI(month,2);
   ELSIF p^='d' THEN AddI(day,2);
   ELSIF p^='y' THEN AddI(year MOD 100,2);
   ELSIF p^='Y' THEN AddI(year,4);
   ELSIF p^='H' THEN AddI(hour,2);
   ELSIF p^='M' THEN AddI(minute,2);
   ELSIF p^='S' THEN AddI(second,2);
   ELSIF p^='t' THEN AddMonth(month);
   ELSIF ('1'<=p^) & (p^<='6') THEN AddI2(micro,INTEGER(p^)-INTEGER('0'));
   ELSE o^:=p^;
   END;
  ELSE
   o^:=p^;
  END;
  INC(p); INC(o);
 END
END DateToStr;

END DateConversions.
