IMPLEMENTATION MODULE Coroutines;
(*$
    LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    NilChk:=FALSE
    StackParms:=FALSE
    LongAlign:=TRUE
*)
(*
 * 2.11.89/ms
 *   In diesem Modul musste zustzlich dafr gesort werden, dass Coroutinen
 *   auch mit der neuen StackCheck Prozedur aus Arts funktionieren. Arts
 *   berprft den Stack anhand der Felder 'spUpper' und 'spLower' in der
 *   'Task' Struktur. Beim Wechsel in eine Coroutine mssen diese Werte
 *   auf dem Stack abgelegt und durch die der Coroutine ersetzt werden.
 *
 * 13.6.90/bp
 *   An den neuen Stackframe und Registerkonvention angepat (ohne A4).
 *   Task herausgenommen, weil ein Wechsel ohne Exec-Hilfe sowieso abstrzt.
 *)

FROM SYSTEM IMPORT
 ADDRESS,ADR,REG,SETREG,ASSEMBLE;
FROM Arts IMPORT
 Assert,Error;
FROM ExecD IMPORT
 Task,execBase,ExecBase;

CONST
 MP=15B;
 saveStack=1600; (* AmigaDOS braucht etwa 1500 Byte auf dem Stack *)
 coTitle="Coroutines";
 npTitle="Coroutines.NEWPROCESS";
 notEnoughStack=
(*    "Insufficient Stackspace"; *)
      "Arbeitsspeicher zu klein";
 coError=
(*    "Illegal end of Coroutine"; *)
      "Unerlaubtes Ende einer Coroutine";

TYPE
(*
 * StackFrame is used to build a stack image as it is produced by a call
 * to TRANSFER. NEWPROCESS initialises this stack for the first TRANSFER.
 *
 *     +-------------------+
 *     | older return adr. | higher memory
 *     +-------------------+
 *     |   parameter 0     |
 *     +-------------------+
 *     |   parameter 1     |
 *     +-------------------+
 *     |  return address   |
 *     +-------------------+
 *     |     old mp        | <-- mp
 *     +-------------------+
 *     |  local variables  |
 *     +-------------------+ <-- sp
 *)

 LocVar=RECORD
  d2,d3,d4,d5,d6,d7,a2,a3,a6:ADDRESS;
  cp,stkUpper,stkLower:ADDRESS;
 END;

 StackFrame=RECORD
  loc:LocVar;
  mp: ADDRESS;
  ret: PROC;
  p0,p1: ADDRESS;
  oret: PROC
 END;

CONST
  LocSize=SIZE(LocVar);

(*
 * All coroutines which are not endless LOOPs return to this routine.
 * The program will be terminated immediately.
 *)
PROCEDURE IllegalExit;
BEGIN
 Error(ADR(coTitle),ADR(coError))
END IllegalExit;

(*
 * mp holds all the procedure context. Switch mp and you are in another
 * coroutine. The entry/exit code of TRANSFER restores the sp and mp
 * registers. Switching mp also switches to the new local variables, so
 * the stkUpper, stkLower values get valid. Nice, isn't it?
 *)
(* Verhindere, da noch Register gerettet werden! *)
(*$ EntryExitCode:=FALSE*)
PROCEDURE TRANSFER(VAR source,destination: PROCESS);
VAR
  l:LocVar;
BEGIN
  ASSEMBLE(
	LINK	A5,#-LocSize
	MOVEM.L	D2-D7/A2/A3/A6,l.d2(A5)
	MOVE.L	destination(A5),A0
	MOVE.L	(A0),l.cp(A5)
	MOVE.L	execBase,A1
	MOVE.L	ExecBase.thisTask(A1),A1
	MOVE.L	Task.spUpper(A1),l.stkUpper(A5)
	MOVE.L	Task.spLower(A1),l.stkLower(A5)
	MOVE.L	source(A5),A0
	MOVE.L	A5,(A0)

	MOVE.L	l.cp(A5),A5 (* Hier switch!! Neues A5 *)
	MOVEM.L	l.d2(A5),D2-D7/A2/A3/A6
	MOVE.L	l.stkUpper(A5),Task.spUpper(A1)
	MOVE.L	l.stkLower(A5),Task.spLower(A1)
	UNLK	A5
	MOVE.L	(A7)+,A0
	ADDQ.L	#8,A7
	JMP	(A0)
	END);
(*
 * cp:=destination;
 *
 *WITH task^ DO
 * stkUpper:=spUpper;
 * stkLower:=spLower;
 *END;
 *
 *source:=REG(MP);
 *SETREG(MP, cp);
 *
(* Nun haben wir andere lokale Variablen! *)
 *WITH task^ DO
 * spUpper:=stkUpper;
 * spLower:=stkLower;
 *END;
 *)
END TRANSFER;

(*
 * NEWPROCESS creates a stackframe which would exit after a call to TRANSFER.
 *)
PROCEDURE NEWPROCESS(p: PROC; wsp: ADDRESS; size: LONGINT; VAR new: PROCESS);
VAR
 pp: POINTER TO StackFrame;
BEGIN
 IF size<coroutinesMinStack THEN
  Error(ADR(npTitle),ADR(notEnoughStack));
 END;
 pp:=ADDRESS(wsp+size-SIZE(StackFrame));
 WITH pp^ DO
  loc.stkLower:=wsp+coroutinesSaveStack;
  loc.stkUpper:=wsp+size;
  loc.d2:=0; loc.d3:=0; loc.d4:=0;
  loc.d5:=0; loc.d6:=0; loc.d7:=0;
  loc.a2:=0; loc.a3:=0; loc.a6:=0;
  mp:=NIL;
  ret:=p;
  oret:=IllegalExit;
 END;
 new:=ADR(pp^.mp)
END NEWPROCESS;

BEGIN
 coroutinesMinStack:=2000;
 coroutinesSaveStack:=1600;
END Coroutines.
