IMPLEMENTATION MODULE Call;
(* 10.6.90/bp *)
(*$
    LargeVars:=FALSE
    StackChk:=FALSE
    RangeChk:=FALSE
    OverflowChk:=FALSE
    Volatile:=FALSE
    NilChk:=FALSE
    StackParms:=FALSE
    LongAlign:=FALSE
*)

FROM SYSTEM	IMPORT	ASSEMBLE,ADDRESS;
FROM Arts	IMPORT	SysErr, thisTask, SystemError, Terminate;
FROM ExecD	IMPORT	Task;

TYPE
  LevelEntry = RECORD
    stackPtr,
    stkUpper,
    stkLower: ADDRESS;
  END;

CONST
  maxLevel = 7;
  entrySize = SIZE(LevelEntry);

VAR
  currentLevel: INTEGER;
  stack: ARRAY [0..maxLevel] OF LevelEntry;

(* Ruft eine PROC auf, die dann bei Bedarf mit Return zurckkehren kann. *)
(*$ EntryExitCode:=FALSE *)
PROCEDURE Call(p{8}:PROC);
CONST illOrd = ORD(illCall);
BEGIN
  ASSEMBLE(
	MOVE.W	currentLevel(A4),D0
	CMPI.W	#maxLevel,D0
	BLE.S	ok
	MOVEQ	#illOrd,D0
	JSR	SystemError(PC)
  ok:
	LEA	stack(A4),A1
	MULS.W	#entrySize,D0
	ADDA.W	D0,A1		(* A1 nun auf aktuellen Entry *)

 (*
  * Da Return jederzeit erfolgen kann, mssen alle Register gerettet werden!
  *)
	MOVEM.L	D2-D7/A2-A6,-(A7)

	MOVE.L	A7,D0
	SUBQ.L	#4,D0 (* fr RetAddr *)
	MOVE.L	D0,(A1)+
	MOVE.L	thisTask(A4),A2
	MOVE.L	Task.spUpper(A2),(A1)+
	MOVE.L	Task.spLower(A2),(A1)+
	ADDQ.W	#1,currentLevel(A4)
	JSR	(A0)	(* hier geht er und hier kommt er! Register zerstrt! *)
	MOVEM.L	(A7)+,D2-D7/A2-A6 (* A1 schon von Return besetzt! *)

	MOVE.W	currentLevel(A4),D0 (* Lieber nochmal rechnen als Abstrze! *)
	SUBQ.W	#1,D0
	MOVE.W	D0,currentLevel(A4)
	LEA	stack(A4),A1  (* Wir hoffen, A4 ist noch ok! *)
	MULS.W	#entrySize,D0
	LEA	4(A1,D0.W),A1 (* hinter stackPtr *)
	MOVE.L	thisTask(A4),A0
	MOVE.L	(A1)+,Task.spUpper(A0)
	MOVE.L	(A1)+,Task.spLower(A0)
	RTS
  END);
END Call;

(* zurck an den Caller oder Programmende *)
(*$ EntryExitCode:=FALSE *)
PROCEDURE Return;
BEGIN
  ASSEMBLE(
	MOVE.W	currentLevel(A4),D0
	SUBQ.W	#1,D0
	BGE.S	ok
	JSR	Terminate(PC) (* Return aus Level 0 = Programmende *)
  ok:	LEA	stack(A4),A1  (* Wir hoffen, A4 ist noch ok! *)
	MULS.W	#entrySize,D0
	ADDA.W	D0,A1
	MOVE.L	(A1),A7
	RTS
  END);
END Return;

(*$ EntryExitCode:=FALSE *)
BEGIN
  (* currentLevel:=0; *)
  ASSEMBLE(RTS END);
CLOSE
  ASSEMBLE(RTS END);
END Call.mod
