IMPLEMENTATION MODULE AslRequest;

(*$ LargeVars:=FALSE *)
FROM SYSTEM	IMPORT	ADR, ADDRESS,TAG,CAST;
FROM UtilityD	IMPORT	tagEnd,tagIgnore;
FROM String	IMPORT	Copy, LastPos, Length, Concat;
IMPORT AslD,AslL, DosD,DosL, ID:IntuitionD, Arts;

VAR
  (*$ LongAlign:=TRUE *)
  myReq:AslD.FileRequesterPtr;
  buff:ARRAY[0..20] OF LONGINT;
  File, Dir: ARRAY[0..255] OF CHAR;


(*$ RangeChk:=FALSE StackChk:=FALSE OverflowChk:=FALSE StackParms:=FALSE
    Volatile:=FALSE
 *)

(* Zerlege f in file und dir *)
PROCEDURE GetPath(VAR f,d:ARRAY OF CHAR);
VAR pos,i:INTEGER;
BEGIN
  Copy(d,f);
  pos:=LastPos(f,-1,'/');
  IF pos<0 THEN
    pos:=LastPos(f,-1,':');
  END;
  IF pos>=0 THEN
    IF d[pos]=':' THEN d[pos+1]:=0C ELSE d[pos]:=0C END;
    INC(pos);
    FOR i:=pos TO Length(f) DO
      f[i-pos]:=f[i]
    END;
    f[i]:=0C;
  ELSE
    d[0]:=0C
  END;
END GetPath;


(*$ CopyDyn:=FALSE *)
PROCEDURE FileReq(
		VAR FName:ARRAY OF CHAR;
		Title,
		Pattern:ARRAY OF CHAR;
		save:BOOLEAN
		):BOOLEAN;
VAR
  flags:AslD.FileReqFlagSet;
  ok:BOOLEAN;
  window:ID.WindowPtr;
  pat:LONGCARD;
BEGIN
  IF Pattern[0]=0C THEN
    pat:=tagIgnore
  ELSE
    pat:=ORD(AslD.aslPattern)
  END;
  window:=CAST(DosD.ProcessPtr,Arts.thisTask)^.windowPtr;
  IF CAST(LONGINT,window)<0 THEN
    RETURN FALSE
  END;
  Copy(File,FName);
  GetPath(File,Dir);
  IF (window#NIL)&(window^.userPort#NIL) THEN
    flags:=AslD.FileReqFlagSet{AslD.filNewIDCMP}
  ELSE
    flags:=AslD.FileReqFlagSet{}
  END;
  IF save THEN
    flags:=flags+AslD.FileReqFlagSet{AslD.filPatGad,AslD.filSave}
  ELSE
    flags:=flags+AslD.FileReqFlagSet{AslD.filPatGad}
  END;
  IF myReq=NIL THEN
    myReq:=AslL.AllocAslRequest(AslD.aslFileRequest,TAG(buff,
      AslD.aslPattern, ADR('#?'),
      tagEnd));
  END;
  IF myReq#NIL THEN
    ok:=AslL.AslRequest(myReq,TAG(buff,
    	    AslD.aslHail,	ADR(Title),
	    AslD.aslWindow,	window,
	    pat,		ADR(Pattern),
	    AslD.aslDir,	ADR(Dir),
	    AslD.aslFile,	ADR(File),
	    AslD.aslFuncFlags,	flags,
	    AslD.aslExtFlags1,	AslD.Fil1FlagSet{},
	    tagEnd));
  ELSE
    ok:=FALSE;
  END;
  IF ok THEN
    Copy(FName,myReq^.dir^);
    IF ~DosL.AddPart(ADR(FName),myReq^.file,HIGH(FName)+1) THEN
      ok:=FALSE
    END;
  END;
  RETURN ok;
END FileReq;

(*$ CopyDyn:=FALSE *)
PROCEDURE DirReq(
		VAR DName:ARRAY OF CHAR;
		Title:ARRAY OF CHAR
		):BOOLEAN;
VAR
  flags:AslD.FileReqFlagSet;
  ok:BOOLEAN;
  window:ID.WindowPtr;
BEGIN
  window:=CAST(DosD.ProcessPtr,Arts.thisTask)^.windowPtr;
  IF CAST(LONGINT,window)<0 THEN
    RETURN FALSE
  END;
  IF (window#NIL)&(window^.userPort#NIL) THEN
    flags:=AslD.FileReqFlagSet{AslD.filNewIDCMP}
  ELSE
    flags:=AslD.FileReqFlagSet{}
  END;
  IF myReq=NIL THEN
    myReq:=AslL.AllocAslRequest(AslD.aslFileRequest,TAG(buff,
      AslD.aslPattern,	ADR('#?'),
      tagEnd));
  END;
  IF myReq#NIL THEN
    ok:=AslL.AslRequest(myReq,TAG(buff,
    	    AslD.aslHail,	ADR(Title),
	    AslD.aslWindow,	window,
	    AslD.aslDir,	ADR(DName),
	    AslD.aslFuncFlags,	flags,
	    AslD.aslExtFlags1,	AslD.Fil1FlagSet{AslD.fil1NoFiles},
	    tagEnd));
  ELSE
    ok:=FALSE;
  END;
  IF ok THEN
    Copy(DName,myReq^.dir^);
  END;
  RETURN ok;
END DirReq;

BEGIN
  (*myReq:=NIL;*)
CLOSE
  IF myReq#NIL THEN AslL.FreeAslRequest(myReq); myReq:=NIL END;
END AslRequest.mod
