/*
 * The routines in this file are called to create a subjob running a command
 * interpreter. This code is a big fat nothing on CP/M-86. You lose.
 */
#include <stdio.h>
#include <exec/types.h>
#include <clib/dos_protos.h>
#include <clib/dos_pragmas.h>
#include "ed.h"

#define  NEW   1006
#define  WINDOWSPEX "CON:0/30/640/150/M2Emacs CLI"
extern void screenback(), screenfront();

/*
 * Create a subjob with a copy of the command intrepreter in it. When the
 * command interpreter exits, mark the screen as garbage so that you do a full
 * repaint. Bound to "C-C". The message at the start in VMS puts out a newline.
 * Under some (unknown) condition, you don't get one free when DCL starts up.
 */
spawncli(f, n)
{
  long newcli;

  newcli = Open(WINDOWSPEX, NEW);
  if (newcli) {
#ifdef DEUTSCH
    mlwrite("[Aufstarten des neuen CLI]");
#else
    mlwrite("[Starting new CLI]");
#endif
    sgarbf = TRUE;
    screenback();
    Execute("", newcli, 0);
    Close(newcli);
    screenfront();
    return(TRUE);
  }
  else {
    mlwrite("Cannot open CLI window");
    return (FALSE);
  }
}

/*
 * Run a one-liner in a subjob. When the command returns, wait for a single
 * character to be typed, then mark the screen as garbage so a full repaint is
 * done. Bound to "C-X !".
 */
spawn(f, n)
{
  register int s;
  char line[NLINE];
  long newcli;

#ifdef DEUTSCH
  if ((s=mlreply("CLI Befehl: ", line, NLINE)) != TRUE)
#else
  if ((s=mlreply("CLI command: ", line, NLINE)) != TRUE)
#endif
    return (s);
  newcli = Open(WINDOWSPEX, NEW);
  if (newcli) {
    screenback();
    Execute(line,0,newcli);
    screenfront();
    Close(newcli);
  }
  while (GetChar() != '\r');
  sgarbf = TRUE;
  return(TRUE);
}
