
# #!/bin/bash
# #!/bin/ksh
# #!/bin/zsh

# No specific shell called as it is NOT fully POSIX compliant.
# ASSUMING 'ksh' is used......
# ......Call as:
#         ksh [~/full/path/to/]EM81_Magic_Eye_AMIGA_Orig.sh<CR>
# Where <CR> is the RETURN/ENTER key.

# EM81_Simulator.sh
# EM81, (6DA5 and 65ME), "magic eye" simulator demo.
# Video of a real one here:
# https://www.youtube.com/watch?v=H2zKvQkMx6A
# The one on the right I have done years ago...

# $VER (C)2025_B.Walker,_G0LCU,_EM81_Simulator.sh_Version_1.00.00._Issued_as_CC0_Public_Domain.

# The builtins and utilities used are fully POSIX compliant.

randnum=0
number=0
timer=1
# 'delay' is found by trial and error but should be OK for this DEMO.
delay=75
platform=$( uname )
if [ "${platform}" = "AmigaOS" ]
then
	delay=0
fi


clrscn()
{
	printf "%b" "\033c\033[2J\033[H\033[0m"
}

Top_LH_Corner()
{
	printf "%b" "\033[H\033[0m"
}

# All sixteen displays to cover _no_sgnal_ to _overload_...
no_signal()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[0;33m"""""""""""""\033[0m *
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[1;32m**\033[0;33m"""""\033[0;33m^\033[0;33m"""""\033[1;32m**\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

one()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[0;33m"""""""""""""\033[0m *
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[1;32m*\033[0;33m"""""""""""""\033[1;32m*\033[0m*
				 *\033[1;32m***\033[0;33m""""\033[0;33m^\033[0;33m""""\033[1;32m***\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

two()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[0;33m"""""""""""""\033[0m *
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[1;32m*\033[0;33m"""""""""""""\033[1;32m*\033[0m*
				 *\033[1;32m***\033[0;33m"""""""""\033[1;32m***\033[0m*
				 *\033[1;32m****\033[0;33m"""\033[0;33m^\033[0;33m"""\033[1;32m****\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
} 

three()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[0;33m"""""""""""""\033[0m *
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[1;32m*\033[0;33m"""""""""""""\033[1;32m*\033[0m*
				 *\033[1;32m***\033[0;33m"""""""""\033[1;32m***\033[0m*
				 *\033[1;32m****\033[0;33m"""""""\033[1;32m****\033[0m*
				 *\033[1;32m*****\033[0;33m""\033[0;33m^\033[0;33m""\033[1;32m*****\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

four()
{
	Top_LH_Corner
	printf '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[0;33m"""""""""""""\033[0m *
				 *\033[0;33m"""""""""""""""\033[0m*
				 *\033[1;32m*\033[0;33m"""""""""""""\033[1;32m*\033[0m*
				 *\033[1;32m**\033[0;33m"""""""""""\033[1;32m**\033[0m*
				 *\033[1;32m****\033[0;33m"""""""\033[1;32m****\033[0m*
				 *\033[1;32m*****\033[0;33m"""""\033[1;32m*****\033[0m*
				 *\033[1;32m*****\033[0;33m""\033[0;33m^\033[0;33m""\033[1;32m*****\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

five()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[0;33m"""""""""""""\033[0m *
				 *\033[1;32m*\033[0;33m"""""""""""""\033[1;32m*\033[0m*
				 *\033[1;32m**\033[0;33m"""""""""""\033[1;32m**\033[0m*
				 *\033[1;32m***\033[0;33m"""""""""\033[1;32m***\033[0m*
				 *\033[1;32m****\033[0;33m"""""""\033[1;32m****\033[0m*
				 *\033[1;32m*****\033[0;33m"""""\033[1;32m*****\033[0m*
				 *\033[1;32m******\033[0;33m"\033[0;33m^\033[0;33m"\033[1;32m******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

six()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[\033[0;33m"""""""""""""\033[0m *
				 *\033[1;32m**\033[0;33m"""""""""""\033[1;32m**\033[0m*
				 *\033[1;32m***\033[0;33m"""""""""\033[1;32m***\033[0m*
				 *\033[1;32m****\033[0;33m"""""""\033[1;32m****\033[0m*
				 *\033[1;32m*****\033[0;33m"""""\033[1;32m*****\033[0m*
				 *\033[1;32m*****\033[0;33m"""""\033[1;32m*****\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

seven()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[1;32m*\033[0;33m"""""""""""\033[1;32m*\033[0m *
				 *\033[1;32m***\033[0;33m"""""""""\033[1;32m***\033[0m*
				 *\033[1;32m****\033[0;33m"""""""\033[1;32m****\033[0m*
				 *\033[1;32m*****\033[0;33m"""""\033[1;32m*****\033[0m*
				 *\033[1;32m*****\033[0;33m"""""\033[1;32m*****\033[0m*
				 *\033[1;32m******\033[0;33m"""\033[1;32m******\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

eight()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[1;32m*\033[0;33m"""""""""""\033[1;32m*\033[0m *
				 *\033[1;32m****\033[0;33m"""""""\033[1;32m****\033[0m*
				 *\033[1;32m*****\033[0;33m"""""\033[1;32m*****\033[0m*
				 *\033[1;32m******\033[0;33m"""\033[1;32m******\033[0m*
				 *\033[1;32m******\033[0;33m"""\033[1;32m******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

nine()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[1;32m**\033[0;33m"""""""""\033[1;32m**\033[0m *
				 *\033[1;32m****\033[0;33m"""""""\033[1;32m****\033[0m*
				 *\033[1;32m******\033[0;33m"""\033[1;32m******\033[0m*
				 *\033[1;32m******\033[0;33m"""\033[1;32m******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

ten()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[0;33m"""""""""\033[0m  **
				 * \033[1;32m***\033[0;33m"""""""\033[1;32m***\033[0m *
				 *\033[1;32m******\033[0;33m"""\033[1;32m******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

eleven()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[1;32m*\033[0;33m"""""""\033[1;32m*\033[0m  **
				 * \033[1;32m****\033[0;33m"""""\033[1;32m****\033[0m *
				 *\033[1;32m******\033[0;33m"""\033[1;32m******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

twelve()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[1;32m**\033[0;33m"""""\033[1;32m**\033[0m  **
				 * \033[1;32m*****\033[0;33m"""\033[1;32m*****\033[0m *
				 *\033[1;32m******\033[0;33m"""\033[1;32m******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

thirteen()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[0;33m-\033[0m     **
				 **  \033[1;32m***\033[0;33m"""\033[1;32m***\033[0m  **
				 * \033[1;32m******\033[0;33m"\033[1;32m******\033[0m *
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m"\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

fourteen()
{
	Top_LH_Corner
	printf "%b" '					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[1;32m-\033[0m     **
				 **  \033[1;32m*********\033[0m  **
				 * \033[1;32m*************\033[0m *
				 *\033[1;32m***************\033[0m*
				 *\033[1;32m***************\033[0m*
				 *\033[1;32m***************\033[0m*
				 *\033[1;32m***************\033[0m*
				 *\033[1;32m***************\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

overload()
{
	Top_LH_Corner
	printf "%b "'					.^.
					* *
				       *   *
				    ***     ***
				  **     \033[1;32m_\033[0m     **
				 **  \033[1;32m****\033[1;30;42m \033[0m\033[1;32m****\033[0m  **
				 * \033[1;32m******\033[1;30;42m \033[0m\033[1;32m******\033[0m *
				 *\033[1;32m*******\033[1;30;42m \033[0m\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[1;30;42m \033[0m\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[1;30;42m \033[0m\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[1;30;42m \033[0m\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[1;30;42m \033[0m\033[1;32m*******\033[0m*
				 *\033[1;32m*******\033[0;33m^\033[0m\033[1;32m*******\033[0m*
				 *\033[1;32m****\033[0;33m./.o.\\.\033[1;32m****\033[0m*
				 *\033[1;32m**\033[0mooooooooooo\033[1;32m**\033[0m*
				 *\033[1;32m*\033[0mooooooooooooo\033[1;32m*\033[0m*
				 * ooooooooooooo *
				 * ooooooooooooo *
				 * ooooooooooooo *
				  *ooooooooooooo*
				   *************
'
}

# Display each section for a short period.
clrscn

for display in no_signal one two three four five six seven eight nine ten eleven twelve thirteen fourteen overload
do
	${display}
	printf "%b" "\033[22;1f     Display ${display}...          "
	# 'sleep 1' is fully POSIX compliant...
	sleep 1
done

# Now run the animation.
clrscn

# Use Ctrl-C to stop the loop...
while true
do
	# 'RANDOM' is NOT strictly POSIX compliant but I could easily have used a subset of my WH_RANDOM.sh:
	#     https://main.aminet.net/package/dev/gcc/WH_RANDOM.sh
	# 'WH_RANDOM.sh' IS fully POSIX, 'dash', compliant.
	randnum=$(( ${RANDOM}/128 ))

	# 'number' gives equispaced integer numbers 0 to 14.
	number=$(( randnum/17 ))
	if [ ${number} -eq 0 ];then no_signal;fi
	if [ ${number} -eq 1 ];then one;fi
	if [ ${number} -eq 2 ];then two;fi
	if [ ${number} -eq 3 ];then three;fi
	if [ ${number} -eq 4 ];then four;fi
	if [ ${number} -eq 5 ];then five;fi
	if [ ${number} -eq 6 ];then six;fi
	if [ ${number} -eq 7 ];then seven;fi
	if [ ${number} -eq 8 ];then eight;fi
	if [ ${number} -eq 9 ];then nine;fi
	if [ ${number} -eq 10 ];then ten;fi
	if [ ${number} -eq 11 ];then eleven;fi
	if [ ${number} -eq 12 ];then twelve;fi
	if [ ${number} -eq 13 ];then thirteen;fi
	if [ ${number} -eq 14 ];then fourteen;fi
	# This piece shows the 'overload' display for completeness.
	if [ ${randnum} -ge 251 ];then overload;fi

	# Slow down a little, purely for this demo...
	# Note: 'sleep 0.1' is NOT POSIX compliant.
	# Crude but effective for this DEMO.
	timer=1
	while [ ${timer} -le ${delay} ]
	do
		/bin/true
		timer=$(( ${timer}+1 ))
	done
done

