#ifndef __IX_AMIGA_H
#define __IX_AMIGA_H

/* This header provides prototypes for Amiga specific functions and
 * variables available in ixemul.library or libc.a.
 *
 * Each function is also documented in this header (or will be). Sometimes
 * an Amiga extension is described here, but for ease of use the original
 * prototype or macro is defined elsewhere.
 */


/* This tells you which OS you are running on. */

extern int ix_os;

#define OS_IS_AMIGAOS   0
#define OS_IS_POS       0x704F5300      /* 'pOS\0' */


/* This is the name of the program without the path. E.g., if argv[0] is
 * "/ade/bin/cat", then __progname is "cat".
 */

extern char *__progname;


/* This macro can be ORed with the other flags you pass to open(). It will
 * make the open() function case sensitive. This macro is defined in
 * sys/fcntl.h.
 *
 * #define     O_CASE          0x1000
 */


/* Like vfork(), but the memory that the child allocates will be owned by
 * the child. vfork() uses the parent's memory list, but since vfork2() is
 * used as a fork() emulation, this would be undesirable, not in the least
 * because that memory wouldn't be released until the parent exits. Causing
 * a huge memory leak.
 */

int vfork2(void);


/* Obsolete function to pass pointers to the _ctype_ array and the sys_nerr
 * variable from ixemul to the program. Do not use, use ix_get_vars2()
 * instead.
 *
 * void ix_get_vars(char **ctype, int *_sys_nerr);
 */


/* This function is used to obtain and set variables from ixemul.library.
 * It is easy to add more variables so it has replaced the old ix_get_vars()
 * function. In general, this is not a function you should call yourself.
 * Only the startup code should use this. If you need to call this
 * function for some reason, I recommend that the ix_get_variables()
 * function from crt0.c is used instead (see below).
 */

void ix_get_vars2(int argc, char **ctype, int *_sys_nerr, 
 	          struct Library **sysbase, struct Library **dosbase,
 	          FILE ***fpp, char ***environ_out, char ***environ_in,
 	          int *real_errno, int *real_h_errno, struct __res_state *_res,
 	          int *_res_socket, int *ExecLib);


/* A wrapper function for ix_get_vars2(). This is not an ixemul function,
 * but it is part of crt0.c. The single argument should be set to 0.
 */

void ix_get_variables(int from_vfork_setup_child);


/* This is a wrapper intended to make life just a little bit easier for those
 * who need to use the vfork2()/vfork_resume() trick.  It replaces the old
 * 'ix_resident()/ix_get_vars2()' pair.
 */

void vfork_setup_child(void);


/* This is an implementation extension to the `real' vfork2(). Normally you
 * can only cause the parent to resume by calling _exit() or execve() from
 * the child. Since there is no real fork() on the Amiga, this function
 * is a third possibility to make the parent resume. You have then two
 * concurrent processes sharing the same frame and global data. Please be
 * EXTREMELY careful what you may do and what not. vfork2() itself is a hack,
 * this is an even greater one...
 *
 * DO NOT use this function in combination with vfork(), or you'll get a big
 * memory leak. Only use it with vfork2().
 */

void vfork_resume(void);


/* This function will show a requester with the given formatted string as
 * the body text and with one or two buttons. If button1 is NULL, then an
 * Abort button is shown. If button1 is not NULL, but button2 is, then only
 * a single button is shown. The title of the requester is passed in the
 * first argument. If that argument is NULL, then ixemul will use the program
 * name instead. Use this function to show a message in an OS independent
 * fashion.
 *
 * The function returns 0 is button1 is pressed and 1 otherwise.
 *
 * Example: ix_req(NULL, "Abort", NULL, "%s only supports AmigaOS!", __progname);
 * choice = ix_req(NULL, "Abort", "Continue", "Cannot find file %s", filename);
 */

int ix_req(char *title, char *button1, char *button2, char *fmt, ...);


/* Similar to chmod(), but obtains the original Amiga/pOS protection bits.
 * No translation to Unix protection bits has taken place.
 */

int achmod(char *name, int mode);


/* Like select() but you can pass an extra bitmask as the last argument. In
 * that case select() will also wait on these signal bits and return if one of
 * these signals came in. If you want to know which signals arrived, use
 * the new extselect function.
 */

int aselect(int nfd, fd_set *ifd, fd_set *ofd, fd_set *efd,
            struct timeval *timeout, long mask);


/* Like select() but you can pass a pointer to an extra bitmask as the last
 * argument. In that case select() will also wait on these signal bits and
 * return if one of these signals came in. The contents of mask will be set
 * to the signals that arrived.
 */

int extselect(int nfd, fd_set *ifd, fd_set *ofd, fd_set *efd,
              struct timeval *timeout, long *mask);


#if 0
/* TODO */
use geta4 in callbacks installed using funopen() when -resident
SYSTEM_CALL (CreateExtIO, 27)
SYSTEM_CALL (CreatePort, 28)
SYSTEM_CALL (CreateStdIO, 29)
SYSTEM_CALL (CreateTask, 30)
SYSTEM_CALL (DeleteExtIO, 31)
SYSTEM_CALL (DeletePort, 32)
SYSTEM_CALL (DeleteStdIO, 33)
SYSTEM_CALL (DeleteTask, 34)
__amiga_filehandle
ix_resident
ix_geta4
ix_check_cpu
tracecntl
SYSTEM_CALL (ix_get_gmt_offset, 473)
SYSTEM_CALL (ix_set_gmt_offset, 474)
SYSTEM_CALL (ix_get_default_settings, 475)
SYSTEM_CALL (ix_get_settings, 476)
SYSTEM_CALL (ix_set_settings, 477)
SYSTEM_CALL (__init_stk_limit, 480)
SYSTEM_CALL (__stkovf, 481)
SYSTEM_CALL (__stkext, 482)
SYSTEM_CALL (__stkext_f, 483)
SYSTEM_CALL (__stkrst, 484)
#endif

#endif
