/* Rules for adding mnemonics with the same name but with different
   operand types or cpu-requirements to this table:
   1. When operand types are a subset of another instruction, place it
      *before* that mnemonic.
   2. When operand types match, but cpu-requirements are higher or completely
      different, place it *after* that mnemonic (also important for next
      rule).
   3. Mnemonics with different operation sizes (opcode extensions), but same
      name and operand types, should be kept together. vasm will scan through
      them to find the correct size, and stop on the first different name
      or operand type.
   4. Mnemonics without an operand ({0}) must be the last of those which have
      the same name.
*/
  "abcd",     {D_,D_},      {{RLO,RHI},        {0xc100,0},1|B|S_NONE,m68000up},
  "abcd",     {PA,PA},      {{RLO,RHI},        {0xc108,0},1|B|S_NONE,m68000up},
  "add",      {A_,D_},      {{SEA,RHI},        {0xd000,0},1|CFWL|S_STD,m68000up|mcf},
  "add",      {DA,D_},      {{SEA,RHI},        {0xd000,0},1|CFBWL|S_STD,m68000up|mcf},
  "add",      {D_,AM},      {{RHI,SEA},        {0xd100,0},1|CFBWL|S_STD,m68000up|mcf},
  "add",      {AY,A_},      {{SEA,RHI},        {0xd0c0,0},1|CFWL|S_WL8,m68000up|mcf},
  "add",      {IM,AD},      {{NEA,SEA},        {0x0600,0},1|BWL|S_STD,m68000up},
  "adda",     {AY,A_},      {{SEA,RHI},        {0xd0c0,0},1|CFWL|S_WL8,m68000up|mcf},
  "addi",     {IM,D_},      {{NEA,RLO},        {0x0600,0},1|CFBWL|S_STD,m68000up|mcf},
  "addi",     {IM,AD},      {{NEA,SEA},        {0x0600,0},1|BWL|S_STD,m68000up},
  "addq",     {QI,A_},      {{D3Q,SEA},        {0x5000,0},1|CFWL|S_STD,m68000up|mcf},
  "addq",     {QI,AD},      {{D3Q,SEA},        {0x5000,0},1|CFBWL|S_STD,m68000up|mcf},
  "addx",     {D_,D_},      {{RLO,RHI},        {0xd100,0},1|CFBWL|S_STD,m68000up|mcf},
  "addx",     {PA,PA},      {{RLO,RHI},        {0xd108,0},1|BWL|S_STD,m68000up},
  "and",      {DA,D_},      {{SEA,RHI},        {0xc000,0},1|CFBWL|S_STD,m68000up|mcf},
  "and",      {D_,AM},      {{RHI,SEA},        {0xc100,0},1|CFBWL|S_STD,m68000up|mcf},
  "and",      {IM,AD},      {{NEA,SEA},        {0x0200,0},1|BWL|S_STD,m68000up},
  "and",      {IM,_CCR},    {{NEA,NOP},        {0x023c,0},1|B|S_NONE,m68000up},
  "and",      {IM,_SR},     {{NEA,NOP},        {0x027c,0},1|W|S_NONE,m68000up},
  "andi",     {IM,D_},      {{NEA,RLO},        {0x0200,0},1|CFBWL|S_STD,m68000up|mcf},
  "andi",     {IM,AD},      {{NEA,SEA},        {0x0200,0},1|BWL|S_STD,m68000up},
  "andi",     {IM,_CCR},    {{NEA,NOP},        {0x023c,0},1|B|S_NONE,m68000up},
  "andi",     {IM,_SR},     {{NEA,NOP},        {0x027c,0},1|W|S_NONE,m68000up},
  "asl",      {AM},         {{SEA},            {0xe1c0,0},1|W|S_NONE,m68000up},
  "asl",      {D_,D_},      {{RHI,RLO},        {0xe120,0},1|CFBWL|S_STD,m68000up|mcf},
  "asl",      {QI,D_},      {{D3Q,RLO},        {0xe100,0},1|CFBWL|S_STD,m68000up|mcf},
  "asl",      {D_},         {{RLO},            {0xe300,0},1|CFBWL|S_STD,m68000up|mcf},
  "asr",      {AM},         {{SEA},            {0xe0c0,0},1|W|S_NONE,m68000up},
  "asr",      {D_,D_},      {{RHI,RLO},        {0xe020,0},1|CFBWL|S_STD,m68000up|mcf},
  "asr",      {QI,D_},      {{D3Q,RLO},        {0xe000,0},1|CFBWL|S_STD,m68000up|mcf},
  "asr",      {D_},         {{RLO},            {0xe200,0},1|CFBWL|S_STD,m68000up|mcf},
  /* Two conditional branches must always be followed by two branches
       with the same, but negated, condition! */
  "bhs",      {BR},         {{BRA},            {0x6400,0},1|SBW|S_NONE,m68000up|mcf},
  "bhs",      {BR},         {{BRA},            {0x6400,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "blo",      {BR},         {{BRA},            {0x6500,0},1|SBW|S_NONE,m68000up|mcf},
  "blo",      {BR},         {{BRA},            {0x6500,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bhi",      {BR},         {{BRA},            {0x6200,0},1|SBW|S_NONE,m68000up|mcf},
  "bhi",      {BR},         {{BRA},            {0x6200,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bls",      {BR},         {{BRA},            {0x6300,0},1|SBW|S_NONE,m68000up|mcf},
  "bls",      {BR},         {{BRA},            {0x6300,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bcc",      {BR},         {{BRA},            {0x6400,0},1|SBW|S_NONE,m68000up|mcf},
  "bcc",      {BR},         {{BRA},            {0x6400,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bcs",      {BR},         {{BRA},            {0x6500,0},1|SBW|S_NONE,m68000up|mcf},
  "bcs",      {BR},         {{BRA},            {0x6500,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bne",      {BR},         {{BRA},            {0x6600,0},1|SBW|S_NONE,m68000up|mcf},
  "bne",      {BR},         {{BRA},            {0x6600,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "beq",      {BR},         {{BRA},            {0x6700,0},1|SBW|S_NONE,m68000up|mcf},
  "beq",      {BR},         {{BRA},            {0x6700,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bvc",      {BR},         {{BRA},            {0x6800,0},1|SBW|S_NONE,m68000up|mcf},
  "bvc",      {BR},         {{BRA},            {0x6800,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bvs",      {BR},         {{BRA},            {0x6900,0},1|SBW|S_NONE,m68000up|mcf},
  "bvs",      {BR},         {{BRA},            {0x6900,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bpl",      {BR},         {{BRA},            {0x6a00,0},1|SBW|S_NONE,m68000up|mcf},
  "bpl",      {BR},         {{BRA},            {0x6a00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bmi",      {BR},         {{BRA},            {0x6b00,0},1|SBW|S_NONE,m68000up|mcf},
  "bmi",      {BR},         {{BRA},            {0x6b00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bge",      {BR},         {{BRA},            {0x6c00,0},1|SBW|S_NONE,m68000up|mcf},
  "bge",      {BR},         {{BRA},            {0x6c00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "blt",      {BR},         {{BRA},            {0x6d00,0},1|SBW|S_NONE,m68000up|mcf},
  "blt",      {BR},         {{BRA},            {0x6d00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bgt",      {BR},         {{BRA},            {0x6e00,0},1|SBW|S_NONE,m68000up|mcf},
  "bgt",      {BR},         {{BRA},            {0x6e00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "ble",      {BR},         {{BRA},            {0x6f00,0},1|SBW|S_NONE,m68000up|mcf},
  "ble",      {BR},         {{BRA},            {0x6f00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bra",      {BR},         {{BRA},            {0x6000,0},1|SBW|S_NONE,m68000up|mcf},
  "bra",      {BR},         {{BRA},            {0x6000,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bsr",      {BR},         {{BRA},            {0x6100,0},1|SBW|S_NONE,m68000up|mcf},
  "bsr",      {BR},         {{BRA},            {0x6100,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "bchg",     {D_,D_},      {{RHI,RLO},        {0x0140,0},1|L|S_NONE,m68000up|mcf},
  "bchg",     {D_,AM},      {{RHI,SEA},        {0x0140,0},1|B|S_NONE,m68000up|mcf},
  "bchg",     {QI,D_},      {{EL8,RLO},        {0x0840,0},2|L|S_NONE,m68000up|mcf},
  "bchg",     {QI,CFAM},    {{EL8,SEA},        {0x0840,0},2|B|S_NONE,m68000up|mcf},
  "bchg",     {QI,AM},      {{EL8,SEA},        {0x0840,0},2|B|S_NONE,m68000up},
  "bclr",     {D_,D_},      {{RHI,RLO},        {0x0180,0},1|L|S_NONE,m68000up|mcf},
  "bclr",     {D_,AM},      {{RHI,SEA},        {0x0180,0},1|B|S_NONE,m68000up|mcf},
  "bclr",     {QI,D_},      {{EL8,RLO},        {0x0880,0},2|L|S_NONE,m68000up|mcf},
  "bclr",     {QI,CFAM},    {{EL8,SEA},        {0x0880,0},2|B|S_NONE,m68000up|mcf},
  "bclr",     {QI,AM},      {{EL8,SEA},        {0x0880,0},2|B|S_NONE,m68000up},
  "bset",     {D_,D_},      {{RHI,RLO},        {0x01c0,0},1|L|S_NONE,m68000up|mcf},
  "bset",     {D_,AM},      {{RHI,SEA},        {0x01c0,0},1|B|S_NONE,m68000up|mcf},
  "bset",     {QI,D_},      {{EL8,RLO},        {0x08c0,0},2|L|S_NONE,m68000up|mcf},
  "bset",     {QI,CFAM},    {{EL8,SEA},        {0x08c0,0},2|B|S_NONE,m68000up|mcf},
  "bset",     {QI,AM},      {{EL8,SEA},        {0x08c0,0},2|B|S_NONE,m68000up},
  "btst",     {D_,D_},      {{RHI,RLO},        {0x0100,0},1|L|S_NONE,m68000up|mcf},
  "btst",     {D_,MA},      {{RHI,SEA},        {0x0100,0},1|B|S_NONE,m68000up|mcf},
  "btst",     {QI,D_},      {{EL8,RLO},        {0x0800,0},2|L|S_NONE,m68000up|mcf},
  "btst",     {QI,CFAM},    {{EL8,SEA},        {0x0800,0},2|B|S_NONE,m68000up|mcf},
  "btst",     {QI,MA},      {{EL8,SEA},        {0x0800,0},2|B|S_NONE,m68000up},
  "bfchg",    {BD},         {{BEA},            {0xeac0,0},2|UNS|S_NONE,m68020up},
  "bfclr",    {BD},         {{BEA},            {0xecc0,0},2|UNS|S_NONE,m68020up},
  "bfexts",   {BS,D_},      {{BEA,R2H},        {0xebc0,0},2|UNS|S_NONE,m68020up},
  "bfextu",   {BS,D_},      {{BEA,R2H},        {0xe9c0,0},2|UNS|S_NONE,m68020up},
  "bfffo",    {BS,D_},      {{BEA,R2H},        {0xedc0,0},2|UNS|S_NONE,m68020up},
  "bfins",    {D_,BD},      {{R2H,BEA},        {0xefc0,0},2|UNS|S_NONE,m68020up},
  "bfset",    {BD},         {{BEA},            {0xeec0,0},2|UNS|S_NONE,m68020up},
  "bftst",    {BS},         {{BEA},            {0xe8c0,0},2|UNS|S_NONE,m68020up},
  "bgnd",     {0},          {{0},              {0x4afa,0},1|UNS|S_NONE,cpu32},
  "bitrev",   {D_},         {{RLO},            {0x00c0,0},1|L|S_NONE,mcfaplus|mcfc},
  "bkpt",     {QI},         {{DL3},            {0x4848,0},1|UNS|S_NONE,m68010up},
  "byterev",  {D_},         {{RLO},            {0x02c0,0},1|L|S_NONE,mcfaplus|mcfc},
  "callm",    {QI,CT},      {{EL8,SEA},        {0x06c0,0},2|UNS|S_NONE,m68020},
  "cas",      {D_,D_,AM},   {{R2L,R2M,SEA},    {0x08c0,0},2|BWL|S_CAS,m68020up},
  "cas2",     {DD,DD,CS},   {{CS1,CS2,CS3},    {0x08fc,0},3|WL|S_CAS,m68020up},
  "chk",      {DA,D_},      {{SEA,RHI},        {0x4100,0},1|WL|S_LW7,m68000up},
  "chk2",     {CT,R_},      {{SEA,C2H},        {0x00c0,0x0800},2|BWL|S_HI,m68020up|cpu32},
  "clr",      {AD},         {{SEA},            {0x4200,0},1|BWL|S_STD,m68000up|mcf},
  "cmp",      {A_,D_},      {{SEA,RHI},        {0xb000,0},1|WL|S_STD,mcfb|mcfc},
  "cmp",      {A_,D_},      {{SEA,RHI},        {0xb000,0},1|CFWL|S_STD,m68000up|mcf},
  "cmp",      {DA,D_},      {{SEA,RHI},        {0xb000,0},1|BWL|S_STD,mcfb|mcfc},
  "cmp",      {DA,D_},      {{SEA,RHI},        {0xb000,0},1|CFBWL|S_STD,m68000up|mcf},
  "cmp",      {AY,A_},      {{SEA,RHI},        {0xb0c0,0},1|WL|S_WL8,mcfb|mcfc},
  "cmp",      {AY,A_},      {{SEA,RHI},        {0xb0c0,0},1|CFWL|S_WL8,m68000up|mcf},
  "cmp",      {IM,AD},      {{NEA,SEA},        {0x0c00,0},1|BWL|S_STD,m68000up},
  "cmp",      {IM,DN},      {{NEA,SEA},        {0x0c00,0},1|BWL|S_STD,m68020up|cpu32},
  "cmp",      {AP,AP},      {{RLO,RHI},        {0xb108,0},1|BWL|S_STD,m68000up},
  "cmpa",     {AY,A_},      {{SEA,RHI},        {0xb0c0,0},1|WL|S_WL8,mcfb|mcfc},
  "cmpa",     {AY,A_},      {{SEA,RHI},        {0xb0c0,0},1|CFWL|S_WL8,m68000up|mcf},
  "cmpi",     {IM,D_},      {{NEA,RLO},        {0x0c00,0},1|BWL|S_STD,mcfb|mcfc},
  "cmpi",     {IM,D_},      {{NEA,RLO},        {0x0c00,0},1|CFBWL|S_STD,m68000up|mcf},
  "cmpi",     {IM,AD},      {{NEA,SEA},        {0x0c00,0},1|BWL|S_STD,m68000up},
  "cmpi",     {IM,DN},      {{NEA,SEA},        {0x0c00,0},1|BWL|S_STD,m68020up|cpu32},
  "cmpm",     {AP,AP},      {{RLO,RHI},        {0xb108,0},1|BWL|S_STD,m68000up},
  "cmp2",     {CT,R_},      {{SEA,C2H},        {0x00c0,0x0000},2|BWL|S_HI,m68020up|cpu32},
  "cinvl",    {_CACHES,AI}, {{CAC,RLO},        {0xf408,0},1|UNS|S_NONE,m68040up},
  "cinvp",    {_CACHES,AI}, {{CAC,RLO},        {0xf410,0},1|UNS|S_NONE,m68040up},
  "cinva",    {_CACHES},    {{CAC},            {0xf418,0},1|UNS|S_NONE,m68040up},
  "cpushl",   {AI},         {{RLO},            {0xf4e8,0},1|UNS|S_NONE,mcf},
  "cpushl",   {_CACHES,AI}, {{CAC,RLO},        {0xf428,0},1|UNS|S_NONE,m68040up},
  "cpushp",   {_CACHES,AI}, {{CAC,RLO},        {0xf430,0},1|UNS|S_NONE,m68040up},
  "cpusha",   {_CACHES},    {{CAC},            {0xf438,0},1|UNS|S_NONE,m68040up},
  "dbt",      {D_,BR},      {{RLO,DBR},        {0x50c8,0},1|W|S_NONE,m68000up},
  "dbf",      {D_,BR},      {{RLO,DBR},        {0x51c8,0},1|W|S_NONE,m68000up},
  "dbra",     {D_,BR},      {{RLO,DBR},        {0x51c8,0},1|W|S_NONE,m68000up},
  "dbhi",     {D_,BR},      {{RLO,DBR},        {0x52c8,0},1|W|S_NONE,m68000up},
  "dbls",     {D_,BR},      {{RLO,DBR},        {0x53c8,0},1|W|S_NONE,m68000up},
  "dbcc",     {D_,BR},      {{RLO,DBR},        {0x54c8,0},1|W|S_NONE,m68000up},
  "dbhs",     {D_,BR},      {{RLO,DBR},        {0x54c8,0},1|W|S_NONE,m68000up},
  "dbcs",     {D_,BR},      {{RLO,DBR},        {0x55c8,0},1|W|S_NONE,m68000up},
  "dblo",     {D_,BR},      {{RLO,DBR},        {0x55c8,0},1|W|S_NONE,m68000up},
  "dbne",     {D_,BR},      {{RLO,DBR},        {0x56c8,0},1|W|S_NONE,m68000up},
  "dbeq",     {D_,BR},      {{RLO,DBR},        {0x57c8,0},1|W|S_NONE,m68000up},
  "dbvc",     {D_,BR},      {{RLO,DBR},        {0x58c8,0},1|W|S_NONE,m68000up},
  "dbvs",     {D_,BR},      {{RLO,DBR},        {0x59c8,0},1|W|S_NONE,m68000up},
  "dbpl",     {D_,BR},      {{RLO,DBR},        {0x5ac8,0},1|W|S_NONE,m68000up},
  "dbmi",     {D_,BR},      {{RLO,DBR},        {0x5bc8,0},1|W|S_NONE,m68000up},
  "dbge",     {D_,BR},      {{RLO,DBR},        {0x5cc8,0},1|W|S_NONE,m68000up},
  "dblt",     {D_,BR},      {{RLO,DBR},        {0x5dc8,0},1|W|S_NONE,m68000up},
  "dbgt",     {D_,BR},      {{RLO,DBR},        {0x5ec8,0},1|W|S_NONE,m68000up},
  "dble",     {D_,BR},      {{RLO,DBR},        {0x5fc8,0},1|W|S_NONE,m68000up},
  "divs",     {CFAD,D_},    {{SEA,RHI},        {0x81c0,0},1|W|S_NONE,m68000up|mcfhwdiv},
  "divs",     {CFAD,D_},    {{SEA,DV1},        {0x4c40,0x0800},2|L|S_NONE,m68020up|cpu32|mcfhwdiv},
  "divs",     {DA,D_},      {{SEA,RHI},        {0x81c0,0},1|W|S_NONE,m68000up|mcfhwdiv},
  "divs",     {DA,D_},      {{SEA,DV1},        {0x4c40,0x0800},2|L|S_NONE,m68020up|cpu32},
  "divs",     {DA,DD},      {{SEA,DV2},        {0x4c40,0x0c00},2|L|S_NONE,m68020up|cpu32},
  "divsl",    {DA,DD},      {{SEA,DV2},        {0x4c40,0x0800},2|L|S_NONE,m68020up|cpu32},
  "divu",     {CFAD,D_},    {{SEA,RHI},        {0x80c0,0},1|W|S_NONE,m68000up|mcfhwdiv},
  "divu",     {CFAD,D_},    {{SEA,DV1},        {0x4c40,0x0000},2|L|S_NONE,m68020up|cpu32|mcfhwdiv},
  "divu",     {DA,D_},      {{SEA,RHI},        {0x80c0,0},1|W|S_NONE,m68000up|mcfhwdiv},
  "divu",     {DA,D_},      {{SEA,DV1},        {0x4c40,0x0000},2|L|S_NONE,m68020up|cpu32},
  "divu",     {DA,DD},      {{SEA,DV2},        {0x4c40,0x0400},2|L|S_NONE,m68020up|cpu32},
  "divul",    {DA,DD},      {{SEA,DV2},        {0x4c40,0x0000},2|L|S_NONE,m68020up|cpu32},
  "eor",      {D_,AD},      {{RHI,SEA},        {0xb100,0},1|CFBWL|S_STD,m68000up|mcf},
  "eor",      {IM,D_},      {{NEA,RLO},        {0x0a00,0},1|CFBWL|S_STD,m68000up|mcf},
  "eor",      {IM,AD},      {{NEA,SEA},        {0x0a00,0},1|BWL|S_STD,m68000up},
  "eor",      {IM,_CCR},    {{NEA,NOP},        {0x0a3c,0},1|B|S_NONE,m68000up},
  "eor",      {IM,_SR},     {{NEA,NOP},        {0x0a7c,0},1|W|S_NONE,m68000up},
  "eori",     {IM,D_},      {{NEA,RLO},        {0x0a00,0},1|CFBWL|S_STD,m68000up|mcf},
  "eori",     {IM,AD},      {{NEA,SEA},        {0x0a00,0},1|BWL|S_STD,m68000up},
  "eori",     {IM,_CCR},    {{NEA,NOP},        {0x0a3c,0},1|B|S_NONE,m68000up},
  "eori",     {IM,_SR},     {{NEA,NOP},        {0x0a7c,0},1|W|S_NONE,m68000up},
  "exg",      {D_,D_},      {{RHI,RLO},        {0xc140,0},1|L|S_NONE,m68000up},
  "exg",      {A_,A_},      {{RHI,RLO},        {0xc148,0},1|L|S_NONE,m68000up},
  "exg",      {D_,A_},      {{RHI,RLO},        {0xc188,0},1|L|S_NONE,m68000up},
  "exg",      {A_,D_},      {{RLO,RHI},        {0xc188,0},1|L|S_NONE,m68000up},
  "ext",      {D_},         {{RLO},            {0x4800,0},1|WL|S_STD1,m68000up|mcf},
  "extb",     {D_},         {{RLO},            {0x4900,0},1|L|S_STD1,m68020up|cpu32|mcf},
  "fabs",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4018},2|SBWL|S_FP,mfloat|mcffpu},
  "fabs",     {CF,F_},      {{SEA,FPN},        {0xf000,0x4018},2|CFANY|S_FP,mcffpu},
  "fabs",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4018},2|ANY|S_FP,mfloat},
  "fabs",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0018},2|FX|S_NONE,mfloat},
  "fabs",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0018},2|FD|S_NONE,mcffpu},
  "fabs",     {F_},         {{FPS},            {0xf000,0x0018},2|FX|S_NONE,mfloat},
  "fabs",     {F_},         {{FPS},            {0xf000,0x0018},2|FD|S_NONE,mcffpu},
  "fsabs",    {D_,F_},      {{SEA,FPN},        {0xf200,0x4058},2|SBWL|S_FP,m68040up|mcffpu},
  "fsabs",    {CF,F_},      {{SEA,FPN},        {0xf200,0x4058},2|CFANY|S_FP,mcffpu},
  "fsabs",    {FA,F_},      {{SEA,FPN},        {0xf200,0x4058},2|ANY|S_FP,m68040up},
  "fsabs",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0058},2|FX|S_NONE,m68040up},
  "fsabs",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0058},2|FD|S_NONE,mcffpu},
  "fsabs",    {F_},         {{FPS},            {0xf200,0x0058},2|FX|S_NONE,m68040up},
  "fsabs",    {F_},         {{FPS},            {0xf200,0x0058},2|FD|S_NONE,mcffpu},
  "fdabs",    {D_,F_},      {{SEA,FPN},        {0xf200,0x405c},2|SBWL|S_FP,m68040up|mcffpu},
  "fdabs",    {CF,F_},      {{SEA,FPN},        {0xf200,0x405c},2|CFANY|S_FP,mcffpu},
  "fdabs",    {FA,F_},      {{SEA,FPN},        {0xf200,0x405c},2|ANY|S_FP,m68040up},
  "fdabs",    {F_,F_},      {{FPM,FPN},        {0xf200,0x005c},2|FX|S_NONE,m68040up},
  "fdabs",    {F_,F_},      {{FPM,FPN},        {0xf200,0x005c},2|FD|S_NONE,mcffpu},
  "fdabs",    {F_},         {{FPS},            {0xf200,0x005c},2|FX|S_NONE,m68040up},
  "fdabs",    {F_},         {{FPS},            {0xf200,0x005c},2|FD|S_NONE,mcffpu},
  "facos",    {D_,F_},      {{SEA,FPN},        {0xf000,0x401c},2|SBWL|S_FP,mfloat},
  "facos",    {FA,F_},      {{SEA,FPN},        {0xf000,0x401c},2|ANY|S_FP,mfloat},
  "facos",    {F_,F_},      {{FPM,FPN},        {0xf000,0x001c},2|FX|S_NONE,mfloat},
  "facos",    {F_},         {{FPS},            {0xf000,0x001c},2|FX|S_NONE,mfloat},
  "fadd",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4022},2|SBWL|S_FP,mfloat|mcffpu},
  "fadd",     {CF,F_},      {{SEA,FPN},        {0xf000,0x4022},2|CFANY|S_FP,mcffpu},
  "fadd",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4022},2|ANY|S_FP,mfloat},
  "fadd",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0022},2|FX|S_NONE,mfloat},
  "fadd",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0022},2|FD|S_NONE,mcffpu},
  "fsadd",    {D_,F_},      {{SEA,FPN},        {0xf200,0x4062},2|SBWL|S_FP,m68040up},
  "fsadd",    {CF,F_},      {{SEA,FPN},        {0xf200,0x4062},2|CFANY|S_FP,mcffpu},
  "fsadd",    {FA,F_},      {{SEA,FPN},        {0xf200,0x4062},2|ANY|S_FP,m68040up},
  "fsadd",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0062},2|FX|S_NONE,m68040up},
  "fsadd",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0062},2|FD|S_NONE,mcffpu},
  "fdadd",    {D_,F_},      {{SEA,FPN},        {0xf200,0x4066},2|SBWL|S_FP,m68040up},
  "fdadd",    {CF,F_},      {{SEA,FPN},        {0xf200,0x4066},2|CFANY|S_FP,mcffpu},
  "fdadd",    {FA,F_},      {{SEA,FPN},        {0xf200,0x4066},2|ANY|S_FP,m68040up},
  "fdadd",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0066},2|FX|S_NONE,m68040up},
  "fdadd",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0066},2|FD|S_NONE,mcffpu},
  "fasin",    {D_,F_},      {{SEA,FPN},        {0xf000,0x400c},2|SBWL|S_FP,mfloat},
  "fasin",    {FA,F_},      {{SEA,FPN},        {0xf000,0x400c},2|ANY|S_FP,mfloat},
  "fasin",    {F_,F_},      {{FPM,FPN},        {0xf000,0x000c},2|FX|S_NONE,mfloat},
  "fasin",    {F_},         {{FPS},            {0xf000,0x000c},2|FX|S_NONE,mfloat},
  "fatan",    {D_,F_},      {{SEA,FPN},        {0xf000,0x400a},2|SBWL|S_FP,mfloat},
  "fatan",    {FA,F_},      {{SEA,FPN},        {0xf000,0x400a},2|ANY|S_FP,mfloat},
  "fatan",    {F_,F_},      {{FPM,FPN},        {0xf000,0x000a},2|FX|S_NONE,mfloat},
  "fatan",    {F_},         {{FPS},            {0xf000,0x000a},2|FX|S_NONE,mfloat},
  "fatanh",   {D_,F_},      {{SEA,FPN},        {0xf000,0x400d},2|SBWL|S_FP,mfloat},
  "fatanh",   {FA,F_},      {{SEA,FPN},        {0xf000,0x400d},2|ANY|S_FP,mfloat},
  "fatanh",   {F_,F_},      {{FPM,FPN},        {0xf000,0x000d},2|FX|S_NONE,mfloat},
  "fatanh",   {F_},         {{FPS},            {0xf000,0x000d},2|FX|S_NONE,mfloat},
  "fbf",      {BR},         {{DBR},            {0xf080,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbeq",     {BR},         {{DBR},            {0xf081,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbogt",    {BR},         {{DBR},            {0xf082,0},1|WL|S_WL6,mfloat|mcffpu},
  "fboge",    {BR},         {{DBR},            {0xf083,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbolt",    {BR},         {{DBR},            {0xf084,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbole",    {BR},         {{DBR},            {0xf085,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbogl",    {BR},         {{DBR},            {0xf086,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbor",     {BR},         {{DBR},            {0xf087,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbun",     {BR},         {{DBR},            {0xf088,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbueq",    {BR},         {{DBR},            {0xf089,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbugt",    {BR},         {{DBR},            {0xf08a,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbuge",    {BR},         {{DBR},            {0xf08b,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbult",    {BR},         {{DBR},            {0xf08c,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbule",    {BR},         {{DBR},            {0xf08d,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbne",     {BR},         {{DBR},            {0xf08e,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbt",      {BR},         {{DBR},            {0xf08f,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbsf",     {BR},         {{DBR},            {0xf090,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbseq",    {BR},         {{DBR},            {0xf091,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbgt",     {BR},         {{DBR},            {0xf092,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbge",     {BR},         {{DBR},            {0xf093,0},1|WL|S_WL6,mfloat|mcffpu},
  "fblt",     {BR},         {{DBR},            {0xf094,0},1|WL|S_WL6,mfloat|mcffpu},
  "fble",     {BR},         {{DBR},            {0xf095,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbgl",     {BR},         {{DBR},            {0xf096,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbgle",    {BR},         {{DBR},            {0xf097,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbngle",   {BR},         {{DBR},            {0xf098,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbngl",    {BR},         {{DBR},            {0xf099,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbnle",    {BR},         {{DBR},            {0xf09a,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbnlt",    {BR},         {{DBR},            {0xf09b,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbnge",    {BR},         {{DBR},            {0xf09c,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbngt",    {BR},         {{DBR},            {0xf09d,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbsne",    {BR},         {{DBR},            {0xf09e,0},1|WL|S_WL6,mfloat|mcffpu},
  "fbst",     {BR},         {{DBR},            {0xf09f,0},1|WL|S_WL6,mfloat|mcffpu},
  "fcmp",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4038},2|SBWL|S_FP,mfloat|mcffpu},
  "fcmp",     {CF,F_},      {{SEA,FPN},        {0xf000,0x4038},2|CFANY|S_FP,mcffpu},
  "fcmp",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4038},2|ANY|S_FP,mfloat},
  "fcmp",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0038},2|FX|S_NONE,mfloat},
  "fcmp",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0038},2|FD|S_NONE,mcffpu},
  "fcos",     {D_,F_},      {{SEA,FPN},        {0xf000,0x401d},2|SBWL|S_FP,mfloat},
  "fcos",     {FA,F_},      {{SEA,FPN},        {0xf000,0x401d},2|ANY|S_FP,mfloat},
  "fcos",     {F_,F_},      {{FPM,FPN},        {0xf000,0x001d},2|FX|S_NONE,mfloat},
  "fcos",     {F_},         {{FPS},            {0xf000,0x001d},2|FX|S_NONE,mfloat},
  "fcosh",    {D_,F_},      {{SEA,FPN},        {0xf000,0x4019},2|SBWL|S_FP,mfloat},
  "fcosh",    {FA,F_},      {{SEA,FPN},        {0xf000,0x4019},2|ANY|S_FP,mfloat},
  "fcosh",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0019},2|FX|S_NONE,mfloat},
  "fcosh",    {F_},         {{FPS},            {0xf000,0x0019},2|FX|S_NONE,mfloat},
  "fdbf",     {D_,BR},      {{RLO,DBR},        {0xf048,0x0000},2|W|S_NONE,mfloat},
  "fdbeq",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0001},2|W|S_NONE,mfloat},
  "fdbogt",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0002},2|W|S_NONE,mfloat},
  "fdboge",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0003},2|W|S_NONE,mfloat},
  "fdbolt",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0004},2|W|S_NONE,mfloat},
  "fdbole",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0005},2|W|S_NONE,mfloat},
  "fdbogl",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0006},2|W|S_NONE,mfloat},
  "fdbor",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0007},2|W|S_NONE,mfloat},
  "fdbun",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0008},2|W|S_NONE,mfloat},
  "fdbueq",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0009},2|W|S_NONE,mfloat},
  "fdbugt",   {D_,BR},      {{RLO,DBR},        {0xf048,0x000a},2|W|S_NONE,mfloat},
  "fdbuge",   {D_,BR},      {{RLO,DBR},        {0xf048,0x000b},2|W|S_NONE,mfloat},
  "fdbult",   {D_,BR},      {{RLO,DBR},        {0xf048,0x000c},2|W|S_NONE,mfloat},
  "fdbule",   {D_,BR},      {{RLO,DBR},        {0xf048,0x000d},2|W|S_NONE,mfloat},
  "fdbne",    {D_,BR},      {{RLO,DBR},        {0xf048,0x000e},2|W|S_NONE,mfloat},
  "fdbt",     {D_,BR},      {{RLO,DBR},        {0xf048,0x000f},2|W|S_NONE,mfloat},
  "fdbsf",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0010},2|W|S_NONE,mfloat},
  "fdbseq",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0011},2|W|S_NONE,mfloat},
  "fdbgt",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0012},2|W|S_NONE,mfloat},
  "fdbge",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0013},2|W|S_NONE,mfloat},
  "fdblt",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0014},2|W|S_NONE,mfloat},
  "fdble",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0015},2|W|S_NONE,mfloat},
  "fdbgl",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0016},2|W|S_NONE,mfloat},
  "fdbgle",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0017},2|W|S_NONE,mfloat},
  "fdbngle",  {D_,BR},      {{RLO,DBR},        {0xf048,0x0018},2|W|S_NONE,mfloat},
  "fdbngl",   {D_,BR},      {{RLO,DBR},        {0xf048,0x0019},2|W|S_NONE,mfloat},
  "fdbnle",   {D_,BR},      {{RLO,DBR},        {0xf048,0x001a},2|W|S_NONE,mfloat},
  "fdbnlt",   {D_,BR},      {{RLO,DBR},        {0xf048,0x001b},2|W|S_NONE,mfloat},
  "fdbnge",   {D_,BR},      {{RLO,DBR},        {0xf048,0x001c},2|W|S_NONE,mfloat},
  "fdbngt",   {D_,BR},      {{RLO,DBR},        {0xf048,0x001d},2|W|S_NONE,mfloat},
  "fdbsne",   {D_,BR},      {{RLO,DBR},        {0xf048,0x001e},2|W|S_NONE,mfloat},
  "fdbst",    {D_,BR},      {{RLO,DBR},        {0xf048,0x001f},2|W|S_NONE,mfloat},
  "fdiv",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4020},2|SBWL|S_FP,mfloat|mcffpu},
  "fdiv",     {CF,F_},      {{SEA,FPN},        {0xf000,0x4020},2|CFANY|S_FP,mcffpu},
  "fdiv",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4020},2|ANY|S_FP,mfloat},
  "fdiv",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0020},2|FX|S_NONE,mfloat},
  "fdiv",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0020},2|FD|S_NONE,mcffpu},
  "fsdiv",    {D_,F_},      {{SEA,FPN},        {0xf200,0x4060},2|SBWL|S_FP,m68040up|mcffpu},
  "fsdiv",    {CF,F_},      {{SEA,FPN},        {0xf200,0x4060},2|CFANY|S_FP,mcffpu},
  "fsdiv",    {FA,F_},      {{SEA,FPN},        {0xf200,0x4060},2|ANY|S_FP,m68040up},
  "fsdiv",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0060},2|FX|S_NONE,m68040up},
  "fsdiv",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0060},2|FD|S_NONE,mcffpu},
  "fddiv",    {D_,F_},      {{SEA,FPN},        {0xf200,0x4064},2|SBWL|S_FP,m68040up|mcffpu},
  "fddiv",    {CF,F_},      {{SEA,FPN},        {0xf200,0x4064},2|CFANY|S_FP,mcffpu},
  "fddiv",    {FA,F_},      {{SEA,FPN},        {0xf200,0x4064},2|ANY|S_FP,m68040up},
  "fddiv",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0064},2|FX|S_NONE,m68040up},
  "fddiv",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0064},2|FD|S_NONE,mcffpu},
  "fetox",    {D_,F_},      {{SEA,FPN},        {0xf000,0x4010},2|SBWL|S_FP,mfloat},
  "fetox",    {FA,F_},      {{SEA,FPN},        {0xf000,0x4010},2|ANY|S_FP,mfloat},
  "fetox",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0010},2|FX|S_NONE,mfloat},
  "fetox",    {F_},         {{FPS},            {0xf000,0x0010},2|FX|S_NONE,mfloat},
  "fetoxm1",  {D_,F_},      {{SEA,FPN},        {0xf000,0x4008},2|SBWL|S_FP,mfloat},
  "fetoxm1",  {FA,F_},      {{SEA,FPN},        {0xf000,0x4008},2|ANY|S_FP,mfloat},
  "fetoxm1",  {F_,F_},      {{FPM,FPN},        {0xf000,0x0008},2|FX|S_NONE,mfloat},
  "fetoxm1",  {F_},         {{FPS},            {0xf000,0x0008},2|FX|S_NONE,mfloat},
  "fgetexp",  {D_,F_},      {{SEA,FPN},        {0xf000,0x401e},2|SBWL|S_FP,mfloat},
  "fgetexp",  {FA,F_},      {{SEA,FPN},        {0xf000,0x401e},2|ANY|S_FP,mfloat},
  "fgetexp",  {F_,F_},      {{FPM,FPN},        {0xf000,0x001e},2|FX|S_NONE,mfloat},
  "fgetexp",  {F_},         {{FPS},            {0xf000,0x001e},2|FX|S_NONE,mfloat},
  "fgetman",  {D_,F_},      {{SEA,FPN},        {0xf000,0x401f},2|SBWL|S_FP,mfloat},
  "fgetman",  {FA,F_},      {{SEA,FPN},        {0xf000,0x401f},2|ANY|S_FP,mfloat},
  "fgetman",  {F_,F_},      {{FPM,FPN},        {0xf000,0x001f},2|FX|S_NONE,mfloat},
  "fgetman",  {F_},         {{FPS},            {0xf000,0x001f},2|FX|S_NONE,mfloat},
  "fint",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4001},2|SBWL|S_FP,mfloat|mcffpu},
  "fint",     {CF,F_},      {{SEA,FPN},        {0xf000,0x4001},2|CFANY|S_FP,mcffpu},
  "fint",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4001},2|ANY|S_FP,mfloat},
  "fint",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0001},2|FX|S_NONE,mfloat},
  "fint",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0001},2|FD|S_NONE,mcffpu},
  "fint",     {F_},         {{FPS},            {0xf000,0x0001},2|FX|S_NONE,mfloat},
  "fint",     {F_},         {{FPS},            {0xf000,0x0001},2|FD|S_NONE,mcffpu},
  "fintrz",   {D_,F_},      {{SEA,FPN},        {0xf000,0x4003},2|SBWL|S_FP,mfloat|mcffpu},
  "fintrz",   {CF,F_},      {{SEA,FPN},        {0xf000,0x4003},2|CFANY|S_FP,mcffpu},
  "fintrz",   {FA,F_},      {{SEA,FPN},        {0xf000,0x4003},2|ANY|S_FP,mfloat},
  "fintrz",   {F_,F_},      {{FPM,FPN},        {0xf000,0x0003},2|FX|S_NONE,mfloat},
  "fintrz",   {F_,F_},      {{FPM,FPN},        {0xf000,0x0003},2|FD|S_NONE,mcffpu},
  "fintrz",   {F_},         {{FPS},            {0xf000,0x0003},2|FX|S_NONE,mfloat},
  "fintrz",   {F_},         {{FPS},            {0xf000,0x0003},2|FD|S_NONE,mcffpu},
  "flog10",   {D_,F_},      {{SEA,FPN},        {0xf000,0x4015},2|SBWL|S_FP,mfloat},
  "flog10",   {FA,F_},      {{SEA,FPN},        {0xf000,0x4015},2|ANY|S_FP,mfloat},
  "flog10",   {F_,F_},      {{FPM,FPN},        {0xf000,0x0015},2|FX|S_NONE,mfloat},
  "flog10",   {F_},         {{FPS},            {0xf000,0x0015},2|FX|S_NONE,mfloat},
  "flog2",    {D_,F_},      {{SEA,FPN},        {0xf000,0x4016},2|SBWL|S_FP,mfloat},
  "flog2",    {FA,F_},      {{SEA,FPN},        {0xf000,0x4016},2|ANY|S_FP,mfloat},
  "flog2",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0016},2|FX|S_NONE,mfloat},
  "flog2",    {F_},         {{FPS},            {0xf000,0x0016},2|FX|S_NONE,mfloat},
  "flogn",    {D_,F_},      {{SEA,FPN},        {0xf000,0x4014},2|SBWL|S_FP,mfloat},
  "flogn",    {FA,F_},      {{SEA,FPN},        {0xf000,0x4014},2|ANY|S_FP,mfloat},
  "flogn",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0014},2|FX|S_NONE,mfloat},
  "flogn",    {F_},         {{FPS},            {0xf000,0x0014},2|FX|S_NONE,mfloat},
  "flognp1",  {D_,F_},      {{SEA,FPN},        {0xf000,0x4006},2|SBWL|S_FP,mfloat},
  "flognp1",  {FA,F_},      {{SEA,FPN},        {0xf000,0x4006},2|ANY|S_FP,mfloat},
  "flognp1",  {F_,F_},      {{FPM,FPN},        {0xf000,0x0006},2|FX|S_NONE,mfloat},
  "flognp1",  {F_},         {{FPS},            {0xf000,0x0006},2|FX|S_NONE,mfloat},
  "fmod",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4021},2|SBWL|S_FP,mfloat},
  "fmod",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4021},2|ANY|S_FP,mfloat},
  "fmod",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0021},2|FX|S_NONE,mfloat},
  "fmove",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0000},2|FX|S_NONE,mfloat},
  "fmove",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0000},2|FD|S_NONE,mcffpu},
  "fmove",    {D_,F_},      {{SEA,FPN},        {0xf000,0x4000},2|SBWL|S_FP,mfloat|mcffpu},
  "fmove",    {CF,F_},      {{SEA,FPN},        {0xf000,0x4000},2|CFANY|S_FP,mcffpu},
  "fmove",    {FA,F_},      {{SEA,FPN},        {0xf000,0x4000},2|ANY|S_FP,mfloat},
  "fmove",    {F_,D_},      {{FPN,SEA},        {0xf000,0x6000},2|SBWL|S_FP,mfloat|mcffpu},
  "fmove",    {F_,AK},      {{FPN,KEA},        {0xf000,0x6000},2|SIZE_PACKED|S_FP,mfloat},
  "fmove",    {F_,CFAM},    {{FPN,SEA},        {0xf000,0x6000},2|CFANY|S_FP,mcffpu},
  "fmove",    {F_,AM},      {{FPN,SEA},        {0xf000,0x6000},2|ANY|S_FP,mfloat},
  "fmove",    {A_,FPIAR},   {{SEA,FPM},        {0xf000,0x8000},2|L|S_NONE,mfloat|mcffpu},
  "fmove",    {CFDA,FR},    {{SEA,FPM},        {0xf000,0x8000},2|L|S_NONE,mcffpu},
  "fmove",    {DA,FR},      {{SEA,FPM},        {0xf000,0x8000},2|L|S_NONE,mfloat},
  "fmove",    {FPIAR,A_},   {{FPM,SEA},        {0xf000,0xa000},2|L|S_NONE,mfloat|mcffpu},
  "fmove",    {FR,CFAD},    {{FPM,SEA},        {0xf000,0xa000},2|L|S_NONE,mcffpu},
  "fmove",    {FR,AD},      {{FPM,SEA},        {0xf000,0xa000},2|L|S_NONE,mfloat},
  "fsmove",   {F_,F_},      {{FPM,FPN},        {0xf200,0x0040},2|FX|S_NONE,m68040up},
  "fsmove",   {F_,F_},      {{FPM,FPN},        {0xf200,0x0040},2|FD|S_NONE,mcffpu},
  "fsmove",   {D_,F_},      {{SEA,FPN},        {0xf200,0x4040},2|SBWL|S_FP,m68040up|mcffpu},
  "fsmove",   {CF,F_},      {{SEA,FPN},        {0xf200,0x4040},2|CFANY|S_FP,mcffpu},
  "fsmove",   {FA,F_},      {{SEA,FPN},        {0xf200,0x4040},2|ANY|S_FP,m68040up},
  "fdmove",   {F_,F_},      {{FPM,FPN},        {0xf200,0x0044},2|FX|S_NONE,m68040up},
  "fdmove",   {F_,F_},      {{FPM,FPN},        {0xf200,0x0044},2|FD|S_NONE,mcffpu},
  "fdmove",   {D_,F_},      {{SEA,FPN},        {0xf200,0x4044},2|SBWL|S_FP,m68040up|mcffpu},
  "fdmove",   {CF,F_},      {{SEA,FPN},        {0xf200,0x4044},2|CFANY|S_FP,mcffpu},
  "fdmove",   {FA,F_},      {{SEA,FPN},        {0xf200,0x4044},2|ANY|S_FP,m68040up},
  "fmovecr",  {QI,F_},      {{FCR,FPN},        {0xf000,0x5c00},2|FX|S_NONE,mfloat},
  "fmovem",   {FL,PA},      {{E8R,SEA},        {0xf000,0xe000},2|FX|S_NONE,mfloat},
  "fmovem",   {FL,CFMM},    {{EL8,SEA},        {0xf000,0xf000},2|FD|S_NONE,mcffpu},
  "fmovem",   {FL,AC},      {{EL8,SEA},        {0xf000,0xf000},2|FX|S_NONE,mfloat},
  "fmovem",   {D_,PA},      {{FMD,SEA},        {0xf000,0xe800},2|FX|S_NONE,mfloat},
  "fmovem",   {D_,AC},      {{FMD,SEA},        {0xf000,0xf800},2|FX|S_NONE,mfloat},
  "fmovem",   {CFMN,FL},    {{SEA,EL8},        {0xf000,0xd000},2|FD|S_NONE,mcffpu},
  "fmovem",   {MR,FL},      {{SEA,EL8},        {0xf000,0xd000},2|FX|S_NONE,mfloat},
  "fmovem",   {MR,D_},      {{SEA,FMD},        {0xf000,0xd800},2|FX|S_NONE,mfloat},
  "fmovem",   {FR,D_},      {{FPM,SEA},        {0xf000,0xa000},2|L|S_NONE,mfloat},
  "fmovem",   {FPIAR,A_},   {{FPM,SEA},        {0xf000,0xa000},2|L|S_NONE,mfloat},
  "fmovem",   {FS,AM},      {{F13,SEA},        {0xf000,0xa000},2|L|S_NONE,mfloat},
  "fmovem",   {D_,FR},      {{SEA,FPM},        {0xf000,0x8000},2|L|S_NONE,mfloat},
  "fmovem",   {A_,FPIAR},   {{SEA,FPM},        {0xf000,0x8000},2|L|S_NONE,mfloat},
  "fmovem",   {MA,FS},      {{SEA,F13},        {0xf000,0x8000},2|L|S_NONE,mfloat},
  "fmul",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4023},2|SBWL|S_FP,mfloat|mcffpu},
  "fmul",     {CF,F_},      {{SEA,FPN},        {0xf000,0x4023},2|CFANY|S_FP,mcffpu},
  "fmul",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4023},2|ANY|S_FP,mfloat},
  "fmul",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0023},2|FX|S_NONE,mfloat},
  "fmul",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0023},2|FD|S_NONE,mcffpu},
  "fsmul",    {D_,F_},      {{SEA,FPN},        {0xf200,0x4063},2|SBWL|S_FP,m68040up|mcffpu},
  "fsmul",    {CF,F_},      {{SEA,FPN},        {0xf200,0x4063},2|CFANY|S_FP,mcffpu},
  "fsmul",    {FA,F_},      {{SEA,FPN},        {0xf200,0x4063},2|ANY|S_FP,m68040up},
  "fsmul",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0063},2|FX|S_NONE,m68040up},
  "fsmul",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0063},2|FD|S_NONE,mcffpu},
  "fdmul",    {D_,F_},      {{SEA,FPN},        {0xf200,0x4067},2|SBWL|S_FP,m68040up|mcffpu},
  "fdmul",    {CF,F_},      {{SEA,FPN},        {0xf200,0x4067},2|CFANY|S_FP,mcffpu},
  "fdmul",    {FA,F_},      {{SEA,FPN},        {0xf200,0x4067},2|ANY|S_FP,m68040up},
  "fdmul",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0067},2|FX|S_NONE,m68040up},
  "fdmul",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0067},2|FD|S_NONE,mcffpu},
  "fneg",     {D_,F_},      {{SEA,FPN},        {0xf000,0x401a},2|SBWL|S_FP,mfloat|mcffpu},
  "fneg",     {CF,F_},      {{SEA,FPN},        {0xf000,0x401a},2|CFANY|S_FP,mcffpu},
  "fneg",     {FA,F_},      {{SEA,FPN},        {0xf000,0x401a},2|ANY|S_FP,mfloat},
  "fneg",     {F_,F_},      {{FPM,FPN},        {0xf000,0x001a},2|FX|S_NONE,mfloat},
  "fneg",     {F_,F_},      {{FPM,FPN},        {0xf000,0x001a},2|FD|S_NONE,mcffpu},
  "fneg",     {F_},         {{FPS},            {0xf000,0x001a},2|FX|S_NONE,mfloat},
  "fneg",     {F_},         {{FPS},            {0xf000,0x001a},2|FD|S_NONE,mcffpu},
  "fsneg",    {D_,F_},      {{SEA,FPN},        {0xf200,0x405a},2|SBWL|S_FP,m68040up|mcffpu},
  "fsneg",    {CF,F_},      {{SEA,FPN},        {0xf200,0x405a},2|CFANY|S_FP,mcffpu},
  "fsneg",    {FA,F_},      {{SEA,FPN},        {0xf200,0x405a},2|ANY|S_FP,m68040up},
  "fsneg",    {F_,F_},      {{FPM,FPN},        {0xf200,0x005a},2|FX|S_NONE,m68040up},
  "fsneg",    {F_,F_},      {{FPM,FPN},        {0xf200,0x005a},2|FD|S_NONE,mcffpu},
  "fsneg",    {F_},         {{FPS},            {0xf200,0x005a},2|FX|S_NONE,m68040up},
  "fsneg",    {F_},         {{FPS},            {0xf200,0x005a},2|FD|S_NONE,mcffpu},
  "fdneg",    {D_,F_},      {{SEA,FPN},        {0xf200,0x405e},2|SBWL|S_FP,m68040up|mcffpu},
  "fdneg",    {CF,F_},      {{SEA,FPN},        {0xf200,0x405e},2|CFANY|S_FP,mcffpu},
  "fdneg",    {FA,F_},      {{SEA,FPN},        {0xf200,0x405e},2|ANY|S_FP,m68040up},
  "fdneg",    {F_,F_},      {{FPM,FPN},        {0xf200,0x005e},2|FX|S_NONE,m68040up},
  "fdneg",    {F_,F_},      {{FPM,FPN},        {0xf200,0x005e},2|FD|S_NONE,mcffpu},
  "fdneg",    {F_},         {{FPS},            {0xf200,0x005e},2|FX|S_NONE,m68040up},
  "fdneg",    {F_},         {{FPS},            {0xf200,0x005e},2|FD|S_NONE,mcffpu},
  "fnop",     {0},          {{0},              {0xf080,0x0000},2|UNS|S_NONE,mfloat|mcffpu},
  "frem",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4025},2|SBWL|S_FP,mfloat},
  "frem",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4025},2|ANY|S_FP,mfloat},
  "frem",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0025},2|FX|S_NONE,mfloat},
  "frestore", {CFMN},       {{SEA},            {0xf140,0},1|UNS|S_NONE,mcffpu},
  "frestore", {MR},         {{SEA},            {0xf140,0},1|UNS|S_NONE,mfloat},
  "fsave",    {CFMM},       {{SEA},            {0xf100,0},1|UNS|S_NONE,mcffpu},
  "fsave",    {MS},         {{SEA},            {0xf100,0},1|UNS|S_NONE,mfloat},
  "fscale",   {D_,F_},      {{SEA,FPN},        {0xf000,0x4026},2|SBWL|S_FP,mfloat},
  "fscale",   {FA,F_},      {{SEA,FPN},        {0xf000,0x4026},2|ANY|S_FP,mfloat},
  "fscale",   {F_,F_},      {{FPM,FPN},        {0xf000,0x0026},2|FX|S_NONE,mfloat},
  "fsf",      {AD},         {{SEA},            {0xf040,0x0000},2|B|S_NONE,mfloat},
  "fseq",     {AD},         {{SEA},            {0xf040,0x0001},2|B|S_NONE,mfloat},
  "fsogt",    {AD},         {{SEA},            {0xf040,0x0002},2|B|S_NONE,mfloat},
  "fsoge",    {AD},         {{SEA},            {0xf040,0x0003},2|B|S_NONE,mfloat},
  "fsolt",    {AD},         {{SEA},            {0xf040,0x0004},2|B|S_NONE,mfloat},
  "fsole",    {AD},         {{SEA},            {0xf040,0x0005},2|B|S_NONE,mfloat},
  "fsogl",    {AD},         {{SEA},            {0xf040,0x0006},2|B|S_NONE,mfloat},
  "fsor",     {AD},         {{SEA},            {0xf040,0x0007},2|B|S_NONE,mfloat},
  "fsun",     {AD},         {{SEA},            {0xf040,0x0008},2|B|S_NONE,mfloat},
  "fsueq",    {AD},         {{SEA},            {0xf040,0x0009},2|B|S_NONE,mfloat},
  "fsugt",    {AD},         {{SEA},            {0xf040,0x000a},2|B|S_NONE,mfloat},
  "fsuge",    {AD},         {{SEA},            {0xf040,0x000b},2|B|S_NONE,mfloat},
  "fsult",    {AD},         {{SEA},            {0xf040,0x000c},2|B|S_NONE,mfloat},
  "fsule",    {AD},         {{SEA},            {0xf040,0x000d},2|B|S_NONE,mfloat},
  "fsne",     {AD},         {{SEA},            {0xf040,0x000e},2|B|S_NONE,mfloat},
  "fst",      {AD},         {{SEA},            {0xf040,0x000f},2|B|S_NONE,mfloat},
  "fssf",     {AD},         {{SEA},            {0xf040,0x0010},2|B|S_NONE,mfloat},
  "fsseq",    {AD},         {{SEA},            {0xf040,0x0011},2|B|S_NONE,mfloat},
  "fsgt",     {AD},         {{SEA},            {0xf040,0x0012},2|B|S_NONE,mfloat},
  "fsge",     {AD},         {{SEA},            {0xf040,0x0013},2|B|S_NONE,mfloat},
  "fslt",     {AD},         {{SEA},            {0xf040,0x0014},2|B|S_NONE,mfloat},
  "fsle",     {AD},         {{SEA},            {0xf040,0x0015},2|B|S_NONE,mfloat},
  "fsgl",     {AD},         {{SEA},            {0xf040,0x0016},2|B|S_NONE,mfloat},
  "fsgle",    {AD},         {{SEA},            {0xf040,0x0017},2|B|S_NONE,mfloat},
  "fsngle",   {AD},         {{SEA},            {0xf040,0x0018},2|B|S_NONE,mfloat},
  "fsngl",    {AD},         {{SEA},            {0xf040,0x0019},2|B|S_NONE,mfloat},
  "fsnle",    {AD},         {{SEA},            {0xf040,0x001a},2|B|S_NONE,mfloat},
  "fsnlt",    {AD},         {{SEA},            {0xf040,0x001b},2|B|S_NONE,mfloat},
  "fsnge",    {AD},         {{SEA},            {0xf040,0x001c},2|B|S_NONE,mfloat},
  "fsngt",    {AD},         {{SEA},            {0xf040,0x001d},2|B|S_NONE,mfloat},
  "fssne",    {AD},         {{SEA},            {0xf040,0x001e},2|B|S_NONE,mfloat},
  "fsst",     {AD},         {{SEA},            {0xf040,0x001f},2|B|S_NONE,mfloat},
  "fsgldiv",  {D_,F_},      {{SEA,FPN},        {0xf000,0x4024},2|SBWL|S_FP,mfloat},
  "fsgldiv",  {FA,F_},      {{SEA,FPN},        {0xf000,0x4024},2|ANY|S_FP,mfloat},
  "fsgldiv",  {F_,F_},      {{FPM,FPN},        {0xf000,0x0024},2|FX|S_NONE,mfloat},
  "fsglmul",  {D_,F_},      {{SEA,FPN},        {0xf000,0x4027},2|SBWL|S_FP,mfloat},
  "fsglmul",  {FA,F_},      {{SEA,FPN},        {0xf000,0x4027},2|ANY|S_FP,mfloat},
  "fsglmul",  {F_,F_},      {{FPM,FPN},        {0xf000,0x0027},2|FX|S_NONE,mfloat},
  "fsin",     {D_,F_},      {{SEA,FPN},        {0xf000,0x400e},2|SBWL|S_FP,mfloat},
  "fsin",     {FA,F_},      {{SEA,FPN},        {0xf000,0x400e},2|ANY|S_FP,mfloat},
  "fsin",     {F_,F_},      {{FPM,FPN},        {0xf000,0x000e},2|FX|S_NONE,mfloat},
  "fsin",     {F_},         {{FPS},            {0xf000,0x000e},2|FX|S_NONE,mfloat},
  "fsincos",  {D_,FF},      {{SEA,FPC},        {0xf000,0x4030},2|SBWL|S_FP,mfloat},
  "fsincos",  {FA,FF},      {{SEA,FPC},        {0xf000,0x4030},2|ANY|S_FP,mfloat},
  "fsincos",  {F_,FF},      {{FPM,FPC},        {0xf000,0x0030},2|FX|S_NONE,mfloat},
  "fsinh",    {D_,F_},      {{SEA,FPN},        {0xf000,0x4002},2|SBWL|S_FP,mfloat},
  "fsinh",    {FA,F_},      {{SEA,FPN},        {0xf000,0x4002},2|ANY|S_FP,mfloat},
  "fsinh",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0002},2|FX|S_NONE,mfloat},
  "fsinh",    {F_},         {{FPS},            {0xf000,0x0002},2|FX|S_NONE,mfloat},
  "fsqrt",    {D_,F_},      {{SEA,FPN},        {0xf000,0x4004},2|SBWL|S_FP,mfloat|mcffpu},
  "fsqrt",    {CF,F_},      {{SEA,FPN},        {0xf000,0x4004},2|CFANY|S_FP,mcffpu},
  "fsqrt",    {FA,F_},      {{SEA,FPN},        {0xf000,0x4004},2|ANY|S_FP,mfloat},
  "fsqrt",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0004},2|FX|S_NONE,mfloat},
  "fsqrt",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0004},2|FD|S_NONE,mcffpu},
  "fsqrt",    {F_},         {{FPS},            {0xf000,0x0004},2|FX|S_NONE,mfloat},
  "fsqrt",    {F_},         {{FPS},            {0xf000,0x0004},2|FD|S_NONE,mcffpu},
  "fssqrt",   {D_,F_},      {{SEA,FPN},        {0xf200,0x4041},2|SBWL|S_FP,m68040up|mcffpu},
  "fssqrt",   {CF,F_},      {{SEA,FPN},        {0xf200,0x4041},2|CFANY|S_FP,mcffpu},
  "fssqrt",   {FA,F_},      {{SEA,FPN},        {0xf200,0x4041},2|ANY|S_FP,m68040up},
  "fssqrt",   {F_,F_},      {{FPM,FPN},        {0xf200,0x0041},2|FX|S_NONE,m68040up},
  "fssqrt",   {F_,F_},      {{FPM,FPN},        {0xf200,0x0041},2|FD|S_NONE,mcffpu},
  "fssqrt",   {F_},         {{FPS},            {0xf200,0x0041},2|FX|S_NONE,m68040up},
  "fssqrt",   {F_},         {{FPS},            {0xf200,0x0041},2|FD|S_NONE,mcffpu},
  "fdsqrt",   {D_,F_},      {{SEA,FPN},        {0xf200,0x4045},2|SBWL|S_FP,m68040up|mcffpu},
  "fdsqrt",   {CF,F_},      {{SEA,FPN},        {0xf200,0x4045},2|CFANY|S_FP,mcffpu},
  "fdsqrt",   {FA,F_},      {{SEA,FPN},        {0xf200,0x4045},2|ANY|S_FP,m68040up},
  "fdsqrt",   {F_,F_},      {{FPM,FPN},        {0xf200,0x0045},2|FX|S_NONE,m68040up},
  "fdsqrt",   {F_,F_},      {{FPM,FPN},        {0xf200,0x0045},2|FD|S_NONE,mcffpu},
  "fdsqrt",   {F_},         {{FPS},            {0xf200,0x0045},2|FX|S_NONE,m68040up},
  "fdsqrt",   {F_},         {{FPS},            {0xf200,0x0045},2|FD|S_NONE,mcffpu},
  "fsub",     {D_,F_},      {{SEA,FPN},        {0xf000,0x4028},2|SBWL|S_FP,mfloat|mcffpu},
  "fsub",     {CF,F_},      {{SEA,FPN},        {0xf000,0x4028},2|CFANY|S_FP,mcffpu},
  "fsub",     {FA,F_},      {{SEA,FPN},        {0xf000,0x4028},2|ANY|S_FP,mfloat},
  "fsub",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0028},2|FX|S_NONE,mfloat},
  "fsub",     {F_,F_},      {{FPM,FPN},        {0xf000,0x0028},2|FD|S_NONE,mcffpu},
  "fssub",    {D_,F_},      {{SEA,FPN},        {0xf200,0x4068},2|SBWL|S_FP,m68040up|mcffpu},
  "fssub",    {FA,F_},      {{SEA,FPN},        {0xf200,0x4068},2|ANY|S_FP,m68040up},
  "fssub",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0068},2|FX|S_NONE,m68040up},
  "fssub",    {F_,F_},      {{FPM,FPN},        {0xf200,0x0068},2|FD|S_NONE,mcffpu},
  "fdsub",    {D_,F_},      {{SEA,FPN},        {0xf200,0x406c},2|SBWL|S_FP,m68040up|mcffpu},
  "fdsub",    {FA,F_},      {{SEA,FPN},        {0xf200,0x406c},2|ANY|S_FP,m68040up},
  "fdsub",    {F_,F_},      {{FPM,FPN},        {0xf200,0x006c},2|FX|S_NONE,m68040up},
  "fdsub",    {F_,F_},      {{FPM,FPN},        {0xf200,0x006c},2|FD|S_NONE,mcffpu},
  "ftan",     {D_,F_},      {{SEA,FPN},        {0xf000,0x400f},2|SBWL|S_FP,mfloat},
  "ftan",     {FA,F_},      {{SEA,FPN},        {0xf000,0x400f},2|ANY|S_FP,mfloat},
  "ftan",     {F_,F_},      {{FPM,FPN},        {0xf000,0x000f},2|FX|S_NONE,mfloat},
  "ftan",     {F_},         {{FPS},            {0xf000,0x000f},2|FX|S_NONE,mfloat},
  "ftanh",    {D_,F_},      {{SEA,FPN},        {0xf000,0x4009},2|SBWL|S_FP,mfloat},
  "ftanh",    {FA,F_},      {{SEA,FPN},        {0xf000,0x4009},2|ANY|S_FP,mfloat},
  "ftanh",    {F_,F_},      {{FPM,FPN},        {0xf000,0x0009},2|FX|S_NONE,mfloat},
  "ftanh",    {F_},         {{FPS},            {0xf000,0x0009},2|FX|S_NONE,mfloat},
  "ftentox",  {D_,F_},      {{SEA,FPN},        {0xf000,0x4012},2|SBWL|S_FP,mfloat},
  "ftentox",  {FA,F_},      {{SEA,FPN},        {0xf000,0x4012},2|ANY|S_FP,mfloat},
  "ftentox",  {F_,F_},      {{FPM,FPN},        {0xf000,0x0012},2|FX|S_NONE,mfloat},
  "ftentox",  {F_},         {{FPS},            {0xf000,0x0012},2|FX|S_NONE,mfloat},
  "ftrapf",   {IM},         {{NEA},            {0xf078,0x0000},2|WL|S_TRAP,mfloat},
  "ftrapf",   {0},          {{0},              {0xf07c,0x0000},2|UNS|S_NONE,mfloat},
  "ftrapeq",  {IM},         {{NEA},            {0xf078,0x0001},2|WL|S_TRAP,mfloat},
  "ftrapeq",  {0},          {{0},              {0xf07c,0x0001},2|UNS|S_NONE,mfloat},
  "ftrapogt", {IM},         {{NEA},            {0xf078,0x0002},2|WL|S_TRAP,mfloat},
  "ftrapogt", {0},          {{0},              {0xf07c,0x0002},2|UNS|S_NONE,mfloat},
  "ftrapoge", {IM},         {{NEA},            {0xf078,0x0003},2|WL|S_TRAP,mfloat},
  "ftrapoge", {0},          {{0},              {0xf07c,0x0003},2|UNS|S_NONE,mfloat},
  "ftrapolt", {IM},         {{NEA},            {0xf078,0x0004},2|WL|S_TRAP,mfloat},
  "ftrapolt", {0},          {{0},              {0xf07c,0x0004},2|UNS|S_NONE,mfloat},
  "ftrapole", {IM},         {{NEA},            {0xf078,0x0005},2|WL|S_TRAP,mfloat},
  "ftrapole", {0},          {{0},              {0xf07c,0x0005},2|UNS|S_NONE,mfloat},
  "ftrapogl", {IM},         {{NEA},            {0xf078,0x0006},2|WL|S_TRAP,mfloat},
  "ftrapogl", {0},          {{0},              {0xf07c,0x0006},2|UNS|S_NONE,mfloat},
  "ftrapor",  {IM},         {{NEA},            {0xf078,0x0007},2|WL|S_TRAP,mfloat},
  "ftrapor",  {0},          {{0},              {0xf07c,0x0007},2|UNS|S_NONE,mfloat},
  "ftrapun",  {IM},         {{NEA},            {0xf078,0x0008},2|WL|S_TRAP,mfloat},
  "ftrapun",  {0},          {{0},              {0xf07c,0x0008},2|UNS|S_NONE,mfloat},
  "ftrapueq", {IM},         {{NEA},            {0xf078,0x0009},2|WL|S_TRAP,mfloat},
  "ftrapueq", {0},          {{0},              {0xf07c,0x0009},2|UNS|S_NONE,mfloat},
  "ftrapugt", {IM},         {{NEA},            {0xf078,0x000a},2|WL|S_TRAP,mfloat},
  "ftrapugt", {0},          {{0},              {0xf07c,0x000a},2|UNS|S_NONE,mfloat},
  "ftrapuge", {IM},         {{NEA},            {0xf078,0x000b},2|WL|S_TRAP,mfloat},
  "ftrapuge", {0},          {{0},              {0xf07c,0x000b},2|UNS|S_NONE,mfloat},
  "ftrapult", {IM},         {{NEA},            {0xf078,0x000c},2|WL|S_TRAP,mfloat},
  "ftrapult", {0},          {{0},              {0xf07c,0x000c},2|UNS|S_NONE,mfloat},
  "ftrapule", {IM},         {{NEA},            {0xf078,0x000d},2|WL|S_TRAP,mfloat},
  "ftrapule", {0},          {{0},              {0xf07c,0x000d},2|UNS|S_NONE,mfloat},
  "ftrapne",  {IM},         {{NEA},            {0xf078,0x000e},2|WL|S_TRAP,mfloat},
  "ftrapne",  {0},          {{0},              {0xf07c,0x000e},2|UNS|S_NONE,mfloat},
  "ftrapt",   {IM},         {{NEA},            {0xf078,0x000f},2|WL|S_TRAP,mfloat},
  "ftrapt",   {0},          {{0},              {0xf07c,0x000f},2|UNS|S_NONE,mfloat},
  "ftrapsf",  {IM},         {{NEA},            {0xf078,0x0010},2|WL|S_TRAP,mfloat},
  "ftrapsf",  {0},          {{0},              {0xf07c,0x0010},2|UNS|S_NONE,mfloat},
  "ftrapseq", {IM},         {{NEA},            {0xf078,0x0011},2|WL|S_TRAP,mfloat},
  "ftrapseq", {0},          {{0},              {0xf07c,0x0011},2|UNS|S_NONE,mfloat},
  "ftrapgt",  {IM},         {{NEA},            {0xf078,0x0012},2|WL|S_TRAP,mfloat},
  "ftrapgt",  {0},          {{0},              {0xf07c,0x0012},2|UNS|S_NONE,mfloat},
  "ftrapge",  {IM},         {{NEA},            {0xf078,0x0013},2|WL|S_TRAP,mfloat},
  "ftrapge",  {0},          {{0},              {0xf07c,0x0013},2|UNS|S_NONE,mfloat},
  "ftraplt",  {IM},         {{NEA},            {0xf078,0x0014},2|WL|S_TRAP,mfloat},
  "ftraplt",  {0},          {{0},              {0xf07c,0x0014},2|UNS|S_NONE,mfloat},
  "ftraple",  {IM},         {{NEA},            {0xf078,0x0015},2|WL|S_TRAP,mfloat},
  "ftraple",  {0},          {{0},              {0xf07c,0x0015},2|UNS|S_NONE,mfloat},
  "ftrapgl",  {IM},         {{NEA},            {0xf078,0x0016},2|WL|S_TRAP,mfloat},
  "ftrapgl",  {0},          {{0},              {0xf07c,0x0016},2|UNS|S_NONE,mfloat},
  "ftrapgle", {IM},         {{NEA},            {0xf078,0x0017},2|WL|S_TRAP,mfloat},
  "ftrapgle", {0},          {{0},              {0xf07c,0x0017},2|UNS|S_NONE,mfloat},
  "ftrapngle",{IM},         {{NEA},            {0xf078,0x0018},2|WL|S_TRAP,mfloat},
  "ftrapngle",{0},          {{0},              {0xf07c,0x0018},2|UNS|S_NONE,mfloat},
  "ftrapngl", {IM},         {{NEA},            {0xf078,0x0019},2|WL|S_TRAP,mfloat},
  "ftrapngl", {0},          {{0},              {0xf07c,0x0019},2|UNS|S_NONE,mfloat},
  "ftrapnle", {IM},         {{NEA},            {0xf078,0x001a},2|WL|S_TRAP,mfloat},
  "ftrapnle", {0},          {{0},              {0xf07c,0x001a},2|UNS|S_NONE,mfloat},
  "ftrapnlt", {IM},         {{NEA},            {0xf078,0x001b},2|WL|S_TRAP,mfloat},
  "ftrapnlt", {0},          {{0},              {0xf07c,0x001b},2|UNS|S_NONE,mfloat},
  "ftrapnge", {IM},         {{NEA},            {0xf078,0x001c},2|WL|S_TRAP,mfloat},
  "ftrapnge", {0},          {{0},              {0xf07c,0x001c},2|UNS|S_NONE,mfloat},
  "ftrapngt", {IM},         {{NEA},            {0xf078,0x001d},2|WL|S_TRAP,mfloat},
  "ftrapngt", {0},          {{0},              {0xf07c,0x001d},2|UNS|S_NONE,mfloat},
  "ftrapsne", {IM},         {{NEA},            {0xf078,0x001e},2|WL|S_TRAP,mfloat},
  "ftrapsne", {0},          {{0},              {0xf07c,0x001e},2|UNS|S_NONE,mfloat},
  "ftrapst",  {IM},         {{NEA},            {0xf078,0x001f},2|WL|S_TRAP,mfloat},
  "ftrapst",  {0},          {{0},              {0xf07c,0x001f},2|UNS|S_NONE,mfloat},
  "ftst",     {D_},         {{SEA},            {0xf000,0x403a},2|SBWL|S_FP,mfloat|mcffpu},
  "ftst",     {CF},         {{SEA},            {0xf000,0x403a},2|CFANY|S_FP,mcffpu},
  "ftst",     {FA},         {{SEA},            {0xf000,0x403a},2|ANY|S_FP,mfloat},
  "ftst",     {F_},         {{FPM},            {0xf000,0x003a},2|FX|S_NONE,mfloat},
  "ftst",     {F_},         {{FPM},            {0xf000,0x003a},2|FD|S_NONE,mcffpu},
  "ftwotox",  {D_,F_},      {{SEA,FPN},        {0xf000,0x4011},2|SBWL|S_FP,mfloat},
  "ftwotox",  {FA,F_},      {{SEA,FPN},        {0xf000,0x4011},2|ANY|S_FP,mfloat},
  "ftwotox",  {F_,F_},      {{FPM,FPN},        {0xf000,0x0011},2|FX|S_NONE,mfloat},
  "ftwotox",  {F_},         {{FPS},            {0xf000,0x0011},2|FX|S_NONE,mfloat},
  "ff1",      {D_},         {{RLO},            {0x04c0,0},1|L|S_NONE,mcfaplus|mcfc},
  "halt",     {0},          {{0},              {0x4ac8,0},1|UNS|S_NONE,m68060|mcf},
  "illegal",  {0},          {{0},              {0x4afc,0},1|UNS|S_NONE,m68000up|mcf},
  "intouch",  {AI},         {{RLO},            {0xf428,0},1|UNS|S_NONE,mcfb|mcfc},
  "jhs",      {BR},         {{BRA},            {0x6400,0},1|SBW|S_NONE,m68000up|mcf},
  "jhs",      {BR},         {{BRA},            {0x6400,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jlo",      {BR},         {{BRA},            {0x6500,0},1|SBW|S_NONE,m68000up|mcf},
  "jlo",      {BR},         {{BRA},            {0x6500,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jhi",      {BR},         {{BRA},            {0x6200,0},1|SBW|S_NONE,m68000up|mcf},
  "jhi",      {BR},         {{BRA},            {0x6200,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jls",      {BR},         {{BRA},            {0x6300,0},1|SBW|S_NONE,m68000up|mcf},
  "jls",      {BR},         {{BRA},            {0x6300,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jcc",      {BR},         {{BRA},            {0x6400,0},1|SBW|S_NONE,m68000up|mcf},
  "jcc",      {BR},         {{BRA},            {0x6400,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jcs",      {BR},         {{BRA},            {0x6500,0},1|SBW|S_NONE,m68000up|mcf},
  "jcs",      {BR},         {{BRA},            {0x6500,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jne",      {BR},         {{BRA},            {0x6600,0},1|SBW|S_NONE,m68000up|mcf},
  "jne",      {BR},         {{BRA},            {0x6600,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jeq",      {BR},         {{BRA},            {0x6700,0},1|SBW|S_NONE,m68000up|mcf},
  "jeq",      {BR},         {{BRA},            {0x6700,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jvc",      {BR},         {{BRA},            {0x6800,0},1|SBW|S_NONE,m68000up|mcf},
  "jvc",      {BR},         {{BRA},            {0x6800,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jvs",      {BR},         {{BRA},            {0x6900,0},1|SBW|S_NONE,m68000up|mcf},
  "jvs",      {BR},         {{BRA},            {0x6900,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jpl",      {BR},         {{BRA},            {0x6a00,0},1|SBW|S_NONE,m68000up|mcf},
  "jpl",      {BR},         {{BRA},            {0x6a00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jmi",      {BR},         {{BRA},            {0x6b00,0},1|SBW|S_NONE,m68000up|mcf},
  "jmi",      {BR},         {{BRA},            {0x6b00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jge",      {BR},         {{BRA},            {0x6c00,0},1|SBW|S_NONE,m68000up|mcf},
  "jge",      {BR},         {{BRA},            {0x6c00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jlt",      {BR},         {{BRA},            {0x6d00,0},1|SBW|S_NONE,m68000up|mcf},
  "jlt",      {BR},         {{BRA},            {0x6d00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jgt",      {BR},         {{BRA},            {0x6e00,0},1|SBW|S_NONE,m68000up|mcf},
  "jgt",      {BR},         {{BRA},            {0x6e00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jle",      {BR},         {{BRA},            {0x6f00,0},1|SBW|S_NONE,m68000up|mcf},
  "jle",      {BR},         {{BRA},            {0x6f00,0},1|SBWL|S_NONE,m68020up|cpu32|mcfb|mcfc},
  "jbra",     {CT},         {{SEA},            {0x4ec0,0},1|UNS|S_NONE,m68000up|mcf},
  "jra",      {CT},         {{SEA},            {0x4ec0,0},1|UNS|S_NONE,m68000up|mcf},
  "jmp",      {CT},         {{SEA},            {0x4ec0,0},1|UNS|S_NONE,m68000up|mcf},
  "jbsr",     {CT},         {{SEA},            {0x4e80,0},1|UNS|S_NONE,m68000up|mcf},
  "jsr",      {CT},         {{SEA},            {0x4e80,0},1|UNS|S_NONE,m68000up|mcf},
  "lea",      {CT,A_},      {{SEA,RHI},        {0x41c0,0},1|L|S_NONE,m68000up|mcf},
  "linea",    {VA},         {{LIN},            {0xa000,0},1|UNS|S_NONE,m68000up|mcf},
  "line_a",   {VA},         {{LIN},            {0xa000,0},1|UNS|S_NONE,m68000up|mcf},
  "linef",    {VA},         {{LIN},            {0xf000,0},1|UNS|S_NONE,m68000up|mcf},
  "line_f",   {VA},         {{LIN},            {0xf000,0},1|UNS|S_NONE,m68000up|mcf},
  "link",     {A_,IM},      {{RLO,NEA},        {0x4e50,0},1|W|S_NONE,m68000up|mcf},
  "link",     {A_,IM},      {{RLO,NEA},        {0x4808,0},1|L|S_NONE,m68020up|cpu32},
  "lpstop",   {IM},         {{NEA},            {0xf800,0x01c0},2|W|S_NONE,m68060|cpu32},
  "lsl",      {AM},         {{SEA},            {0xe3c0,0},1|W|S_NONE,m68000up},
  "lsl",      {D_,D_},      {{RHI,RLO},        {0xe128,0},1|CFBWL|S_STD,m68000up|mcf},
  "lsl",      {QI,D_},      {{D3Q,RLO},        {0xe108,0},1|CFBWL|S_STD,m68000up|mcf},
  "lsl",      {D_},         {{RLO},            {0xe308,0},1|CFBWL|S_STD,m68000up|mcf},
  "lsr",      {AM},         {{SEA},            {0xe2c0,0},1|W|S_NONE,m68000up},
  "lsr",      {D_,D_},      {{RHI,RLO},        {0xe028,0},1|CFBWL|S_STD,m68000up|mcf},
  "lsr",      {QI,D_},      {{D3Q,RLO},        {0xe008,0},1|CFBWL|S_STD,m68000up|mcf},
  "lsr",      {D_},         {{RLO},            {0xe208,0},1|CFBWL|S_STD,m68000up|mcf},
  "maaac",    {RM,RM,SH,_ACCX,_ACCX},{{RMM,RMW,MSF,ACX,ACW},{0xa000,1},2|WL|S_MAC,mcfemac},
  "maaac",    {RM,RM,_ACCX,_ACCX},{{RMM,RMW,ACX,ACW},{0xa000,1},2|WL|S_MAC,mcfemac},
  "mac",      {RM,RM,SH},   {{RMM,RMW,MSF},    {0xa000,0},2|WL|S_MAC,mcfmac|mcfemac},
  "mac",      {RM,RM,SH,CM,R_},{{RMY,RMX,MSF,EAM,RMW},{0xa080,0},2|WL|S_MAC,mcfmac|mcfemac},
  "mac",      {RM,RM,SH,_ACCX},{{RMM,RMW,MSF,ACX},{0xa000,0},2|WL|S_MAC,mcfemac},
  "mac",      {RM,RM,SH,CM,R_,_ACCX},{{RMY,RMX,MSF,EAM,RMW,ACR},{0xa000,0},2|WL|S_MAC,mcfemac},
  "mac",      {RM,RM},      {{RMM,RMW},	       {0xa000,0},2|WL|S_MAC,mcfmac|mcfemac},
  "mac",      {RM,RM,CM,R_},{{RMY,RMX,EAM,RMW},{0xa080,0},2|WL|S_MAC,mcfmac|mcfemac},
  "mac",      {RM,RM,_ACCX},{{RMM,RMW,ACX},    {0xa000,0},2|WL|S_MAC,mcfemac},
  "mac",      {RM,RM,CM,R_,_ACCX},{{RMY,RMX,EAM,RMW,ACR},{0xa000,0},2|WL|S_MAC,mcfemac},
  "masac",    {RM,RM,SH,_ACCX,_ACCX},{{RMM,RMW,MSF,ACX,ACW},{0xa000,3},2|WL|S_MAC,mcfemac},
  "masac",    {RM,RM,_ACCX,_ACCX},{{RMM,RMW,ACX,ACW},{0xa000,3},2|WL|S_MAC,mcfemac},
  "mov3q",    {QI,AL},      {{M3Q,SEA},        {0xa140,0},1|L|S_NONE,mcfb|mcfc},
  "movclr",   {_ACCX,R_},   {{AHI,RL4},        {0xa1c0,0},1|L|S_NONE,mcfemac},
  "move",     {A_,AL},      {{RLO,MEA},        {0x0008,0},1|WL|S_MOVE,m68000up|mcf},
  "move",     {AY,A_},      {{SEA,RHI},        {0x0040,0},1|WL|S_MOVE,m68000up|mcf},
  "move",     {DA,AD},      {{SEA,MEA},        {0x0000,0},1|BWL|S_MOVE,m68000up|mcf},
  "move",     {_CCR,D_},    {{NOP,SEA},        {0x42c0,0},1|W|S_NONE,m68010up|mcf},
  "move",     {_CCR,AD},    {{NOP,SEA},        {0x42c0,0},1|W|S_NONE,m68010up},
  "move",     {_SR,D_},     {{NOP,SEA},        {0x40c0,0},1|W|S_NONE,m68000up|mcf},
  "move",     {_SR,AD},     {{NOP,SEA},        {0x40c0,0},1|W|S_NONE,m68000up},
  "move",     {D_,_CCR},    {{SEA,NOP},        {0x44c0,0},1|W|S_NONE,m68000up|mcf},
  "move",     {IM,_CCR},    {{SEA,NOP},        {0x44c0,0},1|W|S_NONE,m68000up|mcf},
  "move",     {DA,_CCR},    {{SEA,NOP},        {0x44c0,0},1|W|S_NONE,m68000up},
  "move",     {D_,_SR},     {{SEA,NOP},        {0x46c0,0},1|W|S_NONE,m68000up|mcf},
  "move",     {IM,_SR},     {{SEA,NOP},        {0x46c0,0},1|W|S_NONE,m68000up|mcf},
  "move",     {DA,_SR},     {{SEA,NOP},        {0x46c0,0},1|W|S_NONE,m68000up},
  "move",     {_USP,A_},    {{NOP,RLO},        {0x4e68,0},1|L|S_NONE,m68000up|mcfusp},
  "move",     {A_,_USP},    {{RLO,NOP},        {0x4e60,0},1|L|S_NONE,m68000up|mcfusp},
  "move",     {_ACCX,_ACCX},{{ALO,AHI},        {0xa110,0},1|L|S_NONE,mcfemac},
  "move",     {_ACC,R_},    {{NOP,RL4},        {0xa180,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {_ACCX,R_},   {{AHI,RL4},        {0xa180,0},1|L|S_NONE,mcfemac},
  "move",     {_AEXT,R_},   {{AHI,RL4},        {0xab80,0},1|L|S_NONE,mcfemac},
  "move",     {_MACSR,R_},  {{NOP,RL4},        {0xa980,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {_MACSR,_CCR},{{NOP,NOP},        {0xa9c0,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {_MASK,R_},   {{NOP,RL4},        {0xad80,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {R_,_ACC},    {{SEA,NOP},        {0xa100,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {IM,_ACC},    {{SEA,NOP},        {0xa100,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {R_,_ACCX},   {{SEA,AHI},        {0xa100,0},1|L|S_NONE,mcfemac},
  "move",     {IM,_ACCX},   {{SEA,AHI},        {0xa100,0},1|L|S_NONE,mcfemac},
  "move",     {R_,_AEXT},   {{SEA,AHI},        {0xab00,0},1|L|S_NONE,mcfemac},
  "move",     {IM,_AEXT},   {{SEA,AHI},        {0xab00,0},1|L|S_NONE,mcfemac},
  "move",     {R_,_MACSR},  {{SEA,NOP},        {0xa900,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {IM,_MACSR},  {{SEA,NOP},        {0xa900,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {R_,_MASK},   {{SEA,NOP},        {0xad00,0},1|L|S_NONE,mcfmac|mcfemac},
  "move",     {IM,_MASK},   {{SEA,NOP},        {0xad00,0},1|L|S_NONE,mcfmac|mcfemac},
  "movea",    {AY,A_},      {{SEA,RHI},        {0x0040,0},1|WL|S_MOVE,m68000up|mcf},
  "movea",    {A_,AL},      {{RLO,MEA},        {0x0008,0},1|WL|S_MOVE,malias|m68000up|mcf},
  "movea",    {DA,AD},      {{SEA,MEA},        {0x0000,0},1|BWL|S_MOVE,malias|m68000up|mcf},
  "movec",    {_CTRL,R_},   {{CTR,C2H},        {0x4e7a,0},2|L|S_NONE,m68010up},
  "movec",    {R_,_CTRL},   {{C2H,CTR},        {0x4e7b,0},2|L|S_NONE,m68010up|mcf},
  "movem",    {RL,CFMM},    {{D16,SEA},        {0x4880,0},2|CFWL|S_WL6,m68000up|mcf},
  "movem",    {CFMM,RL},    {{SEA,D16},        {0x4c80,0},2|CFWL|S_WL6,m68000up|mcf},
  "movem",    {RL,PA},      {{D2R,SEA},        {0x4880,0},2|WL|S_WL6,m68000up},
  "movem",    {RL,AC},      {{D16,SEA},        {0x4880,0},2|WL|S_WL6,m68000up},
  "movem",    {MR,RL},      {{SEA,D16},        {0x4c80,0},2|WL|S_WL6,m68000up},
  "movem",    {QI,CFMM},    {{D16,SEA},        {0x4880,0},2|CFWL|S_WL6,m68000up|mcf},
  "movem",    {CFMM,QI},    {{SEA,D16},        {0x4c80,0},2|CFWL|S_WL6,m68000up|mcf},
  "movem",    {QI,PA},      {{D2R,SEA},        {0x4880,0},2|WL|S_WL6,m68000up},
  "movem",    {QI,AC},      {{D16,SEA},        {0x4880,0},2|WL|S_WL6,m68000up},
  "movem",    {MR,QI},      {{SEA,D16},        {0x4c80,0},2|WL|S_WL6,m68000up},
  "movep",    {DP,D_},      {{REA,RHI},        {0x0108,0},1|WL|S_WL6,m68000up},
  "movep",    {D_,DP},      {{RHI,REA},        {0x0188,0},1|WL|S_WL6,m68000up},
  "moveq",    {QI,D_},      {{DL8,RHI},        {0x7000,0},1|L|S_NONE,m68000up|mcf},
  "moves",    {AM,R_},      {{SEA,C2H},        {0x0e00,0x0000},2|BWL|S_STD,m68010up},
  "moves",    {R_,AM},      {{C2H,SEA},        {0x0e00,0x0800},2|BWL|S_STD,m68010up},
  "move16",   {AP,AP},      {{RLO,R2H},        {0xf620,0x8000},2|UNS|S_NONE,m68040up},
  "move16",   {AP,AB},      {{RLO,NEA},        {0xf600,0},1|UNS|S_NONE,m68040up},
  "move16",   {AB,AP},      {{NEA,RLO},        {0xf608,0},1|UNS|S_NONE,m68040up},
  "move16",   {AI,AB},      {{RLO,NEA},        {0xf610,0},1|UNS|S_NONE,m68040up},
  "move16",   {AB,AI},      {{NEA,RLO},        {0xf618,0},1|UNS|S_NONE,m68040up},
  "movm",     {RL,CFMM},    {{D16,SEA},        {0x4880,0},2|CFWL|S_WL6,m68000up|mcf},
  "movm",     {CFMM,RL},    {{SEA,D16},        {0x4c80,0},2|CFWL|S_WL6,m68000up|mcf},
  "movm",     {RL,PA},      {{D2R,SEA},        {0x4880,0},2|WL|S_WL6,m68000up},
  "movm",     {RL,AC},      {{D16,SEA},        {0x4880,0},2|WL|S_WL6,m68000up},
  "movm",     {MR,RL},      {{SEA,D16},        {0x4c80,0},2|WL|S_WL6,m68000up},
  "movm",     {QI,CFMM},    {{D16,SEA},        {0x4880,0},2|CFWL|S_WL6,m68000up|mcf},
  "movm",     {CFMM,QI},    {{SEA,D16},        {0x4c80,0},2|CFWL|S_WL6,m68000up|mcf},
  "movm",     {QI,PA},      {{D2R,SEA},        {0x4880,0},2|WL|S_WL6,m68000up},
  "movm",     {QI,AC},      {{D16,SEA},        {0x4880,0},2|WL|S_WL6,m68000up},
  "movm",     {MR,QI},      {{SEA,D16},        {0x4c80,0},2|WL|S_WL6,m68000up},
  "msaac",    {RM,RM,SH,_ACCX,_ACCX},{{RMM,RMW,MSF,ACX,ACW},{0xa000,0x0101},2|WL|S_MAC,mcfemac},
  "msaac",    {RM,RM,_ACCX,_ACCX},{{RMM,RMW,ACX,ACW},{0xa000,0x0101},2|WL|S_MAC,mcfemac},
  "msac",     {RM,RM,SH},   {{RMM,RMW,MSF},    {0xa000,0x0100},2|WL|S_MAC,mcfmac|mcfemac},
  "msac",     {RM,RM,SH,CM,R_},{{RMY,RMX,MSF,EAM,RMW},{0xa080,0x0100},2|WL|S_MAC,mcfmac|mcfemac},
  "msac",     {RM,RM,SH,_ACCX},{{RMM,RMW,MSF,ACX},{0xa000,0x0100},2|WL|S_MAC,mcfemac},
  "msac",     {RM,RM,SH,CM,R_,_ACCX},{{RMY,RMX,MSF,EAM,RMW,ACR},{0xa000,0x0100},2|WL|S_MAC,mcfemac},
  "msac",     {RM,RM},      {{RMM,RMW},	       {0xa000,0x0100},2|WL|S_MAC,mcfmac|mcfemac},
  "msac",     {RM,RM,CM,R_},{{RMY,RMX,EAM,RMW},{0xa080,0x0100},2|WL|S_MAC,mcfmac|mcfemac},
  "msac",     {RM,RM,_ACCX},{{RMM,RMW,ACX},    {0xa000,0x0100},2|WL|S_MAC,mcfemac},
  "msac",     {RM,RM,CM,R_,_ACCX},{{RMY,RMX,EAM,RMW,ACR},{0xa000,0x0100},2|WL|S_MAC,mcfemac},
  "mssac",    {RM,RM,SH,_ACCX,_ACCX},{{RMM,RMW,MSF,ACX,ACW},{0xa000,0x0103},2|WL|S_MAC,mcfemac},
  "mssac",    {RM,RM,_ACCX,_ACCX},{{RMM,RMW,ACX,ACW},{0xa000,0x0103},2|WL|S_MAC,mcfemac},
  "muls",     {CFAD,D_},    {{SEA,RHI},        {0xc1c0,0},1|W|S_NONE,m68000up|mcf},
  "muls",     {CFAD,D_},    {{SEA,R2H},        {0x4c00,0x0800},2|L|S_NONE,m68020up|cpu32|mcf},
  "muls",     {DA,D_},      {{SEA,RHI},        {0xc1c0,0},1|W|S_NONE,m68000up|mcf},
  "muls",     {DA,D_},      {{SEA,R2H},        {0x4c00,0x0800},2|L|S_NONE,m68020up|cpu32},
  "muls",     {DA,DD},      {{SEA,DV2},        {0x4c00,0x0c00},2|L|S_NONE,m68020up|cpu32},
  "mulu",     {CFAD,D_},    {{SEA,RHI},        {0xc0c0,0},1|W|S_NONE,m68000up|mcf},
  "mulu",     {CFAD,D_},    {{SEA,R2H},        {0x4c00,0x0000},2|L|S_NONE,m68020up|cpu32|mcf},
  "mulu",     {DA,D_},      {{SEA,RHI},        {0xc0c0,0},1|W|S_NONE,m68000up|mcf},
  "mulu",     {DA,D_},      {{SEA,R2H},        {0x4c00,0x0000},2|L|S_NONE,m68020up|cpu32},
  "mulu",     {DA,DD},      {{SEA,DV2},        {0x4c00,0x0400},2|L|S_NONE,m68020up|cpu32},
  "mvs",      {AY,D_},      {{SEA,RHI},        {0x7100,0},1|BW|S_STD,mcfb|mcfc},
  "mvz",      {AY,D_},      {{SEA,RHI},        {0x7180,0},1|BW|S_STD,mcfb|mcfc},
  "nbcd",     {AD},         {{SEA},            {0x4800,0},1|B|S_NONE,m68000up},
  "neg",      {D_},         {{SEA},            {0x4400,0},1|CFBWL|S_STD,m68000up|mcf},
  "neg",      {AD},         {{SEA},            {0x4400,0},1|BWL|S_STD,m68000up},
  "negx",     {D_},         {{SEA},            {0x4000,0},1|CFBWL|S_STD,m68000up|mcf},
  "negx",     {AD},         {{SEA},            {0x4000,0},1|BWL|S_STD,m68000up},
  "nop",      {0},          {{0},              {0x4e71,0},1|UNS|S_NONE,m68000up|mcf},
  "not",      {D_},         {{SEA},            {0x4600,0},1|CFBWL|S_STD,m68000up|mcf},
  "not",      {AD},         {{SEA},            {0x4600,0},1|BWL|S_STD,m68000up},
  "or",       {DA,D_},      {{SEA,RHI},        {0x8000,0},1|CFBWL|S_STD,m68000up|mcf},
  "or",       {D_,AM},      {{RHI,SEA},        {0x8100,0},1|CFBWL|S_STD,m68000up|mcf},
  "or",       {IM,AD},      {{NEA,SEA},        {0x0000,0},1|BWL|S_STD,m68000up},
  "or",       {IM,_CCR},    {{NEA,NOP},        {0x003c,0},1|B|S_NONE,m68000up},
  "or",       {IM,_SR},     {{NEA,NOP},        {0x007c,0},1|W|S_NONE,m68000up},
  "ori",      {IM,D_},      {{NEA,RLO},        {0x0000,0},1|CFBWL|S_STD,m68000up|mcf},
  "ori",      {IM,AD},      {{NEA,SEA},        {0x0000,0},1|BWL|S_STD,m68000up},
  "ori",      {IM,_CCR},    {{NEA,NOP},        {0x003c,0},1|B|S_NONE,m68000up},
  "ori",      {IM,_SR},     {{NEA,NOP},        {0x007c,0},1|W|S_NONE,m68000up},
  "pack",     {D_,D_,QI},   {{RLO,RHI,D16},    {0x8140,0},2|UNS|S_NONE,m68020up},
  "pack",     {PA,PA,QI},   {{RLO,RHI,D16},    {0x8148,0},2|UNS|S_NONE,m68020up},
  "pbbs",     {BR},         {{DBR},            {0xf080,0},1|WL|S_WL6,m68851},
  "pbbc",     {BR},         {{DBR},            {0xf081,0},1|WL|S_WL6,m68851},
  "pbls",     {BR},         {{DBR},            {0xf082,0},1|WL|S_WL6,m68851},
  "pblc",     {BR},         {{DBR},            {0xf083,0},1|WL|S_WL6,m68851},
  "pbss",     {BR},         {{DBR},            {0xf084,0},1|WL|S_WL6,m68851},
  "pbsc",     {BR},         {{DBR},            {0xf085,0},1|WL|S_WL6,m68851},
  "pbas",     {BR},         {{DBR},            {0xf086,0},1|WL|S_WL6,m68851},
  "pbac",     {BR},         {{DBR},            {0xf087,0},1|WL|S_WL6,m68851},
  "pbws",     {BR},         {{DBR},            {0xf088,0},1|WL|S_WL6,m68851},
  "pbwc",     {BR},         {{DBR},            {0xf089,0},1|WL|S_WL6,m68851},
  "pbis",     {BR},         {{DBR},            {0xf08a,0},1|WL|S_WL6,m68851},
  "pbic",     {BR},         {{DBR},            {0xf08b,0},1|WL|S_WL6,m68851},
  "pbgs",     {BR},         {{DBR},            {0xf08c,0},1|WL|S_WL6,m68851},
  "pbgc",     {BR},         {{DBR},            {0xf08d,0},1|WL|S_WL6,m68851},
  "pbcs",     {BR},         {{DBR},            {0xf08e,0},1|WL|S_WL6,m68851},
  "pbcc",     {BR},         {{DBR},            {0xf08f,0},1|WL|S_WL6,m68851},
  "pdbbs",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0000},2|W|S_NONE,m68851},
  "pdbbc",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0001},2|W|S_NONE,m68851},
  "pdbls",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0002},2|W|S_NONE,m68851},
  "pdblc",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0003},2|W|S_NONE,m68851},
  "pdbss",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0004},2|W|S_NONE,m68851},
  "pdbsc",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0005},2|W|S_NONE,m68851},
  "pdbas",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0006},2|W|S_NONE,m68851},
  "pdbac",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0007},2|W|S_NONE,m68851},
  "pdbws",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0008},2|W|S_NONE,m68851},
  "pdbwc",    {D_,BR},      {{RLO,DBR},        {0xf048,0x0009},2|W|S_NONE,m68851},
  "pdbis",    {D_,BR},      {{RLO,DBR},        {0xf048,0x000a},2|W|S_NONE,m68851},
  "pdbic",    {D_,BR},      {{RLO,DBR},        {0xf048,0x000b},2|W|S_NONE,m68851},
  "pdbgs",    {D_,BR},      {{RLO,DBR},        {0xf048,0x000c},2|W|S_NONE,m68851},
  "pdbgc",    {D_,BR},      {{RLO,DBR},        {0xf048,0x000d},2|W|S_NONE,m68851},
  "pdbcs",    {D_,BR},      {{RLO,DBR},        {0xf048,0x000e},2|W|S_NONE,m68851},
  "pdbcc",    {D_,BR},      {{RLO,DBR},        {0xf048,0x000f},2|W|S_NONE,m68851},
  "pea",      {CT},         {{SEA},            {0x4840,0},1|L|S_NONE,m68000up|mcf},
  "pflush",   {AI},         {{RLO},            {0xf508,0},1|UNS|S_NONE,m68040up},
  "pflush",   {QI,QI},      {{EL3,EM3},        {0xf000,0x3010},2|UNS|S_NONE,m68030},
  "pflush",   {QI,QI},      {{EL4,EM4},        {0xf000,0x3010},2|UNS|S_NONE,m68851},
  "pflush",   {D_,QI},      {{R2L,EM3},        {0xf000,0x3008},2|UNS|S_NONE,m68030},
  "pflush",   {D_,QI},      {{R2L,EM4},        {0xf000,0x3008},2|UNS|S_NONE,m68851},
  "pflush",   {_FC,QI},     {{EL3,EM3},        {0xf000,0x3000},2|UNS|S_NONE,m68030},
  "pflush",   {_FC,QI},     {{EL3,EM4},        {0xf000,0x3000},2|UNS|S_NONE,m68851},
  "pflush",   {QI,QI,AC},   {{EL3,EM3,SEA},    {0xf000,0x3810},2|UNS|S_NONE,m68030},
  "pflush",   {QI,QI,AC},   {{EL4,EM4,SEA},    {0xf000,0x3810},2|UNS|S_NONE,m68851},
  "pflush",   {D_,QI,AC},   {{R2L,EM3,SEA},    {0xf000,0x3808},2|UNS|S_NONE,m68030},
  "pflush",   {D_,QI,AC},   {{R2L,EM4,SEA},    {0xf000,0x3808},2|UNS|S_NONE,m68851},
  "pflush",   {_FC,QI,AC},  {{EL3,EM3,SEA},    {0xf000,0x3800},2|UNS|S_NONE,m68030},
  "pflush",   {_FC,QI,AC},  {{EL3,EM4,SEA},    {0xf000,0x3800},2|UNS|S_NONE,m68851},
  "pflusha",  {0},          {{0},              {0xf518,0},1|UNS|S_NONE,m68040up},
  "pflusha",  {0},          {{0},              {0xf000,0x2400},2|UNS|S_NONE,m68030|m68851},
  "pflushan", {0},          {{0},              {0xf510,0},1|UNS|S_NONE,m68040up},
  "pflushn",  {AI},         {{RLO},            {0xf500,0},1|UNS|S_NONE,m68040up},
  "pflushr",  {MA},         {{SEA},            {0xf000,0xa000},2|UNS|S_NONE,m68851},
  "pflushs",  {QI,QI},      {{EL4,EM4},        {0xf000,0x3410},2|UNS|S_NONE,m68851},
  "pflushs",  {D_,QI},      {{R2L,EM4},        {0xf000,0x3408},2|UNS|S_NONE,m68851},
  "pflushs",  {_FC,QI},     {{EL3,EM4},        {0xf000,0x3400},2|UNS|S_NONE,m68851},
  "pflushs",  {QI,QI,AC},   {{EL4,EM4,SEA},    {0xf000,0x3c10},2|UNS|S_NONE,m68851},
  "pflushs",  {D_,QI,AC},   {{R2L,EM4,SEA},    {0xf000,0x3c08},2|UNS|S_NONE,m68851},
  "pflushs",  {_FC,QI,AC},  {{EL3,EM4,SEA},    {0xf000,0x3c00},2|UNS|S_NONE,m68851},
  "ploadr",   {QI,AC},      {{EL3,SEA},        {0xf000,0x2210},2|UNS|S_NONE,m68030},
  "ploadr",   {QI,AC},      {{EL4,SEA},        {0xf000,0x2210},2|UNS|S_NONE,m68851},
  "ploadr",   {D_,AC},      {{R2L,SEA},        {0xf000,0x2208},2|UNS|S_NONE,m68030|m68851},
  "ploadr",   {_FC,AC},     {{EL3,SEA},        {0xf000,0x2200},2|UNS|S_NONE,m68030|m68851},
  "ploadw",   {QI,AC},      {{EL3,SEA},        {0xf000,0x2010},2|UNS|S_NONE,m68030},
  "ploadw",   {QI,AC},      {{EL4,SEA},        {0xf000,0x2010},2|UNS|S_NONE,m68851},
  "ploadw",   {D_,AC},      {{R2L,SEA},        {0xf000,0x2008},2|UNS|S_NONE,m68030|m68851},
  "ploadw",   {_FC,AC},     {{EL3,SEA},        {0xf000,0x2000},2|UNS|S_NONE,m68030|m68851},
  "plpar",    {AI},         {{RLO},            {0xf5c8,0},1|UNS|S_NONE,m68060},
  "plpaw",    {AI},         {{RLO},            {0xf588,0},1|UNS|S_NONE,m68060},
  "pmove",    {AC,_RP_030}, {{SEA,EH3},        {0xf000,0x4000},2|Q|S_NONE,m68030|m68851},
  "pmove",    {MAQ,_RP_851},{{SEA,EH3},        {0xf000,0x4000},2|Q|S_NONE,m68851},
  "pmove",    {AC,_TC},     {{SEA,EH3},        {0xf000,0x4000},2|L|S_NONE,m68030|m68851},
  "pmove",    {AY,_TC},     {{SEA,EH3},        {0xf000,0x4000},2|L|S_NONE,m68851},
  "pmove",    {AY,_AC},     {{SEA,EH3},        {0xf000,0x4000},2|W|S_NONE,m68851},
  "pmove",    {AY,_M1_B},   {{SEA,EH3},        {0xf000,0x4000},2|B|S_NONE,m68851},
  "pmove",    {AY,_BAD},    {{SEA,BAX},        {0xf000,0x7000},2|W|S_NONE,m68851},
  "pmove",    {AY,_BAC},    {{SEA,BAX},        {0xf000,0x7400},2|W|S_NONE,m68851},
  "pmove",    {AC,_PSR},    {{SEA,EH3},        {0xf000,0x6000},2|W|S_NONE,m68030|m68851},
  "pmove",    {AY,_PCSR},   {{SEA,EH3},        {0xf000,0x6000},2|W|S_NONE,m68851},
  "pmove",    {AC,_TT},     {{SEA,EH3},        {0xf000,0x0000},2|L|S_NONE,m68030},
  "pmove",    {_RP_030,AC}, {{EH3,SEA},        {0xf000,0x4200},2|Q|S_NONE,m68030|m68851},
  "pmove",    {_RP_851,AC}, {{EH3,SEA},        {0xf000,0x4200},2|Q|S_NONE,m68851},
  "pmove",    {_TC,AC},     {{EH3,SEA},        {0xf000,0x4200},2|L|S_NONE,m68030|m68851},
  "pmove",    {_TC,AY},     {{EH3,SEA},        {0xf000,0x4200},2|L|S_NONE,m68851},
  "pmove",    {_AC,AY},     {{EH3,SEA},        {0xf000,0x4200},2|W|S_NONE,m68851},
  "pmove",    {_M1_B,AY},   {{EH3,SEA},        {0xf000,0x4200},2|B|S_NONE,m68851},
  "pmove",    {_BAD,AY},    {{BAX,SEA},        {0xf000,0x7200},2|W|S_NONE,m68851},
  "pmove",    {_BAC,AY},    {{BAX,SEA},        {0xf000,0x7600},2|W|S_NONE,m68851},
  "pmove",    {_PSR,AC},    {{EH3,SEA},        {0xf000,0x6200},2|W|S_NONE,m68030|m68851},
  "pmove",    {_PCSR,AY},   {{EH3,SEA},        {0xf000,0x6200},2|W|S_NONE,m68851},
  "pmove",    {_TT,AC},     {{EH3,SEA},        {0xf000,0x0200},2|L|S_NONE,m68030},
  "pmovefd",  {AC,_RP_030}, {{SEA,EH3},        {0xf000,0x4100},2|Q|S_NONE,m68030},
  "pmovefd",  {AC,_TC},     {{SEA,EH3},        {0xf000,0x4100},2|L|S_NONE,m68030},
  "pmovefd",  {AC,_TT},     {{SEA,EH3},        {0xf000,0x0100},2|L|S_NONE,m68030},
  "prestore", {MR},         {{SEA},            {0xf140,0},1|UNS|S_NONE,m68851},
  "psave",    {MS},         {{SEA},            {0xf100,0},1|UNS|S_NONE,m68851},
  "psbs",     {AD},         {{SEA},            {0xf040,0x0000},2|B|S_NONE,m68851},
  "psbc",     {AD},         {{SEA},            {0xf040,0x0001},2|B|S_NONE,m68851},
  "psls",     {AD},         {{SEA},            {0xf040,0x0002},2|B|S_NONE,m68851},
  "pslc",     {AD},         {{SEA},            {0xf040,0x0003},2|B|S_NONE,m68851},
  "psss",     {AD},         {{SEA},            {0xf040,0x0004},2|B|S_NONE,m68851},
  "pssc",     {AD},         {{SEA},            {0xf040,0x0005},2|B|S_NONE,m68851},
  "psas",     {AD},         {{SEA},            {0xf040,0x0006},2|B|S_NONE,m68851},
  "psac",     {AD},         {{SEA},            {0xf040,0x0007},2|B|S_NONE,m68851},
  "psws",     {AD},         {{SEA},            {0xf040,0x0008},2|B|S_NONE,m68851},
  "pswc",     {AD},         {{SEA},            {0xf040,0x0009},2|B|S_NONE,m68851},
  "psis",     {AD},         {{SEA},            {0xf040,0x000a},2|B|S_NONE,m68851},
  "psic",     {AD},         {{SEA},            {0xf040,0x000b},2|B|S_NONE,m68851},
  "psgs",     {AD},         {{SEA},            {0xf040,0x000c},2|B|S_NONE,m68851},
  "psgc",     {AD},         {{SEA},            {0xf040,0x000d},2|B|S_NONE,m68851},
  "pscs",     {AD},         {{SEA},            {0xf040,0x000e},2|B|S_NONE,m68851},
  "pscc",     {AD},         {{SEA},            {0xf040,0x000f},2|B|S_NONE,m68851},
  "ptestr",   {AI},         {{RLO},            {0xf568,0},1|UNS|S_NONE,m68040},
  "ptestr",   {QI,AC,QI},   {{EL3,SEA,EH3},    {0xf000,0x8210},2|UNS|S_NONE,m68030},
  "ptestr",   {QI,AC,QI},   {{EL4,SEA,EH3},    {0xf000,0x8210},2|UNS|S_NONE,m68851},
  "ptestr",   {D_,AC,QI},   {{R2L,SEA,EH3},    {0xf000,0x8208},2|UNS|S_NONE,m68030|m68851},
  "ptestr",   {_FC,AC,QI},  {{EL3,SEA,EH3},    {0xf000,0x8200},2|UNS|S_NONE,m68030|m68851},
  "ptestr",   {QI,AC,QI,A_},{{EL3,SEA,EH3,R2P},{0xf000,0x8310},2|UNS|S_NONE,m68030},
  "ptestr",   {QI,AC,QI,A_},{{EL4,SEA,EH3,R2P},{0xf000,0x8310},2|UNS|S_NONE,m68851},
  "ptestr",   {D_,AC,QI,A_},{{R2L,SEA,EH3,R2P},{0xf000,0x8308},2|UNS|S_NONE,m68030|m68851},
  "ptestr",  {_FC,AC,QI,A_},{{EL3,SEA,EH3,R2P},{0xf000,0x8300},2|UNS|S_NONE,m68030|m68851},
  "ptestw",   {AI},         {{RLO},            {0xf548,0},1|UNS|S_NONE,m68040},
  "ptestw",   {QI,AC,QI},   {{EL3,SEA,EH3},    {0xf000,0x8010},2|UNS|S_NONE,m68030},
  "ptestw",   {QI,AC,QI},   {{EL4,SEA,EH3},    {0xf000,0x8010},2|UNS|S_NONE,m68851},
  "ptestw",   {D_,AC,QI},   {{R2L,SEA,EH3},    {0xf000,0x8008},2|UNS|S_NONE,m68030|m68851},
  "ptestw",   {_FC,AC,QI},  {{EL3,SEA,EH3},    {0xf000,0x8000},2|UNS|S_NONE,m68030|m68851},
  "ptestw",   {QI,AC,QI,A_},{{EL3,SEA,EH3,R2P},{0xf000,0x8110},2|UNS|S_NONE,m68030},
  "ptestw",   {QI,AC,QI,A_},{{EL4,SEA,EH3,R2P},{0xf000,0x8110},2|UNS|S_NONE,m68851},
  "ptestw",   {D_,AC,QI,A_},{{R2L,SEA,EH3,R2P},{0xf000,0x8108},2|UNS|S_NONE,m68030|m68851},
  "ptestw",  {_FC,AC,QI,A_},{{EL3,SEA,EH3,R2P},{0xf000,0x8100},2|UNS|S_NONE,m68030|m68851},
  "ptrapbs",  {IM},         {{NEA},            {0xf078,0x0000},2|WL|S_TRAP,m68851},
  "ptrapbs",  {0},          {{0},              {0xf07c,0x0000},2|UNS|S_NONE,m68851},
  "ptrapbc",  {IM},         {{NEA},            {0xf078,0x0001},2|WL|S_TRAP,m68851},
  "ptrapbc",  {0},          {{0},              {0xf07c,0x0001},2|UNS|S_NONE,m68851},
  "ptrapls",  {IM},         {{NEA},            {0xf078,0x0002},2|WL|S_TRAP,m68851},
  "ptrapls",  {0},          {{0},              {0xf07c,0x0002},2|UNS|S_NONE,m68851},
  "ptraplc",  {IM},         {{NEA},            {0xf078,0x0003},2|WL|S_TRAP,m68851},
  "ptraplc",  {0},          {{0},              {0xf07c,0x0003},2|UNS|S_NONE,m68851},
  "ptrapss",  {IM},         {{NEA},            {0xf078,0x0004},2|WL|S_TRAP,m68851},
  "ptrapss",  {0},          {{0},              {0xf07c,0x0004},2|UNS|S_NONE,m68851},
  "ptrapsc",  {IM},         {{NEA},            {0xf078,0x0005},2|WL|S_TRAP,m68851},
  "ptrapsc",  {0},          {{0},              {0xf07c,0x0005},2|UNS|S_NONE,m68851},
  "ptrapas",  {IM},         {{NEA},            {0xf078,0x0006},2|WL|S_TRAP,m68851},
  "ptrapas",  {0},          {{0},              {0xf07c,0x0006},2|UNS|S_NONE,m68851},
  "ptrapac",  {IM},         {{NEA},            {0xf078,0x0007},2|WL|S_TRAP,m68851},
  "ptrapac",  {0},          {{0},              {0xf07c,0x0007},2|UNS|S_NONE,m68851},
  "ptrapws",  {IM},         {{NEA},            {0xf078,0x0008},2|WL|S_TRAP,m68851},
  "ptrapws",  {0},          {{0},              {0xf07c,0x0008},2|UNS|S_NONE,m68851},
  "ptrapwc",  {IM},         {{NEA},            {0xf078,0x0009},2|WL|S_TRAP,m68851},
  "ptrapwc",  {0},          {{0},              {0xf07c,0x0009},2|UNS|S_NONE,m68851},
  "ptrapis",  {IM},         {{NEA},            {0xf078,0x000a},2|WL|S_TRAP,m68851},
  "ptrapis",  {0},          {{0},              {0xf07c,0x000a},2|UNS|S_NONE,m68851},
  "ptrapic",  {IM},         {{NEA},            {0xf078,0x000b},2|WL|S_TRAP,m68851},
  "ptrapic",  {0},          {{0},              {0xf07c,0x000b},2|UNS|S_NONE,m68851},
  "ptrapgs",  {IM},         {{NEA},            {0xf078,0x000c},2|WL|S_TRAP,m68851},
  "ptrapgs",  {0},          {{0},              {0xf07c,0x000c},2|UNS|S_NONE,m68851},
  "ptrapgc",  {IM},         {{NEA},            {0xf078,0x000d},2|WL|S_TRAP,m68851},
  "ptrapgc",  {0},          {{0},              {0xf07c,0x000d},2|UNS|S_NONE,m68851},
  "ptrapcs",  {IM},         {{NEA},            {0xf078,0x000e},2|WL|S_TRAP,m68851},
  "ptrapcs",  {0},          {{0},              {0xf07c,0x000e},2|UNS|S_NONE,m68851},
  "ptrapcc",  {IM},         {{NEA},            {0xf078,0x000f},2|WL|S_TRAP,m68851},
  "ptrapcc",  {0},          {{0},              {0xf07c,0x000f},2|UNS|S_NONE,m68851},
  "pulse",    {0},          {{0},              {0x4acc,0},1|UNS|S_NONE,m68060|mcf},
  "pvalid",   {_VAL,AC},    {{NOP,SEA},        {0xf000,0x2800},2|L|S_NONE,m68851},
  "pvalid",   {A_,AC},      {{R2L,SEA},        {0xf000,0x2c00},2|L|S_NONE,m68851},
  "rems",     {CFAD,DD},    {{SEA,DV2},        {0x4c40,0x0800},2|L|S_NONE,mcfhwdiv},
  "remu",     {CFAD,DD},    {{SEA,DV2},        {0x4c40,0x0000},2|L|S_NONE,mcfhwdiv},
  "reset",    {0},          {{0},              {0x4e70,0},1|UNS|S_NONE,m68000up},
  "rol",      {AM},         {{SEA},            {0xe7c0,0},1|W|S_NONE,m68000up},
  "rol",      {D_,D_},      {{RHI,RLO},        {0xe138,0},1|BWL|S_STD,m68000up},
  "rol",      {QI,D_},      {{D3Q,RLO},        {0xe118,0},1|BWL|S_STD,m68000up},
  "rol",      {D_},         {{RLO},            {0xe318,0},1|BWL|S_STD,m68000up},
  "ror",      {AM},         {{SEA},            {0xe6c0,0},1|W|S_NONE,m68000up},
  "ror",      {D_,D_},      {{RHI,RLO},        {0xe038,0},1|BWL|S_STD,m68000up},
  "ror",      {QI,D_},      {{D3Q,RLO},        {0xe018,0},1|BWL|S_STD,m68000up},
  "ror",      {D_},         {{RLO},            {0xe218,0},1|BWL|S_STD,m68000up},
  "roxl",     {AM},         {{SEA},            {0xe5c0,0},1|W|S_NONE,m68000up},
  "roxl",     {D_,D_},      {{RHI,RLO},        {0xe130,0},1|BWL|S_STD,m68000up},
  "roxl",     {QI,D_},      {{D3Q,RLO},        {0xe110,0},1|BWL|S_STD,m68000up},
  "roxl",     {D_},         {{RLO},            {0xe310,0},1|BWL|S_STD,m68000up},
  "roxr",     {AM},         {{SEA},            {0xe4c0,0},1|W|S_NONE,m68000up},
  "roxr",     {D_,D_},      {{RHI,RLO},        {0xe030,0},1|BWL|S_STD,m68000up},
  "roxr",     {QI,D_},      {{D3Q,RLO},        {0xe010,0},1|BWL|S_STD,m68000up},
  "roxr",     {D_},         {{RLO},            {0xe210,0},1|BWL|S_STD,m68000up},
  "rtd",      {QI},         {{D16},            {0x4e74,0},2|UNS|S_NONE,m68010up},
  "rte",      {0},          {{0},              {0x4e73,0},1|UNS|S_NONE,m68000up|mcf},
  "rtm",      {R_},         {{RL4},            {0x06c0,0},1|UNS|S_NONE,m68020},
  "rtr",      {0},          {{0},              {0x4e77,0},1|UNS|S_NONE,m68000up},
  "rts",      {0},          {{0},              {0x4e75,0},1|UNS|S_NONE,m68000up|mcf},
  "sats",     {D_},         {{RLO},            {0x4c80,0},1|L|S_NONE,mcfb|mcfc},
  "sbcd",     {D_,D_},      {{RLO,RHI},        {0x8100,0},1|B|S_NONE,m68000up},
  "sbcd",     {PA,PA},      {{RLO,RHI},        {0x8108,0},1|B|S_NONE,m68000up},
  "st",       {D_},         {{RLO},            {0x50c0,0},1|B|S_NONE,m68000up|mcf},
  "st",       {AD},         {{SEA},            {0x50c0,0},1|B|S_NONE,m68000up},
  "sf",       {D_},         {{RLO},            {0x51c0,0},1|B|S_NONE,m68000up|mcf},
  "sf",       {AD},         {{SEA},            {0x51c0,0},1|B|S_NONE,m68000up},
  "shi",      {D_},         {{RLO},            {0x52c0,0},1|B|S_NONE,m68000up|mcf},
  "shi",      {AD},         {{SEA},            {0x52c0,0},1|B|S_NONE,m68000up},
  "sls",      {D_},         {{RLO},            {0x53c0,0},1|B|S_NONE,m68000up|mcf},
  "sls",      {AD},         {{SEA},            {0x53c0,0},1|B|S_NONE,m68000up},
  "scc",      {D_},         {{RLO},            {0x54c0,0},1|B|S_NONE,m68000up|mcf},
  "scc",      {AD},         {{SEA},            {0x54c0,0},1|B|S_NONE,m68000up},
  "shs",      {D_},         {{RLO},            {0x54c0,0},1|B|S_NONE,m68000up|mcf},
  "shs",      {AD},         {{SEA},            {0x54c0,0},1|B|S_NONE,m68000up},
  "scs",      {D_},         {{RLO},            {0x55c0,0},1|B|S_NONE,m68000up|mcf},
  "scs",      {AD},         {{SEA},            {0x55c0,0},1|B|S_NONE,m68000up},
  "slo",      {D_},         {{RLO},            {0x55c0,0},1|B|S_NONE,m68000up|mcf},
  "slo",      {AD},         {{SEA},            {0x55c0,0},1|B|S_NONE,m68000up},
  "sne",      {D_},         {{RLO},            {0x56c0,0},1|B|S_NONE,m68000up|mcf},
  "sne",      {AD},         {{SEA},            {0x56c0,0},1|B|S_NONE,m68000up},
  "seq",      {D_},         {{RLO},            {0x57c0,0},1|B|S_NONE,m68000up|mcf},
  "seq",      {AD},         {{SEA},            {0x57c0,0},1|B|S_NONE,m68000up},
  "svc",      {D_},         {{RLO},            {0x58c0,0},1|B|S_NONE,m68000up|mcf},
  "svc",      {AD},         {{SEA},            {0x58c0,0},1|B|S_NONE,m68000up},
  "svs",      {D_},         {{RLO},            {0x59c0,0},1|B|S_NONE,m68000up|mcf},
  "svs",      {AD},         {{SEA},            {0x59c0,0},1|B|S_NONE,m68000up},
  "spl",      {D_},         {{RLO},            {0x5ac0,0},1|B|S_NONE,m68000up|mcf},
  "spl",      {AD},         {{SEA},            {0x5ac0,0},1|B|S_NONE,m68000up},
  "smi",      {D_},         {{RLO},            {0x5bc0,0},1|B|S_NONE,m68000up|mcf},
  "smi",      {AD},         {{SEA},            {0x5bc0,0},1|B|S_NONE,m68000up},
  "sge",      {D_},         {{RLO},            {0x5cc0,0},1|B|S_NONE,m68000up|mcf},
  "sge",      {AD},         {{SEA},            {0x5cc0,0},1|B|S_NONE,m68000up},
  "slt",      {D_},         {{RLO},            {0x5dc0,0},1|B|S_NONE,m68000up|mcf},
  "slt",      {AD},         {{SEA},            {0x5dc0,0},1|B|S_NONE,m68000up},
  "sgt",      {D_},         {{RLO},            {0x5ec0,0},1|B|S_NONE,m68000up|mcf},
  "sgt",      {AD},         {{SEA},            {0x5ec0,0},1|B|S_NONE,m68000up},
  "sle",      {D_},         {{RLO},            {0x5fc0,0},1|B|S_NONE,m68000up|mcf},
  "sle",      {AD},         {{SEA},            {0x5fc0,0},1|B|S_NONE,m68000up},
  "stop",     {QI},         {{D16},            {0x4e72,0},2|UNS|S_NONE,m68000up|mcf},
  "strldsr",  {IM},         {{NEA},            {0x40e7,0x46fc},2|W|S_NONE,mcfaplus|mcfc},
  "sub",      {A_,D_},      {{SEA,RHI},        {0x9000,0},1|CFWL|S_STD,m68000up|mcf},
  "sub",      {DA,D_},      {{SEA,RHI},        {0x9000,0},1|CFBWL|S_STD,m68000up|mcf},
  "sub",      {D_,AM},      {{RHI,SEA},        {0x9100,0},1|CFBWL|S_STD,m68000up|mcf},
  "sub",      {AY,A_},      {{SEA,RHI},        {0x90c0,0},1|CFWL|S_WL8,m68000up|mcf},
  "sub",      {IM,AD},      {{NEA,SEA},        {0x0400,0},1|BWL|S_STD,m68000up},
  "suba",     {AY,A_},      {{SEA,RHI},        {0x90c0,0},1|CFWL|S_WL8,m68000up|mcf},
  "subi",     {IM,D_},      {{NEA,RLO},        {0x0400,0},1|CFBWL|S_STD,m68000up|mcf},
  "subi",     {IM,AD},      {{NEA,SEA},        {0x0400,0},1|BWL|S_STD,m68000up},
  "subq",     {QI,A_},      {{D3Q,SEA},        {0x5100,0},1|CFWL|S_STD,m68000up|mcf},
  "subq",     {QI,AD},      {{D3Q,SEA},        {0x5100,0},1|CFBWL|S_STD,m68000up|mcf},
  "subx",     {D_,D_},      {{RLO,RHI},        {0x9100,0},1|CFBWL|S_STD,m68000up|mcf},
  "subx",     {PA,PA},      {{RLO,RHI},        {0x9108,0},1|BWL|S_STD,m68000up},
  "swap",     {D_},         {{RLO},            {0x4840,0},1|W|S_NONE,m68000up|mcf},
  "tas",      {AD},         {{SEA},            {0x4ac0,0},1|B|S_NONE,m68000up|mcfb|mcfc},
  "tbls",     {CT,D_},      {{SEA,R2H},        {0xf800,0x0900},2|BWL|S_EXT,cpu32},
  "tbls",     {DD,D_},      {{TBL,R2H},        {0xf800,0x0800},2|BWL|S_EXT,cpu32},
  "tblsn",    {CT,D_},      {{SEA,R2H},        {0xf800,0x0d00},2|BWL|S_EXT,cpu32},
  "tblsn",    {DD,D_},      {{TBL,R2H},        {0xf800,0x0c00},2|BWL|S_EXT,cpu32},
  "tblu",     {CT,D_},      {{SEA,R2H},        {0xf800,0x0100},2|BWL|S_EXT,cpu32},
  "tblu",     {DD,D_},      {{TBL,R2H},        {0xf800,0x0000},2|BWL|S_EXT,cpu32},
  "tblun",    {CT,D_},      {{SEA,R2H},        {0xf800,0x0500},2|BWL|S_EXT,cpu32},
  "tblun",    {DD,D_},      {{TBL,R2H},        {0xf800,0x0400},2|BWL|S_EXT,cpu32},
  "tpf",      {IM},         {{NEA},            {0x51f8,0},1|WL|S_TRAP,mcf},
  "tpf",      {0},          {{0},              {0x51fc,0},1|UNS|S_NONE,mcf},
  "trap",     {QI},         {{DL4},            {0x4e40,0},1|UNS|S_NONE,m68000up|mcf},
  "trapv",    {0},          {{0},              {0x4e76,0},1|UNS|S_NONE,m68000up},
  "trapt",    {IM},         {{NEA},            {0x50f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapt",    {0},          {{0},              {0x50fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapf",    {IM},         {{NEA},            {0x51f8,0},1|WL|S_TRAP,m68020up|cpu32|mcf},
  "trapf",    {0},          {{0},              {0x51fc,0},1|UNS|S_NONE,m68020up|cpu32|mcf},
  "traphi",   {IM},         {{NEA},            {0x52f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "traphi",   {0},          {{0},              {0x52fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapls",   {IM},         {{NEA},            {0x53f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapls",   {0},          {{0},              {0x53fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapcc",   {IM},         {{NEA},            {0x54f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapcc",   {0},          {{0},              {0x54fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "traphs",   {IM},         {{NEA},            {0x54f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "traphs",   {0},          {{0},              {0x54fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapcs",   {IM},         {{NEA},            {0x55f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapcs",   {0},          {{0},              {0x55fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "traplo",   {IM},         {{NEA},            {0x55f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "traplo",   {0},          {{0},              {0x55fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapne",   {IM},         {{NEA},            {0x56f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapne",   {0},          {{0},              {0x56fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapeq",   {IM},         {{NEA},            {0x57f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapeq",   {0},          {{0},              {0x57fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapvc",   {IM},         {{NEA},            {0x58f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapvc",   {0},          {{0},              {0x58fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapvs",   {IM},         {{NEA},            {0x59f8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapvs",   {0},          {{0},              {0x59fc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trappl",   {IM},         {{NEA},            {0x5af8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trappl",   {0},          {{0},              {0x5afc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapmi",   {IM},         {{NEA},            {0x5bf8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapmi",   {0},          {{0},              {0x5bfc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapge",   {IM},         {{NEA},            {0x5cf8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapge",   {0},          {{0},              {0x5cfc,0},1|UNS|S_NONE,m68020up|cpu32},
  "traplt",   {IM},         {{NEA},            {0x5df8,0},1|WL|S_TRAP,m68020up|cpu32},
  "traplt",   {0},          {{0},              {0x5dfc,0},1|UNS|S_NONE,m68020up|cpu32},
  "trapgt",   {IM},         {{NEA},            {0x5ef8,0},1|WL|S_TRAP,m68020up|cpu32},
  "trapgt",   {0},          {{0},              {0x5efc,0},1|UNS|S_NONE,m68020up|cpu32},
  "traple",   {IM},         {{NEA},            {0x5ff8,0},1|WL|S_TRAP,m68020up|cpu32},
  "traple",   {0},          {{0},              {0x5ffc,0},1|UNS|S_NONE,m68020up|cpu32},
  "tst",      {AD},         {{SEA},            {0x4a00,0},1|BWL|S_STD,m68000up|mcf},
  "tst",      {DA},         {{SEA},            {0x4a00,0},1|BWL|S_STD,m68020up|cpu32|mcf},
  "tst",      {A_},         {{SEA},            {0x4a00,0},1|WL|S_STD,m68020up|cpu32|mcf},
  "unlk",     {A_},         {{RLO},            {0x4e58,0},1|UNS|S_NONE,m68000up|mcf},
  "unpk",     {D_,D_,QI},   {{RLO,RHI,D16},    {0x8180,0},2|UNS|S_NONE,m68020up},
  "unpk",     {PA,PA,QI},   {{RLO,RHI,D16},    {0x8188,0},2|UNS|S_NONE,m68020up},
  "wddata",   {AM},         {{SEA},            {0xfb00,0},1|BWL|S_STD,mcf},
  "wdebug",   {CFMM},       {{SEA},            {0xfbc0,0x0003},2|L|S_NONE,mcf},
  "",         {0},          {{0},              {0,0},1|SIZE_MASK,~0}
