
@cd /d "%~dp0"
@if x%1 == x goto detail
@set inputfile="dh1\wavsamples\%1.wav"
@set outputfile="dh1\iffsamples\%1.iff"
@if not exist "%inputfile%" (
	@echo Error: File %inputfile% not found
	@goto error
)
@set rate=0
@set note=%2
@if /I "%note%" EQU "" set note=C3
@if /I "%note%" equ "C1" set rate=4144
@if /I "%note%" equ "C1" set rate=4144
@if /I "%note%" equ "C#1" set rate=4390
@if /I "%note%" equ "D1" set rate=4655
@if /I "%note%" equ "D#1" set rate=4926
@if /I "%note%" equ "E1" set rate=5231
@if /I "%note%" equ "F1" set rate=5542
@if /I "%note%" equ "F#1" set rate=5872
@if /I "%note%" equ "G1" set rate=6223
@if /I "%note%" equ "G#1" set rate=6593
@if /I "%note%" equ "A1" set rate=6982
@if /I "%note%" equ "A#1" set rate=7389
@if /I "%note%" equ "B1" set rate=7830
@if /I "%note%" equ "C2" set rate=8287
@if /I "%note%" equ "C#2" set rate=8779
@if /I "%note%" equ "D2" set rate=9309
@if /I "%note%" equ "D#2" set rate=9853
@if /I "%note%" equ "E2" set rate=10463
@if /I "%note%" equ "F2" set rate=11084
@if /I "%note%" equ "F#2" set rate=11745
@if /I "%note%" equ "G2" set rate=12445
@if /I "%note%" equ "G#2" set rate=13186
@if /I "%note%" equ "A2" set rate=13964
@if /I "%note%" equ "A#2" set rate=14779
@if /I "%note%" equ "B2" set rate=15694
@if /I "%note%" equ "C3" set rate=16574
@if /I "%note%" equ "C#3" set rate=17559
@if /I "%note%" equ "D3" set rate=18668
@if /I "%note%" equ "D#3" set rate=19705
@if /I "%note%" equ "E3" set rate=20864
@if /I "%note%" equ "F3" set rate=22168
@if /I "%note%" equ "F#3" set rate=23489
@if /I "%note%" equ "G3" set rate=24804
@if /I "%note%" equ "G#3" set rate=26273
@if /I "%note%" equ "A3" set rate=27928
@if /I "%note%" equ "A#3" set rate=29558
@if /I "%note%" equ "B3" set rate=31388
@if %rate% equ 0 (
	@echo Error: Invalid note %note%
	@goto error
)

@toolchain\sox-14.3.2\sox --multi-threaded --buffer 131072 -G -S -V -D "%inputfile%" -t 8svx -b 8 -c 1 "%outputfile%" remix - treble 6.0206 4000 rate -v -s -I -b 99 -a %rate% gain -n -0.103
@if errorlevel 1 goto end
@echo Error: conversion failed
goto error
:detail
@echo.
@echo Convert wav-file to iff protracker-friendly sample
@echo Usage: ConvertWavToIff WavNameWithoutExtension
@echo 1. copy the xxx.wav file to dh1\wavsamples
@echo 2. run ConvertWavToIff xxx [note (default is C3]
@echo 3. Now you have a iff sample in dh1\iffsamples
:error
:end