@echo off
setlocal enableextensions enabledelayedexpansion

rem build-container.bat [target]
rem target: 68k | ppc-amigaos | ppc-morphos | all (default: all)

set TARGET=%1
if "%TARGET%"=="" set TARGET=all

set ROOT=%~dp0

rem wait for docker to be available
echo Checking Docker availability...
set /a COUNT=0
:waitloop
docker info >nul 2>&1
if %ERRORLEVEL%==0 (
  echo Docker is available.
  goto :proceed
)
set /a COUNT+=1
if %COUNT% GEQ 60 (
  echo Docker did not become available after 120 seconds.
  exit /b 1
)
timeout /t 2 >nul
goto :waitloop

:proceed
echo Building target: %TARGET%

call :handle 68k "%ROOT%\.devcontainer\amiga-68k" "sacredbanana/amiga-compiler:m68k-amigaos"
call :handle ppc-amigaos "%ROOT%\.devcontainer\amigaos-ppc" "sacredbanana/amiga-compiler:ppc-amigaos"
call :handle ppc-morphos "%ROOT%\.devcontainer\morphos-ppc" "sacredbanana/amiga-compiler:ppc-morphos"

echo All requested targets processed.
endlocal
exit /b 0

:handle
set TGT=%1
set FOLDER=%~2
set IMAGE=%~3
if /I "%TARGET%" NEQ "all" if /I "%TARGET%" NEQ "%TGT%" goto :eof

if exist "%FOLDER%\Dockerfile" (
  echo Building image %IMAGE% from %FOLDER%
  docker build -t %IMAGE% "%FOLDER%"
  if %ERRORLEVEL% NEQ 0 (
    echo Failed to build %IMAGE%
    exit /b %ERRORLEVEL%
  )
) else (
  echo No Dockerfile in %FOLDER%; attempting to pull %IMAGE% from registry
  docker pull %IMAGE%
  if %ERRORLEVEL% NEQ 0 (
    echo Failed to pull %IMAGE%
    exit /b %ERRORLEVEL%
  )
)
goto :eof
