# Amiga project - quick compile

Quick helpers to compile source files using the container images.

Usage
- Run the VS Code task: `Terminal` → `Run Task` → `Compile with selected container` (or press `Ctrl+Shift+B`).
- Or from a command prompt in the workspace run the helper batch:

```bat
compile.bat [image] [file]
```

Recommended VS Code extensions
------------------------------

For the workflow in this project these extensions are helpful:

- **ms-vscode.cpptools** — C/C++ IntelliSense, code navigation and debugging.
- **ms-vscode.PowerShell** — PowerShell language support, linting and debugging for the wrapper.
- **ms-azuretools.vscode-docker** — Dockerfile/image helpers and a friendly UI for containers.
- **ms-vscode-remote.remote-containers** — Dev Containers support for developing inside a container.
- **eamodio.gitlens** — Git history/annotations (useful when switching compiler branches).
- **streetsidesoftware.code-spell-checker** — Lightweight typo-catching in docs and scripts.

Install from the Extensions view (`View → Extensions`) or run `ext install <publisher>.<extension>`.

Examples

Compile the default `add3.c` with the MorphOS image:

```bat
compile.bat sacredbanana/amiga-compiler:ppc-morphos .devcontainer\add3.c
```

Notes
- Docker Desktop (or another Docker engine) must be running and `docker` available on PATH.
- The produced binary is written into the workspace root; cross-compiled binaries won't run on Windows.

Keybinding and extensions
- **Toggle keybinding:** `Ctrl+Alt+A` — runs the "Toggle auto-compile" task (toggles run-on-save auto-compile).
- **Recommended extensions:** `emeraldwalk.runonsave` (auto-run on save) and `ms-vscode.PowerShell` (optional, improves editing for `.ps1` scripts).

Building the container images
- A helper script is included to build (or pull) the compiler images for each target:

	- `build-container.bat` — Windows batch helper
	- `build-container.sh`  — POSIX shell helper

Usage examples

```bat
REM Build all targets (Windows)
build-container.bat

REM Build only MorphOS image (Windows)
build-container.bat ppc-morphos
```

```bash
# Build all targets (Linux/macOS)
./build-container.sh

````markdown
# Amiga project - quick compile

Quick helpers to compile source files using the container images.

Usage
- Run the VS Code task: `Terminal` → `Run Task` → `Compile with selected container` (or press `Ctrl+Shift+B`).
- Or from a command prompt in the workspace run the helper batch:

```bat
compile.bat [image] [file]
```

Examples

Compile the default `add3.c` with the MorphOS image:

```bat
compile.bat sacredbanana/amiga-compiler:ppc-morphos .devcontainer\add3.c
```

Notes
- Docker Desktop (or another Docker engine) must be running and `docker` available on PATH.
- The produced binary is written into the workspace root; cross-compiled binaries won't run on Windows.

Keybinding and extensions
- **Toggle keybinding:** `Ctrl+Alt+A` — runs the "Toggle auto-compile" task (toggles run-on-save auto-compile).
- **Recommended extensions:** `emeraldwalk.runonsave` (auto-run on save) and `ms-vscode.PowerShell` (optional, improves editing for `.ps1` scripts).

Building the container images
- A helper script is included to build (or pull) the compiler images for each target:

	- `build-container.bat` — Windows batch helper
	- `build-container.sh`  — POSIX shell helper

Usage examples

```bat
REM Build all targets (Windows)
build-container.bat

REM Build only MorphOS image (Windows)
build-container.bat ppc-morphos
```

```bash
# Build all targets (Linux/macOS)
./build-container.sh

# Build only 68k image
./build-container.sh 68k
```

Behavior
- If a `Dockerfile` exists in `.devcontainer/<target>/Dockerfile` the script builds a local image tagged to match the repo's image name (for example `sacredbanana/amiga-compiler:m68k-amigaos`).
- If no `Dockerfile` is present the script will attempt to `docker pull` the prebuilt image from the registry.
- The scripts wait for the Docker daemon to be available (up to ~2 minutes) and fail with a clear message if the daemon never appears.

Docker Desktop startup
- The Docker engine must be running before running tasks that call `docker`. Starting Docker Desktop automatically at login avoids timing issues and the "docker not available" errors you saw earlier.
- It's not strictly required to auto-start Docker Desktop — you can disable auto-start and start Docker manually when you begin working. The included scripts handle waiting for Docker, so manual start is fine, but an automatic start reduces friction.


Container build wrapper and `osSuffix`
------------------------------------

I added a small PowerShell wrapper at `.vscode/docker-gcc.ps1` that normalizes paths
when invoking `docker` from Windows. The VS Code build task now calls this wrapper.

Usage notes:

- To choose the compiler image, use the `Compile with selected container` task
	and pick the image when prompted (e.g. `sacredbanana/amiga-compiler:ppc-morphos`).
- The task now has an `osSuffix` input which is appended to the output filename.
	Example output names: `add3_m68k-amigaos`, `add3_ppc-amigaos`, `add3_ppc-morphos`.
- If you want to run the wrapper manually from PowerShell:

```powershell
powershell -NoProfile -ExecutionPolicy Bypass -File .vscode\docker-gcc.ps1 \
	sacredbanana/amiga-compiler:ppc-morphos .devcontainer\add3.c add3_ppc-morphos
```

Notes:
- The produced binaries are cross-compiled for Amiga/MorphOS targets and will
	usually not execute on the host or the Linux container (you may see `Exec format error`).
	Use an emulator or a matching target runtime to run them.

````


