Container build wrapper and `osSuffix`
------------------------------------

I added a small PowerShell wrapper at `.vscode/docker-gcc.ps1` that normalizes paths
when invoking `docker` from Windows. The VS Code build task now calls this wrapper.

Usage notes:

- To choose the compiler image, use the `Compile with selected container` task
  and pick the image when prompted (e.g. `sacredbanana/amiga-compiler:ppc-morphos`).
- The task now has an `osSuffix` input which is appended to the output filename.
  Example output names: `add3_m68k-amigaos`, `add3_ppc-amigaos`, `add3_ppc-morphos`.
- If you want to run the wrapper manually from PowerShell:

```powershell
powershell -NoProfile -ExecutionPolicy Bypass -File .vscode\docker-gcc.ps1 \
  sacredbanana/amiga-compiler:ppc-morphos .devcontainer\add3.c add3_ppc-morphos
```

Notes:
- The produced binaries are cross-compiled for Amiga/MorphOS targets and will
  usually not execute on the host or the Linux container (you may see `Exec format error`).
  Use an emulator or a matching target runtime to run them.
